/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.services.FSAssertionManager;
import com.sun.identity.federation.services.FSAuthContextResult;
import com.sun.identity.federation.services.FSAuthnDecisionImpl;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.util.FSNameIdentifierHelper;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public abstract class FSSSOAndFedHandler {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected FSProviderDescriptor spDescriptor;
    protected String relayState = null;
    protected FSAuthnRequest authnRequest = null;
    protected SSOToken ssoToken = null;
    protected String hostProviderId = null;
    protected String metaAlias = null;
    protected FSLocalConfigurationDescriptor localConfig = null;

    public void setHostProviderId(String string) {
        this.hostProviderId = string;
        try {
            this.localConfig = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId).getLocalConfiguration();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSSSOAndFedHandler.setHostProviderId: Could not obtain local config");
        }
    }

    public void setMetaAlias(String string) {
        this.metaAlias = string;
    }

    public String getHostProviderId() {
        return this.hostProviderId;
    }

    protected FSSSOAndFedHandler() {
    }

    public FSSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string, SSOToken sSOToken) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string != null) {
            this.relayState = string;
        }
        if (fSAuthnRequest != null) {
            this.authnRequest = fSAuthnRequest;
        }
        if (fSProviderDescriptor != null) {
            this.spDescriptor = fSProviderDescriptor;
        }
        if (sSOToken != null) {
            this.ssoToken = sSOToken;
        }
    }

    public FSSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (fSAuthnRequest != null) {
            this.authnRequest = fSAuthnRequest;
        }
        if (fSProviderDescriptor != null) {
            this.spDescriptor = fSProviderDescriptor;
        }
        if (string != null) {
            this.relayState = string;
        }
    }

    public FSSSOAndFedHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
    }

    public boolean processPreAuthnSSO(FSAuthnRequest fSAuthnRequest) {
        Object object;
        Object object2;
        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: Called");
        boolean bl = false;
        String string = null;
        ArrayList<String> arrayList = null;
        String string2 = null;
        List list = null;
        String string3 = null;
        String string4 = null;
        FSAuthContextResult fSAuthContextResult = null;
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        if (fSAuthnRequest.getAuthnContext() != null) {
            arrayList = fSAuthnRequest.getAuthnContext().getAuthnContextClassRefList();
            if (arrayList == null) {
                String string5 = "http://www.projectliberty.org/schemas/authctx/classes/Password";
                arrayList = new ArrayList<String>();
                arrayList.add(string5);
            }
            string4 = fSAuthnRequest.getAuthContextCompType();
            list = fSAuthnRequest.getAuthnContext().getAuthnContextStatementRefList();
            string3 = null;
            bl = true;
        }
        boolean bl2 = true;
        SSOToken sSOToken = null;
        try {
            object2 = SSOTokenManager.getInstance();
            sSOToken = object2.createSSOToken(this.request);
            if (sSOToken == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOToken is null. User is not authenticated.");
                }
                bl2 = false;
            } else if (!object2.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOToken is not valid. User is not authenticated.");
                }
                bl2 = false;
            } else {
                object = fSSessionManager.getSession(sSOToken);
                if (object != null) {
                    string3 = ((FSSession)object).getAuthnContext();
                    if (string3 != null) {
                        bl2 = true;
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User has an existing valid session with authnContext: " + string3);
                        }
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context information not found using default authentication context");
                        }
                        string3 = this.localConfig.getDefaultAuthenticationContext();
                        bl2 = true;
                    }
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authenticated session information is not present in FSSessionManager. using default authentication context");
                    }
                    string3 = this.localConfig.getDefaultAuthenticationContext();
                    bl2 = true;
                }
            }
            if (bl2) {
                sSOToken.addSSOTokenListener((SSOTokenListener)new FSTokenListener(this.hostProviderId));
                object = FSSessionManager.getInstance(this.hostProviderId);
                ((FSSessionManager)object).removeAuthnRequest(fSAuthnRequest.getRequestID());
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: SSOException Occured: User does not have SSOToken " + sSOException.getMessage());
            bl2 = false;
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication status: " + bl2);
            }
            object2 = FSServiceManager.getInstance();
            object = new FSAuthnDecisionImpl(this.hostProviderId, this.request);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            arrayList2.add(this.localConfig.getDefaultAuthenticationContext());
            if (fSAuthnRequest.getIsPassive()) {
                if (fSAuthnRequest.getForceAuthn()) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO: IDP is passive can't force authentication.");
                    return false;
                }
                if (bl2) {
                    if (arrayList != null) {
                        fSAuthContextResult = object.decideAuthnContext(arrayList, string3, string4);
                    } else if (string2 != null) {
                        fSAuthContextResult = object.decideAuthnContext(string2, string3);
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                        }
                        fSAuthContextResult = object.getURLForAuthnContext(arrayList2, string4);
                    }
                    if (fSAuthContextResult == null) {
                        return false;
                    }
                    if (fSAuthContextResult.getLoginURL() != null) {
                        string = fSAuthContextResult.getLoginURL();
                        string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
                        FSUtils.forwardRequest(this.request, this.response, string);
                        return true;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is evaluated to be valid");
                    }
                    return this.processPostAuthnSSO(fSAuthnRequest);
                }
                FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO: IDP is passive and user is not authenticated");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnRequest is active");
            }
            if (fSAuthnRequest.getForceAuthn()) {
                fSAuthContextResult = arrayList != null ? object.getURLForAuthnContext(arrayList, string4) : (string2 != null ? object.getURLForAuthnContext(string2) : object.getURLForAuthnContext(arrayList2));
                if (fSAuthContextResult == null || fSAuthContextResult.getLoginURL() == null || fSAuthContextResult.getLoginURL().equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO:AuthnDecision engine failed to take a authn decision");
                    }
                    return false;
                }
                string = fSAuthContextResult.getLoginURL();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + string);
                }
                string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
                FSUtils.forwardRequest(this.request, this.response, string);
                this.response.flushBuffer();
                return true;
            }
            if (bl2) {
                if (arrayList != null) {
                    fSAuthContextResult = object.decideAuthnContext(arrayList, string3, string4);
                } else if (string2 != null) {
                    fSAuthContextResult = object.decideAuthnContext(string2, string3);
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                    }
                    fSAuthContextResult = object.getURLForAuthnContext(arrayList2, string4);
                }
                if (fSAuthContextResult == null) {
                    return false;
                }
                if (fSAuthContextResult.getLoginURL() == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is evaluated to be valid");
                    }
                    return this.processPostAuthnSSO(fSAuthnRequest);
                }
                if (fSAuthContextResult.getLoginURL().equals("")) {
                    return false;
                }
                string = fSAuthContextResult.getLoginURL();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + string);
                }
                string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
                FSUtils.forwardRequest(this.request, this.response, string);
                return true;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnRequest is active");
            }
            if (arrayList != null) {
                fSAuthContextResult = object.getURLForAuthnContext(arrayList, string4);
            } else if (string2 != null) {
                fSAuthContextResult = object.getURLForAuthnContext(string2);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: User's authentication context is default");
                }
                fSAuthContextResult = object.getURLForAuthnContext(arrayList2, string4);
            }
            if (fSAuthContextResult == null || fSAuthContextResult.getLoginURL() == null || fSAuthContextResult.getLoginURL().equals("")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler. processPreAuthnSSO:  AuthnDecision engine failed to take a decision");
                }
                return false;
            }
            string = fSAuthContextResult.getLoginURL();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPreAuthnSSO: AuthnDecision engine returned: " + string);
            }
            string = this.formatLoginURL(string, fSAuthContextResult.getAuthContextRef());
            FSUtils.forwardRequest(this.request, this.response, string);
            return true;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPreAuthnSSO: Exception occured");
            return this.processPostAuthnSSO(fSAuthnRequest);
        }
    }

    public String formatLoginURL(String string, String string2) {
        FSUtils.debug.message("FSSSOAndFedHandler.formatLoginURL: Called");
        try {
            if (string == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.formatLoginURL: ");
                return null;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(this.hostProviderId);
            String string3 = fSHostedProviderDescriptor.getSSOServiceURL();
            StringBuffer stringBuffer = new StringBuffer(string3);
            if (string3.indexOf(63) == -1) {
                stringBuffer.append("?");
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append("Authn").append("=").append("true").append("&").append("AuthnContext").append("=").append(URLEncoder.encode(string2)).append("&").append("_liberty_idp").append("=").append(URLEncoder.encode(this.hostProviderId)).append("&").append("RequestID").append("=").append(URLEncoder.encode(this.authnRequest.getRequestID()));
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            String string4 = FSServiceUtils.getBaseURL(this.request) + "/postLogin";
            StringBuffer stringBuffer2 = new StringBuffer(string4);
            if (string4.indexOf(63) == -1) {
                stringBuffer2.append("?");
            } else {
                stringBuffer2.append("&");
            }
            stringBuffer2.append("RelayState").append("=").append(URLEncoder.encode(stringBuffer.toString())).append("&").append("sso").append("=").append("true").append("&").append("metaAlias").append("=").append(this.metaAlias);
            StringBuffer stringBuffer3 = new StringBuffer(100);
            stringBuffer3.append(string);
            if (string.indexOf(63) == -1) {
                stringBuffer3.append("?");
            } else {
                stringBuffer3.append("&");
            }
            stringBuffer3.append("goto").append("=").append(URLEncoder.encode(stringBuffer2.toString()));
            Set set = this.localConfig.getAuthDomainURLList();
            if (set != null && !set.isEmpty()) {
                String string5 = (String)set.iterator().next();
                stringBuffer3.append("&").append("org").append("=").append(URLEncoder.encode(string5));
            }
            this.request.getSession(true).setAttribute("AuthnContext", (Object)string2);
            int n = stringBuffer3.length() - 1;
            if (stringBuffer3.charAt(n) == '&') {
                stringBuffer3 = stringBuffer3.deleteCharAt(n);
            }
            return stringBuffer3.toString();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.formatLoginURL: Exception: " + exception.getMessage());
            return null;
        }
    }

    public boolean processPostAuthnSSO(FSAuthnRequest fSAuthnRequest) {
        Object object;
        Object object2;
        FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: Called");
        SSOToken sSOToken = null;
        try {
            object2 = SSOTokenManager.getInstance();
            sSOToken = object2.createSSOToken(this.request);
            if (sSOToken == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: SSOToken is null.");
                return false;
            }
            if (!object2.isValidToken(sSOToken)) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: SSOToken is not valid.");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: SSOToken is valid.");
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: " + sSOException.getMessage());
            return false;
        }
        this.ssoToken = sSOToken;
        object2 = null;
        try {
            object2 = sSOToken.getPrincipal().getName();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: UserDN of the principal in the session: " + (String)object2);
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: SSOException occured. Principal information not found in the SSOToken: " + sSOException.getMessage());
            return false;
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        FSSession fSSession = fSSessionManager.getSession((String)object2, sSOToken.getTokenID().toString());
        if (fSSession != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: An existing SSO session found with ID:" + fSSession.getSessionID());
            }
            fSSession.addSessionPartner(new FSSessionPartner(this.spDescriptor.getProviderID(), false));
            fSSessionManager.addSession((String)object2, fSSession);
        } else {
            object = sSOToken.getTokenID().toString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processPostAuthnSSO: No existing SSO session found. Entering a new session to the session manager with ID: " + (String)object);
            }
            fSSession = new FSSession((String)object);
            fSSession.addSessionPartner(new FSSessionPartner(this.spDescriptor.getProviderID(), false));
            fSSessionManager.addSession((String)object2, fSSession);
        }
        if (fSAuthnRequest.getFederate()) {
            object = this.doAccountFederation(sSOToken);
            NameIdentifier nameIdentifier = null;
            NameIdentifier nameIdentifier2 = null;
            if (object == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: Accountfederation failed");
                return false;
            }
            nameIdentifier = ((FSAccountFedInfo)object).getRemoteNameIdentifier();
            nameIdentifier2 = ((FSAccountFedInfo)object).getLocalNameIdentifier();
            if (nameIdentifier2 == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.processPostAuthnSSO: Opaque handle not found");
                return false;
            }
            if (nameIdentifier == null) {
                nameIdentifier = nameIdentifier2;
            }
            return this.doSingleSignOn(sSOToken, fSAuthnRequest.getRequestID(), nameIdentifier, nameIdentifier2);
        }
        return this.doSingleSignOn(sSOToken, fSAuthnRequest.getRequestID());
    }

    protected FSAuthnResponse createAuthnResponse(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        FSUtils.debug.message("FSSSOAndFedHandler.createAuthnResponse:  Called");
        FSAuthnResponse fSAuthnResponse = null;
        try {
            String string2 = this.authnRequest.getRequestID();
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string3 = this.hostProviderId;
            FSAssertionManager fSAssertionManager = FSAssertionManager.getInstance(this.hostProviderId);
            FSAssertion fSAssertion = null;
            fSAssertion = fSAssertionManager.createFSAssertion(sSOToken.getTokenID().toString(), null, this.spDescriptor, string3, nameIdentifier, nameIdentifier2, string, this.authnRequest.getMinorVersion());
            StatusCode statusCode = new StatusCode("samlp:Success");
            Status status = new Status(statusCode);
            ArrayList<FSAssertion> arrayList = new ArrayList<FSAssertion>();
            arrayList.add(fSAssertion);
            fSAuthnResponse = new FSAuthnResponse(null, string2, status, arrayList, this.relayState);
            fSAuthnResponse.setMinorVersion(this.authnRequest.getMinorVersion());
            FSUtils.debug.message("FSSSOAndFedHandler.createAuthnResponse: CHECK1: " + this.hostProviderId);
            fSAuthnResponse.setProviderId(this.hostProviderId);
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: FSException: " + fSException.getMessage());
            return null;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSSSOAndFedHandler.createAuthnResponse: SAMLException: " + sAMLException.getMessage());
            return null;
        }
        return fSAuthnResponse;
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        return false;
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string) {
        FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn(2):  Called");
        try {
            NameIdentifier nameIdentifier;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: Initiating SSO for user with DN: " + sSOToken.getPrincipal().getName());
            }
            String string2 = sSOToken.getPrincipal().getName();
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            FSAccountFedInfo fSAccountFedInfo = fSAccountManager.readAccountFedInfo(string2, this.authnRequest.getProviderId());
            if (fSAccountFedInfo == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: Account Federation Information not found for user with DN: " + sSOToken.getPrincipal().getName());
                FSUtils.error("FSSSOAndFedHandler", "Account Federation Information not found for user with DN: " + sSOToken.getPrincipal().getName());
                return false;
            }
            NameIdentifier nameIdentifier2 = fSAccountFedInfo.getLocalNameIdentifier();
            if (nameIdentifier2 == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: NameIdentifier not found");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: IDP generated opaque handle: " + nameIdentifier2.getName());
            }
            if ((nameIdentifier = fSAccountFedInfo.getRemoteNameIdentifier()) == null) {
                nameIdentifier = nameIdentifier2;
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doSingleSignOn: SP generated opaque handle: " + nameIdentifier.getName());
            }
            return this.doSingleSignOn(sSOToken, string, nameIdentifier, nameIdentifier2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.doSingleSignOn: Exception during Single Sign-On:" + exception.getMessage());
            return false;
        }
    }

    protected FSAccountFedInfo doAccountFederation(SSOToken sSOToken) {
        FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation:  Called");
        try {
            FSNameIdentifierHelper fSNameIdentifierHelper = new FSNameIdentifierHelper(this.hostProviderId);
            String string = fSNameIdentifierHelper.createNameIdentifier();
            if (string == null) {
                FSUtils.debug.error("FSSSOAndFedHandler.doAccountFederation: Could not generate handle");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.doAccountFederation: Generated handle: " + string);
            }
            String string2 = sSOToken.getPrincipal().getName();
            String string3 = this.authnRequest.getProviderId();
            String string4 = this.getHostProviderId();
            NameIdentifier nameIdentifier = new NameIdentifier(string, string4);
            FSAccountFedInfo fSAccountFedInfo = new FSAccountFedInfo(string3, nameIdentifier, null, false);
            FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(string4, string);
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            fSAccountManager.writeAccountFedInfo(string2, fSAccountFedInfoKey, fSAccountFedInfo);
            return fSAccountFedInfo;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.doAccountFederation: Exception when doing account federation");
            return null;
        }
    }

    protected void returnErrorResponse() {
    }

    public FSResponse processSAMLRequest(FSSAMLRequest fSSAMLRequest) {
        FSUtils.debug.error("FSSSOAndFedHandler.processSAMLRequest: Call should not resolve here, abstract class.");
        return null;
    }

    public void processAuthnRequest(FSAuthnRequest fSAuthnRequest, boolean bl) {
        FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: Called");
        this.authnRequest = fSAuthnRequest;
        String string = null;
        String string2 = fSAuthnRequest.getRequestID();
        Status status = null;
        FSAuthnResponse fSAuthnResponse = null;
        String string3 = fSAuthnRequest.getProviderId();
        try {
            Set set = this.localConfig.getTrustedProviders();
            if (set != null) {
                if (!set.contains(string3)) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                    string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                    status = new Status(new StatusCode("samlp:Responder"), string, null);
                    fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                    fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                    this.sendAuthnResponse(fSAuthnResponse);
                    return;
                }
            } else {
                FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: RemoteProvider is not trusted");
                string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                status = new Status(new StatusCode("samlp:Responder"), string, null);
                fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                this.sendAuthnResponse(fSAuthnResponse);
                return;
            }
            if (bl) {
                if (this.processPostAuthnSSO(fSAuthnRequest)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing successful");
                    }
                    return;
                }
                FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing failed");
                FSUtils.error("FSSSOAndFedHandler", FSUtils.bundle.getString("AuthnRequestProcessingFailed"));
                string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
                status = new Status(new StatusCode("samlp:Responder"), string, null);
                fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                this.sendAuthnResponse(fSAuthnResponse);
                return;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string4 = this.spDescriptor.getKeyInfo();
            boolean bl2 = this.spDescriptor.getAuthnRequestSigned();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: ProviderID : " + this.spDescriptor.getProviderID() + " AuthnRequestSigned :this is for testing " + bl2);
            }
            if (FSServiceUtils.isSigningOn() && bl2) {
                if (!this.verifyRequestSignature(fSAuthnRequest)) {
                    FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Signature Verification Failed");
                    FSUtils.error("FSSSOAndFedHandler", FSUtils.bundle.getString("SignatureVerificationFailed"));
                    string = FSUtils.bundle.getString("SignatureVerificationFailed");
                    status = new Status(new StatusCode("samlp:Responder"), string, null);
                    fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                    fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                    this.sendAuthnResponse(fSAuthnResponse);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler. processAuthnRequest: AuthnRequest Signature Verified");
                }
            }
            if (this.processPreAuthnSSO(fSAuthnRequest)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing successful");
                }
                return;
            }
            FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: AuthnRequest Processing failed");
            FSUtils.error("FSSSOAndFedHandler", FSUtils.bundle.getString("AuthnRequestProcessingFailed"));
            string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
            status = new Status(new StatusCode("samlp:Responder"), string, null);
            fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
            fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
            this.sendAuthnResponse(fSAuthnResponse);
            return;
        }
        catch (Exception exception) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(byteArrayOutputStream));
            FSUtils.debug.error("FSSSOAndFedHandler.processAuthnRequest: Exception Occured: " + exception.getMessage() + "Stack trace is " + byteArrayOutputStream.toString());
            FSUtils.error("FSSSOAndFedHandler", FSUtils.bundle.getString("Exception") + exception.getMessage());
            string = FSUtils.bundle.getString("AuthnRequestProcessingFailed");
            try {
                status = new Status(new StatusCode("samlp:Responder"), string, null);
                fSAuthnResponse = new FSAuthnResponse(null, string2, status, null, this.relayState);
                fSAuthnResponse.setMinorVersion(fSAuthnRequest.getMinorVersion());
                this.sendAuthnResponse(fSAuthnResponse);
            }
            catch (Exception exception2) {
                FSUtils.error("FSSSOAndFedHandler", FSUtils.bundle.getString("Exception") + exception2.getMessage());
            }
            return;
        }
    }

    protected void sendAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        FSUtils.debug.error("FSSSOAndFedHandler.sendAuthnResponse: Call should not resolve here. error");
    }

    public void setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        this.spDescriptor = fSProviderDescriptor;
    }

    public FSProviderDescriptor getProvider() {
        return this.spDescriptor;
    }

    protected boolean verifyRequestSignature(FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Called");
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string = this.spDescriptor.getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: couldn't obtain this site's cert alias.");
                }
                throw new FSException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Provider's certAlias is found: " + string);
            }
            if (this.request.getMethod().equals("GET")) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Request is sent by GET");
                }
                String string2 = this.request.getParameter("SigAlg");
                String string3 = this.request.getParameter("Signature");
                if (string2 == null || string2.equals("") || string3 == null || string3.equals("")) {
                    return false;
                }
                String string4 = null;
                if (string2.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                    string4 = "SHA1withDSA";
                } else if (string2.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                    string4 = "SHA1withRSA";
                } else {
                    FSUtils.debug.error("FSSSOAndFedHandler.signAndReturnQueryString: Invalid signature algorithim");
                    return false;
                }
                String string5 = this.request.getQueryString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: queryString:" + string5);
                }
                int n = string5.indexOf("&Signature");
                String string6 = string5.substring(0, n);
                byte[] byArray = null;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Signature: " + string3 + "Algorithm: " + string4);
                }
                BASE64Decoder bASE64Decoder = new BASE64Decoder();
                byArray = bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string3.getBytes()));
                FSSignatureManager fSSignatureManager = FSSignatureManager.getInstance();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: String to be verified: " + string6);
                }
                return fSSignatureManager.verifySignature(string6, byArray, string4, string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSSOAndFedHandler.verifyRequestSignature: Request is sent by POST ");
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            int n = fSAuthnRequest.getMinorVersion();
            if (n == 0) {
                return xMLSignatureManager.verifyXMLSignature(fSAuthnRequest.getSignedXMLString(), "id", string);
            }
            if (n == 2) {
                return xMLSignatureManager.verifyXMLSignature(fSAuthnRequest.getSignedXMLString(), "RequestID", string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedHandler.verifyRequestSignature: Exception occured while verifying SP's signature:" + exception.getMessage());
            return false;
        }
    }

    public static String cleanMetaAlias(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias: Called");
        Enumeration enumeration = httpServletRequest.getParameterNames();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase("metaAlias")) {
                if (!FSUtils.debug.messageEnabled()) continue;
                FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias: found metaAlias");
                continue;
            }
            String string3 = httpServletRequest.getParameter(string2);
            string = string == null || string.length() < 1 ? string2 + "=" + URLEncoder.encode(string3) : string + "&" + string2 + "=" + URLEncoder.encode(string3);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSSOAndFedHandler.cleanMetaAlias:  returning with " + string);
        }
        return string;
    }
}

