/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureException;
import com.sun.identity.federation.services.util.FSSignatureManager;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSIntersiteTransferService
extends HttpServlet {
    String framedLoginPageURL = null;

    private void redirectToCommonDomain(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.redirectToCommonDomain: Called");
        }
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            HttpSession httpSession = httpServletRequest.getSession(true);
            Set set = (Set)httpSession.getAttribute("CotSet");
            if (set == null) {
                set = fSAllianceManager.getAllCirclesOfTrust();
                if (set != null) {
                    httpSession.setAttribute("CotSet", (Object)set);
                }
                if (set == null || set.isEmpty()) {
                    FSUtils.debug.error("FSIntersiteTransferService. redirectToCommonDomain: No CommonDomain metadata found");
                    FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("noCommonDomainMetadata"));
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, this.framedLoginPageURL);
                    return;
                }
            }
            if (set.isEmpty()) {
                FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: No more CommonDomain left");
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("noCommonDomainMetadata"));
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, this.framedLoginPageURL);
                return;
            }
            Iterator iterator = set.iterator();
            String string2 = (String)iterator.next();
            set.remove(string2);
            httpSession.setAttribute("CotSet", (Object)set);
            String string3 = fSAllianceManager.getCircleOfTrust(string2).getReaderServiceURL();
            if (string3 != null) {
                StringBuffer stringBuffer = new StringBuffer(300);
                StringBuffer stringBuffer2 = httpServletRequest.getRequestURL();
                stringBuffer2.append("?").append("RequestID").append("=").append(URLEncoder.encode(string));
                stringBuffer2.append("&").append("metaAlias").append("=").append(httpServletRequest.getParameter("metaAlias"));
                stringBuffer.append(string3);
                stringBuffer.append("?");
                stringBuffer.append("RelayState");
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(stringBuffer2.toString()));
                String string4 = stringBuffer.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.redirectToCommonDomain: Redirecting to check for PrefferedIDP @:" + string4);
                }
                httpServletResponse.setHeader("Location", string4);
                httpServletResponse.sendRedirect(string4);
                return;
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: AllianceManagementException occured while trying to redirect to the CommonDomain: " + fSAllianceManagementException.getMessage());
            FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("Exception") + " :" + fSAllianceManagementException.getMessage());
            try {
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, this.framedLoginPageURL);
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: IOException : " + exception.getMessage());
            }
            return;
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSIntersiteTransferService.redirectToCommonDomain: IOException occured while trying to redirect to the CommonDomain: " + iOException.getMessage());
            FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("Exception") + " :" + iOException.getMessage());
            return;
        }
    }

    private String getProviderIDFromSuccintID(String string) {
        FSUtils.debug.message("getProviderIDFromSuccintID called");
        if (string == null) {
            return null;
        }
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            FSProviderDescriptor fSProviderDescriptor = fSAllianceManager.getProviderBySuccinctID(string);
            if (fSProviderDescriptor != null) {
                String string2 = fSProviderDescriptor.getProviderID();
                return string2;
            }
            return null;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSIntersiteTransferService.getProviderIDFromSuccintID FSAllianceManagementException exception " + fSAllianceManagementException.getMessage());
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIntersiteTransferService getProviderIDFromSuccintID In exception..." + exception.getMessage());
            return null;
        }
    }

    private String findPreferredIdp(HttpServletRequest httpServletRequest) {
        Object object;
        FSUtils.debug.message("FSIntersiteTransferService.findPreferredIdp: Called");
        String string = httpServletRequest.getParameter("_liberty_idp");
        String string2 = null;
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSIntersiteTransferService.findPreferredIdp: No preffered IDP found");
            return null;
        }
        string = string.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            while (string2.length() < 28) {
                string2 = string2 + "+" + stringTokenizer.nextToken();
            }
        }
        try {
            object = new BASE64Decoder();
            string2 = SAMLUtils.byteArrayToHexString(object.decodeBuffer((InputStream)new ByteArrayInputStream(string2.getBytes())));
        }
        catch (IOException iOException) {
            FSUtils.debug.error("FSIntersiteTransferService.findPreferredIdp: Not able to decode encoded providerID");
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.findPreferredIdp: Preferred IDP found: " + string2);
        }
        object = this.getProviderIDFromSuccintID(string2);
        return object;
    }

    private String findRequestID(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSIntersiteTransferService.findRequestID: Called");
        String string = httpServletRequest.getParameter("RequestID");
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.findRequestID:No requestID in the query string");
            }
            FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("nullInputParameter"));
            return null;
        }
        return string;
    }

    private String signAndReturnQueryString(String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: Called");
        }
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: certAlias: " + string2);
        }
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: " + FSUtils.bundle.getString("nullInput"));
            return null;
        }
        FSSignatureManager fSSignatureManager = FSSignatureManager.getInstance();
        String string3 = "SHA1withRSA";
        if (fSSignatureManager.getKeyProvider().getPrivateKey(string2).getAlgorithm().equals("RSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: private key algorithm is: RSA");
            }
            string3 = "SHA1withRSA";
        } else if (fSSignatureManager.getKeyProvider().getPrivateKey(string2).getAlgorithm().equals("DSA")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: private key algorithm is: DSA");
            }
            string3 = "SHA1withDSA";
        } else {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: private key algorithm is not supported");
            return null;
        }
        byte[] byArray = null;
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        if (string3 == null || string3.equals("")) {
            string3 = "SHA1withRSA";
        }
        if (string.charAt(string.length() - 1) != '&') {
            string = string + "&";
        }
        String string4 = null;
        if (string3.equals("SHA1withDSA")) {
            string4 = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
        } else if (string3.equals("SHA1withRSA")) {
            string4 = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
        } else {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: Invalid signature algorithim");
            return null;
        }
        string = string + "SigAlg=" + URLEncoder.encode(string4);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString: Querystring to be signed: " + string);
        }
        try {
            byArray = fSSignatureManager.signBuffer(string, string2, string3);
        }
        catch (FSSignatureException fSSignatureException) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: FSSignatureException occured while signing query string: " + fSSignatureException.getMessage());
            FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("Exception: ") + fSSignatureException.getMessage());
            return null;
        }
        if (byArray == null) {
            FSUtils.debug.error("FSIntersiteTransferService.signAndReturnQueryString: Signature generated is null");
            return null;
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string5 = bASE64Encoder.encode(byArray);
        string = string + "&" + "Signature=" + URLEncoder.encode(string5);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.signAndReturnQueryString:Signed Querystring: " + string);
        }
        return string;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSUtils.debug.message("FSIntersiteTransferService.doGet: Called");
        try {
            FSProviderDescriptor fSProviderDescriptor = null;
            String string = null;
            String string2 = FSServiceUtils.getHostedProviderID(httpServletRequest);
            if (httpServletRequest == null || httpServletResponse == null) {
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("nullInputParameter"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            if (!FSServiceUtils.isLibertyEnabled()) {
                FSUtils.debug.error("FSIntersiteTransferService: " + FSUtils.bundle.getString("notLibertyEnabled"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("notLibertyEnabled"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
                return;
            }
            String string3 = httpServletRequest.getQueryString();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: QueryString Received from CommonDomain: " + string3);
            }
            if ((string = this.findRequestID(httpServletRequest)) == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("nullInputParameter"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("nullInputParameter"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: RequestID found: " + string);
            }
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
            try {
                fSLocalConfigurationDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(string2).getLocalConfiguration();
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: Could not obtain local config");
                return;
            }
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string2);
            FSAuthnRequest fSAuthnRequest = fSSessionManager.getAuthnRequest(string);
            if (fSAuthnRequest == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("invalidRequestId"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("invalidRequestId"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("invalidRequestId"));
                return;
            }
            String string4 = fSAuthnRequest.getRelayState();
            String string5 = FSServiceUtils.getBaseURL(httpServletRequest);
            this.framedLoginPageURL = FSServiceUtils.getCommonLoginPageURL(httpServletRequest.getParameter("metaAlias"), string4, null, httpServletRequest, string5);
            String string6 = this.findPreferredIdp(httpServletRequest);
            if (string6 == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.doGet: No Preffered IDP found in this Common Domain. Try to find PrefferedIDP in other common domains");
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.doGet: RequestID :" + string);
                }
                this.redirectToCommonDomain(httpServletRequest, httpServletResponse, string);
                return;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            fSProviderDescriptor = fSAllianceManager.getProvider(string6);
            if (fSProviderDescriptor == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("noTrust"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("noTrust"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("noTrust"));
                return;
            }
            HttpSession httpSession = httpServletRequest.getSession(true);
            httpSession.removeAttribute("CotSet");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: Preffered IDP found:" + string6);
            }
            fSSessionManager.setProviderDescriptor(string, fSProviderDescriptor);
            fSAuthnRequest.setMinorVersion(fSProviderDescriptor.getMinorVersion());
            fSAuthnRequest.getAuthnContext().setMinorVersion(fSProviderDescriptor.getMinorVersion());
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.doGet: AuthnRequest:" + fSAuthnRequest.toXMLString(true, true));
            }
            if (fSAuthnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/brws-art") || fSAuthnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/brws-post")) {
                this.handleBrowserArtifactPOSTIST(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor);
                return;
            }
            if (fSAuthnRequest.getProtocolProfile().equals("http://projectliberty.org/profiles/wml-post")) {
                this.handleWMLIST(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor);
                return;
            }
            FSUtils.debug.error("FSIntersiteTransferService.doGet: Unknown Protocol Profile");
            FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("invalidAuthnRequest"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("invalidAuthnRequest"));
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("Exception"));
            FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("exception"));
            try {
                httpServletResponse.sendError(500, FSUtils.bundle.getString("exception"));
            }
            catch (IOException iOException) {
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("sendFailed") + ":" + iOException.getMessage());
            }
            return;
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private void handleBrowserArtifactPOSTIST(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Called");
        }
        try {
            if (httpServletRequest == null || httpServletResponse == null || fSAuthnRequest == null || fSProviderDescriptor == null) {
                FSUtils.debug.error("FSIntersiteTransferService.doGet: " + FSUtils.bundle.getString("nullInputParameter"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("nullInputParameter"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            String string = fSProviderDescriptor.getSSOServiceURL();
            if (string == null) {
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Destination URL to send AuthnRequest: " + string);
            }
            StringBuffer stringBuffer = new StringBuffer(1000);
            String string2 = fSAuthnRequest.toURLEncodedQueryString();
            if (string2 == null) {
                FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: " + FSUtils.bundle.getString("invalidRequest"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("invalidRequest"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("invalidRequest"));
                return;
            }
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            String string3 = FSServiceUtils.getHostedProviderID(httpServletRequest);
            String string4 = fSAllianceManager.getHostedProvider(string3).getKeyInfo();
            boolean bl = fSAllianceManager.getHostedProvider(string3).getAuthnRequestSigned();
            if (FSServiceUtils.isSigningOn() && bl && (string2 = this.signAndReturnQueryString(string2, string4)) == null) {
                FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: AuthnRequest signing failed");
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("signFailed"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("signFailed"));
                return;
            }
            if (string.indexOf("?") != -1) {
                stringBuffer.append(string).append("&").append(string2);
            } else {
                stringBuffer.append(string).append("?").append(string2);
            }
            FSUtils.access("FSIntersiteTransferService", FSUtils.bundle.getString("targetURL") + string);
            String string5 = stringBuffer.toString();
            if (string5.length() > 1256) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Redirection  URL length exceeding the URL MAX length restriction. Switching to form post");
                }
                if (bl) {
                    fSAuthnRequest.signXML(string4);
                }
                this.sendAuthnRequestPost(httpServletResponse, string, fSAuthnRequest);
                return;
            }
            httpServletResponse.setStatus(302);
            httpServletResponse.setHeader("Location", string5);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: Sending AuthnRequest by http-redirect to: " + string);
            }
            httpServletResponse.sendRedirect(string5);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: " + FSUtils.bundle.getString("Exception") + exception.getMessage());
            FSUtils.error("FSIntersiteTransferService: ", exception.getMessage());
            try {
                httpServletResponse.sendError(500, FSUtils.bundle.getString("exception"));
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSIntersiteTransferService.handleBrowserArtifactPOSTIST: " + FSUtils.bundle.getString("sendFailed") + iOException.getMessage());
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("sendFailed") + ":" + iOException.getMessage());
            }
            return;
        }
    }

    private void handleWMLIST(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor) {
        try {
            FSUtils.debug.message("FSIntersiteTransferService.handleWMLIST: Called");
            if (httpServletRequest == null || httpServletResponse == null || fSAuthnRequest == null || fSProviderDescriptor == null) {
                FSUtils.debug.error("FSIntersiteTransferService.handleWMLIST: " + FSUtils.bundle.getString("nullInputParameter"));
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("nullInputParameter"));
                httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
                return;
            }
            String string = fSProviderDescriptor.getSSOServiceURL();
            if (string == null) {
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService.handleWMLIST: Destination URL to send AuthnRequest: " + string);
            }
            FSUtils.access("FSIntersiteTransferService", FSUtils.bundle.getString("redirectTo") + string);
            this.sendWMLB64Post(httpServletResponse, string, fSAuthnRequest);
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIntersiteTransferService.handleWMLIST: " + FSUtils.bundle.getString("Exception") + exception.getMessage());
            FSUtils.error("FSIntersiteTransferService: ", exception.getMessage());
            try {
                httpServletResponse.sendError(500, FSUtils.bundle.getString("exception"));
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSIntersiteTransferService.handleWMLIST: " + FSUtils.bundle.getString("sendFailed") + iOException.getMessage());
                FSUtils.error("FSIntersiteTransferService", FSUtils.bundle.getString("sendFailed") + ":" + iOException.getMessage());
            }
            return;
        }
    }

    private boolean sendWMLB64Post(HttpServletResponse httpServletResponse, String string, FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSIntersiteTransferService:sendWMLB64Post: Called");
        try {
            httpServletResponse.setContentType("text/vnd.wap.wml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            printWriter.println("<wml>");
            printWriter.println("<card id=\"request\" title=\"SP Request\">");
            printWriter.println("<onevent type=\"onenterforward\">");
            printWriter.println("<go method=\"post\" href=\"" + string + "\">");
            printWriter.println("<postfield name=\"LAREQ\" value=\"" + fSAuthnRequest.toBASE64EncodedString() + "\"/>");
            printWriter.println("</go>");
            printWriter.println("</onevent>");
            printWriter.println("<onevent type=\"onenterbackward\">");
            printWriter.println("<prev/>");
            printWriter.println("</onevent>");
            printWriter.println("<p>");
            printWriter.println("Contacting IdP. Please wait....");
            printWriter.println("</p>");
            printWriter.println("</card>");
            printWriter.println("</wml>");
            printWriter.close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService:sendWMLB64Post: BASE64 Encoded AuthnRequest at the Sender: " + fSAuthnRequest.toBASE64EncodedString());
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService:sendWMLB64Post: AuthnRequest sent successfully to: " + string);
            }
            return true;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIntersiteTransferService:sendWMLB64Post:" + exception.getMessage());
            return false;
        }
    }

    protected void sendAuthnRequestPost(HttpServletResponse httpServletResponse, String string, FSAuthnRequest fSAuthnRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSIntersiteTransferService.sendAuthnRequestPost: Called");
        }
        try {
            httpServletResponse.setContentType("text/html");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<HTML>");
            printWriter.println("<BODY Onload=\"document.Request.submit()\">");
            printWriter.println("<FORM NAME=\"Request\" METHOD=\"POST\" ACTION=\"" + string + "\">");
            printWriter.println("<INPUT TYPE=\"HIDDEN\" NAME=\"LAREQ\" VALUE=\"" + fSAuthnRequest.toBASE64EncodedString() + "\"/>");
            printWriter.println("</FORM>");
            printWriter.println("</BODY></HTML>");
            printWriter.close();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSIntersiteTransferService:sendAuthnRequestPost: BASE64 Encoded AuthnRequest at the Sender: " + fSAuthnRequest.toBASE64EncodedString());
                FSUtils.debug.message("FSIntersiteTransferService:sendAuthnRequestPost: AuthnRequest sent successfully to: " + string);
            }
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSIntersiteTransferService:sendAuthnRequestPost:" + exception.getMessage());
            return;
        }
    }
}

