/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import org.w3c.dom.Document;
import sun.misc.BASE64Decoder;

public class FSAssertionConsumerService
extends HttpServlet {
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (httpServletRequest == null || httpServletResponse == null) {
            FSUtils.error("FSAssertionConsumerService.doGet", FSUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSAssertionConsumerService: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSAssertionConsumerService", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
        FSRequest fSRequest = null;
        String string2 = null;
        FSUtils.debug.message("FSAssertionConsumerService.doGet(): called");
        String string3 = httpServletRequest.getParameter("RelayState");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doGet():Resource URL: " + string3);
        }
        String string4 = httpServletRequest.getQueryString();
        Hashtable hashtable = HttpUtils.parseQueryString((String)string4);
        String string5 = "SAMLart";
        String[] stringArray = (String[])hashtable.get(string5);
        String string6 = FSServiceUtils.getBaseURL(httpServletRequest);
        String string7 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), string3, null, httpServletRequest, string6);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService: CommonLoginPage: " + string7);
        }
        if (stringArray == null || stringArray.length < 0 || stringArray[0] == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: AuthnRequest Processing Failed at the IDP Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
        }
        ArrayList<FSAssertionArtifact> arrayList = new ArrayList<FSAssertionArtifact>();
        try {
            object = new FSAssertionArtifact(stringArray[0]);
            string2 = ((AssertionArtifact)object).getSourceID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: SourceID within the Artifact is " + string2);
            }
            arrayList.add((FSAssertionArtifact)object);
            int n = 1;
            while (n < stringArray.length) {
                FSAssertionArtifact fSAssertionArtifact = new FSAssertionArtifact(stringArray[n]);
                String string8 = fSAssertionArtifact.getSourceID();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doGet: SourceID within the Artifact is " + string8);
                }
                if (!string8.equals(string2)) {
                    FSUtils.debug.error("FSAssertionConsumerService.doGet: Received multiple artifacts have different source id");
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
                    return;
                }
                FSUtils.access("FSAssertionConsumerService", FSUtils.bundle.getString("Artifact") + n + ": " + stringArray[n]);
                arrayList.add(fSAssertionArtifact);
                ++n;
            }
            fSRequest = new FSRequest(null, arrayList);
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: " + sAMLException.getMessage());
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
            return;
        }
        catch (FSMsgException fSMsgException) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: " + fSMsgException.getMessage());
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
            return;
        }
        try {
            FSAssertionArtifactHandler fSAssertionArtifactHandler;
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: Trying to get BrowserArtifactHandler");
            }
            if ((fSAssertionArtifactHandler = ((FSServiceManager)(object = FSServiceManager.getInstance())).getBrowserArtifactHandler(httpServletRequest, httpServletResponse, string2, fSRequest, string3)) == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doGet: " + FSUtils.bundle.getString("internalError"));
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doGet: BrowserArtifactHandler created");
            }
            fSAssertionArtifactHandler.setHostProviderId(string);
            fSAssertionArtifactHandler.processSAMLRequest();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.doGet: Exception occured :" + exception.getMessage());
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
            return;
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Object object;
        FSUtils.debug.message("FSAssertionConsumerService.doPost : called");
        Document document = null;
        if (httpServletRequest == null || httpServletResponse == null) {
            FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("nullInputParameter"));
            return;
        }
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSAssertionConsumerService: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSAssertionConsumerService", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        String string2 = FSServiceUtils.getHostedProviderID(httpServletRequest);
        String string3 = httpServletRequest.getParameter("LARES");
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: BASE64 encoded AuthnResponse: " + string3);
        }
        if (string3 == null) {
            FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("missingAuthnResponse"));
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("missingAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string4 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string5 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string4);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string5);
            return;
        }
        string3 = string3.replace(' ', '\n');
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: BASE64 encoded AuthnResponse2: " + string3);
        }
        FSAuthnResponse fSAuthnResponse = null;
        try {
            object = new BASE64Decoder();
            string = new String(object.decodeBuffer((InputStream)new ByteArrayInputStream(string3.getBytes())));
            FSUtils.debug.message("Decoded authnResponse" + string);
            document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
            string3 = string3.replace(' ', '\n');
            fSAuthnResponse = FSAuthnResponse.parseBASE64EncodedString(string3);
            if (fSAuthnResponse == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. Can't parse BASE64 encoded AuthnResponse");
                FSUtils.error("FSAssertionConsumerService", FSUtils.bundle.getString("invalidAuthnResponse"));
                FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                String string6 = FSServiceUtils.getBaseURL(httpServletRequest);
                String string7 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string6);
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string7);
                return;
            }
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. FSException occured while parsing BASE64 encoded AuthnResponse: " + fSException.getMessage());
            FSUtils.error("FSAssertionConsumerService", FSUtils.bundle.getString("invalidAuthnResponse"));
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string8 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string9 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string8);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string9);
            return;
        }
        catch (SAMLException sAMLException) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. SAMLException occured while parsing BASE64 encoded AuthnResponse: " + sAMLException.getMessage());
            FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("invalidAuthnResponse"));
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string10 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string11 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string10);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string11);
            return;
        }
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.doPost: AuthnResponse received is valid: " + fSAuthnResponse.toXMLString());
            }
        }
        catch (FSException fSException) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. FSException occured while calling AuthnResponse.toXMLString(): " + fSException.getMessage());
            FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("invalidAuthnResponse"));
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            string = FSServiceUtils.getBaseURL(httpServletRequest);
            String string12 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string12);
            return;
        }
        object = null;
        string = fSAuthnResponse.getInResponseTo();
        if (string == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. AuthnResponse received does not have inResponseTo attribute");
            FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("invalidAuthnResponse"));
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string13 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string14 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string13);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string14);
            return;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: AuthnResponse received is against requestID: " + string);
        }
        if ((object = this.getInResponseToRequest(string, string2)) == null) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. AuthnResponse received does not have an associated AuthnRequest");
            FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("invalidAuthnResponse"));
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            String string15 = FSServiceUtils.getBaseURL(httpServletRequest);
            String string16 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), null, null, httpServletRequest, string15);
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string16);
            return;
        }
        String string17 = FSServiceUtils.getBaseURL(httpServletRequest);
        String string18 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(httpServletRequest), ((FSAuthnRequest)object).getRelayState(), null, httpServletRequest, string17);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.doPost: inResponseTo validation is successful");
        }
        try {
            FSAssertionArtifactHandler fSAssertionArtifactHandler;
            Object object2;
            FSProviderDescriptor fSProviderDescriptor = null;
            if (!((FSAuthnRequest)object).getProtocolProfile().equals("http://projectliberty.org/profiles/lecp")) {
                fSProviderDescriptor = this.getProvider(fSAuthnResponse.getInResponseTo(), string2);
                if (fSProviderDescriptor == null) {
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: Invalid AuthnResponse. Sender information not found for the received AuthnResponse");
                    FSUtils.error("FSAssertionConsumerService.doPost", FSUtils.bundle.getString("invalidAuthnResponse"));
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("invalidAuthnResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
                    return;
                }
                if (FSServiceUtils.isSigningOn() && !this.verifyAuthnResponseSignature(document, fSProviderDescriptor.getProviderID())) {
                    FSUtils.debug.error("FSAssertionConsumerService.doPost: Signature verification failed");
                    FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
                    return;
                }
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionConsumerService.doPost: LECP Profile identified. IDP info is unknown so farGet providerId from the response");
                }
                object2 = FSServiceUtils.getAllianceInstance();
                fSProviderDescriptor = ((FSAllianceManager)object2).getProvider(fSAuthnResponse.getProviderId());
            }
            if ((fSAssertionArtifactHandler = ((FSServiceManager)(object2 = FSServiceManager.getInstance())).getAssertionArtifactHandler(httpServletRequest, httpServletResponse, (FSAuthnRequest)object, fSAuthnResponse, fSProviderDescriptor)) == null) {
                FSUtils.debug.error("FSAssertionConsumerService.doPost: could not create AssertionArtifactHandler");
                FSUtils.error("FSAssertionConsumerService:", FSUtils.bundle.getString("requestProcessingFailed"));
                FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("requestProcessingFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
                return;
            }
            String string19 = FSServiceUtils.getHostedProviderID(httpServletRequest);
            fSAssertionArtifactHandler.setHostProviderId(string19);
            fSAssertionArtifactHandler.processAuthnResponse(fSAuthnResponse);
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.doPost: Exception: " + exception.getMessage());
            FSUtils.debug.error("FSAssertionConsumerService.doPost: " + FSUtils.bundle.getString("requestProcessingFailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string18);
            return;
        }
    }

    private FSAuthnRequest getInResponseToRequest(String string, String string2) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionConsumerService.getInResponseToRequest: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(string2);
        return fSSessionManager.getAuthnRequest(string);
    }

    private FSProviderDescriptor getProvider(String string, String string2) {
        FSUtils.debug.message("FSAssertionConsumerService.getProvider: Called");
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(string2);
        return fSSessionManager.getProviderDescriptor(string);
    }

    private boolean verifyAuthnResponseSignature(Document document, String string) {
        FSUtils.debug.message("FSAssertionConsumerService.verifyAuthnResponseSignature: Called");
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: Unable to get alliance manager");
                return false;
            }
            String string2 = fSAllianceManager.getProvider(string).getKeyInfo();
            if (string2 == null) {
                FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: couldn't obtain this site's cert alias.");
                return false;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionConsumerService.verifyAuthnResponseSignature: Provider's certAlias is found: " + string2);
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionConsumerService.verifyAuthnResponseSignature: Exception occured while verifying signature: ", (Throwable)exception);
            return false;
        }
    }
}

