/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.share.SessionEncodeURL;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountManager;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContextStmt;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.POSTCleanUpThread;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.sm.CookieUtils;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSAssertionArtifactHandler {
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected FSProviderDescriptor idpDescriptor = null;
    protected FSAuthnRequest authnRequest = null;
    protected String relayState = null;
    protected static Map idTimeMap = new HashMap();
    protected static Thread cThread = new POSTCleanUpThread(idTimeMap);
    protected boolean doFederate = false;
    protected String hostProviderId = null;
    protected FSLocalConfigurationDescriptor localConfig = null;
    private String idpSessionIndex = null;
    private Date reAuthnOnOrAfterDate = null;
    private AuthnContextStmt authnContextStmt = null;
    private List cookieDomainList = FSServiceUtils.getCookieDomainList();
    protected AttributeStatement bootStrapStatement = null;
    protected SecurityAssertion securityAssertion = null;

    public void setHostProviderId(String string) {
        this.hostProviderId = string;
        try {
            this.localConfig = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId).getLocalConfiguration();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAssertionArtifactHandler.setHostProviderId: Could not obtain local config");
        }
    }

    public String getHostProviderId() {
        return this.hostProviderId;
    }

    public FSAuthnRequest getAuthnRequest() {
        return this.authnRequest;
    }

    public void setAuthnRequest(FSAuthnRequest fSAuthnRequest) {
        this.authnRequest = fSAuthnRequest;
    }

    protected FSAssertionArtifactHandler() {
    }

    public FSAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSProviderDescriptor fSProviderDescriptor, boolean bl, String string) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string != null) {
            this.relayState = string;
        }
        if (fSProviderDescriptor != null) {
            this.idpDescriptor = fSProviderDescriptor;
        }
        this.doFederate = bl;
    }

    public FSAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSProviderDescriptor fSProviderDescriptor, FSAuthnRequest fSAuthnRequest, boolean bl, String string) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string != null) {
            this.relayState = string;
        }
        if (fSProviderDescriptor != null) {
            this.idpDescriptor = fSProviderDescriptor;
        }
        if (fSAuthnRequest != null) {
            this.authnRequest = fSAuthnRequest;
        }
        this.doFederate = bl;
    }

    public FSAssertionArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl, String string) {
        if (httpServletRequest != null) {
            this.request = httpServletRequest;
        }
        if (httpServletResponse != null) {
            this.response = httpServletResponse;
        }
        if (string != null) {
            this.relayState = string;
        }
        this.doFederate = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.ProcessAuthnResponse: Called");
        }
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
        try {
            fSLocalConfigurationDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId).getLocalConfiguration();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: Could not obtain local config");
            return;
        }
        String string = "RequestID";
        String string2 = FSServiceUtils.getBaseURL(this.request);
        String string3 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(this.request), this.authnRequest.getRelayState(), null, this.request, string2);
        try {
            int n;
            boolean bl;
            if (fSAuthnResponse == null) {
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("missingAuthnResponse"));
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("missingAuthnResponse") + " AuthnRequest Processing Failed at the IDP " + "Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.doPost: Received " + fSAuthnResponse.toXMLString());
            }
            if (!(bl = this.verifyResponseStatus(fSAuthnResponse))) {
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.debug.error("FSAssertionArtifactHandler. processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            List list = fSAuthnResponse.getAssertion();
            FSSubject fSSubject = (FSSubject)this.validateAssertions(list);
            if (fSSubject == null) {
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("invalidAssertion"));
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("InvalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.getHostProviderId());
            if (this.doFederate) {
                IDPProvidedNameIdentifier iDPProvidedNameIdentifier;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Initiate Account Federation");
                }
                if ((iDPProvidedNameIdentifier = fSSubject.getIDPProvidedNameIdentifier()) == null) {
                    FSUtils.error("FSAssertionArtifactHandler", "Single Sign-On failed. NameIdentifier of the subject is null");
                    throw new FSException("NameIdentifier of the subject is null");
                }
                if (!this.doAccountFederation(iDPProvidedNameIdentifier)) {
                    FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("Accountfederationfailed"));
                    FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("Accountfederationfailed") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                    this.response.sendRedirect(string3);
                    return;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Account federation successful");
                }
                String string4 = fSAuthnResponse.getInResponseTo();
                fSSessionManager.removeAuthnRequest(string4);
                fSSessionManager.removeLocalSSOToken(string4);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Initiate SingleSign-On");
            }
            IDPProvidedNameIdentifier iDPProvidedNameIdentifier = fSSubject.getIDPProvidedNameIdentifier();
            NameIdentifier nameIdentifier = fSSubject.getNameIdentifier();
            if (iDPProvidedNameIdentifier == null || nameIdentifier == null) {
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.debug.error("FSAssertionArtifactHandler. processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            String string5 = iDPProvidedNameIdentifier.getName();
            String string6 = nameIdentifier.getName();
            if (string5 == null || string6 == null) {
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            if (string5.equals(string6)) {
                nameIdentifier = iDPProvidedNameIdentifier;
                n = 1;
            } else {
                n = 0;
            }
            String string7 = fSLocalConfigurationDescriptor.getAssociatedOrgDN();
            if (!this.doSingleSignOn(nameIdentifier, n, string7)) {
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("SSOfailed"));
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.processAuthnResponse: Accountfederation successful");
            }
            fSSessionManager.removeAuthnRequest(fSAuthnResponse.getInResponseTo());
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: Exception Occured: " + exception.getMessage());
            FSUtils.error("FSAssertionArtifactHandler", exception.getMessage());
            try {
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: " + FSUtils.bundle.getString("invalidResponse") + " AuthnRequest Processing Failed at the IDP" + " Redirecting to the Framed Login Page");
                this.response.sendRedirect(string3);
                return;
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSAssertionArtifactHandler.processAuthnResponse: IOException Occured: " + iOException.getMessage());
                return;
            }
        }
    }

    protected boolean verifyResponseStatus(Response response) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyResponseStatus: Called");
        }
        if (!response.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            FSUtils.debug.error("FSAssertionArtifactHandler.verifyResponse: Incorrect StatusCode value.\nRESPONSE=" + response);
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyResponse: StatusCode value verified.");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Subject validateAssertions(List list) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertions: Called");
        }
        FSSubject fSSubject = null;
        Iterator iterator = list.iterator();
        FSAssertion fSAssertion = null;
        String string = null;
        String string2 = null;
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        String string3 = null;
        try {
            fSHostedProviderDescriptor = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId);
            string3 = fSHostedProviderDescriptor.getProviderID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertions: ProviderID of the site is:" + string3);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertions:" + exception.getMessage());
            return null;
        }
        Iterator iterator2 = null;
        Statement statement = null;
        int n = -1;
        Object var12_13 = null;
        SubjectConfirmation subjectConfirmation = null;
        Set set = null;
        String string4 = null;
        Date date = null;
        long l = System.currentTimeMillis() + 180000L;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            fSAssertion = (FSAssertion)iterator.next();
            if (!this.authnRequest.getRequestID().equals(fSAssertion.getInResponseTo())) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion does not correspond to any valid request");
                return null;
            }
            if (FSServiceUtils.isSigningOn() && !this.verifyAssertionSignature(fSAssertion)) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion signature verification failed");
                return null;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Assertion signature verified");
            }
            if (idTimeMap.containsKey(string = fSAssertion.getAssertionID())) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion: " + string + " is used");
                return null;
            }
            string2 = fSAssertion.getIssuer();
            try {
                object2 = FSServiceUtils.getAllianceInstance();
                FSProviderDescriptor fSProviderDescriptor = ((FSAllianceManager)object2).getProvider(string2);
                if (fSProviderDescriptor == null) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not on the trust list");
                    return null;
                }
                if (this.idpDescriptor != null) {
                    if (!this.idpDescriptor.getProviderID().equals(string2)) {
                        FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not the entity where AuthnRequest was sent originally.");
                        return null;
                    }
                } else {
                    FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is: " + string2);
                    this.setProviderDescriptor(fSProviderDescriptor);
                }
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion issuer is not on the trust list");
                return null;
            }
            if (!fSAssertion.isTimeValid()) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Assertion's time is not valid.");
                return null;
            }
            object2 = fSAssertion.getConditions();
            if (!this.forThisServer((Conditions)object2, string3)) {
                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: assertion is not issued for this site.");
                return null;
            }
            boolean bl = false;
            if (fSAssertion.getStatement() != null) {
                iterator2 = fSAssertion.getStatement().iterator();
                while (iterator2.hasNext()) {
                    statement = (Statement)iterator2.next();
                    n = statement.getStatementType();
                    if (n == 1) {
                        block36: {
                            object = (FSAuthenticationStatement)statement;
                            bl = true;
                            try {
                                if (FSUtils.debug.messageEnabled()) {
                                    FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: validating AuthenticationStatement:" + ((FSAuthenticationStatement)object).toXMLString());
                                }
                            }
                            catch (FSException fSException) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Exception. Invalid AuthenticationStatement: " + fSException.getMessage());
                                FSUtils.error("FSAssertionArtifactHandler", fSException.getMessage());
                                return null;
                            }
                            this.reAuthnOnOrAfterDate = ((FSAuthenticationStatement)object).getReauthenticateOnOrAfter();
                            this.idpSessionIndex = ((FSAuthenticationStatement)object).getSessionIndex();
                            this.authnContextStmt = ((FSAuthenticationStatement)object).getAuthnContext();
                            fSSubject = (FSSubject)((SubjectStatement)object).getSubject();
                            if (fSSubject == null) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: Subject is null");
                                return null;
                            }
                            try {
                                if (!FSUtils.debug.messageEnabled()) break block36;
                                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: found Authentication Statement. Subject = " + fSSubject.toXMLString());
                            }
                            catch (FSException fSException) {
                                FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion:  Exception. Invalid subject: " + fSException.getMessage());
                                FSUtils.error("FSAssertionArtifactHandler", "Exception. Invalid subject: " + fSException.getMessage());
                                continue;
                            }
                        }
                        subjectConfirmation = fSSubject.getSubjectConfirmation();
                        if (subjectConfirmation == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.size() != 1) {
                            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: missing or extra ConfirmationMethod.");
                            return null;
                        }
                        string4 = (String)set.iterator().next();
                        if (string4 == null || !string4.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer") && !string4.equals(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT) && !string4.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01")) {
                            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: wrong ConfirmationMethod");
                            return null;
                        }
                        if (!FSUtils.debug.messageEnabled()) continue;
                        FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Confirmation method: " + string4);
                        continue;
                    }
                    if (n != 3) continue;
                    this.bootStrapStatement = (AttributeStatement)statement;
                }
            }
            if (!bl) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: No Authentication statement found in the Assertion. User is not authenticated by the IDP");
                }
                return null;
            }
            date = ((Conditions)object2).getNotOnorAfter();
            if (date != null) {
                l = date.getTime();
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.validateAssertion: Adding " + string + " to idTimeMap.");
            }
            object = idTimeMap;
            synchronized (object) {
                idTimeMap.put(string, new Long(l));
            }
            this.securityAssertion = fSAssertion.getDiscoveryCredential();
        }
        if (fSSubject == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.validateAssertion: couldn't find Subject.");
            return null;
        }
        return fSSubject;
    }

    protected boolean verifyAssertionSignature(FSAssertion fSAssertion) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Called");
        }
        try {
            if (!fSAssertion.isSigned()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Assertion is not signed");
                }
                return false;
            }
            String string = this.idpDescriptor.getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("FSAssertionArtifactHandler.verifyAssertionSignature: xmlString to be verified: " + fSAssertion.getSignedXMLString());
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            int n = fSAssertion.getMinorVersion();
            if (n == 0) {
                return xMLSignatureManager.verifyXMLSignature(fSAssertion.getDOMElement(), "id", string);
            }
            if (n == 2 || n == 1) {
                return xMLSignatureManager.verifyXMLSignature(fSAssertion.getDOMElement(), "AssertionID", string);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.verifyAssertionSignature: Exception occured while verifying IDP's signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean forThisServer(Conditions conditions, String string) {
        FSUtils.debug.message("FSAssertionArtifactHandler.forThisServer: Called");
        if (conditions == null || string == null || string.equals("")) {
            return true;
        }
        Set set = conditions.getAudienceRestrictionCondition();
        if (set == null || set.isEmpty()) {
            return true;
        }
        boolean bl = false;
        Iterator iterator = set.iterator();
        AudienceRestrictionCondition audienceRestrictionCondition = null;
        Object var7_7 = null;
        Object var8_8 = null;
        while (iterator.hasNext()) {
            audienceRestrictionCondition = (AudienceRestrictionCondition)iterator.next();
            if (!audienceRestrictionCondition.containsAudience(string)) continue;
            bl = true;
            if (!FSUtils.debug.messageEnabled()) break;
            FSUtils.debug.message("FSAssertionArtifactHandler.forThisServer: Assertion is validated to befor this server");
            break;
        }
        return bl;
    }

    protected boolean generateToken(NameIdentifier nameIdentifier, int n, String string) {
        FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Called");
        if (nameIdentifier == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Invalid userDN input");
            return false;
        }
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.generateToken:Invalid orgDN input using default orgDN");
            }
            string = SystemProperties.get((String)"com.iplanet.am.defaultOrg");
        }
        try {
            FSSessionManager fSSessionManager;
            FSSession fSSession;
            Object object;
            String string2 = nameIdentifier.getName();
            String string3 = null;
            string3 = n == 0 ? this.getHostProviderId() : this.idpDescriptor.getProviderID();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: Trying to get userDN for opaqueHandle= " + string2 + " ,securityDomain= " + string3 + " And HandleType=" + n);
            }
            FSAccountFedInfoKey fSAccountFedInfoKey = new FSAccountFedInfoKey(string3, string2);
            FSAccountManager fSAccountManager = FSAccountManager.getInstance();
            String string4 = fSAccountManager.getUserDN(fSAccountFedInfoKey, string);
            if (string4 == null) {
                FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Can't dereference handle.");
                return false;
            }
            FSAccountFedInfo fSAccountFedInfo = fSAccountManager.readAccountFedInfo(string4, this.idpDescriptor.getProviderID());
            if (fSAccountFedInfo == null) {
                FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: User's account is not federated");
                return false;
            }
            String string5 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            String string6 = null;
            int n2 = 0;
            Map map = this.localConfig.getSPAuthContextInfo();
            if (this.authnContextStmt != null && this.authnContextStmt.getAuthnContextClassRef() != null && !this.authnContextStmt.getAuthnContextClassRef().equals("")) {
                string6 = this.authnContextStmt.getAuthnContextClassRef();
                if (string6 != null && !string6.equals("")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: AuthnContextClassRef found in AuthenticationStatement:" + string6);
                    }
                    if ((object = (FSSPAuthenticationContextInfo)map.get(string6)) != null) {
                        n2 = ((FSSPAuthenticationContextInfo)object).getAuthenticationLevel();
                    } else {
                        FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find AuthnContextClassInfo for authnContextClassRef: " + string6 + "Using default authnContextClass");
                        string6 = null;
                    }
                }
            } else {
                FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find AuthnContextClassRef in the AuthenticationStatement. Using default authnContextClass");
            }
            if (string6 == null || string6.equals("")) {
                string6 = this.localConfig.getDefaultAuthenticationContext();
                object = (FSSPAuthenticationContextInfo)map.get(string6);
                if (object != null) {
                    n2 = ((FSSPAuthenticationContextInfo)object).getAuthenticationLevel();
                } else {
                    FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Could not find authentication level for default authentication context class");
                    return false;
                }
            }
            object = AuthUtils.getAuthContext(string);
            AuthUtils.getLoginState((AuthContextLocal)object).setHttpServletRequest(this.request);
            ((AuthContextLocal)object).login(AuthContext.IndexType.USER, string4, true);
            SSOToken sSOToken = ((AuthContextLocal)object).getSSOToken();
            sSOToken.setProperty("AuthLevel", new Integer(n2).toString());
            sSOToken.setProperty("authInstant", this.getAuthInstant());
            sSOToken.addSSOTokenListener((SSOTokenListener)new FSTokenListener(this.hostProviderId));
            String string7 = sSOToken.getTokenID().toString();
            this.request.setAttribute(string5, (Object)string7);
            this.relayState = SessionEncodeURL.encodeURL((String)SessionEncodeURL.createCookieString((String)string7), (String)this.relayState, (short)0, (boolean)true);
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler. generateTokenSetting SSOToken as cookie: CookieName=" + string5 + " And cookie value= " + string7 + " And relayState=" + this.relayState);
            }
            Iterator iterator = null;
            Cookie cookie = null;
            if (this.cookieDomainList != null) {
                iterator = this.cookieDomainList.iterator();
                while (iterator != null && iterator.hasNext()) {
                    cookie = CookieUtils.newCookie(string5, string7, "/", (String)iterator.next());
                    this.response.addCookie(cookie);
                }
            } else {
                cookie = CookieUtils.newCookie(string5, string7, "/");
                this.response.addCookie(cookie);
            }
            String string8 = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
            String string9 = "yes";
            Cookie cookie2 = null;
            if (this.cookieDomainList != null) {
                iterator = this.cookieDomainList.iterator();
                while (iterator != null && iterator.hasNext()) {
                    cookie2 = CookieUtils.newCookie(string8, string9, 31536000, "/", (String)iterator.next());
                    this.response.addCookie(cookie2);
                }
            } else {
                cookie2 = CookieUtils.newCookie(string8, string9, 31536000, "/", null);
                this.response.addCookie(cookie2);
            }
            if ((fSSession = (fSSessionManager = FSSessionManager.getInstance(this.hostProviderId)).getSession(string4, string7)) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: No existing session found  for userDN:" + string4 + " And SessionID: " + string7 + " Creating a new Session");
                }
                fSSession.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                fSSession.setSessionIndex(this.idpSessionIndex);
                fSSessionManager.addSession(string4, fSSession);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.generateToken: An Existing session foundfor userDN:" + string4 + " And SessionID: " + string7 + " Adding partner to the Session");
                }
                fSSession = new FSSession(string7);
                fSSession.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                if (this.idpSessionIndex != null) {
                    fSSession.setSessionIndex(this.idpSessionIndex);
                }
                fSSessionManager.addSession(string4, fSSession);
            }
            if (this.bootStrapStatement != null) {
                fSSession.setBootStrapAttributeStatement(this.bootStrapStatement);
            }
            if (this.securityAssertion != null) {
                fSSession.setBootStrapCredential(this.securityAssertion);
            }
            return true;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.generateToken: Exception Occured " + exception.getMessage());
            return false;
        }
    }

    protected void processSAMLRequest() {
    }

    protected boolean doSingleSignOn(NameIdentifier nameIdentifier, int n, String string) {
        FSUtils.debug.message("FSAssertionArtifactHandler.doSingleSignOn: Called");
        boolean bl = true;
        try {
            bl = this.generateToken(nameIdentifier, n, string);
            if (!bl) {
                FSUtils.error("FSAssertionArtifactHandler.doSingleSignOn", FSUtils.bundle.getString("failGenerateSSOToken"));
                return false;
            }
            FSUtils.access("FSAssertionArtifactHandler", FSUtils.bundle.getString("accessGranted") + " " + FSUtils.bundle.getString("redirectTo") + this.relayState);
            this.response.setHeader("Location", this.relayState);
            this.redirectToResource(this.relayState);
            return true;
        }
        catch (Exception exception) {
            FSUtils.error("FSAssertionArtifactHandler.doSingleSignOn", exception.getMessage());
            return false;
        }
    }

    protected void redirectToResource(String string) throws FSException {
    }

    protected boolean doAccountFederation(NameIdentifier nameIdentifier) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        String string2;
        String string3;
        SSOToken sSOToken;
        Object object5;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation:Called");
        }
        if (nameIdentifier == null) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:" + FSUtils.bundle.getString("invalidInput"));
            return false;
        }
        try {
            object5 = SSOTokenManager.getInstance();
            sSOToken = object5.createSSOToken(this.request);
            if (sSOToken == null || !object5.isValidToken(sSOToken)) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: couldn't obtain ssoToken from cookie");
                }
                sSOToken = null;
            }
        }
        catch (SSOException sSOException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: exception when getting ssoToken from cookie:", (Throwable)sSOException);
            }
            sSOToken = null;
        }
        object5 = null;
        if (sSOToken == null) {
            try {
                object5 = FSSessionManager.getInstance(this.hostProviderId);
                sSOToken = ((FSSessionManager)object5).getLocalSSOToken(this.authnRequest.getRequestID());
                string3 = SSOTokenManager.getInstance();
                if (sSOToken == null || !string3.isValidToken(sSOToken)) {
                    FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation: " + FSUtils.bundle.getString("failGenerateSSOToken"));
                    FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("failGenerateSSOToken"));
                    return false;
                }
                this.relayState = sSOToken.encodeURL(this.relayState);
                this.request.setAttribute(SystemProperties.get((String)"com.iplanet.am.cookie.name"), (Object)sSOToken.getTokenID().toString());
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation: " + FSUtils.bundle.getString("failGenerateSSOToken"), (Throwable)exception);
                FSUtils.error("FSAssertionArtifactHandler", FSUtils.bundle.getString("failGenerateSSOToken"));
                return false;
            }
        }
        try {
            FSSession fSSession;
            string3 = nameIdentifier.getName();
            string2 = sSOToken.getPrincipal().getName();
            string = this.idpDescriptor.getProviderID();
            object4 = new FSAccountFedInfo(string, null, nameIdentifier, true);
            object3 = FSAccountManager.getInstance();
            object2 = new FSAccountFedInfoKey(string, string3);
            ((FSAccountManager)object3).writeAccountFedInfo(string2, (FSAccountFedInfoKey)object2, (FSAccountFedInfo)object4);
            if (object5 == null) {
                object5 = FSSessionManager.getInstance(this.hostProviderId);
            }
            if ((fSSession = ((FSSessionManager)object5).getSession(string2, (String)(object = sSOToken.getTokenID().toString()))) != null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: No existing session found  for userDN:" + string2 + " And SessionID: " + (String)object + " Creating a new Session");
                }
                fSSession.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                fSSession.setSessionIndex(this.idpSessionIndex);
                ((FSSessionManager)object5).addSession(string2, fSSession);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionArtifactHandler.doAccountFederation: An Existing session foundfor userDN:" + string2 + " And SessionID: " + (String)object + " Adding partner to the Session");
                }
                fSSession = new FSSession((String)object);
                fSSession.addSessionPartner(new FSSessionPartner(this.idpDescriptor.getProviderID(), true));
                if (this.idpSessionIndex != null) {
                    fSSession.setSessionIndex(this.idpSessionIndex);
                }
                ((FSSessionManager)object5).addSession(string2, fSSession);
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionArtifactHandler.doAccountFederation:" + FSUtils.bundle.getString("ExceptionOccured"), (Throwable)exception);
            return false;
        }
        FSUtils.access("FSAssertionArtifactHandler", FSUtils.bundle.getString("accessGranted") + " " + FSUtils.bundle.getString("redirectTo") + this.relayState);
        this.response.setHeader("Location", this.relayState);
        string3 = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
        string2 = "yes";
        string = null;
        object4 = null;
        if (this.cookieDomainList != null) {
            object4 = this.cookieDomainList.iterator();
            while (object4 != null && object4.hasNext()) {
                string = CookieUtils.newCookie(string3, string2, 31536000, "/", (String)object4.next());
                this.response.addCookie((Cookie)string);
            }
        } else {
            string = CookieUtils.newCookie(string3, string2, 31536000, "/", null);
            this.response.addCookie((Cookie)string);
        }
        try {
            object3 = FSServiceUtils.getAllianceInstance().getHostedProvider(this.hostProviderId);
            if (((FSProviderDescriptor)object3).getNameRegistrationIndicator()) {
                object2 = FSServiceManager.getInstance();
                object = ((FSServiceManager)object2).getNameRegistrationHandler(this.idpDescriptor.getProviderID(), sSOToken.getPrincipal().getName());
                if (object != null) {
                    ((FSNameRegistrationHandler)object).setHostedDescriptor((FSHostedProviderDescriptor)object3);
                    ((FSNameRegistrationHandler)object).handleRegistrationAfterFederation(this.relayState, this.response);
                }
                if (!this.isRegisProfileSOAP(sSOToken.getPrincipal().toString(), this.idpDescriptor.getProviderID(), (FSHostedProviderDescriptor)object3, this.idpDescriptor)) {
                    return true;
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
        }
        catch (SSOException sSOException) {
            // empty catch block
        }
        try {
            this.redirectToResource(this.relayState);
            return true;
        }
        catch (Exception exception) {
            FSUtils.error("FSAssertionArtifactHandler.doAccountFederation", exception.getMessage());
            return false;
        }
    }

    protected FSAuthnRequest getInResponseToRequest(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getInResponseToRequest: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        this.authnRequest = fSSessionManager.getAuthnRequest(string);
        return this.authnRequest;
    }

    protected FSProviderDescriptor getProvider(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getProvider: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        return fSSessionManager.getProviderDescriptor(string);
    }

    public void setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        this.idpDescriptor = fSProviderDescriptor;
    }

    private String DNtoName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        string2 = n2 == -1 ? string.substring(n + 1).trim() : string.substring(n + 1, n2).trim();
        return string2;
    }

    public String getAuthInstant() {
        Date date = new Date();
        String string = null;
        try {
            string = SAMLUtils.dateToString(date);
        }
        catch (ParseException parseException) {
            FSUtils.debug.message("Error getting authInstant ", (Throwable)parseException);
            return null;
        }
        return string;
    }

    private boolean isRegisProfileSOAP(String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor, FSProviderDescriptor fSProviderDescriptor) {
        FSAccountFedInfo fSAccountFedInfo = null;
        try {
            fSAccountFedInfo = FSAccountManager.getInstance().readAccountFedInfo(string, string2);
        }
        catch (FSAccountMgmtException fSAccountMgmtException) {
            FSUtils.debug.message("in excpetion" + fSAccountMgmtException.getMessage());
            return true;
        }
        FSUtils.debug.message("host profile is " + fSHostedProviderDescriptor.getNameRegistrationProfile());
        FSUtils.debug.message("remote profile is " + fSProviderDescriptor.getNameRegistrationProfile());
        if (fSAccountFedInfo.isRoleIDP()) {
            if (fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
                return true;
            }
            if (fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || fSHostedProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
                return false;
            }
            FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
            return true;
        }
        if (fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-soap") || fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-soap")) {
            return true;
        }
        if (fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-sp-http") || fSProviderDescriptor.getNameRegistrationProfile().equalsIgnoreCase("http://projectliberty.org/profiles/rni-idp-http")) {
            return false;
        }
        FSUtils.debug.error("FSNameRegistrationHandler::doRemoteRegistration Invalid registration profile cannot process request");
        return true;
    }

    static {
        cThread.start();
    }
}

