/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.Stats;
import com.iplanet.am.util.StatsListener;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionMapStats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FSSessionManager {
    private static Map instanceMap = new HashMap();
    private Map userDNSessionListMap = Collections.synchronizedMap(new HashMap());
    private Map idAuthnRequestMap = Collections.synchronizedMap(new HashMap());
    private Map idLocalSSOTokenMap = Collections.synchronizedMap(new HashMap());
    private Map idDestnMap = Collections.synchronizedMap(new HashMap());
    private String hostProviderId = null;
    private Map relayStateMap = Collections.synchronizedMap(new HashMap());
    public static Stats sessStats = Stats.getInstance((String)"amFedSessionMaps");
    private FSSessionMapStats dnStats;
    private FSSessionMapStats reqStats;
    private FSSessionMapStats tokenStats;
    private FSSessionMapStats idStats;
    private FSSessionMapStats relayStats;

    public String getRelayState(String string) {
        return (String)this.relayStateMap.get(string);
    }

    public void setRelayState(String string, String string2) {
        this.relayStateMap.put(string, string2);
    }

    public void removeRelayState(String string) {
        this.relayStateMap.remove(string);
    }

    public FSAuthnRequest getAuthnRequest(String string) {
        FSUtils.debug.message("FSSessionManager.getAuthnRequest: Called");
        return (FSAuthnRequest)this.idAuthnRequestMap.get(string);
    }

    public void setAuthnRequest(String string, FSAuthnRequest fSAuthnRequest) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.setAuthnRequest: Called, ID=" + string);
        }
        this.idAuthnRequestMap.put(string, fSAuthnRequest);
    }

    public void removeAuthnRequest(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager.removeAuthnRequest: Called, ID=" + string);
        }
        this.idAuthnRequestMap.remove(string);
        this.idDestnMap.remove(string);
    }

    public SSOToken getLocalSSOToken(String string) {
        FSUtils.debug.message("FSSessionManager.getLocalSSOToken: Called");
        return (SSOToken)this.idLocalSSOTokenMap.get(string);
    }

    public void setLocalSSOToken(String string, SSOToken sSOToken) {
        FSUtils.debug.message("FSSessionManager.setLocalSSOToken: Called");
        this.idLocalSSOTokenMap.put(string, sSOToken);
    }

    public void removeLocalSSOToken(String string) {
        FSUtils.debug.message("FSSessionManager.removeLocalSSOToken: Called");
        this.idLocalSSOTokenMap.remove(string);
    }

    public FSProviderDescriptor getProviderDescriptor(String string) {
        FSUtils.debug.message("FSSessionManager.getProviderDescriptor: Called");
        return (FSProviderDescriptor)this.idDestnMap.get(string);
    }

    public void setProviderDescriptor(String string, FSProviderDescriptor fSProviderDescriptor) {
        FSUtils.debug.message("FSSessionManager.setProviderDescriptor:Called");
        this.idDestnMap.put(string, fSProviderDescriptor);
    }

    public List getSessionList(String string) {
        FSUtils.debug.message("FSSessionManager.getSessionList: Called");
        string = string.toLowerCase();
        return (List)this.userDNSessionListMap.get(string);
    }

    public void setSessionList(String string, List list) {
        FSUtils.debug.message("FSSessionManager.setSessionList: Called");
        string = string.toLowerCase();
        this.userDNSessionListMap.put(string, list);
    }

    public void removeSessionList(String string) {
        FSUtils.debug.message("FSSessionManager.removeSessionList: Called");
        string = string.toLowerCase();
        this.userDNSessionListMap.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSSession getSession(String string, String string2) {
        FSUtils.debug.message("FSSessionManager.getSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (!fSSession.isEquals(string2)) continue;
                    return fSSession;
                }
            }
        }
        return null;
    }

    public FSSession getSession(SSOToken sSOToken) {
        FSUtils.debug.message("FSSessionManager.getSession: Called");
        try {
            String string = sSOToken.getPrincipal().getName();
            String string2 = sSOToken.getTokenID().toString();
            return this.getSession(string, string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSessionManager.getSession: " + exception.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProvider(String string, String string2) {
        FSUtils.debug.message("FSSessionManager.removeProvider: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession = (FSSession)iterator.next();
                    if (fSSession == null) continue;
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("removeSessionPartner : " + string2);
                    }
                    fSSession.removeSessionPartner(string2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String string, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.removeSession(2):  Called ");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession2 = (FSSession)iterator.next();
                    if (!fSSession2.equals(fSSession)) continue;
                    list.remove(fSSession2);
                    break;
                }
            }
            if (list.isEmpty()) {
                this.removeSessionList(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(String string, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.addSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            List list2 = list;
            synchronized (list2) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    FSSession fSSession2 = (FSSession)iterator.next();
                    if (!fSSession2.equals(fSSession)) continue;
                    return;
                }
                list.add(fSSession);
                return;
            }
        }
        ArrayList<FSSession> arrayList = new ArrayList<FSSession>();
        arrayList.add(fSSession);
        this.setSessionList(string, arrayList);
    }

    private FSSessionManager(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSSessionManager(): create " + string);
        }
        this.hostProviderId = string;
        if (sessStats.isEnabled()) {
            this.dnStats = new FSSessionMapStats(this.userDNSessionListMap, "userDNSessionListMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.dnStats);
            this.reqStats = new FSSessionMapStats(this.idAuthnRequestMap, "idAuthnRequestMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.reqStats);
            this.tokenStats = new FSSessionMapStats(this.idLocalSSOTokenMap, "idLocalSSOTokenMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.tokenStats);
            this.idStats = new FSSessionMapStats(this.idDestnMap, "idDestnMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.idStats);
            this.relayStats = new FSSessionMapStats(this.relayStateMap, "relayStateMap", this.hostProviderId);
            sessStats.addStatsListener((StatsListener)this.relayStats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized FSSessionManager getInstance(String string) {
        FSUtils.debug.message("FSSessionManager.getInstance: Called");
        if (string == null) {
            FSUtils.debug.error("FSSessionManager.getInstance: null provider ID");
            return null;
        }
        FSSessionManager fSSessionManager = (FSSessionManager)instanceMap.get(string);
        if (fSSessionManager == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSSessionManager.getInstance: Constructing a new instance of FSSessionManager: " + string);
            }
            fSSessionManager = new FSSessionManager(string);
            Map map = instanceMap;
            synchronized (map) {
                instanceMap.put(string, fSSessionManager);
            }
        }
        return fSSessionManager;
    }
}

