/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSFederationTerminationNotification;
import com.sun.identity.federation.message.FSLogoutNotification;
import com.sun.identity.federation.message.FSNameRegistrationRequest;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSAMLRequest;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSServiceManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSSSOBrowserArtifactProfileHandler;
import com.sun.identity.federation.services.fednsso.FSSSOLECPProfileHandler;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSPreLogoutHandler;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.termination.FSFedTerminationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.messaging.JAXMServlet;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSSOAPReceiver
extends JAXMServlet {
    private static MessageFactory msgFactory = null;
    private static FSSOAPService soapService = FSSOAPService.getInstance();

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            msgFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            FSUtils.debug.error("FSSOAPReceiver:Unable to get message factory", (Throwable)sOAPException);
            throw new ServletException(sOAPException.getMessage());
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        FSUtils.debug.message("FSSOAPReceiver.doPost: Called");
        FSUtils.checkHTTPRequestLength(httpServletRequest);
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSSOAPReceiver: notLibertyEnabled");
            FSUtils.error("FSSOAPReceiver", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        try {
            MimeHeaders mimeHeaders = JAXMServlet.getHeaders((HttpServletRequest)httpServletRequest);
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            SOAPMessage sOAPMessage = msgFactory.createMessage(mimeHeaders, (InputStream)servletInputStream);
            this.onMessage(httpServletRequest, httpServletResponse, sOAPMessage);
            return;
        }
        catch (SOAPException sOAPException) {
            throw new ServletException((Throwable)sOAPException);
        }
    }

    /*
     * Exception decompiling
     */
    public void onMessage(HttpServletRequest var1_1, HttpServletResponse var2_2, SOAPMessage var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private FSNameRegistrationResponse handleRegistrationRequest(Element element, SOAPMessage sOAPMessage, FSHostedProviderDescriptor fSHostedProviderDescriptor) {
        try {
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return null;
            }
            if (!FSServiceUtils.isSigningOn() || this.verifyRegistrationSignature(element, sOAPMessage)) {
                Set set;
                FSUtils.debug.message("Registration Signature successfully passed");
                FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest(element);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.onMessage: Completed forming request FSNameRegistrationRequest");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(fSNameRegistrationRequest.getProviderId())) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSNameRegistrationHandler fSNameRegistrationHandler = fSServiceManager.getNameRegistrationHandler(fSNameRegistrationRequest, fSHostedProviderDescriptor);
                        fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                        FSNameRegistrationResponse fSNameRegistrationResponse = fSNameRegistrationHandler.processRegistrationRequest(fSNameRegistrationRequest);
                        return fSNameRegistrationResponse;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process registration request");
                    }
                    return null;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.message("Registration Signature failed verification");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationHandler.doPost.doGet: Exception occured " + exception.getMessage());
            return null;
        }
    }

    private boolean handleTerminationRequest(Element element, SOAPMessage sOAPMessage, HttpServletRequest httpServletRequest) {
        try {
            if (!FSServiceUtils.isSigningOn() || this.verifyTerminationSignature(element, sOAPMessage)) {
                Set set;
                FSHostedProviderDescriptor fSHostedProviderDescriptor;
                FSUtils.debug.message("Termination Signature successfully verified");
                String string = FSServiceUtils.getMetaAlias(httpServletRequest);
                if (string == null || string.length() < 1) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
                    }
                    return false;
                }
                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                if (fSAllianceManager == null) {
                    FSUtils.debug.message("Unable to get alliance manager");
                    return false;
                }
                try {
                    fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string);
                    if (fSHostedProviderDescriptor == null) {
                        throw new FSAllianceManagementException(null);
                    }
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("Unable to find Hosted Provider. Cannot process request");
                    }
                    return false;
                }
                FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification(element);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Completed forming request FSFederationTerminationNotification");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(fSFederationTerminationNotification.getProviderId())) {
                    FSServiceManager fSServiceManager = FSServiceManager.getInstance();
                    if (fSServiceManager != null) {
                        FSFedTerminationHandler fSFedTerminationHandler = fSServiceManager.getFedTerminationHandler(fSFederationTerminationNotification, fSHostedProviderDescriptor);
                        if (fSFedTerminationHandler != null) {
                            fSFedTerminationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
                            boolean bl = fSFedTerminationHandler.processTerminationRequest(fSFederationTerminationNotification);
                            return bl;
                        }
                        FSUtils.debug.message("Unable to get Termination Handler");
                        return false;
                    }
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSServiceManager instance is null. Cannot process termination request");
                    }
                    return false;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return false;
            }
            FSUtils.debug.message("Termination Signature failed verification");
            return false;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPService::handleTerminationRequest failed " + exception.getMessage());
            return false;
        }
    }

    private SOAPMessage handleLogoutRequest(Element element, SOAPMessage sOAPMessage, HttpServletRequest httpServletRequest) {
        try {
            if (!FSServiceUtils.isSigningOn() || this.verifyLogoutSignature(element, sOAPMessage)) {
                Set set;
                FSHostedProviderDescriptor fSHostedProviderDescriptor;
                FSUtils.debug.message("Logout Signature successfully verified");
                String string = FSServiceUtils.getMetaAlias(httpServletRequest);
                if (string == null || string.length() < 1) {
                    FSUtils.debug.message("Unable to retrieve alias, Hosted Provider Cannot process logout request");
                    return null;
                }
                FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                if (fSAllianceManager == null) {
                    FSUtils.debug.error("Unable to get alliance manager ");
                    FSUtils.debug.error("Cannot process logout request");
                    return null;
                }
                try {
                    fSHostedProviderDescriptor = fSAllianceManager.getHostedProviderByMetaAlias(string);
                    if (fSHostedProviderDescriptor == null) {
                        throw new FSAllianceManagementException(null);
                    }
                }
                catch (FSAllianceManagementException fSAllianceManagementException) {
                    FSUtils.debug.error("Unable to find Hosted Provider. Cannot process logout request");
                    return null;
                }
                FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest: Completed forming request FSLogoutNotification");
                }
                if ((set = fSHostedProviderDescriptor.getLocalConfiguration().getActiveTrustedProviders()) != null && set.contains(fSLogoutNotification.getProviderId())) {
                    Object object;
                    StringBuffer stringBuffer;
                    Object object2;
                    Object object3;
                    Object object4;
                    FSLogoutUtil fSLogoutUtil = new FSLogoutUtil();
                    String string2 = FSLogoutUtil.getUserDN(fSLogoutNotification, fSHostedProviderDescriptor.getProviderID());
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequest found userDN = " + string2);
                    }
                    if (!this.isUserExists(string2, fSHostedProviderDescriptor.getProviderID())) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestUser does not exist locally. Finding remotely");
                        }
                        if ((object4 = WebtopNaming.getPlatformServerList()) == null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestplatformList is null");
                            }
                            return null;
                        }
                        object3 = ((Vector)object4).iterator();
                        while (object3.hasNext()) {
                            object2 = (String)object3.next();
                            stringBuffer = new StringBuffer((String)object2);
                            stringBuffer.append(SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor"));
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestremoteServerURL = " + (String)object2 + " and self serverUrl =" + FSServiceUtils.getBaseURL());
                            }
                            if (FSServiceUtils.getBaseURL().equalsIgnoreCase(((String)object2).toString()) || !((FSAssertionManagerClient)(object = new FSAssertionManagerClient(fSHostedProviderDescriptor.getProviderID(), this.getFullServiceURL((String)object2)))).isUserExists(string2, fSHostedProviderDescriptor.getProviderID())) continue;
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSSOAPReceiver:handleLogoutRequestuser found here  = " + (String)object2);
                            }
                            StringBuffer stringBuffer2 = new StringBuffer();
                            stringBuffer2.append(((String)object2).toString());
                            stringBuffer2.append("/amserver");
                            stringBuffer2.append("/SOAPReceiver");
                            stringBuffer2.append("/");
                            stringBuffer2.append("metaAlias");
                            stringBuffer2.append("/");
                            stringBuffer2.append(string);
                            FSSOAPService fSSOAPService = FSSOAPService.getInstance();
                            SOAPMessage sOAPMessage2 = null;
                            if (fSSOAPService != null) {
                                try {
                                    if (FSUtils.debug.messageEnabled()) {
                                        FSUtils.debug.message("Forwarding logout request to " + stringBuffer2.toString());
                                    }
                                    sOAPMessage2 = fSSOAPService.sendLogoutMessage(sOAPMessage, stringBuffer2.toString());
                                    return sOAPMessage2;
                                }
                                catch (SOAPException sOAPException) {
                                    FSUtils.debug.error("FSSOAPException in doSOAPProfile Cannot send request" + sOAPException.getMessage());
                                    return sOAPMessage2;
                                }
                            }
                            return null;
                        }
                    }
                    if ((object4 = FSServiceManager.getInstance()) != null) {
                        object3 = ((FSServiceManager)object4).getPreLogoutHandler();
                        if (object3 != null) {
                            ((FSPreLogoutHandler)object3).setHostedDescriptor(fSHostedProviderDescriptor);
                            object2 = ((FSPreLogoutHandler)object3).processSingleLogoutRequest(fSLogoutNotification);
                            if (((FSLogoutStatus)object2).getStatus().equalsIgnoreCase("samlp:Success")) {
                                stringBuffer = MessageFactory.newInstance();
                                object = stringBuffer.createMessage();
                                return object;
                            }
                            if (((FSLogoutStatus)object2).getStatus().equalsIgnoreCase("lib:Unsupported")) {
                                return soapService.getLogoutSOAPFault();
                            }
                            return null;
                        }
                        FSUtils.debug.error("Unable to get PreLogoutHandler");
                        FSUtils.debug.error("Cannot process request");
                        return null;
                    }
                    FSUtils.debug.message("FSServiceManager instance is null. Cannot process termination request");
                    return null;
                }
                FSUtils.debug.message("Remote provider not in trusted list");
                return null;
            }
            FSUtils.debug.message("Logout Signature failed verification");
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPService::handleLogoutRequest failed " + exception.getMessage());
            return null;
        }
    }

    private FSResponse handleSAMLRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSSAMLRequest fSSAMLRequest, Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("FSSOAPReceiver.handleSAMLRequest: Called");
        try {
            Object object;
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            if (string == null) {
                object = FSServiceUtils.getMetaAlias(httpServletRequest);
                string = FSServiceUtils.getAllianceInstance().getHostedProviderByMetaAlias((String)object).getProviderID();
            }
            object = FSServiceManager.getInstance();
            FSSSOBrowserArtifactProfileHandler fSSSOBrowserArtifactProfileHandler = (FSSSOBrowserArtifactProfileHandler)((FSServiceManager)object).getBrowserArtifactSSOAndFedHandler(httpServletRequest, httpServletResponse, fSSAMLRequest);
            fSSSOBrowserArtifactProfileHandler.setSOAPMessage(sOAPMessage);
            fSSSOBrowserArtifactProfileHandler.setSAMLRequestElement(element);
            fSSSOBrowserArtifactProfileHandler.setHostProviderId(string);
            return fSSSOBrowserArtifactProfileHandler.processSAMLRequest(fSSAMLRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured " + exception.getMessage());
            return null;
        }
    }

    private void handleLECPRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSSOAPReceiver.handleLECPRequest: Called");
        try {
            String string = FSServiceUtils.getHostedProviderID(httpServletRequest);
            FSServiceManager fSServiceManager = FSServiceManager.getInstance();
            FSSSOLECPProfileHandler fSSSOLECPProfileHandler = fSServiceManager.getLECPProfileHandler(httpServletRequest, httpServletResponse, fSAuthnRequest);
            fSSSOLECPProfileHandler.setHostProviderId(string);
            fSSSOLECPProfileHandler.processLECPAuthnRequest(fSAuthnRequest);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSSOAndFedService.onMessage: Exception occured " + exception.getMessage());
            return;
        }
    }

    protected boolean verifyRegistrationSignature(Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Name Registration.verifyRegistrationSignature: Called");
        try {
            FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest(element);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSNameRegistrationRequest.getProviderId()).getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Registration.verifyRegistrationSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("NameRegistration.verifyRegistrationSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("Request : " + fSNameRegistrationRequest.toXMLString(true, true));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("NameRegistration.verifyRegistrationSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyTerminationSignature(Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("Federation Termination.verifyTerminationSignature: Called");
        try {
            FSFederationTerminationNotification fSFederationTerminationNotification = new FSFederationTerminationNotification(element);
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSFederationTerminationNotification.getProviderId()).getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Federation Termination.verifyTerminationSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Federation Termination.verifyTerminationSignature: Provider's certAlias is found: " + string);
                FSUtils.debug.message("Federation Termination.verifyTerminationSignature: xmlString to be verified: " + XMLUtils.print((Node)element));
            }
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("Federation Termination.verifyTerminationSignature: Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected boolean verifyLogoutSignature(Element element, SOAPMessage sOAPMessage) {
        FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature: Called");
        try {
            FSLogoutNotification fSLogoutNotification = new FSLogoutNotification(element);
            FSUtils.debug.message("Completed forming request FSLogoutNotification");
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            if (fSAllianceManager == null) {
                FSUtils.debug.message("Unable to get alliance manager");
                return false;
            }
            String string = fSAllianceManager.getProvider(fSLogoutNotification.getProviderId()).getKeyInfo();
            if (string == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSOAPReceiver.verifyLogoutSignature: couldn't obtain this site's cert alias.");
                }
                throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
            }
            FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature : Provider's certAlias is found : " + string);
            FSUtils.debug.message("FSSOAPReceiver::verifyLogoutSignature: xmlString to be verified: " + XMLUtils.print((Node)element));
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
            return xMLSignatureManager.verifyXMLSignature(document, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOPAReceiver::verifyLogoutSignature  Exception occured while verifying signature:" + exception.getMessage());
            return false;
        }
    }

    protected SOAPMessage signRegistrationResponse(SOAPMessage sOAPMessage, String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws SAMLException, FSMsgException {
        FSUtils.debug.message("Entered FSNameRegistrationHandler::signRegistrationResponse");
        String string3 = fSHostedProviderDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationHandler::signRegistrationResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("FSNameRegistrationHandler::RegistrationResponse:Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    protected SOAPMessage signLogoutResponse(SOAPMessage sOAPMessage, String string, String string2, FSHostedProviderDescriptor fSHostedProviderDescriptor) throws SAMLException, FSMsgException {
        FSUtils.debug.message("SOAPReceiver::Entered signLogoutResponse::");
        String string3 = fSHostedProviderDescriptor.getKeyInfo();
        if (string3 == null || string3.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("signLogoutResponse::signRegistrationResponse: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        FSUtils.debug.message("signLogoutResponse::Provider's certAlias is found: " + string3);
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        Document document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
        String string4 = "//*[local-name()='ProviderID']";
        xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string, string2, false, string4);
        return FSServiceUtils.convertDOMToSOAP(document);
    }

    private void returnSOAPMessage(SOAPMessage sOAPMessage, HttpServletResponse httpServletResponse) {
        try {
            if (sOAPMessage != null) {
                JAXMServlet.putHeaders((MimeHeaders)sOAPMessage.getMimeHeaders(), (HttpServletResponse)httpServletResponse);
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                sOAPMessage.writeTo((OutputStream)servletOutputStream);
                servletOutputStream.flush();
                return;
            }
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnSOAPMessage: Exception::" + exception.getMessage());
            return;
        }
    }

    private void returnTerminationStatus(HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.setStatus(204);
            httpServletResponse.flushBuffer();
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSOAPReceiver.returnFedTerminationStatus: Exception::" + exception.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserExists(String string, String string2) {
        try {
            FSSessionManager fSSessionManager;
            FSSessionManager fSSessionManager2 = fSSessionManager = FSSessionManager.getInstance(string2);
            synchronized (fSSessionManager2) {
                List list;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("About to call getSessionList");
                }
                if ((list = fSSessionManager.getSessionList(string)) == null) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("AMC:isUserExists:List is empty");
                    }
                    return false;
                }
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AMC:isUserExists: List is not emptyUser found: " + string);
                }
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            String string3 = "fsassertionmanager";
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)string3, (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }
}

