/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.XMLUtils;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.DescriptionType;
import com.sun.identity.liberty.ws.disco.jaxb.DirectiveType;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.NameIdentifier;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FSDiscoveryBootStrap {
    private AttributeStatement _bootStrapStatement = null;
    private SecurityAssertion _assertion = null;
    private SSOToken _ssoToken = null;
    private boolean _hasCredentials = false;

    public FSDiscoveryBootStrap(SSOToken sSOToken, AuthnContext authnContext, FSSubject fSSubject, String string) throws FSException {
        if (fSSubject == null || string == null) {
            FSUtils.debug.error("FSDiscoBootStrap: null values.");
            throw new FSException(FSUtils.bundle.getString("nullInputParams"));
        }
        this._ssoToken = sSOToken;
        try {
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            ArrayList<Element> arrayList2 = new ArrayList<Element>();
            Document document = this.getResourceOffering(fSSubject, authnContext, string);
            arrayList2.add(document.getDocumentElement());
            Attribute attribute = new Attribute("DiscoveryResourceOffering", "urn:liberty:disco:2003-08", arrayList2);
            arrayList.add(attribute);
            this._bootStrapStatement = new AttributeStatement(fSSubject, arrayList);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSDiscoBootStrap: Constructorwhile creating discovery bootstrap statement", (Throwable)exception);
            throw new FSException(exception);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Document getResourceOffering(FSSubject var1_1, AuthnContext var2_2, String var3_3) throws FSException {
        FSUtils.debug.message("FSDiscoveryBootStrap.getResourceOffering:Init");
        var4_4 = new StringBuffer(300);
        var4_4.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append("\n");
        var5_5 = DiscoServiceManager.getBootstrappingDiscoEntry();
        if (var5_5 == null) {
            throw new FSException(FSUtils.bundle.getString("nullDiscoveryOffering"));
        }
        try {
            block13: {
                var6_6 = var5_5.getResourceOffering();
                var7_8 = var6_6.getServiceInstance();
                var8_9 = var7_8.getProviderID();
                var9_10 = DiscoServiceManager.getResourceIDMapper(var8_9);
                if (var9_10 == null) {
                    var9_10 = DiscoServiceManager.getDefaultResourceIDMapper();
                }
                var10_11 = new ObjectFactory();
                var11_12 = var10_11.createResourceIDType();
                var12_13 = var9_10.getResourceID(var8_9, var3_3);
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSDiscoveryBootStrap.getResourceOffering: ResourceID Value:" + var12_13);
                }
                var11_12.setValue(var12_13);
                var6_6.setResourceID(var11_12);
                var13_14 = DocumentBuilderFactory.newInstance();
                var13_14.setNamespaceAware(true);
                var14_15 = var13_14.newDocumentBuilder();
                var15_16 = var14_15.newDocument();
                DiscoUtils.getDiscoMarshaller().marshal((Object)var6_6, (Node)var15_16);
                var16_17 = var15_16.getDocumentElement();
                var17_18 = new ResourceOffering(var16_17);
                var18_19 = var5_5.getAny();
                var19_20 = false;
                var20_21 = new HashSet<String>();
                if (var18_19 == null || var18_19.isEmpty()) break block13;
                var21_22 = var18_19.iterator();
                while (var21_22.hasNext()) {
                    block15: {
                        block14: {
                            var22_23 /* !! */  = var21_22.next();
                            if (var22_23 /* !! */  instanceof EncryptResourceIDElement) continue;
                            if (!(var22_23 /* !! */  instanceof AuthenticateRequesterElement) && !(var22_23 /* !! */  instanceof AuthorizeRequesterElement)) break block14;
                            this._hasCredentials = true;
                            var19_20 = true;
                            var23_24 = ((DirectiveType)var22_23 /* !! */ ).getDescriptionIDRefs().iterator();
                            if (var23_24.hasNext()) ** GOTO lbl48
                            continue;
lbl-1000:
                            // 1 sources

                            {
                                var24_25 = (DescriptionType)var23_24.next();
                                var25_26 = var24_25.getId();
                                if (var25_26 == null) continue;
                                var20_21.add(var25_26);
lbl48:
                                // 3 sources

                                ** while (var23_24.hasNext())
                            }
lbl49:
                            // 1 sources

                            continue;
                        }
                        if (!(var22_23 /* !! */  instanceof AuthenticateSessionContextElement)) break block15;
                        this._hasCredentials = true;
                        var23_24 = ((DirectiveType)var22_23 /* !! */ ).getDescriptionIDRefs().iterator();
                        if (var23_24.hasNext()) ** GOTO lbl61
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            var24_25 = (DescriptionType)var23_24.next();
                            var25_26 = var24_25.getId();
                            if (var25_26 == null) continue;
                            var20_21.add(var25_26);
lbl61:
                            // 3 sources

                            ** while (var23_24.hasNext())
                        }
lbl62:
                        // 1 sources

                        continue;
                    }
                    FSUtils.debug.error("FSDiscoveryBootStrap.getResourceOffering: Unknow directive");
                    break;
                }
            }
            if (!this._hasCredentials) {
                this._hasCredentials = DiscoServiceManager.needSessionContextStatement();
            }
            if (this._hasCredentials) {
                this._assertion = this.generateCredentials(var8_9, var2_2, var1_1, var19_20, var12_13);
            }
            var21_22 = var17_18.getServiceInstance();
            if (var20_21 != null && !var20_21.isEmpty()) {
                var22_23 /* !! */  = var21_22.getDescription();
                var23_24 = var22_23 /* !! */ .iterator();
                while (var23_24.hasNext()) {
                    var24_25 = (Description)var23_24.next();
                    var25_26 = var24_25.getId();
                    if (var25_26 == null || !var20_21.contains(var25_26)) continue;
                    var24_25.getCredentialRef().add(this._assertion.getAssertionID());
                }
            }
            var4_4.append(var17_18.toString());
            var4_4.append("</").append("saml:").append("AttributeValue>");
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSDiscoveryBootStap.getResourceOffering:Resource Offering:" + var4_4.toString());
            }
            return XMLUtils.toDOMDocument((String)var4_4.toString(), null);
        }
        catch (Exception var6_7) {
            FSUtils.debug.error("FSDiscoveryBootStrap.getResourceOffering:Exception while creating resource offering.", (Throwable)var6_7);
            throw new FSException(var6_7);
        }
    }

    private SecurityAssertion generateCredentials(String string, AuthnContext authnContext, FSSubject fSSubject, boolean bl, Object object) throws FSException {
        if (string == null || object == null) {
            FSUtils.debug.error("FSDiscoveryBootStrap.generateCredentials:NullInput Params");
            throw new FSException(FSUtils.bundle.getString("nullInputParams"));
        }
        try {
            NameIdentifier nameIdentifier = new NameIdentifier(string, null, "urn:liberty:iff:nameid:entityID");
            SessionSubject sessionSubject = new SessionSubject(fSSubject.getNameIdentifier(), fSSubject.getSubjectConfirmation(), fSSubject.getIDPProvidedNameIdentifier());
            SessionContext sessionContext = new SessionContext(sessionSubject, authnContext, string);
            SecurityTokenManager securityTokenManager = new SecurityTokenManager(this._ssoToken);
            securityTokenManager.setCertAlias(this.getProviderCertAlias(string));
            this._assertion = object instanceof String ? securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, (String)object, true, bl) : securityTokenManager.getSAMLAuthorizationToken(nameIdentifier, sessionContext, (EncryptedResourceID)object, true, bl);
            return this._assertion;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSDiscoveryBootStrap.generateCredentials:Exception while generating credentials", (Throwable)exception);
            throw new FSException(exception);
        }
    }

    private String getProviderCertAlias(String string) throws FSException {
        try {
            FSProviderDescriptor fSProviderDescriptor = FSServiceUtils.getAllianceInstance().getProvider(string);
            return fSProviderDescriptor.getKeyInfo();
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSDiscoveryBootStrap.getProviderCertAlias:Exception while trying to get the certificate alias", (Throwable)exception);
            throw new FSException(exception);
        }
    }

    public boolean hasCredentials() {
        return this._hasCredentials;
    }

    public Advice getCredentials() {
        if (this._assertion != null) {
            ArrayList<SecurityAssertion> arrayList = new ArrayList<SecurityAssertion>();
            arrayList.add(this._assertion);
            return new Advice(null, arrayList, null);
        }
        return null;
    }

    public AttributeStatement getBootStrapStatement() {
        return this._bootStrapStatement;
    }
}

