/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.services.FSAuthContextResult;
import com.sun.identity.federation.services.FSAuthnDecisionSPI;
import com.sun.identity.federation.services.util.FSServiceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class FSAuthnDecisionImpl
implements FSAuthnDecisionSPI {
    private Map idpAuthContextMap = null;
    private Map authPriorityModule = null;
    private String loginURL = null;
    private static boolean messageEnabled = false;
    private static FSAllianceManager alliancemanager = null;
    private int compAuthType = 0;

    public FSAuthnDecisionImpl(String string, HttpServletRequest httpServletRequest) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthnDecisionImpl::Constructor called with providerID" + string);
        }
        this.loginURL = FSServiceUtils.getBaseURL(httpServletRequest) + "/UI/Login";
        this.loginURL = this.loginURL + '?' + "arg" + '=' + "newsession";
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = alliancemanager.getHostedProvider(string);
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            this.idpAuthContextMap = (HashMap)fSLocalConfigurationDescriptor.getIDPAuthContextInfo();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSPostLogin::getFederationPage in alliance exception " + fSAllianceManagementException.getMessage());
        }
    }

    private boolean doesQueryStringExist(String string) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthnDecisionImpl::doesQueryStringExistin url" + string);
        }
        int n = 0;
        n = string.indexOf(63);
        return n != -1;
    }

    private void fillAuthMap() {
        Set set = this.idpAuthContextMap.entrySet();
        Iterator iterator = set.iterator();
        FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = null;
        this.authPriorityModule = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            fSIDPAuthenticationContextInfo = (FSIDPAuthenticationContextInfo)entry.getValue();
            this.authPriorityModule.put(new Integer(fSIDPAuthenticationContextInfo.getPriority()), fSIDPAuthenticationContextInfo);
        }
    }

    private FSIDPAuthenticationContextInfo getHigherAuthContext(int n) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::getHigherAuthContext called.");
        }
        --n;
        this.fillAuthMap();
        while (n > 0) {
            Object var2_2 = null;
            FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = (FSIDPAuthenticationContextInfo)this.authPriorityModule.get(new Integer(n));
            if (fSIDPAuthenticationContextInfo != null && fSIDPAuthenticationContextInfo.getIsSupported()) {
                return fSIDPAuthenticationContextInfo;
            }
            --n;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::getHigherAuthContext returning null");
        }
        return null;
    }

    public FSAuthContextResult decideAuthnContext(List list, String string, String string2) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::decideAuthnContext called with list. " + list + " and authComparisonType " + string2);
        }
        if (string2 == null) {
            string2 = "minimum";
        }
        FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
        if (list != null && string2 != null) {
            if (string2 != null && string2.equals("exact")) {
                fSAuthContextResult = this.decideAuthnContext(list, string);
                return fSAuthContextResult;
            }
            if (string2 != null && string2.equals("minimum")) {
                this.compAuthType = 1;
            } else if (string2 != null && string2.equals("better")) {
                this.compAuthType = 2;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                fSAuthContextResult = this.decideAuthnContext(string3, string);
                if (fSAuthContextResult == null || fSAuthContextResult.getLoginURL() == null) continue;
                return fSAuthContextResult;
            }
        }
        return fSAuthContextResult;
    }

    public FSAuthContextResult getURLForAuthnContext(List list, String string) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::decideAuthnContext called with list. " + list + " and authComparisonType " + string);
        }
        if (string == null) {
            string = "minimum";
        }
        FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
        if (list != null && string != null) {
            if (string != null && string.equals("exact")) {
                fSAuthContextResult = this.getURLForAuthnContext(list);
                return fSAuthContextResult;
            }
            if (string != null && string.equals("minimum")) {
                this.compAuthType = 1;
            } else if (string != null && string.equals("better")) {
                this.compAuthType = 2;
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                fSAuthContextResult = this.getURLForAuthnContext(string2);
                if (fSAuthContextResult == null || fSAuthContextResult.getLoginURL() == null) continue;
                return fSAuthContextResult;
            }
        }
        return fSAuthContextResult;
    }

    public FSAuthContextResult getURLForAuthnContext(List list) {
        int n = 0;
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::getURLForAuthContext. Entered method");
        }
        if (list != null && this.idpAuthContextMap != null) {
            Object object;
            int n2 = 0;
            while (n2 < list.size()) {
                object = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get((String)list.get(n));
                if (messageEnabled) {
                    FSUtils.debug.message("FSAuthnDecisionImpl::getURLForAuthnContextin auth context checking for " + (String)list.get(n));
                }
                if (object != null) {
                    String string = ((FSIDPAuthenticationContextInfo)object).getModuleIndicatorValue();
                    String string2 = ((FSIDPAuthenticationContextInfo)object).getModuleIndicatorKey();
                    String string3 = new String();
                    if (((FSIDPAuthenticationContextInfo)object).getIsSupported() && this.loginURL != null) {
                        FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
                        string3 = !string2.equalsIgnoreCase("none") && string != null ? this.loginURL + "&" + ((FSIDPAuthenticationContextInfo)object).getModuleIndicatorKey() + "=" + string : this.loginURL;
                        fSAuthContextResult.setLoginURL(string3);
                        fSAuthContextResult.setAuthContextRef(((FSIDPAuthenticationContextInfo)object).getAuthenticationContext());
                        return fSAuthContextResult;
                    }
                }
                ++n;
                ++n2;
            }
            FSUtils.debug.error("FSAuthnDecisionImpl::getURLForAuthnContext Required authenticationContext not avialable");
            object = new FSAuthContextResult();
            return object;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::getURLForAuthContext. Method called withauthenticationContext null");
        }
        FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
        return fSAuthContextResult;
    }

    public FSAuthContextResult getURLForAuthnContext(String string) {
        boolean bl = false;
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::getURLForAuthContext. Entered method");
        }
        if (string != null && this.idpAuthContextMap != null) {
            FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(string);
            if (messageEnabled) {
                FSUtils.debug.message("FSAuthnDecisionImpl::getURLForAuthnContextin auth context checking for " + string);
            }
            if (fSIDPAuthenticationContextInfo != null) {
                String string2 = fSIDPAuthenticationContextInfo.getModuleIndicatorValue();
                String string3 = fSIDPAuthenticationContextInfo.getModuleIndicatorKey();
                String string4 = new String();
                if (!fSIDPAuthenticationContextInfo.getIsSupported() || this.compAuthType == 2) {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSAuthnDecisionImpl::getURLForAuthnContextThe given authContextMinRef not supported");
                    }
                    if ((fSIDPAuthenticationContextInfo = this.getHigherAuthContext(fSIDPAuthenticationContextInfo.getPriority())) != null) {
                        string2 = fSIDPAuthenticationContextInfo.getModuleIndicatorValue();
                        string3 = fSIDPAuthenticationContextInfo.getModuleIndicatorKey();
                    }
                }
                if (this.loginURL != null && fSIDPAuthenticationContextInfo.getIsSupported()) {
                    FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
                    string4 = !string3.equalsIgnoreCase("none") && string2 != null ? this.loginURL + "&" + fSIDPAuthenticationContextInfo.getModuleIndicatorKey() + "=" + string2 : this.loginURL;
                    fSAuthContextResult.setLoginURL(string4);
                    fSAuthContextResult.setAuthContextRef(fSIDPAuthenticationContextInfo.getAuthenticationContext());
                    return fSAuthContextResult;
                }
                FSUtils.debug.error("FSAuthnDecisionImpl::getURLForAuthnContext.Login url is null");
                FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
                return fSAuthContextResult;
            }
            FSUtils.debug.error("FSAuthnDecisionImpl::getURLForAuthnContext. Could not get any authcontext");
            FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
            return fSAuthContextResult;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl::getURLForAuthContext. Method called withauthContextMinRef null");
        }
        FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
        return fSAuthContextResult;
    }

    public FSAuthContextResult decideAuthnContext(List list, String string) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::decideAuthnContext. Entered method");
        }
        int n = 0;
        if (list != null && this.idpAuthContextMap != null) {
            FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(string);
            int n2 = 0;
            while (n2 < list.size()) {
                FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo2 = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get((String)list.get(n));
                if (fSIDPAuthenticationContextInfo != null && fSIDPAuthenticationContextInfo2 != null) {
                    Object object;
                    if (fSIDPAuthenticationContextInfo.getPriority() <= fSIDPAuthenticationContextInfo2.getPriority()) {
                        if (messageEnabled) {
                            FSUtils.debug.message("FSAuthDecisionImpl::decideAuthnContext.Present AuthLevel higher than needed.");
                        }
                        object = new FSAuthContextResult();
                        return object;
                    }
                    object = new ArrayList<String>();
                    object.add(fSIDPAuthenticationContextInfo2.getAuthenticationContext());
                    FSAuthContextResult fSAuthContextResult = this.getURLForAuthnContext((List)object);
                    if (fSAuthContextResult == null) {
                        ++n;
                    } else {
                        return fSAuthContextResult;
                    }
                }
                ++n;
                ++n2;
            }
            FSUtils.debug.error("FSAuthDecisionImpl::decideAuthnContext. AuthContextRef not supported returing null");
            return null;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl::decideAuthnContext. Method called withauthContextRef null");
        }
        return null;
    }

    public FSAuthContextResult decideAuthnContext(String string, String string2) {
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl ::decideAuthnContext. Entered method");
        }
        if (string != null && this.idpAuthContextMap != null) {
            FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(string2);
            FSIDPAuthenticationContextInfo fSIDPAuthenticationContextInfo2 = (FSIDPAuthenticationContextInfo)this.idpAuthContextMap.get(string);
            if (fSIDPAuthenticationContextInfo != null && fSIDPAuthenticationContextInfo2 != null) {
                if (fSIDPAuthenticationContextInfo.getPriority() <= fSIDPAuthenticationContextInfo2.getPriority()) {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSAuthDecisionImpl::decideAuthnContext.Present Auth Level higher than needed.");
                    }
                    FSAuthContextResult fSAuthContextResult = new FSAuthContextResult();
                    return fSAuthContextResult;
                }
                FSAuthContextResult fSAuthContextResult = this.getURLForAuthnContext(string);
                return fSAuthContextResult;
            }
            FSUtils.debug.error("FSAuthDecisionImpl::decideAuthnContextNot Supported AuthContext");
            return null;
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSAuthDecisionImpl::decideAuthnContext. Method called withauthContextMinRef null");
        }
        return null;
    }

    static {
        if (FSUtils.debug.messageEnabled()) {
            messageEnabled = true;
        }
        alliancemanager = FSServiceUtils.getAllianceInstance();
    }
}

