/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequestVersionTooHighException;
import com.sun.identity.saml.common.SAMLRequestVersionTooLowException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Request;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSSAMLRequest
extends Request {
    protected FSSAMLRequest() {
    }

    public FSSAMLRequest(Element element) throws SAMLException {
        Object object;
        String string = null;
        if (element == null) {
            SAMLUtils.debug.message("FSSAMLRequest(Element): null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        string = element.getLocalName();
        if (string == null || !string.equals("Request")) {
            SAMLUtils.debug.message("FSSAMLRequest(Element): wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n = list.size();
        if (n == 1) {
            object = XMLSignatureManager.getInstance();
            this.valid = this.minorVersion == 0 ? ((XMLSignatureManager)object).verifyXMLSignature(element) : ((XMLSignatureManager)object).verifyXMLSignature(element, "RequestID", null);
            if (!this.valid && SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): couldn't verify Request's signature.");
            }
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        this.requestID = element.getAttribute("RequestID");
        if (this.requestID == null || this.requestID.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): Request doesn't have a RequestID.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        object = element.getAttribute("IssueInstant");
        if (object == null || ((String)object).equals("")) {
            SAMLUtils.debug.message("FSSAMLRequest(Element): missing IssueInstant");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = SAMLUtils.stringToDate((String)object);
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): could not parse IssueInstant:" + exception.getMessage());
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = nodeList.getLength();
        while (n2 < n3) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("RespondWith")) {
                    String string3 = XMLUtils.getElementValue((Element)((Element)node));
                    if (string3.length() == 0) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("FSSAMLRequest(Element): wrong RespondWith value.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                    if (this.respondWiths == Collections.EMPTY_LIST) {
                        this.respondWiths = new ArrayList();
                    }
                    this.respondWiths.add(string3);
                } else if (string2.equals("Signature")) {
                    this.signature = (Element)node;
                } else if (string2.equals("AssertionArtifact")) {
                    if (this.contentType != -1 && this.contentType != 3) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("FSSAMLRequest(Element): contained mixed contents.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                    this.contentType = 3;
                    if (this.artifacts == Collections.EMPTY_LIST) {
                        this.artifacts = new ArrayList();
                    }
                    try {
                        FSAssertionArtifact fSAssertionArtifact = new FSAssertionArtifact(XMLUtils.getElementValue((Element)((Element)node)));
                        this.artifacts.add(fSAssertionArtifact);
                    }
                    catch (Exception exception) {
                        SAMLUtils.debug.error("FSSAMLRequest(Element): ", (Throwable)exception);
                    }
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("FSSAMLRequest(Element): invalid node" + string2);
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
            }
            ++n2;
        }
        if (this.contentType == -1) {
            SAMLUtils.debug.message("Request: empty content.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
    }

    private void parseMajorVersion(String string) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("FSSAMLRequest(Element):MajorVersion of the Request is too high.");
                }
                throw new SAMLRequestVersionTooHighException(SAMLUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("FSSAMLRequest(Element):MajorVersion of the Request is too low.");
            }
            throw new SAMLRequestVersionTooLowException(SAMLUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Request(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new SAMLRequesterException(FSUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion > 1) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too high.");
            throw new SAMLRequestVersionTooHighException(FSUtils.bundle.getString("requestVersionTooHigh"));
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("Request(Element): MinorVersion of the Request is too low.");
            throw new SAMLRequestVersionTooLowException(FSUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }
}

