/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSResponse
extends Response {
    protected String id = null;

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public FSResponse(String string, String string2, List list, Status status, List list2) throws SAMLException {
        super(string, string2, status, list2);
    }

    public FSResponse(String string, String string2, Status status, List list) throws SAMLException, FSMsgException {
        super(string, string2, status, list);
    }

    public static FSResponse parseResponseXML(String string) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSResponse.parseResponseXML: Called");
        Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
        if (document == null) {
            FSUtils.debug.error("FSResponse.parseXML:Error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element element = document.getDocumentElement();
        return new FSResponse(element);
    }

    public FSResponse(Element element) throws SAMLException, FSMsgException {
        FSUtils.debug.message("FSResponse(Element): Called");
        if (element == null) {
            FSUtils.debug.message("FSResponse(Element): Input paramenter (root) is null");
            throw new FSMsgException("nullInput", null);
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("Response")) {
            FSUtils.debug.message("FSResponse(Element): Root element name is not Response");
            throw new FSMsgException("wrongInput", null);
        }
        this.id = element.getAttribute("id");
        this.responseID = element.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): Response doesn't have ResponseID attribute");
            }
            throw new FSMsgException("missingAttribute", null);
        }
        this.inResponseTo = element.getAttribute("InResponseTo");
        if (this.inResponseTo == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): Response doesn't have InResponseTo attribute");
            }
            throw new FSMsgException("missingAttribute", null);
        }
        String string2 = element.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            FSUtils.debug.message("FSResponse(Element): missing IssueInstant");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            this.issueInstant = FSUtils.stringToDate(string2);
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): could not parse IssueInstant:" + exception.getMessage());
            }
            throw new FSMsgException("wrongInput", null);
        }
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        this.setRecipient(element.getAttribute("Recipient"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null && !string3.equals("Signature")) {
                if (string3.equals("Status")) {
                    if (this.status != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSResponse(Element): included more than one <Status>");
                        }
                        throw new FSMsgException("moreElement", null);
                    }
                    this.status = new Status((Element)node);
                } else if (string3.equals("Assertion")) {
                    if (this.assertions == Collections.EMPTY_LIST) {
                        this.assertions = new ArrayList();
                    }
                    this.assertions.add(new FSAssertion((Element)node));
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSResponse(Element): included wrong element: " + string3);
                    }
                    throw new FSMsgException("wrongInput", null);
                }
            }
            ++n2;
        }
        if (this.status == null) {
            FSUtils.debug.message("FSResponse(Element): missing element <Status>.");
            throw new FSMsgException("missingElement");
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n3 = list.size();
        if (n3 == 1) {
            Element element2 = (Element)list.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n3 != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    private void parseMajorVersion(String string) throws SAMLException, FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSResponse(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws SAMLException, FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion > 1) {
            FSUtils.debug.error("FSResponse(Element):MinorVersion of the Response is too high.");
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooHigh"));
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("FSResponse(Element):MinorVersion of the Response is too low.");
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        FSUtils.debug.message("FSResponse.toXMLString(3): Called");
        StringBuffer stringBuffer = new StringBuffer(500);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        if (bl) {
            string2 = "lib:";
            string = "saml:";
            string3 = "samlp:";
        }
        if (bl2) {
            string6 = this.minorVersion == 1 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string5 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            string4 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
            string7 = "xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"";
            string8 = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        String string9 = null;
        try {
            string9 = FSUtils.dateToString(this.issueInstant);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSResponse.toString: could not convert issueInstant to String: " + exception.getMessage());
            throw new FSMsgException("wrongInput", null);
        }
        if (this.responseID != null && this.inResponseTo != null) {
            stringBuffer.append("<").append(string3).append("Response").append(string6).append(string5).append(string4).append(" ").append(string7).append(" ").append(string8).append(" ResponseID=\"").append(this.responseID).append("\" ");
            if (this.inResponseTo != null && !this.inResponseTo.equals("")) {
                stringBuffer.append(" InResponseTo=\"").append(this.inResponseTo).append("\" ");
            }
            if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
                stringBuffer.append(" id=\"").append(this.id).append("\"");
            }
            stringBuffer.append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(string9).append("\"");
            if (this.recipient != null && !this.recipient.equals("")) {
                stringBuffer.append(" Recipient=\"").append(this.recipient).append("\" ");
            }
            stringBuffer.append(">");
        }
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        if (this.status != null) {
            stringBuffer.append(this.status.toString(bl, false));
        }
        if (this.assertions != null && this.assertions != Collections.EMPTY_LIST) {
            Iterator iterator = this.assertions.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((FSAssertion)iterator.next()).toXMLString(true, bl2));
            }
        }
        stringBuffer.append("</").append(string3).append("Response>");
        return stringBuffer.toString();
    }

    public static FSResponse parseBASE64EncodedString(String string) throws FSMsgException, SAMLException {
        FSUtils.debug.message("FSResponse.parseBASE64EncodedString: Called new");
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        if (string != null) {
            try {
                String string2 = new String(bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string.getBytes())));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSResponse.parseBASE64EncodedString: Decoded AuthnResponse message: " + string2);
                }
                return FSResponse.parseResponseXML(string2);
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSResponse.parseBASE64EncodedString: IOException caused at the time of decoding");
                throw new FSMsgException(iOException, "IOException occured");
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSResponse.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        FSUtils.debug.message("FSResponse.toBASE64EncodedString: Called");
        if (this.responseID == null || this.responseID.equals("")) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSResponse.toBASE64EncodedString: couldn't generate ResponseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString().getBytes());
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSResponse.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSResponse.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "ResponseID", this.getResponseID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception: ") + exception.getMessage());
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("Unsupported method");
    }
}

