/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.protocol.AbstractResponse;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSNameRegistrationResponse
extends AbstractResponse {
    private String providerId = null;
    private String relayState = "";
    private Status status = null;
    protected String xmlString = null;
    protected String signatureString = null;
    protected String id = null;
    protected int minorVersion = 0;

    public FSNameRegistrationResponse() {
        try {
            this.setIssueInstant(new Date());
            StatusCode statusCode = new StatusCode("samlp:Success");
            this.status = new Status(statusCode);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationResponse.Constructor", (Throwable)exception);
        }
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String string) {
        this.relayState = string;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String string) {
        this.providerId = string;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public FSNameRegistrationResponse(String string, String string2, Status status, String string3, String string4) throws FSMsgException {
        if (string == null || string.equals("")) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                throw new FSMsgException("errorGenerateID", null);
            }
        } else {
            this.responseID = string;
        }
        if (string2 == null) {
            FSUtils.debug.message("Response: inResponseTo is null.");
            throw new FSMsgException("nullInput", null);
        }
        this.inResponseTo = string2;
        if (status == null) {
            FSUtils.debug.message("Response: missing <Status>.");
            throw new FSMsgException("missingElement", null);
        }
        this.status = status;
        this.providerId = string3;
        this.relayState = string4;
        this.setIssueInstant(new Date());
    }

    public FSNameRegistrationResponse(Element element) throws FSMsgException, SAMLException {
        if (element == null) {
            FSUtils.debug.message("FSNameRegistrationResponse.parseXML: null input.");
            throw new FSMsgException("nullInput", null);
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("RegisterNameIdentifierResponse")) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseXML: wrong input.");
            throw new FSMsgException("wrongInput", null);
        }
        this.id = element.getAttribute("id");
        this.responseID = element.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.equals("")) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseXML: Reponse doesn't have ResponseID.");
            throw new FSMsgException("missingAttribute", null);
        }
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        this.inResponseTo = element.getAttribute("InResponseTo");
        if (this.inResponseTo == null) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseXML: Response doesn't have InResponseTo.");
            throw new FSMsgException("missingAttribute", null);
        }
        String string2 = element.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            FSUtils.debug.error("FSNameRegistrationResponse(Element): missing IssueInstant");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            this.issueInstant = FSUtils.stringToDate(string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationResponse(Element): could not parse IssueInstant:", (Throwable)exception);
            throw new FSMsgException("wrongInput", null);
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null && !string3.equals("Signature")) {
                if (string3.equals("Status")) {
                    if (this.status != null) {
                        FSUtils.debug.error("FSNameRegistrationResponse: included more than one <Status>");
                        throw new FSMsgException("moreElement", null);
                    }
                    this.status = new Status((Element)node);
                } else if (string3.equals("ProviderID")) {
                    if (this.providerId != null) {
                        FSUtils.debug.error("FSNameRegistrationResponse: included more than one providerId");
                        throw new FSMsgException("moreElement", null);
                    }
                    this.providerId = XMLUtils.getElementValue((Element)((Element)node));
                } else if (string3.equals("RelayState")) {
                    this.relayState = XMLUtils.getElementValue((Element)((Element)node));
                } else {
                    FSUtils.debug.error("FSNameRegistrationResponse: included wrong element:" + string3);
                    throw new FSMsgException("wrongInput", null);
                }
            }
            ++n2;
        }
        if (this.status == null) {
            FSUtils.debug.message("FSNameRegistrationResponse: missing element <Status>.");
            throw new FSMsgException("oneElement", null);
        }
        if (this.providerId == null) {
            FSUtils.debug.message("FSNameRegistrationResponse: missing element providerId.");
            throw new FSMsgException("oneElement", null);
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n3 = list.size();
        if (n3 == 1) {
            Element element2 = (Element)list.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n3 != 0) {
            FSUtils.debug.error("FSNameRegistrationResponse(Element): included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    private void parseMajorVersion(String string) throws FSMsgException, SAMLException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            FSUtils.debug.error("Response(Element): invalid MajorVersion", (Throwable)numberFormatException);
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("Response(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Response(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSRegisResp(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion == 2 || this.minorVersion == 0) {
            return;
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSRegisResp(Element):MinorVersion of the Response is too high.");
            throw new FSMsgException(FSUtils.bundle.getString("responseVersionTooHigh"));
        }
        FSUtils.debug.error("FSRegisResp(Element):MinorVersion of the Response is too low.");
        throw new FSMsgException(FSUtils.bundle.getString("responseVersionTooLow"));
    }

    public static FSNameRegistrationResponse parseXML(String string) throws FSMsgException {
        try {
            Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
            Element element = document.getDocumentElement();
            return new FSNameRegistrationResponse(element);
        }
        catch (SAMLException sAMLException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationResponse.parseXML: Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null, sAMLException);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (bl) {
            string2 = "lib:";
            string = "samlp:";
        }
        if (bl2) {
            string4 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string3 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String string5 = null;
        try {
            string5 = FSUtils.dateToString(this.issueInstant);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationResponse.toString: could not convert issueInstant to String: ", (Throwable)exception);
            throw new FSMsgException("wrongInput", null);
        }
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSNameRegistrationResponse.toXMLString: providerId is null in the response with responseId:" + this.responseID);
            throw new FSMsgException(FSUtils.bundle.getString("nullProvideID"));
        }
        if (this.responseID != null && this.inResponseTo != null) {
            stringBuffer.append("<").append(string2).append("RegisterNameIdentifierResponse").append(string4);
            if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
                stringBuffer.append(" id=\"").append(this.id).append("\" ");
            }
            stringBuffer.append(" ResponseID=\"").append(this.responseID).append("\" ").append(" InResponseTo=\"").append(this.inResponseTo).append("\" ").append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(string5).append("\" ").append(">");
        }
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print((Node)this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        if (this.providerId != null) {
            stringBuffer.append("<").append(string2).append("ProviderID").append(">").append(this.providerId).append("</").append(string2).append("ProviderID").append(">");
        }
        if (this.status != null) {
            stringBuffer.append(this.status.toString(bl, true));
        }
        if (this.relayState != null) {
            stringBuffer.append("<").append(string2).append("RelayState").append(">").append(this.relayState).append("</").append(string2).append("RelayState").append(">");
        }
        stringBuffer.append("</").append(string2).append("RegisterNameIdentifierResponse>");
        return stringBuffer.toString();
    }

    public static FSNameRegistrationResponse parseBASE64EncodedString(String string) throws FSMsgException, SAMLException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        if (string != null) {
            try {
                String string2 = new String(bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string.getBytes())));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationResponse.parseBASE64EncodedString: decoded input string: " + string2);
                }
                return FSNameRegistrationResponse.parseXML(string2);
            }
            catch (IOException iOException) {
                FSUtils.debug.error("FSNameRegistrationResponse.parseBASE64EncodedString: IOException caused at the time of decoding");
                throw new FSMsgException(iOException, "IOException");
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSNameRegistrationResponse.parseBASE64EncodedString: null String passed in as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.responseID == null || this.responseID.equals("")) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSNameRegistrationResponse.toBASE64EncodedString: couldn't generate ResponseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString().getBytes());
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSNameRegistrationResponse.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationResponse.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "ResponseID", this.getResponseID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception") + exception.getMessage());
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("Unsupported method");
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print((Node)element);
        return super.setSignature(element);
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSNameRegistrationResponse.toURLEncodedQueryString: providerId is null in the response ");
            throw new FSMsgException(FSUtils.bundle.getString("ProviderId is null in the request "));
        }
        if (this.responseID == null || this.responseID.equals("")) {
            this.responseID = FSUtils.generateID();
            if (this.responseID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: couldn't generate responseID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("ResponseID=").append(URLEncoder.encode(this.responseID)).append("&");
        stringBuffer.append("MajorVersion=").append(this.majorVersion).append("&");
        stringBuffer.append("MinorVersion=").append(this.minorVersion).append("&");
        if (this.issueInstant != null) {
            try {
                stringBuffer.append("IssueInstant=").append(URLEncoder.encode(FSUtils.dateToString(this.issueInstant))).append("&");
            }
            catch (ParseException parseException) {
                FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: Exception: " + parseException.getMessage());
            }
        } else {
            FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: issueInstant missing");
            throw new FSMsgException("missingAttribute", null);
        }
        if (this.providerId != null && !this.providerId.equals("")) {
            stringBuffer.append("ProviderID=").append(URLEncoder.encode(this.providerId)).append("&");
        }
        if (this.relayState != null && !this.relayState.equals("")) {
            stringBuffer.append("RelayState=").append(URLEncoder.encode(this.relayState)).append("&");
        }
        if (this.status != null) {
            stringBuffer.append("Value=");
            stringBuffer.append(URLEncoder.encode(this.status.getStatusCode().getValue())).append("&");
        }
        return stringBuffer.toString();
    }

    public static FSNameRegistrationResponse parseURLEncodedRequest(HttpServletRequest httpServletRequest) throws FSMsgException, SAMLException {
        FSNameRegistrationResponse fSNameRegistrationResponse = new FSNameRegistrationResponse();
        try {
            FSUtils.debug.message("checking minor version");
            fSNameRegistrationResponse.majorVersion = Integer.parseInt(httpServletRequest.getParameter("MajorVersion"));
            fSNameRegistrationResponse.minorVersion = Integer.parseInt(httpServletRequest.getParameter("MinorVersion"));
        }
        catch (NumberFormatException numberFormatException) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseURLEncodedRequest: version parsing error:" + numberFormatException);
            throw new FSMsgException(numberFormatException.getMessage());
        }
        if (httpServletRequest.getParameter("ResponseID") == null) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseURLEncodedRequest: Response ID is null");
            throw new FSMsgException("missingAttribute", null);
        }
        fSNameRegistrationResponse.responseID = httpServletRequest.getParameter("ResponseID");
        String string = httpServletRequest.getParameter("IssueInstant");
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseURLEncodedRequest: Issue Instant is null");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            fSNameRegistrationResponse.issueInstant = FSUtils.stringToDate(string);
        }
        catch (ParseException parseException) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseURLEncodedRequest: Can not parse Issue Instant");
            throw new FSMsgException(parseException.getMessage());
        }
        if (httpServletRequest.getParameter("ProviderID") == null) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseURLEncodedRequest: Provider ID is null ");
            throw new FSMsgException("missingElement", null);
        }
        fSNameRegistrationResponse.providerId = httpServletRequest.getParameter("ProviderID");
        if (httpServletRequest.getParameter("RelayState") != null) {
            fSNameRegistrationResponse.relayState = httpServletRequest.getParameter("RelayState");
        }
        if (httpServletRequest.getParameter("Value") == null) {
            FSUtils.debug.error("FSNameRegistrationResponse.parseURLEncodedRequest: Status Value is  null ");
            throw new FSMsgException("missingElement", null);
        }
        FSUtils.debug.message("Status : " + httpServletRequest.getParameter("Value"));
        StatusCode statusCode = new StatusCode(httpServletRequest.getParameter("Value"));
        fSNameRegistrationResponse.status = new Status(statusCode);
        FSUtils.debug.message("Returning registration response Object");
        return fSNameRegistrationResponse;
    }
}

