/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.message.common.OldProvidedNameIdentifier;
import com.sun.identity.federation.message.common.SPProvidedNameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;

public class FSNameRegistrationRequest
extends AbstractRequest {
    private String providerId = null;
    private SPProvidedNameIdentifier spProvidedNameIdentifier = null;
    private IDPProvidedNameIdentifier idpProvidedNameIdentifier = null;
    private OldProvidedNameIdentifier oldProvidedNameIdentifier = null;
    private String relayState = "";
    protected String xmlString = null;
    protected String signatureString = null;
    protected String id = null;
    protected int minorVersion = 0;

    public FSNameRegistrationRequest() {
        this.setIssueInstant(new Date());
    }

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String string) {
        this.relayState = string;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public FSNameRegistrationRequest(String string, List list, List list2, String string2, SPProvidedNameIdentifier sPProvidedNameIdentifier, IDPProvidedNameIdentifier iDPProvidedNameIdentifier, OldProvidedNameIdentifier oldProvidedNameIdentifier, String string3) throws FSMsgException {
        int n = 0;
        int n2 = 0;
        this.setIssueInstant(new Date());
        if (list != null && list != Collections.EMPTY_LIST) {
            n = list.size();
            n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!(e instanceof String)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("NameRegistrationRequest: wrong input for RespondWith");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                ++n2;
            }
            this.respondWiths = list;
        }
        if (string != null && !string.equals("")) {
            this.requestID = string;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.providerId = string2;
        this.spProvidedNameIdentifier = sPProvidedNameIdentifier;
        this.idpProvidedNameIdentifier = iDPProvidedNameIdentifier;
        this.oldProvidedNameIdentifier = oldProvidedNameIdentifier;
        this.relayState = string3;
    }

    public FSNameRegistrationRequest(Element element) throws FSMsgException {
        String string = null;
        if (element == null) {
            FSUtils.debug.message("FSNameRegistrationRequest(Element): null input.");
            throw new FSMsgException("nullInput", null);
        }
        string = element.getLocalName();
        if (string == null || !string.equals("RegisterNameIdentifierRequest")) {
            FSUtils.debug.message("FSNameRegistrationRequest(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String string2 = element.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            FSUtils.debug.error("FSNameRegistrationRequest(Element):missing IssueInstant");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            this.issueInstant = FSUtils.stringToDate(string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSNameRegistrationRequest(Element): could not parse IssueInstant:", (Throwable)exception);
            throw new FSMsgException("wrongInput", null);
        }
        int n = 0;
        this.id = element.getAttribute("id");
        this.requestID = element.getAttribute("RequestID");
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        NodeList nodeList = element.getChildNodes();
        n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null) {
                if (string3.equals("RespondWith")) {
                    if (this.respondWiths == Collections.EMPTY_LIST) {
                        this.respondWiths = new ArrayList();
                    }
                    this.respondWiths.add(XMLUtils.getElementValue((Element)((Element)node)));
                } else if (!string3.equals("Signature")) {
                    if (string3.equals("ProviderID")) {
                        if (this.providerId != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSNameRegistrationRequest(Element): should contain only one ProviderID.");
                            }
                            throw new FSMsgException("wrongInput", null);
                        }
                        this.providerId = XMLUtils.getElementValue((Element)((Element)node));
                    } else if (string3.equals("SPProvidedNameIdentifier")) {
                        this.spProvidedNameIdentifier = new SPProvidedNameIdentifier((Element)node);
                    } else if (string3.equals("IDPProvidedNameIdentifier")) {
                        this.idpProvidedNameIdentifier = new IDPProvidedNameIdentifier((Element)node);
                    } else if (string3.equals("OldProvidedNameIdentifier")) {
                        this.oldProvidedNameIdentifier = new OldProvidedNameIdentifier((Element)node);
                    } else if (string3.equals("RelayState")) {
                        this.relayState = XMLUtils.getElementValue((Element)((Element)node));
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSNameRegistrationRequest(Element): invalid node" + string3);
                        }
                        throw new FSMsgException("wrongInput", null);
                    }
                }
            }
            ++n2;
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n3 = list.size();
        if (n3 == 1) {
            Element element2 = (Element)list.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n3 != 0) {
            FSUtils.debug.error("FSNameRegistrationRequest(Element): included more than one Signature element.");
            throw new FSMsgException("moreElement", null);
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public static FSNameRegistrationRequest parseXML(String string) throws FSMsgException {
        Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
        if (document == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseXML:Error while parsing input xml string");
            throw new FSMsgException("parseError", null);
        }
        Element element = document.getDocumentElement();
        return new FSNameRegistrationRequest(element);
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSNameRegistrationRequest.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("ProviderId is null in the request with requestId:" + this.requestID));
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String string4 = null;
        try {
            string4 = FSUtils.dateToString(this.issueInstant);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSRegisterNameIdentifierRequest.toString: could not convert issueInstant to String: ", (Throwable)exception);
        }
        if (this.requestID != null) {
            stringBuffer.append("<").append(string).append("RegisterNameIdentifierRequest").append(string2).append(string3);
            if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
                stringBuffer.append(" id=\"").append(this.id).append("\" ");
            }
            stringBuffer.append(" RequestID=\"").append(this.requestID).append("\" ").append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(string4).append("\"").append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                Iterator iterator = this.respondWiths.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append("<").append(string).append("RespondWith>").append((String)iterator.next()).append("</").append(string).append("RespondWith>");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    stringBuffer.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print((Node)this.signature);
                    stringBuffer.append(this.signatureString);
                }
            }
            stringBuffer.append("<").append(string).append("ProviderID").append(">").append(this.providerId).append("</").append(string).append("ProviderID").append(">");
            if (this.idpProvidedNameIdentifier != null && !this.idpProvidedNameIdentifier.getName().equals("")) {
                stringBuffer.append(this.idpProvidedNameIdentifier.toXMLString());
            }
            if (this.spProvidedNameIdentifier != null && !this.spProvidedNameIdentifier.getName().equals("")) {
                stringBuffer.append(this.spProvidedNameIdentifier.toXMLString());
            }
            if (this.oldProvidedNameIdentifier != null && !this.oldProvidedNameIdentifier.getName().equals("")) {
                stringBuffer.append(this.oldProvidedNameIdentifier.toXMLString());
            }
            if (this.relayState != null) {
                stringBuffer.append("<").append(string).append("RelayState").append(">").append(this.relayState).append("</").append(string).append("RelayState").append(">");
            }
        } else {
            FSUtils.debug.error("FSNameRegistrationRequest.toString: requestID is null ");
            throw new FSMsgException(FSUtils.bundle.getString("nullRequestID"));
        }
        stringBuffer.append("</").append(string).append("RegisterNameIdentifierRequest>");
        return stringBuffer.toString();
    }

    public IDPProvidedNameIdentifier getIDPProvidedNameIdentifier() {
        return this.idpProvidedNameIdentifier;
    }

    public OldProvidedNameIdentifier getOldProvidedNameIdentifier() {
        return this.oldProvidedNameIdentifier;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setIDPProvidedNameIdentifier(IDPProvidedNameIdentifier iDPProvidedNameIdentifier) {
        this.idpProvidedNameIdentifier = iDPProvidedNameIdentifier;
    }

    public void setOldProvidedNameIdentifier(OldProvidedNameIdentifier oldProvidedNameIdentifier) {
        this.oldProvidedNameIdentifier = oldProvidedNameIdentifier;
    }

    public void setSPProvidedNameIdentifier(SPProvidedNameIdentifier sPProvidedNameIdentifier) {
        this.spProvidedNameIdentifier = sPProvidedNameIdentifier;
    }

    public void setProviderId(String string) {
        this.providerId = string;
    }

    public SPProvidedNameIdentifier getSPProvidedNameIdentifier() {
        return this.spProvidedNameIdentifier;
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSNameRegistrationRequest.toBASE64EncodedString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("ProviderId is null in the request with requestId:" + this.requestID));
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toBASE64EncodedString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString().getBytes());
    }

    private void parseMajorVersion(String string) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSNameRegistrationRequest(Element): MajorVersion of the RegisterNameIdentifierRequestis too high.");
                }
                throw new FSMsgException(SAMLUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest(Element): MajorVersion of the RegisterNameIdentifierRequestis too low.");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegis(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion == 2 || this.minorVersion == 0) {
            return;
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSNameRegisNot(Element):MinorVersion of the Response is too high.");
            throw new FSMsgException(FSUtils.bundle.getString("responseVersionTooHigh"));
        }
        FSUtils.debug.error("FSNameRegis(Element):MinorVersion of the Response is too low.");
        throw new FSMsgException(FSUtils.bundle.getString("responseVersionTooLow"));
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSNameRegistrationRequest.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSNameRegistrationRequest.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception: ") + exception.getMessage());
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("Unsupported method");
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print((Node)element);
        return super.setSignature(element);
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: providerId is null in the request with requestId: " + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("nullProviderID"));
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("RequestID=").append(URLEncoder.encode(this.requestID)).append("&");
        stringBuffer.append("MajorVersion=").append(this.majorVersion).append("&");
        stringBuffer.append("MinorVersion=").append(this.minorVersion).append("&");
        stringBuffer.append("RelayState=").append(URLEncoder.encode(this.relayState)).append("&");
        if (this.issueInstant != null) {
            try {
                stringBuffer.append("IssueInstant=").append(URLEncoder.encode(FSUtils.dateToString(this.issueInstant))).append("&");
            }
            catch (ParseException parseException) {
                FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: Exception: ", (Throwable)parseException);
            }
        } else {
            FSUtils.debug.error("FSNameRegistrationRequest.toURLEncodedQueryString: issueInstant missing");
            throw new FSMsgException("missingAttribute", null);
        }
        if (this.providerId != null && !this.providerId.equals("")) {
            stringBuffer.append("ProviderID=").append(URLEncoder.encode(this.providerId)).append("&");
        }
        if (this.spProvidedNameIdentifier != null) {
            if (this.spProvidedNameIdentifier.getName() != null && !this.spProvidedNameIdentifier.getName().equals("")) {
                stringBuffer.append("SPProvidedNameIdentifier=").append(URLEncoder.encode(this.spProvidedNameIdentifier.getName())).append("&");
            }
            if (this.spProvidedNameIdentifier.getNameQualifier() != null && !this.spProvidedNameIdentifier.getNameQualifier().equals("")) {
                stringBuffer.append("SPNameQualifier=").append(URLEncoder.encode(this.spProvidedNameIdentifier.getNameQualifier())).append("&");
            }
            if (this.spProvidedNameIdentifier.getFormat() != null && !this.spProvidedNameIdentifier.getFormat().equals("")) {
                stringBuffer.append("SPNameFormat=").append(URLEncoder.encode(this.spProvidedNameIdentifier.getFormat())).append("&");
            }
        }
        if (this.oldProvidedNameIdentifier != null) {
            if (this.oldProvidedNameIdentifier.getName() != null && !this.oldProvidedNameIdentifier.getName().equals("")) {
                stringBuffer.append("OldProvidedNameIdentifier=").append(URLEncoder.encode(this.oldProvidedNameIdentifier.getName())).append("&");
            }
            if (this.oldProvidedNameIdentifier.getNameQualifier() != null && !this.oldProvidedNameIdentifier.getNameQualifier().equals("")) {
                stringBuffer.append("OldNameQualifier=").append(URLEncoder.encode(this.oldProvidedNameIdentifier.getNameQualifier())).append("&");
            }
            if (this.oldProvidedNameIdentifier.getFormat() != null && !this.oldProvidedNameIdentifier.getFormat().equals("")) {
                stringBuffer.append("OldNameFormat=").append(URLEncoder.encode(this.oldProvidedNameIdentifier.getFormat())).append("&");
            }
        }
        if (this.idpProvidedNameIdentifier != null) {
            if (this.idpProvidedNameIdentifier.getName() != null && !this.idpProvidedNameIdentifier.getName().equals("")) {
                stringBuffer.append("IDPProvidedNameIdentifier=").append(URLEncoder.encode(this.idpProvidedNameIdentifier.getName())).append("&");
            }
            if (this.idpProvidedNameIdentifier.getNameQualifier() != null && !this.idpProvidedNameIdentifier.getNameQualifier().equals("")) {
                stringBuffer.append("IDPNameQualifier=").append(URLEncoder.encode(this.idpProvidedNameIdentifier.getNameQualifier())).append("&");
            }
            if (this.idpProvidedNameIdentifier.getFormat() != null && !this.idpProvidedNameIdentifier.getFormat().equals("")) {
                stringBuffer.append("IDPNameFormat=").append(URLEncoder.encode(this.idpProvidedNameIdentifier.getFormat())).append("&");
            }
        }
        return stringBuffer.toString();
    }

    public static FSNameRegistrationRequest parseURLEncodedRequest(HttpServletRequest httpServletRequest) throws FSMsgException, SAMLException {
        FSNameRegistrationRequest fSNameRegistrationRequest = new FSNameRegistrationRequest();
        try {
            FSUtils.debug.message("checking minor version");
            fSNameRegistrationRequest.majorVersion = Integer.parseInt(httpServletRequest.getParameter("MajorVersion"));
            fSNameRegistrationRequest.minorVersion = Integer.parseInt(httpServletRequest.getParameter("MinorVersion"));
        }
        catch (NumberFormatException numberFormatException) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: Invalid versions", (Throwable)numberFormatException);
            throw new FSMsgException(numberFormatException.getMessage());
        }
        FSUtils.debug.message("checking RequestID");
        if (httpServletRequest.getParameter("RequestID") == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: RequestID not found");
            throw new FSMsgException("missingAttribute", null);
        }
        fSNameRegistrationRequest.requestID = httpServletRequest.getParameter("RequestID");
        FSUtils.debug.message("checking instantString");
        String string = httpServletRequest.getParameter("IssueInstant");
        FSUtils.debug.message("instantString : " + string);
        if (string == null || string.equals("")) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: IssueInstant not found");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            FSUtils.debug.message("calling : FSUtils.stringToDate.issueInstant");
            fSNameRegistrationRequest.issueInstant = FSUtils.stringToDate(string);
        }
        catch (ParseException parseException) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: Can not parse IssueInstant");
            throw new FSMsgException(parseException.getMessage());
        }
        if (httpServletRequest.getParameter("ProviderID") == null) {
            FSUtils.debug.error("FSNameRegistrationRequest.parseURLEncodedRequest: Can not find ProviderID");
            throw new FSMsgException("missingElement", null);
        }
        fSNameRegistrationRequest.providerId = httpServletRequest.getParameter("ProviderID");
        FSUtils.debug.message("start identifier processing");
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (httpServletRequest.getParameter("SPNameFormat") != null) {
            string2 = httpServletRequest.getParameter("SPNameFormat");
        }
        if (httpServletRequest.getParameter("SPNameQualifier") != null) {
            string3 = httpServletRequest.getParameter("SPNameQualifier");
        }
        if (httpServletRequest.getParameter("SPProvidedNameIdentifier") != null) {
            string4 = httpServletRequest.getParameter("SPProvidedNameIdentifier");
        }
        if (string4 != null && string4.length() >= 1) {
            fSNameRegistrationRequest.setSPProvidedNameIdentifier(new SPProvidedNameIdentifier(string4, string3, string2));
        }
        String string5 = null;
        String string6 = null;
        String string7 = null;
        if (httpServletRequest.getParameter("IDPNameFormat") != null) {
            string5 = httpServletRequest.getParameter("IDPNameFormat");
        }
        if (httpServletRequest.getParameter("IDPNameQualifier") != null) {
            string6 = httpServletRequest.getParameter("IDPNameQualifier");
        }
        if (httpServletRequest.getParameter("IDPProvidedNameIdentifier") != null) {
            string7 = httpServletRequest.getParameter("IDPProvidedNameIdentifier");
        }
        if (string7 != null && string7.length() >= 1) {
            fSNameRegistrationRequest.idpProvidedNameIdentifier = new IDPProvidedNameIdentifier(string7, string6, string5);
        }
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (httpServletRequest.getParameter("OldNameFormat") != null) {
            string8 = httpServletRequest.getParameter("OldNameFormat");
        }
        if (httpServletRequest.getParameter("OldNameQualifier") != null) {
            string9 = httpServletRequest.getParameter("OldNameQualifier");
        }
        if (httpServletRequest.getParameter("OldProvidedNameIdentifier") != null) {
            string10 = httpServletRequest.getParameter("OldProvidedNameIdentifier");
        }
        if (string10 != null && string10.length() >= 1) {
            fSNameRegistrationRequest.oldProvidedNameIdentifier = new OldProvidedNameIdentifier(string10, string9, string8);
        }
        if (httpServletRequest.getParameter("RelayState") != null) {
            fSNameRegistrationRequest.relayState = httpServletRequest.getParameter("RelayState");
        }
        return fSNameRegistrationRequest;
    }
}

