/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AbstractRequest;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Encoder;

public class FSLogoutNotification
extends AbstractRequest {
    private String providerId;
    private NameIdentifier nameIdentifier;
    protected String sessionIndex;
    protected String xmlString = null;
    protected String signatureString = null;
    protected String id = null;
    private String relayState = null;

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public String getRelayState() {
        return this.relayState;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public FSLogoutNotification() {
        this.setIssueInstant(new Date());
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public FSLogoutNotification(Element element) throws FSMsgException {
        String string = null;
        if (element == null) {
            FSUtils.debug.message("FSLogoutNotification(Element): null input.");
            throw new FSMsgException("nullInput", null);
        }
        string = element.getLocalName();
        if (string == null || !string.equals("LogoutRequest")) {
            FSUtils.debug.message("FSLogoutNotification(Element): wrong input");
            throw new FSMsgException("wrongInput", null);
        }
        String string2 = element.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            FSUtils.debug.message("LogoutRequest(Element): missing IssueInstant");
            throw new FSMsgException("missingAttribute", null);
        }
        try {
            this.issueInstant = FSUtils.stringToDate(string2);
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LogoutRequest(Element): could not parse IssueInstant:" + exception.getMessage());
            }
            throw new FSMsgException("wrongInput", null);
        }
        int n = 0;
        this.id = element.getAttribute("id");
        this.requestID = element.getAttribute("RequestID");
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        NodeList nodeList = element.getChildNodes();
        n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string3 = node.getLocalName();
            if (string3 != null) {
                if (string3.equals("RespondWith")) {
                    if (this.respondWiths == Collections.EMPTY_LIST) {
                        this.respondWiths = new ArrayList();
                    }
                    this.respondWiths.add(XMLUtils.getElementValue((Element)((Element)node)));
                } else if (!string3.equals("Signature")) {
                    if (string3.equals("ProviderID")) {
                        if (this.providerId != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSLogoutNotification(Element): should contain only one ProviderID.");
                            }
                            throw new FSMsgException("wrongInput", null);
                        }
                        this.providerId = XMLUtils.getElementValue((Element)((Element)node));
                    } else if (string3.equals("RelayState")) {
                        if (this.relayState != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSLogoutNotification(Element): should contain only one relyaState.");
                            }
                            throw new FSMsgException("wrongInput", null);
                        }
                        this.relayState = XMLUtils.getElementValue((Element)((Element)node));
                    } else if (string3.equals("NameIdentifier")) {
                        try {
                            this.nameIdentifier = new NameIdentifier((Element)node);
                        }
                        catch (SAMLException sAMLException) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSLogoutNotification(Element): SAMLException while constructing nameidentifier");
                            }
                            throw new FSMsgException(sAMLException, "FSLogoutNotification(Element): SAMLException while constructing nameidentifier");
                        }
                    } else if (string3.equals("SessionIndex")) {
                        if (this.sessionIndex != null) {
                            if (FSUtils.debug.messageEnabled()) {
                                FSUtils.debug.message("FSLogoutNotification(Element): should contain only one SessionIndex.");
                            }
                            throw new FSMsgException("wrongInput", null);
                        }
                        this.sessionIndex = XMLUtils.getElementValue((Element)((Element)node));
                    } else {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSLogoutNotification(Element): invalid node" + string3);
                        }
                        throw new FSMsgException("wrongInput", null);
                    }
                }
            }
            ++n2;
        }
        List list = XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n3 = list.size();
        if (n3 == 1) {
            Element element2 = (Element)list.get(0);
            this.setSignature(element2);
            this.xmlString = XMLUtils.print((Node)element);
            this.signed = true;
        } else if (n3 != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
    }

    public FSLogoutNotification(String string, List list, String string2, NameIdentifier nameIdentifier, String string3) throws FSMsgException {
        int n = 0;
        int n2 = 0;
        this.setIssueInstant(new Date());
        if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
            n = this.respondWiths.size();
            n2 = 0;
            while (n2 < n) {
                Object e = this.respondWiths.get(n2);
                if (!(e instanceof String)) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSLogoutNotification: wrong input for RespondWith");
                    }
                    throw new FSMsgException("wrongInput", null);
                }
                ++n2;
            }
            this.respondWiths = this.respondWiths;
        }
        if (string != null && !string.equals("")) {
            this.requestID = string;
        } else {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        this.relayState = null;
        this.providerId = string2;
        this.nameIdentifier = nameIdentifier;
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSLogoutNotification.toXMLString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException("ProviderId is null in the request with requestId:" + this.requestID);
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification.toXMLString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = this.minorVersion == 2 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string3 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        String string4 = null;
        try {
            string4 = FSUtils.dateToString(this.issueInstant);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLogoutNotification.toString: could not convert issueInstant to String: " + exception.getMessage());
            throw new FSMsgException("wrongInput", null);
        }
        if (this.requestID != null) {
            stringBuffer.append("<").append(string).append("LogoutRequest").append(string2).append(string3);
            if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
                stringBuffer.append(" id=\"").append(this.id).append("\" ");
            }
            stringBuffer.append(" RequestID=\"").append(this.requestID).append("\" ").append(" MajorVersion=\"").append(this.majorVersion).append("\" ").append(" MinorVersion=\"").append(this.minorVersion).append("\" ").append(" IssueInstant=\"").append(string4).append("\"").append(">");
            if (this.respondWiths != null && this.respondWiths != Collections.EMPTY_LIST) {
                Iterator iterator = this.respondWiths.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append("<").append(string).append("RespondWith>").append((String)iterator.next()).append("</").append(string).append("RespondWith>");
                }
            }
            if (this.signed) {
                if (this.signatureString != null) {
                    stringBuffer.append(this.signatureString);
                } else if (this.signature != null) {
                    this.signatureString = XMLUtils.print((Node)this.signature);
                    stringBuffer.append(this.signatureString);
                }
            }
            stringBuffer.append("<").append(string).append("ProviderID").append(string2).append(">").append(this.providerId).append("</").append(string).append("ProviderID").append(">");
            if (this.nameIdentifier != null) {
                stringBuffer.append(this.nameIdentifier.toString());
            }
            if (this.sessionIndex != null && !this.sessionIndex.equals("")) {
                stringBuffer.append("<").append(string).append("SessionIndex").append(string2).append(">").append(this.sessionIndex).append("</").append(string).append("SessionIndex").append(">");
            }
            if (this.relayState != null && !this.relayState.equals("")) {
                stringBuffer.append("<").append(string).append("RelayState").append(string2).append(">").append(this.relayState).append("</").append(string).append("RelayState").append(">");
            }
        } else {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification.toString: requestID is null ");
            }
            throw new FSMsgException("requestID is null");
        }
        stringBuffer.append("</").append(string).append("LogoutRequest>");
        return stringBuffer.toString();
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public static FSLogoutNotification parseXML(String string) throws FSMsgException {
        Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
        if (document == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null);
        }
        Element element = document.getDocumentElement();
        return new FSLogoutNotification(element);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String string) {
        this.providerId = string;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String string) {
        this.sessionIndex = string;
    }

    public NameIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public void setNameIdentifier(NameIdentifier nameIdentifier) {
        this.nameIdentifier = nameIdentifier;
    }

    public String toURLEncodedQueryString() throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("ProviderId is null in the request with requestId:" + this.requestID));
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("RequestID=").append(URLEncoder.encode(this.requestID)).append("&");
        stringBuffer.append("MajorVersion=").append(this.majorVersion).append("&");
        stringBuffer.append("MinorVersion=").append(this.minorVersion).append("&");
        if (this.issueInstant != null) {
            try {
                stringBuffer.append("IssueInstant=").append(URLEncoder.encode(FSUtils.dateToString(this.issueInstant))).append("&");
            }
            catch (ParseException parseException) {
                FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: Exception: " + parseException.getMessage());
            }
        } else {
            FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: issueInstant missing");
            throw new FSMsgException("missingAttribute", null);
        }
        if (this.providerId != null && !this.providerId.equals("")) {
            stringBuffer.append("ProviderID=").append(URLEncoder.encode(this.providerId)).append("&");
        }
        if (this.sessionIndex != null && !this.sessionIndex.equals("")) {
            stringBuffer.append("SessionIndex=").append(URLEncoder.encode(this.sessionIndex)).append("&");
        }
        if (this.relayState != null && !this.relayState.equals("")) {
            stringBuffer.append("RelayState=").append(URLEncoder.encode(this.relayState)).append("&");
        }
        if (this.nameIdentifier != null) {
            if (this.nameIdentifier.getName() != null && !this.nameIdentifier.getName().equals("")) {
                stringBuffer.append("Name=").append(URLEncoder.encode(this.nameIdentifier.getName())).append("&");
                stringBuffer.append("NameIdentifier=").append(URLEncoder.encode(this.nameIdentifier.getName())).append("&");
            }
            if (this.nameIdentifier.getNameQualifier() != null && !this.nameIdentifier.getNameQualifier().equals("")) {
                stringBuffer.append("NameQualifier=").append(URLEncoder.encode(this.nameIdentifier.getNameQualifier())).append("&");
            }
            if (this.nameIdentifier.getFormat() != null && !this.nameIdentifier.getFormat().equals("")) {
                stringBuffer.append("NameFormat=").append(URLEncoder.encode(this.nameIdentifier.getFormat())).append("&");
            }
        }
        return stringBuffer.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        if (this.providerId == null || this.providerId.equals("")) {
            FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: providerId is null in the request with requestId:" + this.requestID);
            throw new FSMsgException(FSUtils.bundle.getString("ProviderId is null in the request with requestId:" + this.requestID));
        }
        if (this.requestID == null || this.requestID.equals("")) {
            this.requestID = SAMLUtils.generateID();
            if (this.requestID == null) {
                FSUtils.debug.error("FSLogoutNotification.toURLEncodedQueryString: couldn't generate RequestID.");
                throw new FSMsgException("errorGenerateID", null);
            }
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString().getBytes());
    }

    public static FSLogoutNotification parseURLEncodedRequest(HttpServletRequest httpServletRequest) throws FSMsgException {
        try {
            FSLogoutNotification fSLogoutNotification = new FSLogoutNotification();
            if (httpServletRequest.getParameter("RequestID") == null) {
                throw new FSMsgException("missingAttribute", null);
            }
            fSLogoutNotification.requestID = httpServletRequest.getParameter("RequestID");
            try {
                fSLogoutNotification.majorVersion = Integer.parseInt(httpServletRequest.getParameter("MajorVersion"));
                FSUtils.debug.message("Majorversion : " + fSLogoutNotification.majorVersion);
                fSLogoutNotification.minorVersion = Integer.parseInt(httpServletRequest.getParameter("MinorVersion"));
                FSUtils.debug.message("Minorversion : " + fSLogoutNotification.minorVersion);
            }
            catch (NumberFormatException numberFormatException) {
                FSUtils.debug.message("FSLogoutNotification.parseURLEncodedRequest: Major/Minor version problem");
                throw new FSMsgException(numberFormatException.getMessage());
            }
            String string = httpServletRequest.getParameter("IssueInstant");
            if (string == null || string.equals("")) {
                throw new FSMsgException("missingAttribute", null);
            }
            try {
                fSLogoutNotification.issueInstant = FSUtils.stringToDate(string);
            }
            catch (ParseException parseException) {
                throw new FSMsgException(parseException.getMessage());
            }
            if (httpServletRequest.getParameter("ProviderID") == null) {
                throw new FSMsgException("missingElement", null);
            }
            fSLogoutNotification.providerId = httpServletRequest.getParameter("ProviderID");
            if (httpServletRequest.getParameter("SessionIndex") != null) {
                fSLogoutNotification.sessionIndex = httpServletRequest.getParameter("SessionIndex");
            }
            if (httpServletRequest.getParameter("RelayState") != null) {
                fSLogoutNotification.relayState = httpServletRequest.getParameter("RelayState");
            }
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (httpServletRequest.getParameter("NameFormat") != null) {
                string2 = httpServletRequest.getParameter("NameFormat");
            }
            if (httpServletRequest.getParameter("NameQualifier") != null) {
                string3 = httpServletRequest.getParameter("NameQualifier");
            }
            if (httpServletRequest.getParameter("Name") != null) {
                string4 = httpServletRequest.getParameter("Name");
            } else if (httpServletRequest.getParameter("NameIdentifier") != null) {
                string4 = httpServletRequest.getParameter("NameIdentifier");
            } else {
                throw new FSMsgException("missingElement", null);
            }
            fSLogoutNotification.nameIdentifier = new NameIdentifier(string4, string3, string2);
            FSUtils.debug.message("Returning Logout Object");
            return fSLogoutNotification;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static FSLogoutNotification parseBASE64EncodedString(String string) throws FSMsgException {
        return null;
    }

    private void parseMajorVersion(String string) throws FSMsgException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSLogoutNotification(Element): MajorVersion of the LogoutRequest is too high.");
                }
                throw new FSMsgException(SAMLUtils.bundle.getString("requestVersionTooHigh"));
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): MajorVersion of the LogoutRequest is too low.");
            }
            throw new FSMsgException(SAMLUtils.bundle.getString("requestVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws FSMsgException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new FSMsgException("wrongInput", null);
        }
        if (this.minorVersion == 2 || this.minorVersion == 0) {
            return;
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSLogoutNotification(Element): MinorVersion of the LogoutRequest is too high.");
            throw new FSMsgException("requestVersionTooHigh", null);
        }
        FSUtils.debug.error("FSLogoutNotification(Element): MinorVersion of the LogoutRequest is too low.");
        throw new FSMsgException("requestVersionTooLow", null);
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSLogoutNotification.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSLogoutNotification.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "RequestID", this.getRequestID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception: ") + exception.getMessage());
        }
    }

    public void signXML() throws SAMLException {
        throw new SAMLException("Unsupported method");
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print((Node)element);
        return super.setSignature(element);
    }
}

