/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FSAuthnResponseEnvelope {
    private List otherElements;
    private FSAuthnResponse authnResponse;
    private String assertionConsumerServiceURL = null;

    public FSAuthnResponseEnvelope() {
    }

    public FSAuthnResponseEnvelope(FSAuthnResponse fSAuthnResponse) {
        this.authnResponse = fSAuthnResponse;
        this.otherElements = null;
    }

    public FSAuthnResponseEnvelope(Element element) throws FSMsgException, SAMLException {
        if (element == null) {
            FSUtils.debug.message("FSAuthnResponseEnvelope.parseXML: null input.");
            throw new FSMsgException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("AuthnResponseEnvelope")) {
            FSUtils.debug.message("FSAuthnResponseEnvelope.parseXML: wrong input.");
            throw new FSMsgException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("AuthnResponse")) {
                    if (this.authnResponse != null) {
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("FSAuthnResponseEnvelope: included more than one <AuthnResponse>");
                        }
                        throw new FSMsgException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this.authnResponse = new FSAuthnResponse((Element)node);
                } else if (string2.equals("AssertionConsumerServiceURL")) {
                    this.assertionConsumerServiceURL = XMLUtils.getElementValue((Element)((Element)node));
                }
            }
            ++n2;
        }
    }

    public List getOtherElements() {
        return this.otherElements;
    }

    public void setOtherElements(List list) {
        this.otherElements = list;
    }

    public FSAuthnResponse getAuthnResponse() {
        return this.authnResponse;
    }

    public void setAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        this.authnResponse = fSAuthnResponse;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String string) {
        this.assertionConsumerServiceURL = string;
    }

    public static FSAuthnResponseEnvelope parseXML(String string) throws FSMsgException {
        try {
            Document document = XMLUtils.toDOMDocument((String)string, (Debug)FSUtils.debug);
            Element element = document.getDocumentElement();
            return new FSAuthnResponseEnvelope(element);
        }
        catch (SAMLException sAMLException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAuthnResponseEnvelope.parseXML:Error while parsing input xml string");
            }
            throw new FSMsgException("parseError", null, sAMLException);
        }
    }

    public String toXMLString() throws FSMsgException {
        return this.toXMLString(true, true);
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        return this.toXMLString(bl, bl2, false);
    }

    public String toXMLString(boolean bl, boolean bl2, boolean bl3) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>");
        }
        String string = "";
        String string2 = "";
        if (bl) {
            string = "lib:";
        }
        if (bl2) {
            string2 = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        stringBuffer.append("<").append(string).append("AuthnResponseEnvelope").append(string2).append(">");
        if (this.authnResponse != null) {
            stringBuffer.append(this.authnResponse.toXMLString());
        }
        if (this.assertionConsumerServiceURL == null || this.assertionConsumerServiceURL.equals("")) {
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        stringBuffer.append("<").append(string).append("AssertionConsumerServiceURL").append(string2).append(">").append(this.assertionConsumerServiceURL).append("</").append(string).append("AssertionConsumerServiceURL").append(">");
        stringBuffer.append("</").append(string).append("AuthnResponseEnvelope>");
        return stringBuffer.toString();
    }

    public String toBASE64EncodedString() throws FSMsgException {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        return bASE64Encoder.encode(this.toXMLString().getBytes());
    }

    public static FSAuthnResponseEnvelope parseBASE64EncodedString(String string) throws FSMsgException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        if (string != null) {
            try {
                String string2 = new String(bASE64Decoder.decodeBuffer((InputStream)new ByteArrayInputStream(string.getBytes())));
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnResponseEnvelope.parseBASE64EncodedString: decoded input string: \n" + string2);
                }
                return FSAuthnResponseEnvelope.parseXML(string2);
            }
            catch (IOException iOException) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAuthnResponseEnvelope.parseBASE64EncodedString: IOException occuredduring encoding");
                }
                throw new FSMsgException(iOException, "IOException occured during encoding");
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAuthnResponseEnvelope.parseBASE64EncodedString: null String passedin as argument.");
        }
        throw new FSMsgException("nullInput", null);
    }
}

