/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message;

import com.iplanet.am.util.Debug;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FSAssertion
extends Assertion {
    private Element domElement;
    static SAMLConstants sc;
    protected String id = null;
    protected int minorVersion = 0;
    private SecurityAssertion securityAssertion = null;
    protected String inResponseTo = null;

    public String getID() {
        return this.id;
    }

    public void setID(String string) {
        this.id = string;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int n) {
        this.minorVersion = n;
    }

    public Element getDOMElement() {
        return this.domElement;
    }

    public String getInResponseTo() {
        return this.inResponseTo;
    }

    public void setInResponseTo(String string) {
        this.inResponseTo = string;
    }

    public String getSignedXMLString() {
        return this.xmlString;
    }

    public String getSignatureString() {
        return this.signatureString;
    }

    public FSAssertion(Element element) throws FSMsgException, SAMLException {
        Object object;
        FSUtils.debug.message("FSAssertion(Element):  Called");
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: local name missing");
            }
            throw new FSMsgException("nullInput", null);
        }
        if (!string.equals("Assertion")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: invalid root element");
            }
            throw new FSMsgException(FSUtils.bundle.getString("invalidElement") + ":" + string);
        }
        this.domElement = element;
        this.id = element2.getAttribute("id");
        String string2 = element2.getAttribute("MajorVersion");
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: MajorVersion missing");
            }
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute") + ":MajorVersion");
        }
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            FSUtils.debug.error("FSAssertion: invalid integer in MajorVersion", (Throwable)numberFormatException);
            throw new FSMsgException(FSUtils.bundle.getString("invalidNumber") + ":MajorVersion");
        }
        if (n != 1) {
            if (n < 1) {
                FSUtils.debug.error("FSAssertion: MajorVersion too low");
                throw new SAMLVersionMismatchException(FSUtils.bundle.getString("assertionVersionTooLow"));
            }
            if (n > 1) {
                FSUtils.debug.error("FSAssertion: MajorVersion too high");
                throw new SAMLVersionMismatchException(FSUtils.bundle.getString("assertionVersionTooHigh"));
            }
        }
        if ((string2 = element2.getAttribute("MinorVersion")) == null || string2.equals("")) {
            FSUtils.debug.error("FSAssertion: MinorVersion missing");
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute") + ": " + "MinorVersion");
        }
        try {
            this.minorVersion = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            FSUtils.debug.error("FSAssertion: invalid integer in MinorVersion", (Throwable)numberFormatException);
            throw new FSMsgException(FSUtils.bundle.getString("invalidNumber") + ": " + "MinorVersion");
        }
        if (this.minorVersion < 0) {
            FSUtils.debug.error("FSAssertion: MinorVersion too low");
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("assertionVersionTooLow"));
        }
        if (this.minorVersion > 2) {
            FSUtils.debug.error("FSAssertion: MinorVersion too high");
            throw new SAMLVersionMismatchException(FSUtils.bundle.getString("assertionMinorVersionTooHigh"));
        }
        string2 = element2.getAttribute("AssertionID");
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: AssertionID missing");
            }
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute") + ": " + "AssertionID");
        }
        this.setAssertionID(string2);
        string2 = element2.getAttribute("Issuer");
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: Issuer missing");
            }
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute") + ": " + "Issuer");
        }
        this.setIssuer(string2);
        string2 = element2.getAttribute("InResponseTo");
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: InResponseTo missing");
            }
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute") + ": " + "InResponseTo");
        }
        this.inResponseTo = string2;
        string2 = element2.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: IssueInstant missing");
            }
            throw new FSMsgException(FSUtils.bundle.getString("missingAttribute") + ": " + "IssueInstant");
        }
        try {
            this.setIssueInstant(FSUtils.stringToDate(string2));
        }
        catch (ParseException parseException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion: could not parse IssueInstant");
            }
            throw new FSMsgException(FSUtils.bundle.getString("wrongInput:" + parseException.getMessage()));
        }
        n = 0;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            object = nodeList.item(n3);
            if (object.getNodeType() == 1) {
                String string3 = object.getLocalName();
                if (string3.equals("Conditions")) {
                    this.setConditions(new Conditions((Element)object));
                } else if (string3.equals("Advice")) {
                    this.parseAdvice((Element)object);
                } else if (string3.equals("AuthenticationStatement")) {
                    this.addStatement(new FSAuthenticationStatement((Element)object));
                    n = 1;
                } else if (string3.equals("AuthorizationDecisionStatement")) {
                    this.addStatement(new AuthorizationDecisionStatement((Element)object));
                    n = 1;
                } else if (string3.equals("AttributeStatement")) {
                    this.addStatement(new AttributeStatement((Element)object));
                    n = 1;
                } else if (string3.equals("Signature")) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertion: Signature found");
                    }
                } else {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertion: invalid element in Assertion");
                    }
                    throw new FSMsgException("invalidElement", null);
                }
            }
            ++n3;
        }
        object = com.iplanet.am.util.XMLUtils.getElementsByTagNameNS1((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        int n4 = object.size();
        if (n4 == 1) {
            Element element3 = (Element)object.get(0);
            this.setSignature(element3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
            XMLUtils.outputDOM((Node)element, (OutputStream)byteArrayOutputStream);
            this.xmlString = byteArrayOutputStream.toString();
            this.signed = true;
        } else if (n4 != 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion(Element): included more than one Signature element.");
            }
            throw new FSMsgException("moreElement", null);
        }
        if (n == 0) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Assertion: mandatory statement missing");
            }
            throw new FSMsgException("missingStatement", null);
        }
        FSUtils.debug.message("FSAssertion(Element): leaving");
    }

    public boolean isTimeValid() {
        if (this.getConditions() == null) {
            return true;
        }
        return this.getConditions().checkDateValidity(System.currentTimeMillis());
    }

    public FSAssertion(String string, String string2, Date date, Set set, String string3) throws FSMsgException, SAMLException {
        super(string, string2, date, set);
        this.inResponseTo = string3;
    }

    public FSAssertion(String string, String string2, Date date, Conditions conditions, Set set, String string3) throws FSMsgException, SAMLException {
        super(string, string2, date, conditions, set);
        this.inResponseTo = string3;
    }

    public FSAssertion(String string, String string2, Date date, Conditions conditions, Advice advice, Set set, String string3) throws FSMsgException, SAMLException {
        super(string, string2, date, conditions, advice, set);
        this.inResponseTo = string3;
    }

    public boolean addStatement(Statement statement) {
        if (statement == null) {
            return false;
        }
        super.addStatement(statement);
        return true;
    }

    public String toXMLString() throws FSMsgException {
        String string = this.toXMLString(true, true);
        return string;
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (bl2) {
            string = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
            string3 = this.minorVersion == 2 || this.minorVersion == 1 ? " xmlns:lib=\"urn:liberty:iff:2003-08\"" : " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
            string5 = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
        }
        if (bl) {
            string2 = "saml:";
            string4 = "lib:";
        }
        String string6 = null;
        if (this.getIssueInstant() != null) {
            try {
                string6 = FSUtils.dateToString(this.getIssueInstant());
            }
            catch (ParseException parseException) {
                FSUtils.debug.error("FSAssertion: could not dateToString  NotBefore");
            }
        }
        stringBuffer.append("<").append(string2).append("Assertion").append(" ").append(string).append(" ").append(string5).append(" ").append(string3).append(" ");
        if (this.minorVersion == 0 && this.id != null && !this.id.equals("")) {
            stringBuffer.append(" id=\"").append(this.id).append("\" ");
        }
        stringBuffer.append("MajorVersion").append("=\"").append(this.getMajorVersion()).append("\"").append(" ").append("MinorVersion").append("=\"").append(this.minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this.getAssertionID()).append("\"").append(" ").append("Issuer").append("=\"").append(this.getIssuer()).append("\"").append(" ").append("IssueInstant").append("=\"").append(string6).append("\"").append(" ").append("InResponseTo").append("=\"").append(this.inResponseTo).append("\"").append(" ").append("xsi:type").append("=\"").append(string4).append("AssertionType").append("\"").append(">").append("\n");
        if (this.getConditions() != null) {
            stringBuffer.append(this.getConditions().toString(bl, false));
        }
        if (this.getAdvice() != null) {
            stringBuffer.append(this.getAdvice().toString(bl, false));
        }
        Iterator iterator = this.getStatement().iterator();
        while (iterator.hasNext()) {
            object = (Statement)iterator.next();
            if (object instanceof FSAuthenticationStatement) {
                stringBuffer.append(((FSAuthenticationStatement)object).toXMLString(bl, false));
                continue;
            }
            if (!(object instanceof AttributeStatement)) continue;
            stringBuffer.append(((AttributeStatement)object).toString(bl, false));
        }
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                object = new ByteArrayOutputStream(2000);
                XMLUtils.outputDOM((Node)this.signature, (OutputStream)object);
                this.signatureString = ((ByteArrayOutputStream)object).toString();
                stringBuffer.append(this.signatureString);
            }
        }
        stringBuffer.append("</").append(string2).append("Assertion").append(">\n");
        return stringBuffer.toString();
    }

    public void signXML(String string) throws SAMLException {
        FSUtils.debug.message("FSAssertion.signXML: Called");
        if (this.signed) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertion.signXML: the assertion is already signed.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("alreadySigned"));
        }
        if (string == null || string.equals("")) {
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        try {
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            if (this.minorVersion == 0) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "id", this.id, false);
            } else if (this.minorVersion == 2 || this.minorVersion == 1) {
                this.signatureString = xMLSignatureManager.signXML(this.toXMLString(true, true), string, (String)null, "AssertionID", this.getAssertionID(), false);
            } else if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("invalid minor version.");
            }
            this.signature = com.iplanet.am.util.XMLUtils.toDOMDocument((String)this.signatureString, (Debug)FSUtils.debug).getDocumentElement();
            this.signed = true;
            this.xmlString = this.toXMLString(true, true);
        }
        catch (Exception exception) {
            throw new SAMLResponderException(FSUtils.bundle.getString("Exception: ") + exception.getMessage());
        }
    }

    public boolean setSignature(Element element) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)byteArrayOutputStream);
        this.signatureString = byteArrayOutputStream.toString();
        return super.setSignature(element);
    }

    public void parseAdvice(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            String string;
            Node node = nodeList.item(n2);
            if (node.getNodeType() == 1 && (string = node.getLocalName()).equals("Assertion")) {
                try {
                    this.securityAssertion = new SecurityAssertion((Element)node);
                }
                catch (Exception exception) {
                    FSUtils.debug.error("FSAssertion.parseAdvice: Error inparsing security assertion", (Throwable)exception);
                }
            }
            ++n2;
        }
    }

    public SecurityAssertion getDiscoveryCredential() {
        return this.securityAssertion;
    }
}

