/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.login;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.login.FSPostLoginException;
import com.sun.identity.federation.login.IPostLogin;
import com.sun.identity.federation.services.FSLoginHelper;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.logout.FSTokenListener;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.liberty.LibertyManager;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUtils;

public class FSPostLogin
implements IPostLogin {
    private static String headerKey = "headerKey";
    private static String URLKey = "urlKey";
    private static String providerIDKey = "_liberty_idp";
    private static String metaAliasKey = "metaAlias";
    private static String SSOKey = "sso";
    private static String LRURLKey = "RelayState";
    private static boolean messageEnabled = false;
    private static String COTKey = "cotkey";
    private static String selectedProviderKey = "selectedprovider";
    private static String showFederateKey = "federate";
    private static String showFederateValue = "false";
    private String federationPage = null;
    private String consentPage = null;
    private Set cotSet = null;
    private String errorPage = null;
    private static FSAllianceManager allianceManager = null;
    private HttpServletRequest httpRequest = null;
    private boolean isIDP = false;

    public FSPostLogin() {
        if (messageEnabled) {
            FSUtils.debug.message("FSPostLogin::Constructor called");
        }
    }

    public Map doPostLogin(Map map) {
        return map;
    }

    public void doPostLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        String string2;
        block23: {
            String string3;
            Object object;
            Object object2;
            CharSequence charSequence;
            string2 = httpServletRequest.getParameter(metaAliasKey);
            String string4 = httpServletRequest.getParameter(SSOKey);
            String string5 = httpServletRequest.getParameter(LRURLKey);
            String string6 = httpServletRequest.getParameter(showFederateKey);
            string = new String();
            this.httpRequest = httpServletRequest;
            if (string2 == null) {
                string2 = FSServiceUtils.getMetaAlias(httpServletRequest);
                charSequence = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
                object2 = ((StringBuffer)charSequence).toString();
                string5 = FSPostLogin.getValueFromURL((String)object2, LRURLKey);
                string4 = FSPostLogin.getValueFromURL((String)object2, SSOKey);
                object = FSSessionManager.getInstance(LibertyManager.getProviderID(string2));
                string3 = ((FSSessionManager)object).getRelayState(string5);
                if (string3 != null) {
                    ((FSSessionManager)object).removeRelayState(string5);
                    string5 = string3;
                }
            }
            if (string5 == null || string5.length() <= 0) {
                charSequence = LibertyManager.getProviderID(string2);
                string5 = LibertyManager.getHomeURL((String)charSequence);
            }
            try {
                this.setAllianceInfo(string2);
            }
            catch (FSPostLoginException fSPostLoginException) {
                this.sendResponse(httpServletRequest, httpServletResponse, this.errorPage);
            }
            if (string4 != null && string4.length() > 0 && string4.equalsIgnoreCase("true") || this.isIDP) {
                try {
                    charSequence = LibertyManager.getProviderID(string2);
                    object2 = LibertyManager.getListOfCOTs((String)charSequence);
                    if (object2 != null && !object2.isEmpty()) {
                        if (object2.size() <= 1) {
                            object = (String)object2.iterator().next();
                            if (messageEnabled) {
                                FSUtils.debug.message("FSPostLogin::doPostLogin single cot present is " + (String)object);
                            }
                            string = this.doConsentToIntro(string2, string5, (String)object);
                        } else {
                            string = this.consentPage + "?" + metaAliasKey + "=" + string2 + "&" + LRURLKey + "=" + URLEncoder.encode(string5);
                        }
                        break block23;
                    }
                    if (messageEnabled) {
                        FSUtils.debug.message("FSPostLogin::doPostLogin: No COTS configured. redirecting to lrurl " + string5);
                    }
                    string = string5;
                }
                catch (FSPostLoginException fSPostLoginException) {
                    this.sendResponse(httpServletRequest, httpServletResponse, this.errorPage);
                }
            } else if (string6 != null && !string6.equalsIgnoreCase(showFederateValue)) {
                charSequence = LibertyManager.getProviderID(string2);
                object2 = LibertyManager.getUser(httpServletRequest);
                if (object2 == null) {
                    object = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest).toString() + "?" + httpServletRequest.getQueryString();
                    string3 = LibertyManager.getLoginURL(httpServletRequest);
                    this.sendResponse(httpServletRequest, httpServletResponse, string3 + "&goto=" + URLEncoder.encode((String)object));
                    return;
                }
                object = LibertyManager.getProvidersToFederate((String)charSequence, (String)object2);
                if (object != null && object.size() != 0 && this.federationPage != null) {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSPostLogin::doPostLogin: Found provider(s) to federated with " + object);
                    }
                    string = this.federationPage + "?" + metaAliasKey + "=" + string2 + "&" + LRURLKey + "=" + URLEncoder.encode(string5);
                } else {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSPostLogin::doPostLogin: No provider(s) to federated with or federationPage null. Redirecting to LRURL " + string5);
                    }
                    string = string5;
                }
            } else {
                if (messageEnabled) {
                    FSUtils.debug.message("FSPostLogin::doPostLogin. No cotkey or Federatekey found");
                }
                string = string5;
            }
        }
        this.setTokenListenerAndSessionInfo(httpServletRequest, string2);
        if (messageEnabled) {
            FSUtils.debug.message("FSPostLogin::doPostLogin return url " + string);
        }
        this.sendResponse(httpServletRequest, httpServletResponse, string);
    }

    private void setTokenListenerAndSessionInfo(HttpServletRequest httpServletRequest, String string) {
        Object object;
        if (messageEnabled) {
            FSUtils.debug.message("FSPostLogin::setTokenListenerAndSessionInfo");
        }
        SSOToken sSOToken = null;
        String string2 = null;
        String string3 = null;
        String string4 = LibertyManager.getProviderID(string);
        try {
            object = SSOTokenManager.getInstance();
            sSOToken = object.createSSOToken(httpServletRequest);
            string2 = sSOToken.getTokenID().toString();
            string3 = sSOToken.getPrincipal().getName();
            sSOToken.addSSOTokenListener((SSOTokenListener)new FSTokenListener(string4));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSPostLogin::setTokenListenerAndSessionInfo Failed during trying to add token Listener.Got SSOException " + sSOException.getMessage());
            return;
        }
        object = FSSessionManager.getInstance(string4);
        FSSession fSSession = ((FSSessionManager)object).getSession(string3, string2);
        if (fSSession == null) {
            if (messageEnabled) {
                FSUtils.debug.message("FSPostLogin::setTokenListenerAndSessionInfo. No existing session found  for userDN:" + string3 + " And SessionID: " + string2 + " Creating a new Session");
            }
            FSSession fSSession2 = new FSSession(string2);
            ((FSSessionManager)object).addSession(string3, fSSession2);
        }
    }

    private void sendResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        try {
            FSUtils.forwardRequest(httpServletRequest, httpServletResponse, string);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSPreLogin:: sendError Error during sending error page");
        }
    }

    public String doConsentToIntro(HttpServletRequest httpServletRequest) throws FSPostLoginException {
        String string = httpServletRequest.getParameter(metaAliasKey);
        String string2 = httpServletRequest.getParameter(LRURLKey);
        String string3 = httpServletRequest.getParameter(COTKey);
        return this.doConsentToIntro(string, string2, string3);
    }

    private void setAllianceInfo(String string) throws FSPostLoginException {
        try {
            FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
            if (allianceManager == null) {
                FSUtils.debug.error("FSPostLogin::setAllianceInfo could not get alliane manager handle Cannot proceed so throwing error page");
                throw new FSPostLoginException("FSPostLogin:: could not get alliancemanager handle.");
            }
            fSHostedProviderDescriptor = allianceManager.getHostedProviderByMetaAlias(string);
            if (fSHostedProviderDescriptor != null) {
                this.cotSet = fSHostedProviderDescriptor.getListOfCOTs();
                fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
                String string2 = fSHostedProviderDescriptor.getProviderRole();
                if (messageEnabled) {
                    FSUtils.debug.message("FSPostLogin::setAllianceInfo  role of the provider is " + string2);
                }
                if (string2.indexOf("IDP") != -1) {
                    this.isIDP = true;
                }
            } else {
                FSUtils.debug.error("FSPostLogin::setAllianceInfo getHostedProviderByMetaAlias retured null. Cannot proceed so throwing error page");
                throw new FSPostLoginException("FSPostLogin:: could not get provider Descriptor handle.");
            }
            if (fSLocalConfigurationDescriptor == null) {
                FSUtils.debug.error("FSPostLogin:setAllianceInfo failedFSLocalConfigurationDescriptor is null");
                throw new FSPostLoginException("FSPostLogin:: could not get local config.");
            }
            this.consentPage = fSLocalConfigurationDescriptor.getListOfCOTsPageURL(this.httpRequest);
            this.federationPage = fSLocalConfigurationDescriptor.getDoFederationPageURL(this.httpRequest);
            this.errorPage = fSLocalConfigurationDescriptor.getErrorPageURL(this.httpRequest);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSPostLogin::setAllianceInfo Alliance management Failed." + fSAllianceManagementException.getMessage());
            throw new FSPostLoginException("FSPostLogin:: FSAllianceManagementException" + fSAllianceManagementException.getMessage());
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSPostLogin::setAllianceInfo General Exception caugth." + exception.getMessage());
            throw new FSPostLoginException("FSPostLogin:: FSAllianceManagementException" + exception.getMessage());
        }
    }

    private String doConsentToIntro(String string, String string2, String string3) throws FSPostLoginException {
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        try {
            fSCircleOfTrustDescriptor = allianceManager.getCircleOfTrust(string3);
            if (fSCircleOfTrustDescriptor != null && fSCircleOfTrustDescriptor.getCircleOfTrustStatus().equalsIgnoreCase("active")) {
                string5 = fSCircleOfTrustDescriptor.getWriterServiceURL();
            }
            fSHostedProviderDescriptor = allianceManager.getHostedProviderByMetaAlias(string);
            string4 = fSHostedProviderDescriptor.getProviderID();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSPostLogin::doConsentToIntro in alliance managment expextion" + fSAllianceManagementException.getMessage());
            string5 = null;
        }
        String string6 = new String();
        string6 = string5 != null ? string5 + "?" + LRURLKey + "=" + URLEncoder.encode(string2) + "&" + providerIDKey + "=" + URLEncoder.encode(string4) : string2;
        if (messageEnabled) {
            FSUtils.debug.message("FSPostLogin::doConsentToIntro return url" + string6);
        }
        return string6;
    }

    public String doFederation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FSPostLoginException {
        Object object;
        Object object2;
        String string = httpServletRequest.getParameter(metaAliasKey);
        String string2 = httpServletRequest.getParameter(LRURLKey);
        String string3 = httpServletRequest.getParameter(selectedProviderKey);
        if (messageEnabled) {
            FSUtils.debug.message("FSPostLogin::doFederation metaAlias " + string);
            FSUtils.debug.message("FSPostLogin::doFederation lrurl " + string2);
            FSUtils.debug.message("FSPostLogin::doFederation selected provider" + string3);
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement().toString();
            object = httpServletRequest.getHeader((String)object2);
            hashMap.put(object2, object);
        }
        object2 = new FSLoginHelper(httpServletRequest);
        object = new HashMap();
        String string4 = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            string4 = (String)httpSession.getAttribute("authlevel");
        }
        try {
            object = ((FSLoginHelper)object2).createAuthnRequest(hashMap, string2, string4, string, string3, true);
        }
        catch (FSLoginHelperException fSLoginHelperException) {
            FSUtils.debug.error("FSPostLogin::doFederate in exception " + fSLoginHelperException.getMessage());
            throw new FSPostLoginException("FSPostLogin::doFederate in exception " + fSLoginHelperException.getMessage());
        }
        Map map = (Map)object.get(headerKey);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string5 = iterator.next().toString();
            String string6 = (String)hashMap.get(string5);
            httpServletResponse.addHeader(string5, string6);
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSPostLogin::doFederation returing with " + (String)object.get(URLKey));
        }
        return (String)object.get(URLKey);
    }

    private static String getValueFromURL(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n != -1) {
            n = n + string2.length() + 1;
            String string3 = string.substring(n);
            byte[] byArray = string3.getBytes();
            int n2 = string3.length();
            int n3 = 0;
            while (n3 < n2) {
                if (byArray[n3] == 47 || byArray[n3] == 63) break;
                ++n3;
            }
            String string4 = string3.substring(0, n3);
            return string4;
        }
        return null;
    }

    static {
        if (FSUtils.debug.messageEnabled()) {
            messageEnabled = true;
        }
        allianceManager = FSServiceUtils.getAllianceInstance();
    }
}

