/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.common;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.common.FSCommonManager;
import com.sun.identity.federation.common.IFSConstants;
import com.sun.identity.log.Logger;
import com.sun.identity.saml.common.SAMLUtils;
import java.net.URL;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xml.security.Init;
import sun.misc.BASE64Encoder;

public class FSUtils {
    public static String deploymentURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor");
    public static boolean logStatus = false;
    public static final String BUNDLE_NAME = "amFederation";
    public static IFSConstants sc;
    public static ResourceBundle bundle;
    public static Debug debug;
    private static final String UTC_DATEFORMAT_STR = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String UTC_DATEFORMAT_WITH_MS_STR = "yyyy-MM-dd'T'HH:mm:ss.S'Z'";
    private static final String PST_DATEFORMAT_STR = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final String PST_DATEFORMAT_WITH_MS_STR = "yyyy-MM-dd'T'HH:mm:ss.sz";
    public static SecureRandom random;
    public static final String FSID_PREFIX = "f";
    private static BASE64Encoder encoder;
    private static Logger accessLogger;
    private static Logger errorLogger;
    private static Object lock;

    private FSUtils() {
    }

    public static void setLocale(String string) {
        try {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getLocale((String)string));
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println(missingResourceException.getMessage());
            System.exit(1);
        }
    }

    public static void access(String string, String string2, Object[] objectArray) {
        FSUtils.access(string, MessageFormat.format(bundle.getString(string2), objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void access(String string, String string2) {
        Object object;
        if (!logStatus) {
            return;
        }
        if (accessLogger == null) {
            object = lock;
            synchronized (object) {
                if (accessLogger == null) {
                    try {
                        accessLogger = (Logger)Logger.getLogger((String)"Federation.access");
                        debug.message("initialized access logger");
                    }
                    catch (Exception exception) {
                        debug.error("FSUtils:error creating access logger:" + exception.getMessage());
                    }
                }
            }
        }
        object = new com.sun.identity.log.LogRecord(Level.INFO, string + ":" + string2);
        try {
            accessLogger.log((LogRecord)object, (Object)FSCommonManager.getSSOToken());
        }
        catch (Exception exception) {
            debug.error("FSUtils:error writing  to federation access log:", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void error(String string, String string2) {
        Object object;
        if (!logStatus) {
            return;
        }
        if (errorLogger == null) {
            object = lock;
            synchronized (object) {
                if (errorLogger == null) {
                    try {
                        errorLogger = (Logger)Logger.getLogger((String)"Federation.error");
                        debug.message("initialized error logger");
                    }
                    catch (Exception exception) {
                        debug.error("FSUtils:error creating error logger:" + exception.getMessage());
                    }
                }
            }
        }
        object = new com.sun.identity.log.LogRecord(Level.INFO, string + ":" + string2);
        try {
            errorLogger.log((LogRecord)object, (Object)FSCommonManager.getSSOToken());
        }
        catch (Exception exception) {
            debug.error("FSUtils:error writing  to federation error log:" + exception.getMessage());
        }
    }

    public static Date stringToDate(String string) throws ParseException {
        Date date = null;
        Object var2_2 = null;
        SimpleDateFormat simpleDateFormat = null;
        if (string.indexOf(90) == -1) {
            simpleDateFormat = new SimpleDateFormat(PST_DATEFORMAT_STR);
            if (string.indexOf(".") == -1) {
                date = simpleDateFormat.parse(string);
            } else {
                int n = string.indexOf(".");
                int n2 = -1;
                n2 = string.lastIndexOf(43);
                if (n2 == -1) {
                    n2 = string.lastIndexOf(45);
                }
                if (n2 == -1) {
                    throw new ParseException("Date not in proper +/- hh:mm format", n2);
                }
                String string2 = string.substring(0, n) + string.substring(n2);
                if (debug.messageEnabled()) {
                    debug.message("parsing date:" + string2);
                }
                date = simpleDateFormat.parse(string2);
                if (debug.messageEnabled()) {
                    debug.message("+/- parsed date is:" + date);
                }
            }
        } else {
            if (string.indexOf(".") == -1) {
                simpleDateFormat = new SimpleDateFormat(UTC_DATEFORMAT_STR);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                date = simpleDateFormat.parse(string);
            } else {
                simpleDateFormat = new SimpleDateFormat(UTC_DATEFORMAT_WITH_MS_STR);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                date = simpleDateFormat.parse(string);
            }
            if (debug.messageEnabled()) {
                debug.message("after reading from vendor Z parsedDate is:" + date);
            }
        }
        return date;
    }

    public static String dateToString(Date date) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer(100);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(UTC_DATEFORMAT_STR);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = simpleDateFormat.format(date, stringBuffer, new FieldPosition(0)).toString();
        if (debug.messageEnabled()) {
            debug.message("dateToString of vendor " + date + " is:" + string);
        }
        return string;
    }

    public static Date convertToUTC(Date date) throws ParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date2 = new Date(date.getTime() - (long)gregorianCalendar.get(15));
        return date2;
    }

    public static String generateID() {
        if (random == null) {
            return null;
        }
        byte[] byArray = new byte[20];
        random.nextBytes(byArray);
        String string = FSID_PREFIX + FSUtils.byteArrayToHexString(byArray);
        if (debug.messageEnabled()) {
            debug.message("FSUtils.generateID: generated id is" + string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateSourceID(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            debug.error("FSUtils.generateSourceID: Exception:", (Throwable)exception);
            return null;
        }
        byte[] byArray = string.getBytes();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = null;
        String string3 = null;
        try {
            BASE64Encoder bASE64Encoder = encoder;
            synchronized (bASE64Encoder) {
                string2 = encoder.encodeBuffer(byArray2).trim();
            }
            string3 = string2.substring(0, 20);
        }
        catch (Exception exception) {
            debug.error("FSUtils:generateSourceID: exception:", (Throwable)exception);
        }
        return string3;
    }

    public static String generateAssertionHandle() {
        String string;
        block2: {
            string = null;
            String string2 = FSUtils.generateID();
            if (string2 == null) break block2;
            try {
                string = string2.substring(0, 20);
            }
            catch (Exception exception) {
                debug.error("FSUtil.generateAssertionHandle:" + exception.getMessage());
            }
        }
        return string;
    }

    public static byte[] hexStringToByteArray(String string) {
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            String string2 = string.substring(n, n + 2);
            if (string2.equals("FF")) {
                byArray[n2] = -1;
            } else {
                try {
                    byArray[n2] = (byte)Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("FSUtils.hexStringToByteArray: Failed " + numberFormatException.getMessage());
                    return null;
                }
            }
            n += 2;
            ++n2;
        }
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Integer.toHexString(0xFF & byArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hexStringToBase64(String string) {
        String string2;
        block7: {
            int n = string.length();
            byte[] byArray = new byte[n / 2];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                string2 = string.substring(n2, n2 + 2);
                byArray[n3] = new Short(Integer.toString(Integer.parseInt(string2, 16))).byteValue();
                ++n2;
                ++n2;
                ++n3;
            }
            string2 = null;
            try {
                BASE64Encoder bASE64Encoder = encoder;
                synchronized (bASE64Encoder) {
                    string2 = encoder.encodeBuffer(byArray).trim();
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block7;
                debug.message("SAMLUtil:hexStringToBase64: exception encode input:", (Throwable)exception);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("base 64 source id is :" + string2);
        }
        return string2;
    }

    public static void checkHTTPRequestLength(HttpServletRequest httpServletRequest) throws ServletException {
        int n = SAMLUtils.getMaxContentLength();
        if (n != 0) {
            int n2 = httpServletRequest.getContentLength();
            if (n2 == -1) {
                throw new ServletException(bundle.getString("unknownLength"));
            }
            if (n2 > n) {
                if (debug.messageEnabled()) {
                    debug.message("FSUtils.checkHTTPRequestLength: content length too large" + n2);
                }
                throw new ServletException(bundle.getString("largeContentLength"));
            }
        }
    }

    public static void forwardRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        Object object;
        debug.message("FSUtils.forwardRequest: called");
        String string2 = null;
        try {
            object = SSOTokenManager.getInstance();
            SSOToken sSOToken = object.createSSOToken(httpServletRequest);
            if (sSOToken != null && object.isValidToken(sSOToken)) {
                string2 = sSOToken.encodeURL(string);
            }
        }
        catch (SSOException sSOException) {
            if (debug.messageEnabled()) {
                debug.message("FSUtils.forwardReqeust: couldn't rewrite url: " + sSOException.getMessage());
            }
            string2 = null;
        }
        if (string2 == null) {
            string2 = string;
        }
        try {
            object = httpServletRequest.getServerName();
            int n = httpServletRequest.getServerPort();
            debug.message("FSUtils.forwardRequest: SourceHost=" + (String)object + " SourcePort=" + n);
            URL uRL = new URL(string2);
            String string3 = uRL.getHost();
            int n2 = uRL.getPort();
            debug.message("FSUtils.forwardRequest: targetHost=" + string3 + " targetPort=" + n2);
            int n3 = string2.indexOf(deploymentURI);
            if (!((String)object).equals(string3) || n != n2 || n3 <= 0) {
                debug.message("FSUtils.forwardRequest: Source and Target are not on the same container. Redirecting to target");
                httpServletResponse.sendRedirect(string2);
                return;
            }
            String string4 = string2.substring(n3 + deploymentURI.length());
            if (debug.messageEnabled()) {
                debug.message("FSUtils.forwardRequest: Forwarding to :" + string4);
            }
            RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(string4);
            try {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (Exception exception) {
                debug.error("FSUtils.forwardRequest: Exception occured while trying to forward to resource" + string4 + " : " + exception.getMessage());
            }
        }
        catch (Exception exception) {
            debug.error("FSUtils.forwardRequest: Exception occured" + exception.getMessage());
        }
    }

    public static byte[] generateSuccintID(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        return byArray2;
    }

    static {
        String string = SystemProperties.get((String)"com.iplanet.am.logstatus");
        if (string == null) {
            string = "INACTIVE";
        }
        if (string.equalsIgnoreCase("ACTIVE") && WebtopNaming.isServerMode()) {
            logStatus = true;
        }
        Init.init();
        bundle = Locale.getInstallResourceBundle((String)BUNDLE_NAME);
        debug = Debug.getInstance((String)BUNDLE_NAME);
        random = new SecureRandom();
        encoder = new BASE64Encoder();
        accessLogger = null;
        errorLogger = null;
        lock = new Object();
    }
}

