/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.common.SAMLUtils;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSProviderDescriptor {
    protected String entityID = null;
    protected String providerID = null;
    protected String providerName = null;
    protected String providerStatus = null;
    protected String providerType = null;
    protected String providerRole = null;
    protected Set listOfCOTs = null;
    protected String providerSuccinctID = null;
    protected String keyInfo = null;
    protected String keyUse = null;
    protected String encryptMethod = null;
    protected String keySize = null;
    protected String SOAPEndPoint = null;
    protected String SLOServiceURL = null;
    protected String SLOServiceReturnURL = null;
    protected String federationTerminationServiceURL = null;
    protected String federationTerminationServiceReturnURL = null;
    protected String assertionConsumerServiceURL = null;
    protected Set federationTerminationProtocolProfile = null;
    protected Set SLOProtocolProfile = null;
    protected Set nameRegistrationProfile = null;
    protected String nameRegistrationURL = null;
    protected String nameRegistrationReturnURL = null;
    protected boolean authnRequestSigned = false;
    protected boolean nameRegistrationAfterSSO = false;
    protected String SSOServiceURL = null;
    protected boolean nameRegistrationIndicator = false;
    protected Set termNotificationProfile = null;
    protected Set listOfNameIdMapBinds = null;
    protected Set addMetaLocn = null;
    protected Map contactPerson = null;
    private int cpMaxNum = 0;
    protected FSOrganization organization = null;
    protected String extension = null;
    protected String signCertAlias = null;
    protected String validUtil = null;
    protected String cacheDuration = null;
    protected String preferProtSuppEnum = null;
    protected Set protSuppEnum = null;
    protected String assertionConsumerServiceURLId = null;
    protected boolean assertionConsumerServiceURLIsDefault = false;
    protected Set introNotificationProtocolProfile = null;
    protected Set singleSignonProtocolProfile = null;
    private int beginIndex = "ContactPerson".length();

    public FSProviderDescriptor(String string, String string2) throws FSAllianceManagementException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSProviderDescriptor::constructor Id is null");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        this.providerID = string;
        this.setProviderStatus(string2);
        this.providerSuccinctID = this.generateSuccinctID(string);
    }

    public FSProviderDescriptor(String string, String string2, String string3) throws FSAllianceManagementException {
        this(string, string2);
        this.setProviderRole(string3);
    }

    FSProviderDescriptor(String string, Map map) {
        this.providerID = string;
        this.providerName = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-name");
        this.providerStatus = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-status");
        this.providerSuccinctID = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-succinctid");
        this.providerType = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-type");
        this.providerRole = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-provider-role");
        this.listOfCOTs = (Set)map.get("iplanet-am-list-of-authenticationdomains");
        this.keyInfo = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-certificate-alias");
        this.keyUse = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerKeyUse");
        this.keySize = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerKeySize");
        this.encryptMethod = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEncryptionMethod");
        this.SOAPEndPoint = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-soap-end-point");
        this.SLOServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-service-url");
        this.termNotificationProfile = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerRelationshipTermNotificationProtocolProfile");
        this.addMetaLocn = new HashSet();
        this.addMetaLocn = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerAdditionalMetaLocation");
        this.listOfNameIdMapBinds = new HashSet();
        this.listOfNameIdMapBinds = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerNameIdentifierMappingBinding");
        this.extension = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerExtension");
        this.signCertAlias = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerSignatureCertAlias");
        this.validUtil = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerValidUntil");
        this.cacheDuration = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerCacheDuration");
        this.protSuppEnum = new HashSet();
        this.protSuppEnum = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerProtocolSupportEnum");
        this.SLOServiceReturnURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-slo-service-return-url");
        this.federationTerminationServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-service-url");
        this.federationTerminationServiceReturnURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-federation-termination-service-return-url");
        this.assertionConsumerServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-assertion-consumer-service-url");
        this.assertionConsumerServiceURLId = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAssertionConsumerServiceUrlId");
        String string2 = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAssertionConsumerServiceUrlisDefault");
        if (string2.equalsIgnoreCase("true")) {
            this.assertionConsumerServiceURLIsDefault = true;
        } else if (string2.equalsIgnoreCase("false")) {
            this.assertionConsumerServiceURLIsDefault = false;
        }
        this.federationTerminationProtocolProfile = FSAllianceManagementUtils.getEntry(map, "iplanet-am-federation-termination-protocol-profile");
        this.SLOProtocolProfile = FSAllianceManagementUtils.getEntry(map, "iplanet-am-slo-protocol-profile");
        this.nameRegistrationProfile = FSAllianceManagementUtils.getEntry(map, "iplanet-am-name-registration-profile");
        this.nameRegistrationURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-url");
        this.nameRegistrationReturnURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-return-url");
        String string3 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authnrequest-signed");
        this.authnRequestSigned = string3.equalsIgnoreCase("true");
        String string4 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-after-sso");
        this.nameRegistrationAfterSSO = string4.equalsIgnoreCase("true");
        this.SSOServiceURL = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-sso-service-url");
        String string5 = FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-name-registration-indicator");
        this.nameRegistrationIndicator = string5.equalsIgnoreCase("true");
        this.introNotificationProtocolProfile = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerIntroductionNotificationProtProfile");
        this.singleSignonProtocolProfile = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerSingleSignOnProtocolprofile");
    }

    String getProviderType() {
        return this.providerType;
    }

    void setProviderType(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("hosted") && !string.equalsIgnoreCase("remote")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerType = string;
    }

    public String getProviderID() {
        return this.providerID;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getProviderStatus() {
        return this.providerStatus;
    }

    public String getProviderRole() {
        return this.providerRole;
    }

    public String getKeyInfo() {
        return this.keyInfo;
    }

    public String getEncryptionMethod() {
        return this.encryptMethod;
    }

    public String getKeyUse() {
        return this.keyUse;
    }

    public int getKeySize() {
        int n = -1;
        if (this.keySize != null && !this.keySize.equals("")) {
            n = Integer.parseInt(this.keySize);
        }
        return n;
    }

    public String getProviderSuccinctID() {
        return this.providerSuccinctID;
    }

    public Set getListOfCOTs() {
        return this.listOfCOTs;
    }

    public String getSLOServiceURL() {
        return this.SLOServiceURL;
    }

    public Set getRelationshipTerminationNotificationProfileSet() {
        return this.termNotificationProfile;
    }

    public String getRelationshipTerminationNotificationProfile() {
        String string = null;
        if (this.termNotificationProfile != null && !this.termNotificationProfile.isEmpty()) {
            string = (String)this.termNotificationProfile.iterator().next();
        }
        return string;
    }

    public Set getNameIdMapBind() {
        return this.listOfNameIdMapBinds;
    }

    public FSOrganization getOrganization() {
        return this.organization;
    }

    public Set getAdditionalMetaLocation() {
        return this.addMetaLocn;
    }

    public Set getContactPerson() {
        if (this.contactPerson != null && !this.contactPerson.isEmpty()) {
            return this.contactPerson.entrySet();
        }
        return null;
    }

    public Set getContactPersonId() {
        if (this.contactPerson != null && !this.contactPerson.isEmpty()) {
            return this.contactPerson.keySet();
        }
        return null;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getSignCertAlias() {
        return this.signCertAlias;
    }

    public String getValidUntil() {
        return this.validUtil;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public Set getProtocolSupportEnumSet() {
        return this.protSuppEnum;
    }

    public String getProtocolSupportEnum() {
        String string = null;
        if (this.preferProtSuppEnum != null) {
            return this.preferProtSuppEnum;
        }
        if (this.protSuppEnum != null && !this.protSuppEnum.isEmpty()) {
            string = (String)this.protSuppEnum.iterator().next();
        }
        return string;
    }

    public int getMinorVersion() {
        int n = 0;
        String string = this.getProtocolSupportEnum();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("getMinorVersion:null protcolSuppEnum.");
            }
        } else if (string.equalsIgnoreCase("urn:liberty:iff:2002-12")) {
            n = 0;
        } else if (string.equalsIgnoreCase("urn:liberty:iff:2003-08")) {
            n = 2;
        }
        return n;
    }

    public String getSLOServiceReturnURL() {
        return this.SLOServiceReturnURL;
    }

    public Set getNameRegistrationProfileSet() {
        return this.nameRegistrationProfile;
    }

    public String getNameRegistrationProfile() {
        String string = null;
        if (this.nameRegistrationProfile != null && !this.nameRegistrationProfile.isEmpty()) {
            string = (String)this.nameRegistrationProfile.iterator().next();
        }
        return string;
    }

    public String getNameRegistrationURL() {
        return this.nameRegistrationURL;
    }

    public String getNameRegistrationReturnURL() {
        return this.nameRegistrationReturnURL;
    }

    public String getSOAPEndPoint() {
        return this.SOAPEndPoint;
    }

    public String getFederationTerminationServiceURL() {
        return this.federationTerminationServiceURL;
    }

    public String getFederationTerminationServiceReturnURL() {
        return this.federationTerminationServiceReturnURL;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public String getAssertionConsumerServiceURLId() {
        return this.assertionConsumerServiceURLId;
    }

    public boolean getAssertionConsumerServiceURLIsDefault() {
        return this.assertionConsumerServiceURLIsDefault;
    }

    public Set getFederationTerminationProtocolProfileSet() {
        return this.federationTerminationProtocolProfile;
    }

    public String getFederationTerminationProtocolProfile() {
        String string = null;
        if (this.federationTerminationProtocolProfile != null && !this.federationTerminationProtocolProfile.isEmpty()) {
            string = (String)this.federationTerminationProtocolProfile.iterator().next();
        }
        return string;
    }

    public Set getSLOProtocolProfileSet() {
        return this.SLOProtocolProfile;
    }

    public String getSLOProtocolProfile() {
        String string = null;
        if (this.SLOProtocolProfile != null && !this.SLOProtocolProfile.isEmpty()) {
            string = (String)this.SLOProtocolProfile.iterator().next();
        }
        return string;
    }

    public boolean getAuthnRequestSigned() {
        return this.authnRequestSigned;
    }

    public boolean getNameRegistrationAfterSSO() {
        return this.nameRegistrationAfterSSO;
    }

    public boolean getNameRegistrationIndicator() {
        return this.nameRegistrationIndicator;
    }

    public Set getIntroductionNotificationProtocolProfileSet() {
        return this.introNotificationProtocolProfile;
    }

    public String getIntroductionNotificationProtocolProfile() {
        String string = null;
        if (this.introNotificationProtocolProfile != null && !this.introNotificationProtocolProfile.isEmpty()) {
            string = (String)this.introNotificationProtocolProfile.iterator().next();
        }
        return string;
    }

    public void setIntroductionNotificationProtocolProfile(Set set) {
        this.introNotificationProtocolProfile = set;
    }

    public void setIntroductionNotificationProtocolProfile(String string) {
        if (this.introNotificationProtocolProfile == null) {
            this.introNotificationProtocolProfile = new HashSet();
        }
        if (!this.introNotificationProtocolProfile.isEmpty()) {
            this.introNotificationProtocolProfile.clear();
        }
        this.introNotificationProtocolProfile.add(string);
    }

    public Set getSingleSignOnProtocolProfileSet() {
        return this.singleSignonProtocolProfile;
    }

    public String getSingleSignOnProtocolProfile() {
        String string = null;
        if (this.singleSignonProtocolProfile != null && !this.singleSignonProtocolProfile.isEmpty()) {
            string = (String)this.singleSignonProtocolProfile.iterator().next();
        }
        return string;
    }

    public void setSingleSignOnProtocolProfile(Set set) {
        this.singleSignonProtocolProfile = set;
    }

    public void setSingleSignOnProtocolProfile(String string) {
        if (this.singleSignonProtocolProfile == null) {
            this.singleSignonProtocolProfile = new HashSet();
        }
        if (!this.singleSignonProtocolProfile.isEmpty()) {
            this.singleSignonProtocolProfile.clear();
        }
        this.singleSignonProtocolProfile.add(string);
    }

    public void setNameRegistrationIndicator(boolean bl) {
        this.nameRegistrationIndicator = bl;
    }

    public String getSSOServiceURL() {
        return this.SSOServiceURL;
    }

    public void setProviderName(String string) {
        this.providerName = string;
    }

    public void setProviderStatus(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("active") && !string.equalsIgnoreCase("inactive")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerStatus = string;
    }

    public void setProviderRole(String string) throws FSAllianceManagementException {
        if (string == null || !string.equalsIgnoreCase("SP") && !string.equalsIgnoreCase("IDP") && !string.equalsIgnoreCase("IDP/SP")) {
            throw new FSAllianceManagementException("alliance_management_invalid_input_exception", null);
        }
        this.providerRole = string;
    }

    public void setKeyInfo(String string) {
        this.keyInfo = string;
    }

    public void setEncryptionMethod(String string) {
        this.encryptMethod = string;
    }

    public void setKeyUse(String string) {
        this.keyUse = string;
    }

    public void setKeySize(int n) {
        this.keySize = Integer.toString(n);
    }

    public void setListOfCOTs(Set set) {
        this.listOfCOTs = set;
    }

    public void setSLOServiceURL(String string) {
        this.SLOServiceURL = string;
    }

    public void setRelationshipTerminationNotificationProfile(Set set) {
        this.termNotificationProfile = set;
    }

    public void setRelationshipTerminationNotificationProfile(String string) {
        if (this.termNotificationProfile == null) {
            this.termNotificationProfile = new HashSet();
        }
        if (!this.termNotificationProfile.isEmpty()) {
            this.termNotificationProfile.clear();
        }
        this.termNotificationProfile.add(string);
    }

    public void setNameIdMapBind(Set set) {
        this.listOfNameIdMapBinds = set;
    }

    public void setOrganization(FSOrganization fSOrganization) {
        this.organization = fSOrganization;
    }

    public boolean addContactPerson(FSContactPerson fSContactPerson, boolean bl) {
        if (this.contactPerson == null) {
            this.contactPerson = new HashMap();
        }
        if (!fSContactPerson.getCPID().startsWith("ContactPerson")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("ContactPerson id should startwith ContactPerson.");
            }
            return false;
        }
        Set set = this.contactPerson.keySet();
        String string = null;
        try {
            string = fSContactPerson.getCPID().substring(this.beginIndex);
        }
        catch (NumberFormatException numberFormatException) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("addContactPerson: NumberFormatException" + numberFormatException.getMessage());
            }
            return false;
        }
        if (set != null && !set.isEmpty() && set.contains(string)) {
            if (bl) {
                this.contactPerson.remove(string);
            } else {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("ContactPerson existed. SuggestcpId=ContactPerson" + new Integer(++this.cpMaxNum).toString());
                }
                return false;
            }
        }
        this.contactPerson.put(string, fSContactPerson);
        if (Integer.parseInt(string) > this.cpMaxNum) {
            this.cpMaxNum = Integer.parseInt(string);
        }
        return true;
    }

    public void setAdditionalMetaLocation(Set set) {
        this.addMetaLocn = set;
    }

    public boolean setContactPerson(List list) {
        return this.setContactPerson(list, true);
    }

    public boolean setContactPerson(List list, boolean bl) {
        boolean bl2 = false;
        if (list != null && !list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                if (!this.addContactPerson((FSContactPerson)list.get(n), bl)) {
                    return false;
                }
                ++n;
            }
        } else {
            this.contactPerson = null;
        }
        return true;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setSignCertAlias(String string) {
        this.signCertAlias = string;
    }

    public void setValidUntil(String string) {
        this.validUtil = string;
    }

    public void setCacheDuration(String string) {
        this.cacheDuration = string;
    }

    public void setProtocolSuppEnum(String string) {
        this.setProtocolSuppEnum(string, true);
    }

    public void setProtocolSuppEnum(String string, boolean bl) {
        if (this.protSuppEnum == null) {
            this.protSuppEnum = new HashSet();
        }
        if (this.isValidProtocolSuppEnum(string)) {
            this.protSuppEnum.add(string);
        } else if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Invalid input: protocol support enum.");
        }
        if (bl) {
            this.preferProtSuppEnum = string;
        }
    }

    private boolean isValidProtocolSuppEnum(String string) {
        return string != null && string.equalsIgnoreCase("urn:liberty:iff:2002-12") || string.equalsIgnoreCase("urn:liberty:iff:2003-08");
    }

    public void setSLOServiceReturnURL(String string) {
        this.SLOServiceReturnURL = string;
    }

    public void setNameRegistrationProfile(Set set) {
        this.nameRegistrationProfile = set;
    }

    public void setNameRegistrationProfile(String string) {
        if (this.nameRegistrationProfile == null) {
            this.nameRegistrationProfile = new HashSet();
        }
        if (!this.nameRegistrationProfile.isEmpty()) {
            this.nameRegistrationProfile.clear();
        }
        this.nameRegistrationProfile.add(string);
    }

    public void setNameRegistrationURL(String string) {
        this.nameRegistrationURL = string;
    }

    public void setNameRegistrationReturnURL(String string) {
        this.nameRegistrationReturnURL = string;
    }

    public void setSOAPEndPoint(String string) {
        this.SOAPEndPoint = string;
    }

    public void setFederationTerminationServiceURL(String string) {
        this.federationTerminationServiceURL = string;
    }

    public void setFederationTerminationServiceReturnURL(String string) {
        this.federationTerminationServiceReturnURL = string;
    }

    public void setAssertionConsumerServiceURL(String string) {
        this.assertionConsumerServiceURL = string;
    }

    public void setAssertionConsumerServiceURLId(String string) {
        this.assertionConsumerServiceURLId = string;
    }

    public void setAssertionConsumerServiceURLIsDefault(boolean bl) {
        this.assertionConsumerServiceURLIsDefault = bl;
    }

    public void setFederationTerminationProtocolProfile(Set set) {
        this.federationTerminationProtocolProfile = set;
    }

    public void setFederationTerminationProtocolProfile(String string) {
        if (this.federationTerminationProtocolProfile == null) {
            this.federationTerminationProtocolProfile = new HashSet();
        }
        if (!this.federationTerminationProtocolProfile.isEmpty()) {
            this.federationTerminationProtocolProfile.clear();
        }
        this.federationTerminationProtocolProfile.add(string);
    }

    public void setSLOProtocolProfile(Set set) {
        this.SLOProtocolProfile = set;
    }

    public void setSLOProtocolProfile(String string) {
        if (this.SLOProtocolProfile == null) {
            this.SLOProtocolProfile = new HashSet();
        }
        if (!this.SLOProtocolProfile.isEmpty()) {
            this.SLOProtocolProfile.clear();
        }
        this.SLOProtocolProfile.add(string);
    }

    public void setAuthnRequestSigned(boolean bl) {
        this.authnRequestSigned = bl;
    }

    public void setNameRegistrationAfterSSO(boolean bl) {
        this.nameRegistrationAfterSSO = bl;
    }

    public void setSSOServiceURL(String string) {
        this.SSOServiceURL = string;
    }

    public void setProviderSuccinctID(String string) {
        this.providerSuccinctID = string;
    }

    Map getAttributes() {
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-name", this.providerName);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-status", this.providerStatus);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-type", this.providerType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-role", this.providerRole);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-provider-succinctid", this.providerSuccinctID);
        if (this.listOfCOTs != null) {
            hashMap.put("iplanet-am-list-of-authenticationdomains", this.listOfCOTs);
        }
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-certificate-alias", this.keyInfo);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerKeyUse", this.keyUse);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerKeySize", this.keySize);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEncryptionMethod", this.encryptMethod);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-soap-end-point", this.SOAPEndPoint);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-service-url", this.SLOServiceURL);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerRelationshipTermNotificationProtocolProfile", this.termNotificationProfile);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerAdditionalMetaLocation", this.addMetaLocn);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerNameIdentifierMappingBinding", this.listOfNameIdMapBinds);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerExtension", this.extension);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerSignatureCertAlias", this.signCertAlias);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerValidUntil", this.validUtil);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerCacheDuration", this.cacheDuration);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProtocolSupportEnum", this.protSuppEnum);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-slo-service-return-url", this.SLOServiceReturnURL);
        FSAllianceManagementUtils.fillEntries(hashMap, "iplanet-am-name-registration-profile", this.nameRegistrationProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-url", this.nameRegistrationURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-return-url", this.nameRegistrationReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-service-url", this.federationTerminationServiceURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-federation-termination-service-return-url", this.federationTerminationServiceReturnURL);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-assertion-consumer-service-url", this.assertionConsumerServiceURL);
        String string = null;
        string = this.assertionConsumerServiceURLIsDefault ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAssertionConsumerServiceUrlisDefault", string);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAssertionConsumerServiceUrlId", this.assertionConsumerServiceURLId);
        FSAllianceManagementUtils.fillEntries(hashMap, "iplanet-am-federation-termination-protocol-profile", this.federationTerminationProtocolProfile);
        FSAllianceManagementUtils.fillEntries(hashMap, "iplanet-am-slo-protocol-profile", this.SLOProtocolProfile);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-sso-service-url", this.SSOServiceURL);
        String string2 = null;
        string2 = this.authnRequestSigned ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-authnrequest-signed", string2);
        String string3 = this.nameRegistrationAfterSSO ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-after-sso", string3);
        String string4 = this.nameRegistrationIndicator ? "true" : "false";
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "iplanet-am-name-registration-indicator", string4);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerIntroductionNotificationProtProfile", this.introNotificationProtocolProfile);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerSingleSignOnProtocolprofile", this.singleSignonProtocolProfile);
        return hashMap;
    }

    public String generateSuccinctID(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            byArray[n] = (byte)cArray[n];
            ++n;
        }
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = null;
        string2 = SAMLUtils.byteArrayToHexString(byArray2);
        return string2;
    }
}

