/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FSOrganization {
    private String orgID = null;
    private Set orgName = null;
    private Set orgDisplayName = null;
    private Set orgURL = null;
    private String extension = "";

    public FSOrganization(String string) throws FSAllianceManagementException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSOrganization::constructor Id is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("contactperson-id-invalid"));
        }
        this.orgID = string;
    }

    FSOrganization(String string, Map map, boolean bl) throws FSAllianceManagementException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSOrganization::constructor Id is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("organization-id-invalid"));
        }
        this.orgID = string;
        if (bl) {
            this.orgName = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerProviderOrgName");
            this.orgDisplayName = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerProviderOrgDisplayName");
            this.orgURL = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerProviderOrgURL");
            this.extension = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerProviderOrgExtension");
        } else {
            this.orgName = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerOrgName");
            this.orgDisplayName = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerOrgDisplayName");
            this.orgURL = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerOrgURL");
            this.extension = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerOrgExtension");
        }
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String string) {
        this.orgID = string;
    }

    public Set getOrgName() {
        return this.orgName;
    }

    public void setOrgName(Set set) {
        if (this.orgName == null) {
            this.orgName = new HashSet();
        }
        this.orgName = set;
    }

    public Set getOrgDisplayName() {
        return this.orgDisplayName;
    }

    public void setOrgDisplayName(Set set) {
        if (this.orgDisplayName == null) {
            this.orgDisplayName = new HashSet();
        }
        this.orgDisplayName = set;
    }

    public Set getOrgURL() {
        return this.orgURL;
    }

    public void setOrgURL(Set set) {
        if (this.orgURL == null) {
            this.orgURL = new HashSet();
        }
        this.orgURL = set;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    Map getAttributes(boolean bl) {
        HashMap hashMap = new HashMap();
        if (bl) {
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderOrgName", this.orgName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderOrgDisplayName", this.orgDisplayName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerProviderOrgURL", this.orgURL);
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerProviderOrgExtension", this.extension);
        } else {
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerOrgName", this.orgName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerOrgDisplayName", this.orgDisplayName);
            FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerOrgURL", this.orgURL);
            FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerOrgExtension", this.extension);
        }
        return hashMap;
    }
}

