/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class FSEntityDescriptor {
    private Map SPDescriptorMap = null;
    private Map IDPDescriptorMap = null;
    private FSAffiliationDescriptor AffiliationDescriptor = null;
    private String Extension = null;
    private FSContactPerson contactPerson = null;
    private FSOrganization organization = null;
    private String validUtil = null;
    private String cacheDuration = null;
    private String entityID = null;
    private String entityStatus = "Active";
    private String providerType = "urn:liberty:iff:provider";
    private String description = null;

    public FSEntityDescriptor(String string, String string2) throws FSAllianceManagementException {
        this.entityID = string;
        this.entityStatus = string2;
    }

    FSEntityDescriptor(String string, Map map) throws FSAllianceManagementException {
        if (string == null) {
            throw new FSAllianceManagementException("alliance_management_entityid_invalid", null);
        }
        this.entityID = string;
        this.validUtil = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityValidUntil");
        this.cacheDuration = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityCacheDuration");
        this.providerType = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityType");
        if (this.providerType == null) {
            this.providerType = "urn:liberty:iff:provider";
        }
        this.description = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityDescription");
    }

    public String getEntityID() {
        return this.entityID;
    }

    public void setEntityID(String string) {
        this.entityID = string;
    }

    public String getEntityDescription() {
        return this.description;
    }

    public void setEntityDescription(String string) {
        this.description = string;
    }

    public void setAffiliationDescriptor(FSAffiliationDescriptor fSAffiliationDescriptor) {
        this.AffiliationDescriptor = fSAffiliationDescriptor;
        this.providerType = "urn:liberty:iff:affiliate";
    }

    public FSAffiliationDescriptor getAffiliationDescriptor() {
        return this.AffiliationDescriptor;
    }

    public void setContactPerson(FSContactPerson fSContactPerson) {
        this.contactPerson = fSContactPerson;
    }

    public FSContactPerson getContactPerson() {
        return this.contactPerson;
    }

    public void setOrganization(FSOrganization fSOrganization) {
        this.organization = fSOrganization;
    }

    public FSOrganization getOrganization() {
        return this.organization;
    }

    public void addIDPDescriptor(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string;
        if (this.IDPDescriptorMap == null) {
            this.IDPDescriptorMap = new HashMap();
        }
        if ((string = fSProviderDescriptor.getProviderID()) != null && this.IDPDescriptorMap.keySet().contains(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Provider " + string + " existed.");
            }
            throw new FSAllianceManagementException("Provider" + string + "existed");
        }
        this.IDPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public void modifyIDPDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        String string;
        if (this.IDPDescriptorMap == null) {
            this.IDPDescriptorMap = new HashMap();
        }
        if ((string = fSProviderDescriptor.getProviderID()) != null && this.IDPDescriptorMap.keySet().contains(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Modify Provider " + string);
            }
            this.IDPDescriptorMap.remove(string);
        }
        this.IDPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public Set getIDPDescriptor() {
        if (this.IDPDescriptorMap != null) {
            return this.IDPDescriptorMap.entrySet();
        }
        return null;
    }

    public Set getIDPDescriptorKey() {
        if (this.IDPDescriptorMap != null) {
            return this.IDPDescriptorMap.keySet();
        }
        return null;
    }

    public void addSPDescriptor(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string;
        if (this.SPDescriptorMap == null) {
            this.SPDescriptorMap = new HashMap();
        }
        if ((string = fSProviderDescriptor.getProviderID()) != null && this.SPDescriptorMap.keySet().contains(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Provider " + string + " existed.");
            }
            throw new FSAllianceManagementException("Provider " + string + " existed.");
        }
        this.SPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public void modifySPDescriptor(FSProviderDescriptor fSProviderDescriptor) {
        String string;
        if (this.SPDescriptorMap == null) {
            this.SPDescriptorMap = new HashMap();
        }
        if ((string = fSProviderDescriptor.getProviderID()) != null && this.SPDescriptorMap.keySet().contains(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("Modify provider " + string);
            }
            this.SPDescriptorMap.remove(string);
        }
        this.SPDescriptorMap.put(string, fSProviderDescriptor);
    }

    public Set getSPDescriptor() {
        if (this.SPDescriptorMap != null) {
            return this.SPDescriptorMap.entrySet();
        }
        return null;
    }

    public Set getSPDescriptorKey() {
        if (this.SPDescriptorMap != null) {
            return this.SPDescriptorMap.keySet();
        }
        return null;
    }

    public String getValidUntil() {
        return this.validUtil;
    }

    public void setValidUntil(String string) {
        this.validUtil = string;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public void setCacheDuration(String string) {
        this.cacheDuration = string;
    }

    public String getType() {
        return this.providerType;
    }

    public void setType(String string) {
        this.providerType = string;
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityValidUntil", this.validUtil);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityCacheDuration", this.cacheDuration);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityType", this.providerType);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerEntityDescription", this.description);
        return hashMap;
    }
}

