/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.security.AccessController;
import java.security.Principal;
import java.util.Hashtable;

public class FSCache
implements ServiceListener {
    private static FSCache fsCache = new FSCache();
    private static Hashtable fsProviderTable = new Hashtable();
    private static Hashtable fsAffiliationTable = new Hashtable();
    private static ServiceConfigManager scm;
    private static SSOToken token;
    private static SSOToken ssoAuthSession;

    public static FSProviderDescriptor getProviderDescriptor(String string) {
        return (FSProviderDescriptor)fsProviderTable.get(string);
    }

    public static FSProviderDescriptor setProviderDescriptor(FSProviderDescriptor fSProviderDescriptor) throws NullPointerException, FSAllianceManagementException {
        if (fSProviderDescriptor == null) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullInput"));
        }
        String string = fSProviderDescriptor.getProviderID();
        if (string == null || string.equals("")) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullProviderID"));
        }
        return fsProviderTable.put(string, fSProviderDescriptor);
    }

    public static FSAffiliationDescriptor getAffiliationDescriptor(String string) {
        return (FSAffiliationDescriptor)fsAffiliationTable.get(string);
    }

    public static FSAffiliationDescriptor setAffiliationDescriptor(FSAffiliationDescriptor fSAffiliationDescriptor) throws NullPointerException, FSAllianceManagementException {
        if (fSAffiliationDescriptor == null) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullInput"));
        }
        String string = fSAffiliationDescriptor.getAffiliationID();
        if (string == null || string.equals("")) {
            throw new FSAllianceManagementException(FSUtils.bundle.getString("nullAffiliationID"));
        }
        return fsAffiliationTable.put(string, fSAffiliationDescriptor);
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        FSUtils.debug.message("FSCache: OrgConfigChanged.");
        this.clearProviderTable();
    }

    public void schemaChanged(String string, String string2) {
        FSUtils.debug.message("FSCache: schemaChanged.");
        this.clearProviderTable();
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        FSUtils.debug.message("FSCache: globalConfigChanged.");
        this.clearProviderTable();
    }

    private void clearProviderTable() {
        if (fsProviderTable != null && !fsProviderTable.isEmpty()) {
            fsProviderTable.clear();
        }
        if (fsAffiliationTable != null && !fsAffiliationTable.isEmpty()) {
            fsAffiliationTable.clear();
        }
    }

    private static SSOToken getSSOToken() throws SSOException, SessionException {
        if (ssoAuthSession == null) {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            String string = (String)AccessController.doPrivileged(new AdminDNAction());
            String string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
            try {
                ssoAuthSession = sSOTokenManager.createSSOToken((Principal)new AuthPrincipal(string), string2);
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSCache:SSOException : ", (Throwable)sSOException);
                throw new SessionException(sSOException.getMessage());
            }
        }
        return ssoAuthSession;
    }

    static {
        ssoAuthSession = null;
        try {
            token = FSCache.getSSOToken();
            scm = new ServiceConfigManager(token, "iPlanetAMProviderConfigService", "1.1");
            scm.addListener(fsCache);
        }
        catch (Exception exception) {
            FSUtils.debug.error(FSUtils.bundle.getString("can_not_create_provider_cache"), (Throwable)exception);
        }
    }
}

