/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAffiliationDescriptor;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSCache;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSContactPerson;
import com.sun.identity.federation.alliance.FSEntityDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSIDPAuthenticationContextInfo;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSOrganization;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;
import netscape.ldap.util.RDN;

public final class FSAllianceManager {
    private String orgDN = null;
    private SSOToken token = null;
    private ServiceConfigManager providerManager = null;
    private ServiceConfigManager authDomainManager = null;
    private ServiceConfig authDomainConfig = null;
    private ServiceConfig entityConfig = null;
    private ServiceConfig contactConfig = null;
    private ServiceConfig orgConfig = null;
    private boolean messageEnabled = false;
    private Map idMapEntityID = null;
    private static boolean cacheOn = true;

    public FSAllianceManager(SSOToken sSOToken) throws FSAllianceManagementException {
        this(sSOToken, SystemProperties.get((String)"com.iplanet.am.defaultOrg"));
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::Constructor with ssoToken only");
        }
    }

    public FSAllianceManager(SSOToken sSOToken, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::Constructor orgDN invalid");
            throw new FSAllianceManagementException("alliance_management_org_exception", null);
        }
        if (sSOToken == null) {
            FSUtils.debug.error("FSAllianceManager::Constructor ssoToken is null");
            throw new FSAllianceManagementException("alliance_management_sso_exception", null);
        }
        this.token = sSOToken;
        this.messageEnabled = FSUtils.debug.messageEnabled();
        try {
            this.authDomainManager = new ServiceConfigManager(this.token, "iPlanetAMAuthenticationDomainConfigService", "1.0");
            if (this.authDomainManager == null || (this.authDomainConfig = this.authDomainManager.getOrganizationConfig(string, null)) == null) {
                FSUtils.debug.error("FSAllianceManager::Constructor Service Configuration not done properly for iPlanetAMAuthenticationDomainConfigServiceservice");
                throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::Constructor Finished AuthDomainConfig");
            }
            this.providerManager = new ServiceConfigManager(this.token, "iPlanetAMProviderConfigService", "1.1");
            this.entityConfig = this.providerManager.getOrganizationConfig(string, null);
            if (this.providerManager != null && this.entityConfig == null) {
                this.providerManager.createOrganizationConfig(string, null);
            }
            if (this.providerManager == null || (this.entityConfig = this.providerManager.getOrganizationConfig(string, null)) == null) {
                FSUtils.debug.error("FSAllianceManager::Constructor Service Configuration not done properly for iPlanetAMProviderConfigServiceService");
                throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::Constructor Finished entityConfig");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::Constructor SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::Constructor SSOException ", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_service_initiation_exception", null);
        }
    }

    public void createCircleOfTrust(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) throws FSInvalidNameException, FSAllianceManagementException {
        String string = null;
        if (fSCircleOfTrustDescriptor == null || (string = fSCircleOfTrustDescriptor.getCircleOfTrustName()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Name in the given COT descriptor: " + string + " is invalid");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        if (this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrustExists");
            throw new FSAllianceManagementException("alliance_management_authdomain_exists", null);
        }
        Object var3_3 = null;
        Map map = fSCircleOfTrustDescriptor.getAttributes();
        try {
            this.authDomainConfig.addSubConfig(string, "AuthenticationDomain", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createCircleOfTrust created " + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("COT_Created") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Couldn't add subconfig for AuthenticationDomainCreation", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createCircleOfTrust Couldn't add subconfig for AuthenticationDomainCreation", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_creation_exception", null);
        }
    }

    public void deleteCircleOfTrust(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust Name is null or such COT does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            this.authDomainConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteCircleOfTrust deleted " + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("COT_Deleted") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust SMSException while deleting", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_deletion_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteCircleOfTrust SSOException while deleting", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_deletion_exception", null);
        }
    }

    public void modifyCircleOfTrust(FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        String string;
        if (fSCircleOfTrustDescriptor == null || (string = fSCircleOfTrustDescriptor.getCircleOfTrustName()) == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::modifyCircleOfTrust Name in the given COT descriptor is nullor such a COT does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            ServiceConfig serviceConfig = this.authDomainConfig.getSubConfig(string);
            serviceConfig.setAttributes(fSCircleOfTrustDescriptor.getAttributes());
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::modifyCircleOfTrust modified " + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("COT_Modified") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::modifyCircleOfTrust SMSException while modifying", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_modification_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyCircleOfTrust SSOException while modifying", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_modification_exception", null);
        }
    }

    public FSCircleOfTrustDescriptor getCircleOfTrust(String string) throws FSAllianceManagementException, FSInvalidNameException {
        ServiceConfig serviceConfig = null;
        if (string == null || string.length() <= 0 || !this.getAllCirclesOfTrust().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::getCircleOfTrust Name of COT is null or this does not exist");
            throw new FSInvalidNameException("alliance_management_cotname_invalid", null);
        }
        try {
            serviceConfig = this.authDomainConfig.getSubConfig(string);
            return new FSCircleOfTrustDescriptor(string, serviceConfig.getAttributes());
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCircleOfTrust SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getCircleOfTrust SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllCirclesOfTrust(String string) throws FSAllianceManagementException {
        Object var3_2 = null;
        try {
            Set set = string.equals("*") ? this.authDomainConfig.getSubConfigNames() : this.authDomainConfig.getSubConfigNames(string);
            return set;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCirclesOfTrust could not get CirclesOfTrust got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllActiveCirclesOfTrust() throws FSAllianceManagementException {
        Set set = new HashSet();
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        try {
            set = this.authDomainConfig.getSubConfigNames();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    Map map = this.authDomainConfig.getSubConfig(string).getAttributes();
                    if (!FSAllianceManagementUtils.getFirstEntry(map, "iplanet-am-authenticationdomain-status").equalsIgnoreCase("active")) continue;
                    hashSet.add(string);
                }
            }
            return hashSet;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCirclesOfTrust couldn't get COT got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getCirclesOfTrust couldn't get COT got SSSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_authdomain_retrieval_exception", null);
        }
    }

    public Set getAllCirclesOfTrust() throws FSAllianceManagementException {
        return this.getAllCirclesOfTrust("*");
    }

    public void deleteCirclesOfTrust(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.deleteCircleOfTrust((String)iterator.next());
        }
    }

    public void createProvider(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        ServiceConfig serviceConfig = null;
        if (fSProviderDescriptor == null) {
            throw new FSAllianceManagementException("Null input");
        }
        String string = fSProviderDescriptor.getProviderID();
        if (string == null) {
            throw new FSAllianceManagementException("Provider id is null.");
        }
        try {
            if (this.getAllEntityIds().contains(string)) {
                serviceConfig = this.entityConfig.getSubConfig(string);
            } else {
                this.entityConfig.addSubConfig(string, "EntityDescriptor", 0, null);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Dummy Entity Node created");
                }
                serviceConfig = this.entityConfig.getSubConfig(string);
            }
            this.createProvider(serviceConfig, fSProviderDescriptor);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_creation_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_creation_exception"));
        }
    }

    public void createProvider(ServiceConfig serviceConfig, FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException {
        String string = null;
        if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createProvider  ID in the given ProviderDescriptor is null");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        if (this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::createProvider Provider already exists");
            throw new FSAllianceManagementException("alliance_management_provider_exists", null);
        }
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::createProvider valid provider ID");
        }
        Map map = fSProviderDescriptor.getAttributes();
        ServiceConfig serviceConfig2 = null;
        try {
            Object object;
            Object object2;
            Object object3;
            Set set = fSProviderDescriptor.getListOfCOTs();
            if (!this.isValidCOTList(set)) {
                FSUtils.debug.error("FSAllianceManager.java:: createProvider ListOfCOTs invalid");
                throw new FSAllianceManagementException("cotlist_invalid", null);
            }
            if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSProviderDescriptor")) {
                map = fSProviderDescriptor.getAttributes();
                serviceConfig.addSubConfig(string, "Provider", 0, map);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Remote Provider Node created");
                }
                FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("RemoteProvider_Created") + string);
            } else if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
                fSProviderDescriptor.setProviderType("hosted");
                map = fSProviderDescriptor.getAttributes();
                serviceConfig.addSubConfig(string, "Provider", 0, map);
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider Created Hosted Provider General attrs nodeabout to set LocalConfiguration");
                }
                serviceConfig2 = serviceConfig.getSubConfig(string);
                object3 = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration();
                if (object3 != null) {
                    Object object4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    if (((FSLocalConfigurationDescriptor)object3).getIsPassive() && ((FSLocalConfigurationDescriptor)object3).getForceAuthentication()) {
                        FSUtils.debug.error("FSAllianceManager.java:: createProvider LocalConfig Invalid");
                        throw new FSAllianceManagementException("localconfig_invalid", null);
                    }
                    object2 = ((FSLocalConfigurationDescriptor)object3).getTrustedProviders();
                    if (!this.isValidProviderList(set, (Set)object2)) {
                        serviceConfig.removeSubConfig(string);
                        FSUtils.debug.error("FSAllianceManager.java:: createProvider trusted provider list invalid");
                        throw new FSAllianceManagementException("trustedproviderlist_invalid", null);
                    }
                    serviceConfig2.addSubConfig("LocalConfiguration", "LocalConfiguration", 0, ((FSLocalConfigurationDescriptor)object3).getAttributes());
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::createProvider Finished setting LocalConfig");
                    }
                    FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("HostedProvider_Created") + string);
                    object = serviceConfig2.getSubConfig("LocalConfiguration");
                    Map map2 = ((FSLocalConfigurationDescriptor)object3).getSPAuthContextInfo();
                    if (map2 != null) {
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProvider SPAuthInfo is not null");
                        }
                        ((ServiceConfig)object).addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                        object8 = ((ServiceConfig)object).getSubConfig("SPAuthenticationContextInfo");
                        object7 = map2.keySet();
                        object6 = object7.iterator();
                        while (object6.hasNext()) {
                            object5 = (FSSPAuthenticationContextInfo)map2.get((String)object6.next());
                            if (object5 == null || (object4 = ((FSSPAuthenticationContextInfo)object5).getAuthenticationContext()) == null || ((String)object4).length() <= 0) continue;
                            ((ServiceConfig)object8).addSubConfig((String)object4, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object5).getAttributes());
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProvider finished SPAuth information saved in DS");
                        }
                    }
                    if ((object8 = ((FSLocalConfigurationDescriptor)object3).getIDPAuthContextInfo()) != null) {
                        ((ServiceConfig)object).addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                        object7 = ((ServiceConfig)object).getSubConfig("IDPAuthenticationContextInfo");
                        object6 = object8.keySet();
                        object5 = object6.iterator();
                        while (object5.hasNext()) {
                            String string2;
                            object4 = (FSIDPAuthenticationContextInfo)object8.get((String)object5.next());
                            if (object4 == null || (string2 = ((FSIDPAuthenticationContextInfo)object4).getAuthenticationContext()) == null || string2.length() <= 0) continue;
                            ((ServiceConfig)object7).addSubConfig(string2, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object4).getAttributes());
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager::createProviderfinished IDPAuth information");
                        }
                    }
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::createProvider createdHostedProvider");
                    }
                }
            }
            if (serviceConfig2 == null) {
                serviceConfig2 = serviceConfig.getSubConfig(string);
            }
            if ((object3 = fSProviderDescriptor.getContactPerson()) == null) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createProvider provide contact person is null");
                }
            } else {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (FSContactPerson)((Map.Entry)object2.next()).getValue();
                    if (object == null) continue;
                    this.createContactPerson(serviceConfig2, (FSContactPerson)object, true);
                }
            }
            if ((object2 = fSProviderDescriptor.getOrganization()) != null) {
                this.createOrganization(serviceConfig2, (FSOrganization)object2, true);
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_creation_exception", null);
        }
    }

    private ServiceConfig getEntityConfig(String string) {
        try {
            Set set = this.entityConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                return null;
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            while (iterator.hasNext()) {
                Set set2;
                serviceConfig = this.entityConfig.getSubConfig((String)iterator.next());
                if (serviceConfig == null || (set2 = serviceConfig.getSubConfigNames()) == null || set2.isEmpty() || !set2.contains(string)) continue;
                return serviceConfig;
            }
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAllianceManager::getEntityConfig couldn't get EntityConfig", (Throwable)exception);
            return null;
        }
    }

    private String getContainerEntityId(String string) {
        try {
            Set set = this.entityConfig.getSubConfigNames();
            String string2 = null;
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                return null;
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            while (iterator.hasNext()) {
                Set set2;
                string2 = (String)iterator.next();
                serviceConfig = this.entityConfig.getSubConfig(string2);
                if (serviceConfig == null || (set2 = serviceConfig.getSubConfigNames()) == null || set2.isEmpty() || !set2.contains(string)) continue;
                return string2;
            }
            return null;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAllianceManager::getContainerEntityId couldn't get EntityId", (Throwable)exception);
            return null;
        }
    }

    public FSEntityDescriptor getParentEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        String string2 = this.getContainerEntityId(string);
        if (string2 != null) {
            return this.getEntity(string2);
        }
        throw new FSAllianceManagementException("getParentEntity: No entity found!");
    }

    public Set getAffiliateEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        HashSet<FSAffiliationDescriptor> hashSet = null;
        try {
            Set set = this.entityConfig.getSubConfigNames();
            String string2 = null;
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                throw new FSAllianceManagementException("getAffiliateEntity: No entity found.");
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            FSEntityDescriptor fSEntityDescriptor = null;
            FSAffiliationDescriptor fSAffiliationDescriptor = null;
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                serviceConfig = this.entityConfig.getSubConfig(string2);
                if (serviceConfig == null) continue;
                fSEntityDescriptor = this.getEntity(string2);
                if (fSEntityDescriptor.getType().equalsIgnoreCase("urn:liberty:iff:affiliate")) {
                    fSAffiliationDescriptor = fSEntityDescriptor.getAffiliationDescriptor();
                }
                if (fSAffiliationDescriptor == null || !fSAffiliationDescriptor.getAffiliationMember().contains(string)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<FSAffiliationDescriptor>();
                }
                hashSet.add(fSAffiliationDescriptor);
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliateEntity ", (Throwable)sSOException);
            throw new FSAllianceManagementException(sSOException.getMessage());
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliateEntity ", (Throwable)sMSException);
            throw new FSAllianceManagementException(sMSException.getMessage());
        }
    }

    public void deleteProviderContactPerson(String string, String string2) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = this.getEntityConfig(string);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null && serviceConfig2.getSubConfigNames().contains(string2)) {
                serviceConfig2.removeSubConfig(string2);
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityContactPerson could not delete contact got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("contactperson-deletion-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityContactPerson could not delete contact got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("contactperson-deletion-exception"));
        }
    }

    public void deleteProviderOrganization(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = this.getEntityConfig(string);
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null && serviceConfig2.getSubConfigNames().contains("Organization")) {
                serviceConfig2.removeSubConfig("Organization");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteProviderOrganization could not delete org got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("org-deletion-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteProviderOrganization could not delete org got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("org-deletion-exception"));
        }
    }

    public void deleteProvider(String string) throws FSAllianceManagementException {
        ServiceConfig serviceConfig = this.getEntityConfig(string);
        if (serviceConfig != null) {
            this.deleteProvider(serviceConfig, string);
        } else if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("deletProvider:getEntityConfig is null.");
        }
    }

    public void deleteAffiliationDescriptor(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::deleteAffiliationDescriptoraffID " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("affiliation-id-invalid"));
        }
        try {
            serviceConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteAffiliationDescriptor deleted" + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("Affiliation_Deleted") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteAffiliationDescriptor could not delete affiliation got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-deletion-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteAffiliationDescriptorcould not delete affiliation got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-deletion-exception"));
        }
    }

    public void deleteProvider(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider providerID " + string + "is invalid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            serviceConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteProvider deleted" + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("Provider_Deleted") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider could not delete provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteProvider could not delete provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_deletion_exception", null);
        }
    }

    public FSProviderDescriptor getProvider(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            FSProviderDescriptor fSProviderDescriptor = null;
            if (cacheOn && (fSProviderDescriptor = FSCache.getProviderDescriptor(string)) != null) {
                return fSProviderDescriptor;
            }
            Set set = this.entityConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                throw new FSAllianceManagementException("getProvider(providerid): No entity found");
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            Map map = null;
            String string2 = null;
            while (iterator.hasNext()) {
                serviceConfig = this.entityConfig.getSubConfig((String)iterator.next());
                if (serviceConfig != null) {
                    map = serviceConfig.getAttributes();
                }
                if (map == null || map.isEmpty() || (string2 = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityType")) == null || !string2.equalsIgnoreCase("urn:liberty:iff:provider")) continue;
                Set set2 = serviceConfig.getSubConfigNames();
                if (set2 == null || set2.isEmpty()) {
                    if (!FSUtils.debug.messageEnabled()) continue;
                    FSUtils.debug.message("This entity does not contain any sub element.");
                    continue;
                }
                if (!set2.contains(string)) continue;
                fSProviderDescriptor = this.getProvider(serviceConfig, string);
                if (cacheOn) {
                    FSProviderDescriptor fSProviderDescriptor2 = FSCache.setProviderDescriptor(fSProviderDescriptor);
                }
                return fSProviderDescriptor;
            }
            return null;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getProvider  couldn't get provider SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_retrieval_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getProvider couldn't get provider SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_retrieval_exception"));
        }
    }

    private FSProviderDescriptor getProvider(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::getProvider providerID: " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_providerid_invalid"));
        }
        try {
            Object object;
            Object object2;
            Object object3;
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            FSProviderDescriptor fSProviderDescriptor = new FSProviderDescriptor(string, map);
            String string2 = fSProviderDescriptor.getProviderType();
            if (string2.equalsIgnoreCase("remote")) {
                Set set = serviceConfig2.getSubConfigNames();
                if (set == null || set.isEmpty()) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("provider does not contain sub element");
                    }
                } else {
                    Iterator iterator = set.iterator();
                    String string3 = null;
                    while (iterator.hasNext()) {
                        Object object4;
                        string3 = (String)iterator.next();
                        if (FSUtils.debug.messageEnabled()) {
                            FSUtils.debug.message("id =" + string3);
                        }
                        if (string3.startsWith("ContactPerson")) {
                            object4 = this.getContactPerson(serviceConfig2, string3, true);
                            fSProviderDescriptor.addContactPerson((FSContactPerson)object4, false);
                            continue;
                        }
                        if (string3.startsWith("Organization")) {
                            object4 = this.getOrganization(serviceConfig2, string3, true);
                            fSProviderDescriptor.setOrganization((FSOrganization)object4);
                            continue;
                        }
                        FSUtils.debug.error("do not support");
                    }
                }
                return fSProviderDescriptor;
            }
            FSHostedProviderDescriptor fSHostedProviderDescriptor = new FSHostedProviderDescriptor(string, map);
            Set set = serviceConfig2.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("provider does not contain sub element");
            } else {
                object3 = set.iterator();
                object2 = null;
                while (object3.hasNext()) {
                    object2 = (String)object3.next();
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("id =" + (String)object2);
                    }
                    if (object2 != null && ((String)object2).startsWith("ContactPerson")) {
                        object = this.getContactPerson(serviceConfig2, (String)object2, true);
                        fSHostedProviderDescriptor.addContactPerson((FSContactPerson)object, false);
                        continue;
                    }
                    if (object2 == null || !((String)object2).startsWith("Organization")) continue;
                    object = this.getOrganization(serviceConfig2, (String)object2, true);
                    fSHostedProviderDescriptor.setOrganization((FSOrganization)object);
                }
            }
            object3 = serviceConfig2.getSubConfig("LocalConfiguration");
            if (object3 == null) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::getProvider No LocalConfig for hostedProvider");
                }
                return fSHostedProviderDescriptor;
            }
            object2 = ((ServiceConfig)object3).getAttributes();
            object = new FSLocalConfigurationDescriptor((ServiceConfig)object3, (Map)object2);
            try {
                Set set2 = this.getAuthDomainURLList(((FSLocalConfigurationDescriptor)object).getAssociatedOrgDN());
                ((FSLocalConfigurationDescriptor)object).setAuthDomainURLList(set2);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSAllianceManager.java::getProvider AuthDomainURLs not read ");
            }
            fSHostedProviderDescriptor.setLocalConfiguration((FSLocalConfigurationDescriptor)object);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::getProvider finished setting Local Config");
            }
            return fSHostedProviderDescriptor;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getProvider  couldn't get provider SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getProvider couldn't get provider SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    private ServiceConfig getEntityServiceConfig(String string) throws FSAllianceManagementException {
        try {
            if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
                FSUtils.debug.error("FSAllianceManager::getEntityServiceConfig entityID " + string + "is invalid");
                throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_entityid_invalid"));
            }
            return this.entityConfig.getSubConfig(string);
        }
        catch (Exception exception) {
            throw new FSAllianceManagementException(exception.getMessage());
        }
    }

    public void deleteEntityContactPerson(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = null;
            serviceConfig = this.getEntityServiceConfig(string);
            if (serviceConfig != null && serviceConfig.getSubConfigNames().contains("ContactPerson1")) {
                serviceConfig.removeSubConfig("ContactPerson1");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityContactPerson could not delete contact got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("contactperson-deletion-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityContactPerson could not delete contact got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("contactperson-deletion-exception"));
        }
    }

    public void deleteEntityOrganization(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            ServiceConfig serviceConfig = null;
            serviceConfig = this.getEntityServiceConfig(string);
            if (serviceConfig != null && serviceConfig.getSubConfigNames().contains("Organization")) {
                serviceConfig.removeSubConfig("Organization");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityOrganization could not delete org got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("org-deletion-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntityOrganization could not delete org got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("org-deletion-exception"));
        }
    }

    public void deleteEntity(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        if (set == null || set.isEmpty()) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity entityID is empty set.");
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_invalid_input_exception"));
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.deleteEntity((String)iterator.next());
        }
    }

    public void deleteEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity entityID " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_entityid_invalid"));
        }
        try {
            this.entityConfig.removeSubConfig(string);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::deleteEntity deleted" + string);
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("Entity_Deleted") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity could not delete entity got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("entity-deletion-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::deleteEntity could not delete entity got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("entity-deletion-exception"));
        }
    }

    public FSEntityDescriptor getEntity(String string) throws FSAllianceManagementException, FSInvalidNameException {
        if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::getEntity entityID: " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_providerid_invalid"));
        }
        try {
            ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string);
            Map map = serviceConfig.getAttributes();
            FSEntityDescriptor fSEntityDescriptor = new FSEntityDescriptor(string, map);
            Set set = serviceConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("enitity does not contain sub element");
                }
            } else {
                Iterator iterator = set.iterator();
                String string2 = null;
                while (iterator.hasNext()) {
                    Object object;
                    string2 = (String)iterator.next();
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("id =" + string2);
                    }
                    if (string2 != null && string2.startsWith("ContactPerson")) {
                        object = this.getContactPerson(serviceConfig, string2, false);
                        fSEntityDescriptor.setContactPerson((FSContactPerson)object);
                        continue;
                    }
                    if (string2 != null && string2.startsWith("Organization")) {
                        object = this.getOrganization(serviceConfig, string2, false);
                        fSEntityDescriptor.setOrganization((FSOrganization)object);
                        continue;
                    }
                    if (fSEntityDescriptor.getType().equals("urn:liberty:iff:affiliate")) {
                        object = this.getAffiliationDescriptor(serviceConfig, string2);
                        fSEntityDescriptor.setAffiliationDescriptor((FSAffiliationDescriptor)object);
                        continue;
                    }
                    object = this.getProvider(serviceConfig, string2);
                    String string3 = ((FSProviderDescriptor)object).getProviderRole();
                    if (string3.equalsIgnoreCase("sp")) {
                        fSEntityDescriptor.addSPDescriptor((FSProviderDescriptor)object);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("idp")) {
                        fSEntityDescriptor.addIDPDescriptor((FSProviderDescriptor)object);
                        continue;
                    }
                    FSUtils.debug.error("No support role ");
                }
            }
            return fSEntityDescriptor;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getEntity  couldn't get entity SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_entity_retrieval_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getEntity couldn't get entity SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_entity_retrieval_exception"));
        }
    }

    public void modifyProvider(FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        ServiceConfig serviceConfig = this.getEntityConfig(fSProviderDescriptor.getProviderID());
        this.modifyProvider(serviceConfig, fSProviderDescriptor);
    }

    public void modifyEntity(FSEntityDescriptor fSEntityDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        block32: {
            if (fSEntityDescriptor == null) {
                FSUtils.debug.error("FSAllianceManager::ModifyEntity entityrDescriptor not valid");
                throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_entityid_invalid"));
            }
            String string = fSEntityDescriptor.getEntityID();
            if (string == null || string.length() <= 0 || !this.getAllEntityIds().contains(string)) {
                FSUtils.debug.error("FSAllianceManager::ModifyEntity entityID :" + string + "not valid");
                throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_entityid_invalid"));
            }
            try {
                ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string);
                if (serviceConfig != null) {
                    Object object;
                    FSOrganization fSOrganization;
                    Map map = fSEntityDescriptor.getAttributes();
                    Map map2 = serviceConfig.getAttributes();
                    if (!map2.equals(map)) {
                        serviceConfig.setAttributes(map);
                    }
                    if (this.messageEnabled) {
                        FSUtils.debug.message("FSAllianceManager::ModifyEntity set general attributes");
                    }
                    Set set = serviceConfig.getSubConfigNames();
                    HashSet<String> hashSet = new HashSet<String>();
                    ServiceConfig serviceConfig2 = null;
                    FSContactPerson fSContactPerson = fSEntityDescriptor.getContactPerson();
                    if (fSContactPerson != null) {
                        map = fSContactPerson.getAttributes(false);
                        serviceConfig2 = serviceConfig.getSubConfig(fSContactPerson.getCPID());
                        if (serviceConfig2 != null) {
                            map2 = serviceConfig2.getAttributes();
                            if (!map2.equals(map)) {
                                serviceConfig2.setAttributes(map);
                            }
                        } else {
                            this.deleteEntityContactPerson(string);
                            this.createContactPerson(serviceConfig, fSContactPerson, false);
                        }
                        hashSet.add(fSContactPerson.getCPID());
                    }
                    if ((fSOrganization = fSEntityDescriptor.getOrganization()) != null) {
                        map = fSOrganization.getAttributes(false);
                        serviceConfig2 = serviceConfig.getSubConfig(fSOrganization.getOrgID());
                        if (serviceConfig2 != null) {
                            map2 = serviceConfig2.getAttributes();
                            if (!map2.equals(map)) {
                                serviceConfig2.setAttributes(map);
                            }
                        } else {
                            this.deleteEntityOrganization(string);
                            this.createOrganization(serviceConfig, fSOrganization, false);
                        }
                        hashSet.add(fSOrganization.getOrgID());
                    }
                    Iterator iterator = null;
                    String string2 = null;
                    Object var13_15 = null;
                    if (fSEntityDescriptor.getType().equalsIgnoreCase("urn:liberty:iff:provider")) {
                        Object object2;
                        object = fSEntityDescriptor.getSPDescriptor();
                        if (object == null || object.isEmpty()) {
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager:modifyEntity sp list is empty");
                            }
                        } else {
                            iterator = object.iterator();
                            while (iterator.hasNext()) {
                                object2 = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                                string2 = ((FSProviderDescriptor)object2).getProviderID();
                                if (set.contains(string2)) {
                                    this.modifyProvider(serviceConfig, (FSProviderDescriptor)object2);
                                } else {
                                    this.createProvider(serviceConfig, (FSProviderDescriptor)object2);
                                }
                                hashSet.add(string2);
                            }
                        }
                        if ((object2 = fSEntityDescriptor.getIDPDescriptor()) == null || object2.isEmpty()) {
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyEntity: idp list is null");
                            }
                        } else {
                            iterator = object2.iterator();
                            hashSet = new HashSet();
                            while (iterator.hasNext()) {
                                FSProviderDescriptor fSProviderDescriptor = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                                string2 = fSProviderDescriptor.getProviderID();
                                if (set.contains(string2)) {
                                    this.modifyProvider(serviceConfig, fSProviderDescriptor);
                                } else {
                                    this.createProvider(serviceConfig, fSProviderDescriptor);
                                }
                                hashSet.add(string2);
                            }
                        }
                    } else {
                        object = fSEntityDescriptor.getAffiliationDescriptor();
                        if (object != null) {
                            this.modifyAffiliationDescriptor(serviceConfig, (FSAffiliationDescriptor)object);
                            hashSet.add(((FSAffiliationDescriptor)object).getAffiliationID());
                        }
                    }
                    iterator = set.iterator();
                    while (iterator.hasNext()) {
                        string2 = (String)iterator.next();
                        if (!set.contains(string2) || hashSet.contains(string2)) continue;
                        serviceConfig.removeSubConfig(string2);
                    }
                    break block32;
                }
                throw new FSAllianceManagementException("No such Entity: " + string);
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAllianceManager::modifyEntity couldn't modify entity SSOException", (Throwable)sSOException);
                throw new FSAllianceManagementException(FSUtils.bundle.getString("entity-modify-exception"));
            }
            catch (SMSException sMSException) {
                FSUtils.debug.error("FSAllianceManager::modifyEntity couldn't modify entity SMSException", (Throwable)sMSException);
                throw new FSAllianceManagementException(FSUtils.bundle.getString("entity-modify-exception"));
            }
        }
    }

    public void modifyAffiliationDescriptor(ServiceConfig serviceConfig, FSAffiliationDescriptor fSAffiliationDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSAffiliationDescriptor == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyAffiliatonDescriptor AffiliationDescriptor not valid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("affiliation-invalid"));
        }
        String string = fSAffiliationDescriptor.getAffiliationID();
        if (string == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyAffiliatonDescriptor AffiliationDescriptor not valid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("affiliation-id-invalid"));
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null) {
                Map map = fSAffiliationDescriptor.getAttributes();
                Map map2 = serviceConfig2.getAttributes();
                if (!map2.equals(map)) {
                    serviceConfig2.setAttributes(map);
                }
            } else {
                this.createAffiliationDescriptor(serviceConfig, fSAffiliationDescriptor);
            }
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyAffiliationDescriptorcouldn't modify affiliation SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-modify-exception"));
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::modifyAffiliationDescriptor couldn't modify affiliation SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-modify-exception"));
        }
    }

    public void modifyProvider(ServiceConfig serviceConfig, FSProviderDescriptor fSProviderDescriptor) throws FSAllianceManagementException, FSInvalidNameException {
        if (fSProviderDescriptor == null) {
            FSUtils.debug.error("FSAllianceManager::ModifyProvider providerDescriptor not valid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        String string = fSProviderDescriptor.getProviderID();
        if (string == null || string.length() <= 0 || !this.getAllProviderIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::ModifyProvider providerID :" + string + "not valid");
            throw new FSInvalidNameException("alliance_management_providerid_invalid", null);
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                Object object7;
                Set set;
                FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
                Map map = fSProviderDescriptor.getAttributes();
                Set set2 = fSProviderDescriptor.getListOfCOTs();
                if (!this.isValidCOTList(set2)) {
                    FSUtils.debug.error("FSAllianceManager.java:: modifyProvider ListOfCOTs invalid");
                    throw new FSAllianceManagementException("cotlist_invalid", null);
                }
                Map map2 = serviceConfig2.getAttributes();
                if (!map2.equals(map)) {
                    serviceConfig2.setAttributes(map);
                }
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::ModifyProvider set general attributes");
                }
                if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor") && (fSLocalConfigurationDescriptor = ((FSHostedProviderDescriptor)fSProviderDescriptor).getLocalConfiguration()) != null) {
                    Object object8;
                    if (fSLocalConfigurationDescriptor.getIsPassive() && fSLocalConfigurationDescriptor.getForceAuthentication()) {
                        FSUtils.debug.error("FSAllianceManager.java:: modifyProvider LocalConfig Invalid");
                        throw new FSAllianceManagementException("localconfig_invalid", null);
                    }
                    set = fSLocalConfigurationDescriptor.getTrustedProviders();
                    if (!this.isValidProviderList(set2, set)) {
                        FSUtils.debug.error("FSAllianceManager.java:: modifyProvider trusted provider list invalid");
                        throw new FSAllianceManagementException("trustedproviderlist_invalid", null);
                    }
                    object7 = serviceConfig2.getSubConfig("LocalConfiguration");
                    map = fSLocalConfigurationDescriptor.getAttributes();
                    if (object7 == null) {
                        serviceConfig2.addSubConfig("LocalConfiguration", "LocalConfiguration", 0, map);
                        object7 = serviceConfig2.getSubConfig("LocalConfiguration");
                        object6 = fSLocalConfigurationDescriptor.getSPAuthContextInfo();
                        if (object6 != null) {
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider SPAuthInfo Not null");
                            }
                            ((ServiceConfig)object7).addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider SPAuthContext Node created ");
                            }
                            object5 = ((ServiceConfig)object7).getSubConfig("SPAuthenticationContextInfo");
                            object4 = object6.keySet();
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                object2 = (FSSPAuthenticationContextInfo)object6.get((String)object3.next());
                                if (object2 == null || (object = ((FSSPAuthenticationContextInfo)object2).getAuthenticationContext()) == null || ((String)object).length() <= 0) continue;
                                ((ServiceConfig)object5).addSubConfig((String)object, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object2).getAttributes());
                            }
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAllianceManager.java::createProvider finished SP Auth information");
                        }
                        if ((object5 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                            ((ServiceConfig)object7).addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider IDPAuthode created");
                            }
                            object4 = ((ServiceConfig)object7).getSubConfig("IDPAuthenticationContextInfo");
                            object3 = object5.keySet();
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                object = (FSIDPAuthenticationContextInfo)object5.get((String)object2.next());
                                if (object == null || (object8 = ((FSIDPAuthenticationContextInfo)object).getAuthenticationContext()) == null || ((String)object8).length() <= 0) continue;
                                ((ServiceConfig)object4).addSubConfig((String)object8, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object).getAttributes());
                            }
                        }
                    } else {
                        map2 = ((ServiceConfig)object7).getAttributes();
                        if (!map2.equals(map)) {
                            ((ServiceConfig)object7).setAttributes(map);
                        }
                        if (this.messageEnabled) {
                            FSUtils.debug.message("FSAlliaceManager::ModifyProvider set LocalConfiguration");
                        }
                        if ((object5 = ((ServiceConfig)object7).getSubConfig("SPAuthenticationContextInfo")) == null) {
                            ((ServiceConfig)object7).addSubConfig("SPAuthenticationContextInfo", "SPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider created Node for SPAuthConfig Info ");
                            }
                            object5 = ((ServiceConfig)object7).getSubConfig("SPAuthenticationContextInfo");
                        }
                        if ((object6 = fSLocalConfigurationDescriptor.getSPAuthContextInfo()) != null) {
                            object4 = object6.keySet();
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                object2 = (FSSPAuthenticationContextInfo)object6.get((String)object3.next());
                                if (object2 == null || (object = ((FSSPAuthenticationContextInfo)object2).getAuthenticationContext()) == null || ((String)object).length() <= 0) continue;
                                object8 = ((ServiceConfig)object5).getSubConfig((String)object);
                                if (object8 != null) {
                                    ((ServiceConfig)object8).setAttributes(((FSSPAuthenticationContextInfo)object2).getAttributes());
                                    continue;
                                }
                                ((ServiceConfig)object5).addSubConfig((String)object, "AuthenticationContext-Level-Mapping", 0, ((FSSPAuthenticationContextInfo)object2).getAttributes());
                            }
                        }
                        if ((object3 = ((ServiceConfig)object7).getSubConfig("IDPAuthenticationContextInfo")) == null) {
                            ((ServiceConfig)object7).addSubConfig("IDPAuthenticationContextInfo", "IDPAuthenticationContextInfo", 0, null);
                            if (this.messageEnabled) {
                                FSUtils.debug.message("FSAllianceManager::modifyProvider createdNode for IDPAuthConfig Info ");
                            }
                            object3 = ((ServiceConfig)object7).getSubConfig("IDPAuthenticationContextInfo");
                        }
                        if ((object4 = fSLocalConfigurationDescriptor.getIDPAuthContextInfo()) != null) {
                            object2 = object4.keySet();
                            object = object2.iterator();
                            while (object.hasNext()) {
                                String string2;
                                object8 = (FSIDPAuthenticationContextInfo)object4.get((String)object.next());
                                if (object8 == null || (string2 = ((FSIDPAuthenticationContextInfo)object8).getAuthenticationContext()) == null || string2.length() <= 0) continue;
                                ServiceConfig serviceConfig3 = ((ServiceConfig)object3).getSubConfig(string2);
                                if (serviceConfig3 != null) {
                                    serviceConfig3.setAttributes(((FSIDPAuthenticationContextInfo)object8).getAttributes());
                                    continue;
                                }
                                ((ServiceConfig)object3).addSubConfig(string2, "AuthenticationContext-Priority-ModuleIndicator-Mapping", 0, ((FSIDPAuthenticationContextInfo)object8).getAttributes());
                            }
                        }
                    }
                }
                set = fSProviderDescriptor.getContactPerson();
                object7 = new HashSet();
                object6 = null;
                object5 = new HashSet();
                if (set != null) {
                    object4 = set.iterator();
                    object3 = null;
                    while (object4.hasNext()) {
                        object3 = (FSContactPerson)((Map.Entry)object4.next()).getValue();
                        map = ((FSContactPerson)object3).getAttributes(true);
                        object6 = serviceConfig2.getSubConfig(((FSContactPerson)object3).getCPID());
                        if (object6 != null) {
                            map2 = ((ServiceConfig)object6).getAttributes();
                            if (!map2.equals(map)) {
                                ((ServiceConfig)object6).setAttributes(map);
                            }
                        } else {
                            this.createContactPerson(serviceConfig2, (FSContactPerson)object3, true);
                        }
                        object7.add(((FSContactPerson)object3).getCPID());
                    }
                }
                if ((object4 = fSProviderDescriptor.getOrganization()) != null) {
                    map = ((FSOrganization)object4).getAttributes(true);
                    object6 = serviceConfig2.getSubConfig(((FSOrganization)object4).getOrgID());
                    if (object6 != null) {
                        map2 = ((ServiceConfig)object6).getAttributes();
                        if (!map2.equals(map)) {
                            ((ServiceConfig)object6).setAttributes(map);
                        }
                    } else {
                        this.createOrganization(serviceConfig2, (FSOrganization)object4, true);
                    }
                    object7.add(((FSOrganization)object4).getOrgID());
                }
                object3 = serviceConfig2.getSubConfigNames();
                object2 = null;
                if (object3 != null) {
                    object = object3.iterator();
                    while (object.hasNext()) {
                        object2 = (String)object.next();
                        if (((String)object2).equalsIgnoreCase("LocalConfiguration") || object7 != null && (!object3.contains(object2) || object7.contains(object2))) continue;
                        serviceConfig.removeSubConfig((String)object2);
                    }
                }
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::modifyPovider Modified provider");
            }
            FSUtils.access("FSAllianceManager", FSUtils.bundle.getString("Provider_Modified") + string);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::modifyProvider SMSException while modifying", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_modification_exception", null);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::modifyProvider SSOException while modifying", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_provider_modification_exception", null);
        }
    }

    public Set getAllEntityIds() throws FSAllianceManagementException {
        return this.getAllEntityIds("*");
    }

    public Set getAllProviderIds() throws FSAllianceManagementException {
        return this.getAllProviderIds("*");
    }

    public Set getAllEntityIds(String string) throws FSAllianceManagementException {
        try {
            Set set = null;
            set = string != null && string.equals("*") ? this.entityConfig.getSubConfigNames() : this.entityConfig.getSubConfigNames(string);
            return set;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAllEntityIds SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_entity_retrieval_exception"));
        }
    }

    public Set getAllProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = null;
        ServiceConfig serviceConfig = null;
        try {
            Set set = this.getAllEntityIds();
            if (set != null) {
                Iterator iterator = set.iterator();
                String string3 = null;
                while (iterator.hasNext()) {
                    Map map;
                    FSEntityDescriptor fSEntityDescriptor;
                    string3 = (String)iterator.next();
                    serviceConfig = this.entityConfig.getSubConfig(string3);
                    if (serviceConfig == null || !(fSEntityDescriptor = new FSEntityDescriptor(string3, map = serviceConfig.getAttributes())).getType().equalsIgnoreCase("urn:liberty:iff:provider")) continue;
                    Set set2 = null;
                    set2 = string != null && string.equals("*") ? serviceConfig.getSubConfigNames() : serviceConfig.getSubConfigNames(string);
                    if (set2 == null || set2.isEmpty()) continue;
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        string2 = (String)iterator2.next();
                        if (string2 == null || string2.startsWith("ContactPerson") || string2.startsWith("Organization")) continue;
                        hashSet.add(string2);
                    }
                }
            }
            return hashSet;
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAllProviderID SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_sso_exception", null);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAllProviderIds SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllActiveProviderIds() throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public Set getAllHostedProviderIds() throws FSAllianceManagementException {
        return this.getAllHostedProviderIds("*");
    }

    public Set getAllHostedProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllProviderIds(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string3);
                    if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderType()) == null || !string2.equalsIgnoreCase("hosted")) continue;
                    hashSet.add(string3);
                }
            }
            return hashSet;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllHostedProviders, SMSException");
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllActiveHostedProviderIds() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllHostedProviderIds();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                    if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                    hashSet.add(string2);
                }
            }
            return hashSet;
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllActiveHostedProviderIds SMSException", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_provider_retrieval_exception", null);
        }
    }

    public Set getAllRemoteProviderIds(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.getAllProviderIds(string);
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    String string3 = (String)iterator.next();
                    FSProviderDescriptor fSProviderDescriptor = this.getProvider(string3);
                    if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderType()) == null || !string2.equalsIgnoreCase("remote")) continue;
                    hashSet.add(string3);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManager::getAllRemoteProviders SMSException", (Throwable)((Object)fSAllianceManagementException));
            throw new FSAllianceManagementException("alliance_management_sms_exception", null, (Throwable)((Object)fSAllianceManagementException));
        }
        return hashSet;
    }

    public Set getAllRemoteProviderIds() throws FSAllianceManagementException {
        return this.getAllRemoteProviderIds("*");
    }

    public Set getAllActiveRemoteProviderIds() throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.getAllRemoteProviderIds();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
                if (fSProviderDescriptor == null || (string = fSProviderDescriptor.getProviderStatus()) == null || !string.equalsIgnoreCase("active")) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public void deleteProviders(Set set) throws FSAllianceManagementException, FSInvalidNameException {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.deleteProvider((String)iterator.next());
            }
        }
    }

    public FSProviderDescriptor getProviderBySuccinctID(String string) throws FSAllianceManagementException {
        Set set = this.getAllProviderIds();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            FSProviderDescriptor fSProviderDescriptor = this.getProvider((String)iterator.next());
            if (fSProviderDescriptor == null || (string2 = fSProviderDescriptor.getProviderSuccinctID()) == null || !string2.equalsIgnoreCase(string)) continue;
            return fSProviderDescriptor;
        }
        throw new FSAllianceManagementException("alliance_management_provider_succinctid_invalid", null);
    }

    public FSHostedProviderDescriptor getHostedProviderByMetaAlias(String string) throws FSAllianceManagementException {
        Set set = this.getAllHostedProviderIds();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2;
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor;
            FSHostedProviderDescriptor fSHostedProviderDescriptor = this.getHostedProvider((String)iterator.next());
            if (fSHostedProviderDescriptor == null || (fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration()) == null || (string2 = fSLocalConfigurationDescriptor.getProviderAlias()) == null || !string2.equalsIgnoreCase(string)) continue;
            return fSHostedProviderDescriptor;
        }
        throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_metaalias_invalid"));
    }

    public FSHostedProviderDescriptor getHostedProvider(String string) throws FSAllianceManagementException {
        FSProviderDescriptor fSProviderDescriptor = this.getProvider(string);
        if (fSProviderDescriptor.getClass().getName().equals("com.sun.identity.federation.alliance.FSHostedProviderDescriptor")) {
            return (FSHostedProviderDescriptor)fSProviderDescriptor;
        }
        FSUtils.debug.error("FSAllianceManager::getHostedProviderDescriptor given provider is not a hosted provider");
        throw new FSAllianceManagementException("alliance_management_providerid_invalid", null);
    }

    Set getAuthDomainURLList(String string) throws FSAllianceManagementException {
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(this.token);
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            Set set = aMOrganization.getAttribute("sunPreferredDomain");
            set.addAll(aMOrganization.getAttribute("associatedDomain"));
            DN dN = new DN(string);
            set.add(((RDN)dN.getRDNs().firstElement()).getValues()[0]);
            return set;
        }
        catch (AMException aMException) {
            FSUtils.debug.error("FSAllianceManager::getURLMappingList AMException while reading", (Throwable)aMException);
            throw new FSAllianceManagementException("alliance_management_sms_exception", null, aMException);
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getURLMappingList SSOException while reading", (Throwable)sSOException);
            throw new FSAllianceManagementException("alliance_management_sso_exception", null, sSOException);
        }
    }

    public Set getProspectiveTrustedProviders(String string) throws FSAllianceManagementException {
        HashSet<String> hashSet = new HashSet<String>();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = this.getHostedProvider(string);
        Set set = fSHostedProviderDescriptor.getListOfCOTs();
        if (set == null) {
            FSUtils.debug.message("FSAllianceManager::getProspectiveTrustedProviders No Prospective provider");
            return hashSet;
        }
        Set set2 = this.getAllProviderIds();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            FSProviderDescriptor fSProviderDescriptor = this.getProvider(string2);
            Set set3 = fSProviderDescriptor.getListOfCOTs();
            if (set3 == null) continue;
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                if (!set3.contains(iterator2.next())) continue;
                hashSet.add(string2);
            }
        }
        hashSet.remove(string);
        return hashSet;
    }

    boolean isValidCOTList(Set set) throws FSAllianceManagementException {
        Set set2 = this.getAllCirclesOfTrust();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (set2.contains(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    boolean isValidProviderList(Set set, Set set2) throws FSAllianceManagementException {
        Set set3 = this.getAllProviderIds();
        if (set2 != null) {
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!set3.contains(string)) continue;
                FSProviderDescriptor fSProviderDescriptor = this.getProvider(string);
                Set set4 = fSProviderDescriptor.getListOfCOTs();
                if (set4 == null || set == null) {
                    return false;
                }
                boolean bl = false;
                Iterator iterator2 = set4.iterator();
                while (iterator2.hasNext()) {
                    if (!set.contains(iterator2.next())) continue;
                    bl = true;
                }
                if (bl) continue;
                return false;
            }
        }
        return true;
    }

    public void createEntityProvider(FSEntityDescriptor fSEntityDescriptor) throws FSAllianceManagementException {
        Object var2_2 = null;
        String string = null;
        if (fSEntityDescriptor == null || (string = fSEntityDescriptor.getEntityID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createEntityProvider  ID in the given EntityDescriptor is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("alliance_management_entityid_invalid"));
        }
        if (this.getAllEntityIds().contains(string)) {
            FSUtils.debug.error("FSAllianceManager::createEntityDescriptor Entity already exists");
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_entity_exists"));
        }
        if (this.messageEnabled) {
            FSUtils.debug.message("FSAllianceManager::createEntityDescriptor valid entity ID");
        }
        try {
            FSOrganization fSOrganization;
            FSContactPerson fSContactPerson;
            Object object;
            Object object2;
            Map map = fSEntityDescriptor.getAttributes();
            this.entityConfig.addSubConfig(string, "EntityDescriptor", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createEntityDescriptor Entity Node created");
            }
            Iterator iterator = null;
            ServiceConfig serviceConfig = this.entityConfig.getSubConfig(string);
            Set set = fSEntityDescriptor.getSPDescriptor();
            if (set == null || set.isEmpty()) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager:createEntityDescriptor sp list is empty");
                }
            } else {
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    object2 = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    this.createProvider(serviceConfig, (FSProviderDescriptor)object2);
                }
            }
            if ((object2 = fSEntityDescriptor.getIDPDescriptor()) == null || object2.isEmpty()) {
                if (this.messageEnabled) {
                    FSUtils.debug.message("FSAllianceManager::createEntityDescriptor idp list is null");
                }
            } else {
                iterator = object2.iterator();
                while (iterator.hasNext()) {
                    object = (FSProviderDescriptor)((Map.Entry)iterator.next()).getValue();
                    this.createProvider(serviceConfig, (FSProviderDescriptor)object);
                }
            }
            if ((object = fSEntityDescriptor.getAffiliationDescriptor()) != null) {
                this.createAffiliationDescriptor(serviceConfig, (FSAffiliationDescriptor)object);
            }
            if ((fSContactPerson = fSEntityDescriptor.getContactPerson()) != null) {
                this.createContactPerson(serviceConfig, fSContactPerson, false);
            }
            if ((fSOrganization = fSEntityDescriptor.getOrganization()) != null) {
                this.createOrganization(serviceConfig, fSOrganization, false);
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_creation_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::createProvider could not create provider got SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_provider_creation_exception"));
        }
    }

    public void createAffiliationDescriptor(ServiceConfig serviceConfig, FSAffiliationDescriptor fSAffiliationDescriptor) throws FSAllianceManagementException {
        String string = null;
        String string2 = null;
        if (fSAffiliationDescriptor == null || (string = fSAffiliationDescriptor.getAffiliationID()) == null || string.length() <= 0 || (string2 = fSAffiliationDescriptor.getAffiliationOwnerID()) == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createaffiliationDescriptor  ID in the given affiliationDescriptor is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("affiliation-id-invalid"));
        }
        Map map = fSAffiliationDescriptor.getAttributes();
        try {
            serviceConfig.addSubConfig(string, "AffiliationDescriptor", 0, map);
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createaffiliationDescriptoraffiliationDescriptor  Node created");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::affiliation SMSException while create affiliation", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_affiliation_creation_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::affiliation SSOException while create affiliation", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_affiliation_creation_exception"));
        }
    }

    public void createContactPerson(ServiceConfig serviceConfig, FSContactPerson fSContactPerson, boolean bl) throws FSAllianceManagementException {
        Object var4_4 = null;
        String string = null;
        if (fSContactPerson == null || (string = fSContactPerson.getCPID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createContactPerson  ID in the given Contact person is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("contactperson-id-invalid"));
        }
        Map map = fSContactPerson.getAttributes(bl);
        try {
            if (bl) {
                serviceConfig.addSubConfig(string, "ProviderContactPerson", 0, map);
            } else {
                serviceConfig.addSubConfig(string, "ContactPerson", 0, map);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createContactPersonContact person  Node created");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::cp SMSException while create cp", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_contactperson_creation_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::cp SSOException while create cp", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_contactperson_creation_exception"));
        }
    }

    public void createOrganization(ServiceConfig serviceConfig, FSOrganization fSOrganization, boolean bl) throws FSAllianceManagementException {
        String string = null;
        if (fSOrganization == null || (string = fSOrganization.getOrgID()) == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::createOrganization  ID in the given organization is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("organization-id-invalid"));
        }
        Map map = fSOrganization.getAttributes(bl);
        try {
            if (bl) {
                serviceConfig.addSubConfig(string, "ProviderOrganization", 0, map);
            } else {
                serviceConfig.addSubConfig(string, "EntityOrganization", 0, map);
            }
            if (this.messageEnabled) {
                FSUtils.debug.message("FSAllianceManager::createOrganizationorganization Node created");
            }
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::org SMSException while create org", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_organization_creation_exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::org SSOException while create org", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("alliance_management_organization_creation_exception"));
        }
    }

    public FSContactPerson getContactPerson(ServiceConfig serviceConfig, String string, boolean bl) throws FSAllianceManagementException, FSInvalidNameException {
        FSContactPerson fSContactPerson = null;
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAllianceManager::getContactPerson contactPersonID: " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("contactperson-id-invalid"));
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            fSContactPerson = new FSContactPerson(string, map, bl);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getCP  couldn't get contact person SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("contactPerson-retrieval-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getCP couldn't get contact person SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("contactPerson-retrieval-exception"));
        }
        return fSContactPerson;
    }

    public FSOrganization getOrganization(ServiceConfig serviceConfig, String string, boolean bl) throws FSAllianceManagementException, FSInvalidNameException {
        FSOrganization fSOrganization = null;
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("orgID: " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("organization-id-invalid"));
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            fSOrganization = new FSOrganization(string, map, bl);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getOrg  couldn't get organization SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("organization-retrieval-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getOrg couldn't get organization SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("organization-retrieval-exception"));
        }
        return fSOrganization;
    }

    public FSAffiliationDescriptor getAffiliationDescriptor(ServiceConfig serviceConfig, String string) throws FSAllianceManagementException, FSInvalidNameException {
        FSAffiliationDescriptor fSAffiliationDescriptor = null;
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("affID: " + string + "is invalid");
            throw new FSInvalidNameException(FSUtils.bundle.getString("affiliation-id-invalid"));
        }
        try {
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            Map map = serviceConfig2.getAttributes();
            fSAffiliationDescriptor = new FSAffiliationDescriptor(string, map);
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliation  couldn't get Affiliation SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-retrieval-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliation couldn't get affiliation SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-retrieval-exception"));
        }
        return fSAffiliationDescriptor;
    }

    public FSAffiliationDescriptor getAffiliationDescriptor(String string) throws FSAllianceManagementException, FSInvalidNameException {
        try {
            FSAffiliationDescriptor fSAffiliationDescriptor = null;
            if (cacheOn && (fSAffiliationDescriptor = FSCache.getAffiliationDescriptor(string)) != null) {
                return fSAffiliationDescriptor;
            }
            Set set = this.entityConfig.getSubConfigNames();
            if (set == null || set.isEmpty()) {
                FSUtils.debug.error("No entity found!");
                throw new FSAllianceManagementException(FSUtils.bundle.getString("getAffiliationDescNoEntity"));
            }
            Iterator iterator = set.iterator();
            ServiceConfig serviceConfig = null;
            Map map = null;
            String string2 = null;
            while (iterator.hasNext()) {
                serviceConfig = this.entityConfig.getSubConfig((String)iterator.next());
                if (serviceConfig != null) {
                    map = serviceConfig.getAttributes();
                }
                if (map == null || map.isEmpty() || (string2 = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerEntityType")) == null || !string2.equalsIgnoreCase("urn:liberty:iff:affiliate")) continue;
                Set set2 = serviceConfig.getSubConfigNames();
                if (set2 == null || set2.isEmpty()) {
                    if (!FSUtils.debug.messageEnabled()) continue;
                    FSUtils.debug.message("This entity does not contain any sub element.");
                    continue;
                }
                if (!set2.contains(string)) continue;
                fSAffiliationDescriptor = this.getAffiliationDescriptor(serviceConfig, string);
                if (cacheOn) {
                    FSAffiliationDescriptor fSAffiliationDescriptor2 = FSCache.setAffiliationDescriptor(fSAffiliationDescriptor);
                }
                return fSAffiliationDescriptor;
            }
            return null;
        }
        catch (SMSException sMSException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliationDescriptor  couldn't get AffiliationDescriptor SMSException", (Throwable)sMSException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-retrieval-exception"));
        }
        catch (SSOException sSOException) {
            FSUtils.debug.error("FSAllianceManager::getAffiliationDescriptor couldn't get AffiliationDescriptor SSOException", (Throwable)sSOException);
            throw new FSAllianceManagementException(FSUtils.bundle.getString("affiliation-retrieval-exception"));
        }
    }

    static {
        try {
            String string = SystemProperties.get((String)"com.sun.identity.federation.alliance.cache.enabled");
            if (string.equalsIgnoreCase("false")) {
                cacheOn = false;
            }
        }
        catch (Exception exception) {
            FSUtils.debug.error("Could not get cacheOn signal from config.  Take default value.");
            cacheOn = true;
        }
    }
}

