/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.alliance;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManagementUtils;
import com.sun.identity.federation.alliance.FSInvalidNameException;
import com.sun.identity.federation.common.FSUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FSAffiliationDescriptor {
    private String affID = null;
    private String affOwnerID = null;
    private String extension = null;
    private String validUtil = null;
    private String cacheDuration = null;
    private Set affMember = null;
    private String keyInfo = null;
    private String keyUse = null;
    private String encryptMethod = null;
    private String keySize = null;

    public FSAffiliationDescriptor(String string) throws FSAllianceManagementException {
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAffiliationDescriptor::constructor Id is null");
            throw new FSInvalidNameException(FSUtils.bundle.getString("affiliation-id-invalid"));
        }
        this.affID = string;
    }

    public FSAffiliationDescriptor(String string, String string2) throws FSAllianceManagementException {
        this(string);
        this.setAffiliationOwnerID(string2);
    }

    FSAffiliationDescriptor(String string, Map map) {
        this.affID = string;
        this.affOwnerID = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationOwnerID");
        this.extension = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationExtension");
        this.affMember = new HashSet();
        this.affMember = FSAllianceManagementUtils.getEntry(map, "sunIdentityServerAffiliateMember");
        this.keyInfo = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateKeyInfo");
        this.keyUse = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateKeyUse");
        this.keySize = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateKeySize");
        this.encryptMethod = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliateEncryptionMethod");
        this.validUtil = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationValidUntil");
        this.cacheDuration = FSAllianceManagementUtils.getFirstEntry(map, "sunIdentityServerAffiliationCacheDuration");
    }

    public String getAffiliationID() {
        return this.affID;
    }

    void setAffiliationID(String string) {
        this.affID = string;
    }

    public String getAffiliationOwnerID() {
        return this.affOwnerID;
    }

    public void setAffiliationOwnerID(String string) {
        this.affOwnerID = string;
    }

    public String getKeyInfo() {
        return this.keyInfo;
    }

    public String getEncryptionMethod() {
        return this.encryptMethod;
    }

    public String getKeyUse() {
        return this.keyUse;
    }

    public int getKeySize() {
        int n;
        block2: {
            n = -1;
            if (this.keySize == null || this.keySize.trim().length() <= 0) break block2;
            try {
                n = Integer.parseInt(this.keySize);
            }
            catch (NumberFormatException numberFormatException) {
                FSUtils.debug.warning("FSAffiliationDescriptor.getKeySize", (Throwable)numberFormatException);
            }
        }
        return n;
    }

    public void setKeyInfo(String string) {
        this.keyInfo = string;
    }

    public void setEncryptionMethod(String string) {
        this.encryptMethod = string;
    }

    public void setKeyUse(String string) {
        this.keyUse = string;
    }

    public void setKeySize(int n) {
        this.keySize = Integer.toString(n);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getValidUntil() {
        return this.validUtil;
    }

    public String getCacheDuration() {
        return this.cacheDuration;
    }

    public Set getAffiliationMember() {
        return this.affMember;
    }

    public void setAffiliationMember(Set set) {
        if (this.affMember == null) {
            this.affMember = new HashSet();
        }
        this.affMember = set;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public void setValidUntil(String string) {
        this.validUtil = string;
    }

    public void setCacheDuration(String string) {
        this.cacheDuration = string;
    }

    Map getAttributes() {
        HashMap hashMap = new HashMap();
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationOwnerID", this.affOwnerID);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateKeyInfo", this.keyInfo);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateKeyUse", this.keyUse);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateKeySize", this.keySize);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliateEncryptionMethod", this.encryptMethod);
        FSAllianceManagementUtils.fillEntries(hashMap, "sunIdentityServerAffiliateMember", this.affMember);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationExtension", this.extension);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationValidUntil", this.validUtil);
        FSAllianceManagementUtils.fillEntriesInSet(hashMap, "sunIdentityServerAffiliationCacheDuration", this.cacheDuration);
        return hashMap;
    }
}

