/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.accountmgmt;

import com.sun.identity.federation.accountmgmt.FSAccountFedInfo;
import com.sun.identity.federation.accountmgmt.FSAccountFedInfoKey;
import com.sun.identity.federation.accountmgmt.FSAccountMgmtException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

class FSAccountUtils {
    static final String USER_FED_INFO_KEY_ATTR = "iplanet-am-user-federation-info-key";
    static final String USER_FED_INFO_ATTR = "iplanet-am-user-federation-info";
    private static final String FED_INFO_DELIM = "|";

    FSAccountUtils() {
    }

    static FSAccountFedInfo stringToObject(String string) throws FSAccountMgmtException {
        FSAccountFedInfo fSAccountFedInfo;
        block20: {
            fSAccountFedInfo = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, FED_INFO_DELIM);
            fSAccountFedInfo = new FSAccountFedInfo();
            try {
                String string2;
                String string3;
                String string4;
                String string5 = stringTokenizer.nextToken();
                fSAccountFedInfo.setProviderID(string5);
                NameIdentifier nameIdentifier = null;
                NameIdentifier nameIdentifier2 = null;
                string5 = stringTokenizer.nextToken();
                if (!string5.equalsIgnoreCase("null")) {
                    string4 = string5;
                    string3 = "";
                    string2 = "";
                    string5 = stringTokenizer.nextToken();
                    if (!string5.equalsIgnoreCase("null")) {
                        string3 = string5;
                    }
                    if (!(string5 = stringTokenizer.nextToken()).equalsIgnoreCase("null")) {
                        string2 = string5;
                    }
                    try {
                        nameIdentifier = new NameIdentifier(string4, string3, string2);
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSAccountUtils.stringToObject() : SAMLException: ", (Throwable)sAMLException);
                        throw new FSAccountMgmtException(sAMLException.getMessage());
                    }
                } else {
                    string5 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                fSAccountFedInfo.setLocalNameIdentifier(nameIdentifier);
                string5 = stringTokenizer.nextToken();
                if (!string5.equalsIgnoreCase("null")) {
                    string4 = string5;
                    string3 = "";
                    string2 = "";
                    string5 = stringTokenizer.nextToken();
                    if (!string5.equalsIgnoreCase("null")) {
                        string3 = string5;
                    }
                    if (!(string5 = stringTokenizer.nextToken()).equalsIgnoreCase("null")) {
                        string2 = string5;
                    }
                    try {
                        nameIdentifier2 = new NameIdentifier(string4, string3, string2);
                    }
                    catch (SAMLException sAMLException) {
                        FSUtils.debug.error("FSAccountUtils.stringToObject() : SAMLException: ", (Throwable)sAMLException);
                        throw new FSAccountMgmtException(sAMLException.getMessage());
                    }
                } else {
                    string5 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                fSAccountFedInfo.setRemoteNameIdentifier(nameIdentifier2);
                string5 = stringTokenizer.nextToken();
                if (string5.equalsIgnoreCase("IDPRole")) {
                    fSAccountFedInfo.setRole(true);
                } else if (string5.equalsIgnoreCase("SPRole")) {
                    fSAccountFedInfo.setRole(false);
                } else {
                    FSUtils.debug.error("FSAccountUtils.stringToObject(): oops !!! You have modified IDP/SP Role in iDS :: set it to IDPRole/SPRole ");
                    throw new FSAccountMgmtException("actmgmt-fed-info-modified-in-ids", null);
                }
                string5 = stringTokenizer.nextToken();
                if (string5.equalsIgnoreCase("Active")) {
                    fSAccountFedInfo.activateFedStatus();
                    break block20;
                }
                if (string5.equalsIgnoreCase("InActive")) {
                    fSAccountFedInfo.deActivateFedStatus();
                    break block20;
                }
                FSUtils.debug.error("FSAccountUtils.stringToObject(): oops !!! You have modified  Active/InActive in iDS ");
                throw new FSAccountMgmtException("actmgmt-fed-info-modified-in-ids", null);
            }
            catch (NoSuchElementException noSuchElementException) {
                FSUtils.debug.error("FSAccountUtils.stringToObject() : NoSuchElementException: ", (Throwable)noSuchElementException);
                throw new FSAccountMgmtException(noSuchElementException.getMessage());
            }
        }
        return fSAccountFedInfo;
    }

    static String objectToInfoString(FSAccountFedInfo fSAccountFedInfo) throws FSAccountMgmtException {
        String string;
        String string2;
        String string3;
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(FED_INFO_DELIM);
        stringBuffer.append(fSAccountFedInfo.getProviderID());
        NameIdentifier nameIdentifier = fSAccountFedInfo.getLocalNameIdentifier();
        NameIdentifier nameIdentifier2 = fSAccountFedInfo.getRemoteNameIdentifier();
        if (nameIdentifier == null && nameIdentifier2 == null) {
            FSUtils.debug.error("FSAccountUtils.objectToInfoString(): both NameIdentifiers are null");
            throw new FSAccountMgmtException("actmgmt-name-identifier-is-null", null);
        }
        if (nameIdentifier != null) {
            stringBuffer.append(FED_INFO_DELIM);
            string3 = nameIdentifier.getName();
            if (string3 == null || string3.length() <= 0) {
                FSUtils.debug.error("FSAccountUtils.objectToInfoString(): local Name is null");
                throw new FSAccountMgmtException("actmgmt-name-is-null", null);
            }
            stringBuffer.append(string3);
            stringBuffer.append(FED_INFO_DELIM);
            string2 = nameIdentifier.getNameQualifier();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(FED_INFO_DELIM);
            string = nameIdentifier.getFormat();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("null");
            }
        } else {
            stringBuffer.append(FED_INFO_DELIM);
            stringBuffer.append("null");
            stringBuffer.append(FED_INFO_DELIM);
            stringBuffer.append("null");
            stringBuffer.append(FED_INFO_DELIM);
            stringBuffer.append("null");
        }
        if (nameIdentifier2 != null) {
            stringBuffer.append(FED_INFO_DELIM);
            string3 = nameIdentifier2.getName();
            if (string3 == null || string3.length() <= 0) {
                FSUtils.debug.error("FSAccountUtils.objectToInfoString(): remote Name is null");
                throw new FSAccountMgmtException("actmgmt-name-is-null", null);
            }
            stringBuffer.append(string3);
            stringBuffer.append(FED_INFO_DELIM);
            string2 = nameIdentifier2.getNameQualifier();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(FED_INFO_DELIM);
            string = nameIdentifier2.getFormat();
            if (string != null && string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append("null");
            }
        } else {
            stringBuffer.append(FED_INFO_DELIM);
            stringBuffer.append("null");
            stringBuffer.append(FED_INFO_DELIM);
            stringBuffer.append("null");
            stringBuffer.append(FED_INFO_DELIM);
            stringBuffer.append("null");
        }
        stringBuffer.append(FED_INFO_DELIM);
        if (fSAccountFedInfo.isRoleIDP()) {
            stringBuffer.append("IDPRole");
        } else {
            stringBuffer.append("SPRole");
        }
        stringBuffer.append(FED_INFO_DELIM);
        if (fSAccountFedInfo.isFedStatusActive()) {
            stringBuffer.append("Active");
        } else {
            stringBuffer.append("InActive");
        }
        stringBuffer.append(FED_INFO_DELIM);
        return stringBuffer.toString();
    }

    static String objectToKeyString(FSAccountFedInfoKey fSAccountFedInfoKey) throws FSAccountMgmtException {
        StringBuffer stringBuffer = new StringBuffer(300);
        String string = fSAccountFedInfoKey.getNameSpace();
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.objectToKeyString():Invalid Argument : nameSpace is NULL");
            throw new FSAccountMgmtException("actmgmt-name-space-is-null", null);
        }
        String string2 = fSAccountFedInfoKey.getName();
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.objectToKeyString():Invalid Argument : name is NULL");
            throw new FSAccountMgmtException("actmgmt-name-is-null", null);
        }
        stringBuffer.append(FED_INFO_DELIM).append(string).append(FED_INFO_DELIM).append(string2).append(FED_INFO_DELIM);
        String string3 = stringBuffer.toString();
        FSUtils.debug.message("FSAccountUtils.objectToKeyString(): Value: " + string3);
        return string3;
    }

    static String createFilter(String string) {
        return FED_INFO_DELIM + string + FED_INFO_DELIM;
    }

    static String createFilter(String string, String string2) {
        return FED_INFO_DELIM + string + FED_INFO_DELIM + string2 + FED_INFO_DELIM;
    }

    static String createFilter(FSAccountFedInfoKey fSAccountFedInfoKey) throws FSAccountMgmtException {
        String string = fSAccountFedInfoKey.getNameSpace();
        if (string == null || string.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.createFilter():Invalid Argument : nameSpace is NULL");
            throw new FSAccountMgmtException("actmgmt-name-space-is-null", null);
        }
        String string2 = fSAccountFedInfoKey.getName();
        if (string2 == null || string2.length() <= 0) {
            FSUtils.debug.error("FSAccountUtils.createFilter():Invalid Argument : name is NULL");
            throw new FSAccountMgmtException("actmgmt-name-is-null", null);
        }
        return FED_INFO_DELIM + string + FED_INFO_DELIM + string2 + FED_INFO_DELIM;
    }
}

