/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.spi.AMAuthCallBack;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMAuthCallBackImpl {
    static final String AUTH_PLUGIN_MODULES_ATTR = "iplanet-am-auth-callback-plugins";
    static final String DEBUG_FILE = "amAuth";
    static final String bundleName = "amAuth";
    private static Debug debug = Debug.getInstance((String)"amAuth");
    private static Map theCallBackInst = Collections.EMPTY_MAP;
    private Map callBackObjects;
    private String theOrgDN;

    private AMAuthCallBackImpl(String string) throws AMAuthCallBackException {
        String string2;
        Object object;
        Object object2;
        SSOToken sSOToken;
        block4: {
            this.callBackObjects = Collections.EMPTY_MAP;
            this.theOrgDN = null;
            this.theOrgDN = string;
            sSOToken = null;
            try {
                object2 = SSOTokenManager.getInstance();
                object = (String)AccessController.doPrivileged(new AdminDNAction());
                string2 = (String)AccessController.doPrivileged(new AdminPasswordAction());
                sSOToken = object2.createSSOToken((Principal)new AuthPrincipal((String)object), string2);
            }
            catch (SSOException sSOException) {
                if (debug.getState() < 1) break block4;
                debug.error("AMAuthCallBackImpl constructor : cannot get SSO Token", (Throwable)sSOException);
            }
        }
        object2 = this.getOrgAuthPlugIns(sSOToken, AUTH_PLUGIN_MODULES_ATTR);
        if (object2 != null && !object2.isEmpty()) {
            this.callBackObjects = new HashMap();
            object = object2.iterator();
            while (object.hasNext()) {
                string2 = (String)object.next();
                AMAuthCallBack aMAuthCallBack = this.instantiateClass(string2);
                if (aMAuthCallBack == null) continue;
                this.callBackObjects.put(string2, aMAuthCallBack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AMAuthCallBackImpl getInstance(String string) throws AMAuthCallBackException {
        if (theCallBackInst == Collections.EMPTY_MAP) {
            theCallBackInst = new HashMap();
        }
        Map map = theCallBackInst;
        synchronized (map) {
            if (theCallBackInst.get(string) == null) {
                theCallBackInst.put(string, new AMAuthCallBackImpl(string));
            }
        }
        return (AMAuthCallBackImpl)theCallBackInst.get(string);
    }

    public void processedPasswordChange(Long l, String string) throws AMAuthCallBackException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timechanged", l);
        hashMap.put("organization", this.theOrgDN);
        hashMap.put("userdn", string);
        this.processedEvent(1, hashMap);
    }

    public void processedAccounttLockout(Long l, String string) throws AMAuthCallBackException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("timechanged", l);
        hashMap.put("organization", this.theOrgDN);
        hashMap.put("userdn", string);
        this.processedEvent(2, hashMap);
    }

    public void processedEvent(int n, Map map) throws AMAuthCallBackException {
        if (this.callBackObjects != Collections.EMPTY_MAP) {
            Set set = this.callBackObjects.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMAuthCallBack aMAuthCallBack = (AMAuthCallBack)this.callBackObjects.get(iterator.next());
                aMAuthCallBack.authEventCallback(n, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getOrgAuthPlugIns(SSOToken sSOToken, String string) {
        Set set = Collections.EMPTY_SET;
        try {
            block8: {
                try {
                    ServiceConfigManager serviceConfigManager = new ServiceConfigManager("iPlanetAMAuthService", sSOToken);
                    ServiceConfig serviceConfig = serviceConfigManager.getOrganizationConfig(this.theOrgDN, null);
                    if (serviceConfig != null) {
                        Map map = serviceConfig.getAttributes();
                        set = (Set)map.get(AUTH_PLUGIN_MODULES_ATTR);
                        break block8;
                    }
                    ServiceConfig serviceConfig2 = serviceConfigManager.getGlobalConfig(null);
                    if (serviceConfig2 == null) break block8;
                    Map map = serviceConfig2.getAttributes();
                    set = (Set)map.get(AUTH_PLUGIN_MODULES_ATTR);
                }
                catch (SMSException sMSException) {
                    if (debug.getState() >= 1) {
                        debug.error("getOrgAuthPlugIns : SMS error", (Throwable)sMSException);
                    }
                    Object var9_12 = null;
                    return set;
                }
                catch (SSOException sSOException) {
                    if (debug.getState() >= 1) {
                        debug.error("getOrgAuthPlugIns : SSO error", (Throwable)sSOException);
                    }
                    Object var9_13 = null;
                    return set;
                }
            }
            Object var9_11 = null;
            return set;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            return set;
        }
    }

    private AMAuthCallBack instantiateClass(String string) {
        try {
            return (AMAuthCallBack)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            debug.error("AuthCallBackImpl.instantiateClass(): Unable to locate class " + string, (Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            debug.error("AuthCallBackImpl.instantiateClass(): Unable to instantiate class " + string, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            debug.error("AuthCallBackImpl.instantiateClass(): Problem with the Security Manager for class " + string, (Throwable)illegalAccessException);
        }
        catch (Exception exception) {
            debug.error("AMCallBackImpl.instantiateClass(): Unknown error for class " + string, (Throwable)exception);
        }
        return null;
    }
}

