/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.FileLookup;
import com.iplanet.am.util.FileLookupException;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.Guid;
import com.iplanet.ums.dctree.DomainComponentTree;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.SSOTokenPrincipal;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.RequestUtils;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import java.io.File;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPDN;
import netscape.ldap.util.DN;

public class LoginState {
    AMLoginContext amLoginContext;
    Callback[] receivedCallbackInfo;
    Callback[] prevCallback;
    Callback[] submittedCallbackInfo;
    HashMap callbacksPerState = new HashMap();
    InternalSession sess;
    HttpServletRequest servletRequest;
    HttpServletResponse servletResponse;
    String orgName;
    String userOrg;
    String orgDN;
    int loginStatus = 2;
    Hashtable requestHash;
    boolean requestType;
    private static final String rootSuffix;
    private static final String consoleProto;
    private static final String consoleHost;
    private static final String consolePort;
    private static final boolean isConsoleRemote;
    private static boolean isSessionFailoverEnabled;
    private static final boolean urlRewriteInPath;
    private static AuthD ad;
    Set containerDNs = null;
    Set aliasAttrNames = null;
    public boolean inetDomainStatus = true;
    String userOrgDN = null;
    String userContainerDN = null;
    String agentContainerDN = null;
    boolean nullUserContainerDN = false;
    boolean dnByUserContainer = false;
    String userNamingAttr = null;
    public Set defaultRoles = null;
    public String defaultRole = null;
    boolean dynamicProfileCreation = false;
    boolean ignoreUserProfile = false;
    boolean persistentCookieMode = false;
    public String persistentCookieTime = null;
    public boolean persistentCookieOn = false;
    public String defaultAuthLevel = "0";
    public String redirectURL = null;
    String acceptLangHeader = null;
    Subject subject;
    String token = null;
    String userDN = null;
    int maxSession;
    int idleTime;
    int cacheTime;
    int authLevel = 0;
    int moduleAuthLevel = Integer.MIN_VALUE;
    String client = null;
    String clientType = null;
    String authMethName = "";
    String pAuthMethName = null;
    String cookieSupport = "true";
    String queryOrg = null;
    SessionID sid;
    SSOToken ssoToken;
    SSOTokenManager ssoManager;
    boolean cookieSupported = true;
    boolean cookieSet = false;
    String filePath;
    boolean userEnabled = true;
    private static boolean getUser;
    private static Set userAttributes;
    AMUser amUser = null;
    AMEntity amEntity = null;
    public String userId = null;
    boolean isAdmin;
    boolean isApp = false;
    int failedStatus;
    String role;
    String roleDN;
    String roleNamingAttr;
    String moduleName;
    Set tokenSet;
    String userName;
    AuthContext.IndexType indexType;
    AuthContext.IndexType prevIndexType = null;
    Set userAliasList = null;
    boolean hasAdminToken = false;
    String pCookieName = ad.getPersistentCookieName();
    String gotoURL = null;
    String gotoOnFailURL = null;
    String failureLoginURL = null;
    String successLoginURL = null;
    String moduleSuccessLoginURL = null;
    String moduleFailureLoginURL = null;
    Set orgSuccessLoginURLSet = null;
    String clientOrgSuccessLoginURL = null;
    String defaultOrgSuccessLoginURL = null;
    String clientOrgFailureLoginURL = null;
    String defaultOrgFailureLoginURL = null;
    Set orgFailureLoginURLSet = null;
    Map requestMap = new HashMap();
    String clientOrgLoginSuccessURL = null;
    String defaultOrgLoginSuccessURL = null;
    String orgLoginFailureURL = null;
    public boolean userIDGeneratorEnabled;
    public String userIDGeneratorClassName;
    Set domainAuthenticators = null;
    Set moduleInstances = null;
    Map queryParamsMap;
    AuthContextLocal oldAuthContext;
    boolean sessionUpgrade = false;
    int upgradeAuthLevel = 0;
    String upgradeModuleList = null;
    String upgradeServiceName = null;
    String upgradeRoleName = null;
    String loginURL = null;
    long pageTimeOut = 60L;
    long lastCallbackSent = System.currentTimeMillis();
    private static boolean isHttpSessionEnabled;
    private static DomainComponentTree dcTree;
    public static final String installDir;
    public static String installBaseDir;
    public static String templateDir;
    public boolean loginFailureLockoutMode = false;
    public String accountLife = null;
    public long loginFailureLockoutDuration = 0L;
    public long loginFailureLockoutTime = 300000L;
    public int loginFailureLockoutCount = 5;
    public String loginLockoutNotification = null;
    public String loginLockoutAttrName = null;
    public String loginLockoutAttrValue = null;
    public int loginLockoutUserWarning = 3;
    public int userWarningCount = 0;
    String errorCode = null;
    String errorMessage = null;
    String errorTemplate = null;
    String moduleErrorTemplate = null;
    String lockoutMsg = null;
    boolean timedOut = false;
    public String failureTokenId = null;
    String principalList = null;
    String pCookieUserName = null;
    private ISLocaleContext localeContext = new ISLocaleContext();
    String fileRoot = null;
    String fileSubPaths = null;
    String indexName = null;
    X509Certificate cert = null;
    String defaultUserSuccessURL;
    String clientUserSuccessURL;
    Set userSuccessURLSet = Collections.EMPTY_SET;
    String clientUserFailureURL;
    String defaultUserFailureURL;
    Set userFailureURLSet = Collections.EMPTY_SET;
    String clientSuccessRoleURL;
    String defaultSuccessRoleURL;
    Set successRoleURLSet = Collections.EMPTY_SET;
    String clientFailureRoleURL;
    String defaultFailureRoleURL;
    Set failureRoleURLSet = Collections.EMPTY_SET;
    String userPostLoginClassName;
    String orgPostLoginClassName;
    Map serviceAttributesMap = new HashMap();
    String moduleErrorMessage = null;
    String defaultSuccessURL = null;
    String defaultFailureURL = null;
    String tempDefaultURL = null;
    AMPostAuthProcessInterface postLoginInstance = null;
    boolean isRemote = false;
    boolean cookieDetect = false;
    HashMap userCreationAttributes = null;
    Set externalAliasList = null;
    Set successModuleSet = new HashSet();
    Set failureModuleSet = new HashSet();
    String failureModuleList = "";
    String fqdnURL = null;
    String fqdnFailureLoginURL = null;
    Map moduleMap = null;
    static String serviceURI;

    public HttpServletRequest getHttpServletRequest() {
        return this.servletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this.servletRequest = httpServletRequest;
    }

    public InternalSession getSession() {
        if (this.sess == null || this.sess.getState() == 2 || this.sess.getState() == 3) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Session is null OR INACTIVE OR DESTROYED :" + this.sess);
            }
            return null;
        }
        return this.sess;
    }

    public void setSession(InternalSession internalSession) {
        this.sess = internalSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceivedCallback(Callback[] callbackArray, AMLoginContext aMLoginContext) {
        this.amLoginContext = aMLoginContext;
        AMLoginContext aMLoginContext2 = aMLoginContext;
        synchronized (aMLoginContext2) {
            this.submittedCallbackInfo = null;
            this.receivedCallbackInfo = callbackArray;
            this.prevCallback = callbackArray;
            aMLoginContext.notify();
        }
    }

    public void setReceivedCallback_NoThread(Callback[] callbackArray) {
        this.submittedCallbackInfo = null;
        this.receivedCallbackInfo = callbackArray;
        this.prevCallback = callbackArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubmittedCallback(Callback[] callbackArray, AMLoginContext aMLoginContext) {
        this.amLoginContext = aMLoginContext;
        AMLoginContext aMLoginContext2 = aMLoginContext;
        synchronized (aMLoginContext2) {
            this.receivedCallbackInfo = null;
            this.prevCallback = this.receivedCallbackInfo;
            this.submittedCallbackInfo = callbackArray;
            aMLoginContext.notify();
        }
    }

    public void setSubmittedCallback_NoThread(Callback[] callbackArray) {
        this.receivedCallbackInfo = null;
        this.prevCallback = this.receivedCallbackInfo;
        this.submittedCallbackInfo = callbackArray;
    }

    public Callback[] getReceivedInfo() {
        return this.receivedCallbackInfo;
    }

    public Callback[] getSubmittedInfo() {
        return this.submittedCallbackInfo;
    }

    public String getOrgDN() {
        try {
            if (this.orgDN == null) {
                this.orgDN = ad.getOrgDN(this.userOrg);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Error getting orgDN: ", (Throwable)exception);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("orgDN is : " + this.orgDN);
        }
        return this.orgDN;
    }

    public String getOrgName() {
        if (this.orgName == null) {
            this.orgName = this.DNtoName(this.orgDN);
        }
        return this.orgName;
    }

    public int getLoginStatus() {
        return this.loginStatus;
    }

    public synchronized void setLoginStatus(int n) {
        this.loginStatus = n;
    }

    public void setParamHash(Hashtable hashtable) {
        this.requestHash = hashtable;
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                this.requestMap.put(k, v);
            }
        }
    }

    public void setRequestType(boolean bl) {
        this.requestType = bl;
    }

    public boolean isNewRequest() {
        return this.requestType;
    }

    public boolean isDynamicProfileCreationEnabled() {
        return this.dynamicProfileCreation;
    }

    public String getRootSuffix() {
        return rootSuffix;
    }

    public void populateOrgProfile() throws AuthException {
        try {
            Object object;
            this.inetDomainStatus = ad.getInetDomainStatus(this.orgDN);
            if (!this.inetDomainStatus) {
                this.logFailed(LoginState.ad.bundle.getString("invalidDomain"));
                throw new AuthException("109", null);
            }
            AMTemplate aMTemplate = ad.getOrganizationTemplate(this.orgDN, "iPlanetAMAuthService");
            Map map = aMTemplate.getAttributes();
            this.aliasAttrNames = (Set)map.get("iplanet-am-auth-alias-attr-name");
            this.containerDNs = (Set)map.get("iplanet-am-auth-user-container");
            if (this.containerDNs == null || this.containerDNs.isEmpty()) {
                AuthD.debug.message("Container DNs is null");
                this.nullUserContainerDN = true;
            } else {
                object = this.containerDNs.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    try {
                        if (Misc.isDescendantOf((String)string, (String)this.orgDN)) {
                            int n = ad.getSDK().getAMObjectType(string);
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("Container Type = " + n);
                                AuthD.debug.message("Container Name = " + string);
                            }
                            if (n == 3 && this.agentContainerDN == null) {
                                this.agentContainerDN = string;
                            } else if (n == 2 && this.userOrgDN == null) {
                                this.userOrgDN = string;
                            } else if (n == 5 && this.userContainerDN == null) {
                                this.userContainerDN = string;
                            }
                        }
                        if (this.userContainerDN == null || this.agentContainerDN == null || this.userOrgDN == null) continue;
                        break;
                    }
                    catch (Exception exception) {
                        AuthD.debug.error("Container - " + string + " is INVALID :- ", (Throwable)exception);
                    }
                }
            }
            if (this.userContainerDN == null) {
                this.userContainerDN = AMStoreConnection.getNamingAttribute(5) + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + this.orgDN;
            }
            if (this.userContainerDN == null && this.agentContainerDN == null) {
                AuthD.debug.message("No Valid Container in the list");
                throw new AuthException("102", null);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("agentContainerDN = " + this.agentContainerDN);
                AuthD.debug.message("userContainerDN = " + this.userContainerDN);
                AuthD.debug.message("userOrgDN set in PC atrr = " + this.userOrgDN);
            }
            this.userNamingAttr = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-user-naming-attr", (String)"uid");
            this.defaultRoles = (Set)map.get("iplanet-am-auth-default-role");
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-dynamic-profile-creation");
            if (((String)object).equalsIgnoreCase("true")) {
                this.dynamicProfileCreation = true;
            } else if (((String)object).equalsIgnoreCase("ignore")) {
                this.ignoreUserProfile = true;
            }
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-persistent-cookie-mode");
            if (((String)object).equalsIgnoreCase("true")) {
                this.persistentCookieMode = true;
            }
            object = null;
            this.persistentCookieTime = object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-persistent-cookie-time");
            this.domainAuthenticators = (Set)map.get("iplanet-am-auth-allowed-modules");
            if (this.domainAuthenticators == null) {
                this.domainAuthenticators = Collections.EMPTY_SET;
            }
            this.defaultAuthLevel = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-default-auth-level");
            if (this.defaultAuthLevel == null || this.defaultAuthLevel.equals("")) {
                this.defaultAuthLevel = "0";
            }
            AuthUtils.retainSupportedModules(this.domainAuthenticators, this.getClientType());
            this.defaultRole = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-default-role");
            this.localeContext.setOrgLocale(this.orgDN);
            this.orgSuccessLoginURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
            if (this.orgSuccessLoginURLSet == null) {
                this.orgSuccessLoginURLSet = Collections.EMPTY_SET;
            }
            this.clientOrgSuccessLoginURL = this.getRedirectUrl(this.orgSuccessLoginURLSet);
            this.defaultOrgSuccessLoginURL = this.tempDefaultURL;
            this.orgFailureLoginURLSet = (Set)map.get("iplanet-am-auth-login-failure-url");
            if (this.orgFailureLoginURLSet == null) {
                this.orgFailureLoginURLSet = Collections.EMPTY_SET;
            }
            this.clientOrgFailureLoginURL = this.getRedirectUrl(this.orgFailureLoginURLSet);
            this.defaultOrgFailureLoginURL = this.tempDefaultURL;
            this.orgPostLoginClassName = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-post-login-process-class");
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-login-failure-lockout-mode");
            if (object != null && ((String)object).equalsIgnoreCase("true")) {
                this.loginFailureLockoutMode = true;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-duration")) != null) {
                try {
                    this.loginFailureLockoutDuration = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-lockout-duration bad format.");
                }
                this.loginFailureLockoutDuration *= 60000L;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-login-failure-count")) != null) {
                try {
                    this.loginFailureLockoutCount = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-lockout-count bad format.");
                }
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-login-failure-duration")) != null) {
                try {
                    this.loginFailureLockoutTime = Long.parseLong((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-login-failure-duration bad format.");
                }
                this.loginFailureLockoutTime *= 60000L;
            }
            if ((object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-warn-user")) != null) {
                try {
                    this.loginLockoutUserWarning = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    AuthD.debug.error("auth-lockout-warn-user bad format.");
                }
            }
            this.loginLockoutNotification = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-email-address");
            object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-username-generator-enabled");
            if (object != null) {
                this.userIDGeneratorEnabled = Boolean.valueOf((String)object);
            }
            this.userIDGeneratorClassName = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-username-generator-class");
            this.loginLockoutAttrName = object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-attribute-name");
            this.loginLockoutAttrValue = object = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-lockout-attribute-value");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Getting Org Profile: " + this.orgDN + "\nlocale->" + this.localeContext.getLocale() + "\ncharset->" + this.localeContext.getMIMECharset() + "\ndynamicProfileCreation->" + this.dynamicProfileCreation + "\ndefaultRole->" + this.defaultRole + "\ndefaultAuthLevel->" + this.defaultAuthLevel + "\norgSucessLoginURLSet->" + this.orgSuccessLoginURLSet + "\norgFailureLoginURLSet->" + this.orgFailureLoginURLSet + "\nclientSuccessLoginURL ->" + this.clientOrgSuccessLoginURL + "\ndefaultSuccessLoginURL ->" + this.defaultOrgSuccessLoginURL + "\norgPostLoginClassName ->" + this.orgPostLoginClassName + "\nclientFailureLoginURL ->" + this.clientOrgFailureLoginURL + "\ndefaultFailureLoginURL ->" + this.defaultOrgFailureLoginURL + "\nloginFailureLockoutMode->" + this.loginFailureLockoutMode + "\nloginFailureLockoutCount->" + this.loginFailureLockoutCount + "\nloginFailureLockoutTime->" + this.loginFailureLockoutTime + "\nloginLockoutUserWarning->" + this.loginLockoutUserWarning + "\nloginLockoutNotification->" + this.loginLockoutNotification + "\npersistentCookieMode->" + this.persistentCookieMode);
            }
        }
        catch (AuthException authException) {
            AuthD.debug.error("Error in populateOrgProfile", (Throwable)((Object)authException));
            throw new AuthException((Throwable)((Object)authException));
        }
        catch (Exception exception) {
            AuthD.debug.error("Error in populateOrgProfile", (Throwable)exception);
            throw new AuthException("102", null);
        }
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public int getIdleTime() {
        return this.idleTime;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public String getUserDN(String string) {
        this.token = string;
        this.userDN = this.tokenToDN(string);
        return this.userDN;
    }

    public String getUserDN() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getUserDN: " + this.userDN);
        }
        return this.userDN;
    }

    public int getAuthLevel() {
        return this.authLevel;
    }

    public void setClient(String string) {
        this.client = string;
    }

    public String getClient() {
        String string;
        block7: {
            if (this.client != null) {
                return this.client;
            }
            string = "";
            try {
                String string2 = null;
                if (this.requestHash != null) {
                    string2 = (String)this.requestHash.get("client");
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("getClient : servletRequest is : " + this.client);
                    AuthD.debug.message("getClient : cli is : " + string2);
                }
                if ((string2 == null || string2.equals("")) && this.servletRequest != null) {
                    string = this.servletRequest.getRemoteAddr();
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block7;
                AuthD.debug.message("Error getting clienty Type ", (Throwable)exception);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Client is : " + string);
        }
        this.client = string;
        return string;
    }

    public String tokenToDN(String string) {
        try {
            String string2 = string.toLowerCase();
            int n = string2.indexOf("|");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
            if (Misc.isDescendantOf((String)string2, (String)this.orgDN)) {
                return string2;
            }
            String string3 = "amService-".toLowerCase();
            if (string2.startsWith(string3)) {
                return "cn=" + string + ",ou=DSAME Users," + rootSuffix;
            }
            if (ad.isSuperAdmin(string2)) {
                return string2;
            }
            String string4 = string2;
            if (DN.isDN(string2)) {
                string4 = LDAPDN.explodeDN(string2, true)[0];
            }
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append(this.userNamingAttr).append("=").append(string4).append(",").append(this.userContainerDN);
            this.dnByUserContainer = true;
            String string5 = stringBuffer.toString();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("token=" + string + ", id=" + string4 + ", DN=" + string5);
            }
            return string5;
        }
        catch (Exception exception) {
            AuthD.debug.error("tokenToDN : " + exception.getMessage());
            return string;
        }
    }

    public String getClientType() {
        if (this.clientType == null) {
            this.clientType = this.servletRequest != null ? ad.getClientType(this.servletRequest) : ad.getDefaultClient();
        }
        return this.clientType;
    }

    public boolean activateSession(Subject subject) {
        try {
            this.subject = this.addSSOTokenPrincipal(subject);
            if (this.userName != null) {
                this.token = this.userName;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("activateSession - Token is : " + this.token);
                AuthD.debug.message("activateSession - userDN is : " + this.userDN);
            }
            this.setSessionProperties(this.sess);
            boolean bl = false;
            try {
                bl = this.sess.activate(this.userDN);
            }
            catch (Exception exception) {
                return false;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Activating session: " + this.sess);
            }
            return bl;
        }
        catch (AuthException authException) {
            AuthD.debug.error("Error activating session: ");
            return false;
        }
    }

    public void setSessionProperties(InternalSession internalSession) throws AuthException {
        String string;
        block23: {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("LoginState getSession = " + internalSession + " \nrequest token = " + this.token);
            }
            if (this.token == null) {
                throw new AuthException("102", null);
            }
            if (this.principalList == null) {
                this.getTokenFromPrincipal(this.subject);
            }
            this.clientType = this.getClientType();
            this.client = this.getClient();
            this.cookieSupport = this.cookieSupported ? "true" : "false";
            if (this.userDN == null) {
                this.userDN = this.getUserDN(this.token);
            }
            if (this.userId == null) {
                this.userId = DN.isDN(this.token) ? this.DNtoName(this.token) : this.token;
            }
            String string2 = null;
            if (this.oldAuthContext != null) {
                string2 = AuthUtils.getLoginState(this.oldAuthContext).getUserDN();
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("userDN is : " + this.userDN);
                AuthD.debug.message("oldUserDN is : " + string2);
                AuthD.debug.message("sessonUpgrade is : " + this.sessionUpgrade);
            }
            if (this.sessionUpgrade && string2 != null && this.userDN.equalsIgnoreCase(string2)) {
                this.sessionUpgrade();
            } else {
                this.sessionUpgrade = false;
            }
            Date date = new Date();
            string = null;
            try {
                string = SAMLUtils.dateToString(date);
            }
            catch (ParseException parseException) {
                if (!AuthD.debug.messageEnabled()) break block23;
                AuthD.debug.message("Error getting authInstant ", (Throwable)parseException);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setSessionProperties userDN = " + this.userDN + "\n" + "token = " + this.token + "\n" + "client = " + this.client + "\n" + "orgDN = " + this.orgDN + "\n" + "locale = " + this.localeContext.getLocale() + "\n" + "charset = " + this.localeContext.getMIMECharset() + "\n" + "idleTime = " + this.idleTime + "\n" + "cacheTime = " + this.cacheTime + "\n" + "maxSession = " + this.maxSession + "\n" + "authLevel = " + this.authLevel + "\n" + "authMethName = " + this.authMethName + "\n" + "Subject = " + this.subject.toString() + "\n" + "cookieSupport = " + this.cookieSupport + "\n" + "principals= " + this.principalList + "\n" + "IndexType= " + this.indexType + "\n" + "AuthInstant = " + string);
        }
        try {
            if (this.isApplicationModule() && ad.isSpecialUser(this.userDN) || this.isAgent(this.userDN)) {
                AuthD.debug.message("setSessionProperties for non-expiring session");
                internalSession.setClientID(this.token);
                internalSession.setExpire(false);
                internalSession.setType(1);
            } else {
                AuthD.debug.message("request: in putProperty stuff");
                internalSession.setClientID(this.userDN);
                internalSession.setMaxSessionTime((long)this.maxSession);
                internalSession.setMaxIdleTime((long)this.idleTime);
                internalSession.setMaxCachingTime((long)this.cacheTime);
            }
            internalSession.setClientDomain(this.orgDN);
            internalSession.setType(0);
            if (this.client != null) {
                internalSession.putProperty("Host", this.client);
            }
            if (!this.sessionUpgrade) {
                internalSession.putProperty("AuthLevel", new Integer(this.authLevel).toString());
                internalSession.putProperty("AuthType", this.authMethName);
            }
            internalSession.putProperty("Principal", this.userDN);
            internalSession.putProperty("UserId", this.token);
            internalSession.putProperty("UserToken", this.DNtoName(this.token));
            internalSession.putProperty("Organization", this.orgDN);
            internalSession.putProperty("Locale", this.localeContext.getLocale().toString());
            internalSession.putProperty("CharSet", this.localeContext.getMIMECharset());
            internalSession.putProperty("clientType", this.clientType);
            internalSession.putProperty("cookieSupport", this.cookieSupport);
            internalSession.putProperty("authInstant", string);
            internalSession.putProperty("Principals", this.principalList);
            if (this.loginURL != null) {
                int n = this.loginURL.indexOf("?");
                String string3 = this.loginURL;
                if (n != -1) {
                    string3 = this.loginURL.substring(0, n);
                }
                internalSession.putProperty("loginURL", string3);
            }
            if (this.indexType != null) {
                internalSession.putProperty("IndexType", this.indexType.toString());
            }
            if (this.indexType == AuthContext.IndexType.ROLE && this.indexName != null && !this.sessionUpgrade) {
                internalSession.putProperty("Role", this.indexName);
            }
            if (this.indexType == AuthContext.IndexType.SERVICE && this.indexName != null && !this.sessionUpgrade) {
                internalSession.putProperty("Service", this.indexName);
            }
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception in setSession ", (Throwable)exception);
            throw new AuthException(exception);
        }
    }

    public boolean getInetDomainStatus() {
        return this.inetDomainStatus;
    }

    public void setQueryOrg(String string) {
        this.queryOrg = string;
    }

    public String getQueryOrg() {
        return this.queryOrg;
    }

    public String getLocale() {
        if (this.isRemote) {
            return AuthD.platLocale;
        }
        return this.localeContext.getLocale().toString();
    }

    void destroySession() {
        if (this.sess != null) {
            SessionID sessionID = this.sess.getID();
            ad.destroySession(sessionID);
            this.sid = null;
            this.sess = null;
            AuthUtils.removeSessionFromHash(sessionID);
        }
    }

    String DNtoName(String string) {
        String string2 = null;
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        string2 = n2 == -1 ? string.substring(n + 1).trim() : string.substring(n + 1, n2).trim();
        return string2;
    }

    public void persistentCookieArgExists() {
        String string = (String)this.requestHash.get("iPSPCookie");
        if (string != null && !string.equals("")) {
            this.persistentCookieOn = string.equalsIgnoreCase("yes");
        }
    }

    public SessionID getSid() {
        return this.sess.getID();
    }

    public String getUserDomain(HttpServletRequest httpServletRequest, SessionID sessionID, Hashtable hashtable) {
        String string = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (!this.sessionUpgrade && !hashtable.isEmpty() && sSOTokenManager.isValidToken(sSOToken)) {
                string = sSOToken.getProperty("Organization");
                AuthD.debug.message("User org from existing valid session");
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("ERROR in getUserDomain - " + exception.toString());
        }
        if (string == null) {
            string = AuthUtils.newSessionArgExists(hashtable, sessionID) && sessionID.toString().length() > 0 ? sessionID.getSessionDomain() : ad.getDomainNameByRequest(httpServletRequest, hashtable);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("returning from getUserDomain : " + string);
        }
        return string;
    }

    public AuthContextLocal createAuthContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionID sessionID, Hashtable hashtable) throws AuthException {
        StringBuffer stringBuffer = new StringBuffer(serviceURI);
        String string = httpServletRequest.getQueryString();
        String string2 = this.getDecodedQueryString(hashtable, string);
        if (string2 != null && !string2.equals("")) {
            stringBuffer.append("?");
            stringBuffer.append(string2);
        }
        this.loginURL = stringBuffer.toString();
        this.setRequestLocale(httpServletRequest);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("locale : " + this.localeContext.getLocale());
        }
        this.userOrg = this.getUserDomain(httpServletRequest, sessionID, hashtable);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("createAuthContext: userOrg is : " + this.userOrg);
        }
        if (this.userOrg == null || this.userOrg.equals("")) {
            AuthD.debug.message("domain is null, error condtion");
            this.logFailed(LoginState.ad.bundle.getString("invalidDomain"));
            throw new AuthException("108", null);
        }
        AuthD.debug.message("AuthUtil:getAuthContext:Creating new AuthContextLocal & LoginState");
        AuthContextLocal authContextLocal = new AuthContextLocal(this.userOrg);
        this.requestType = true;
        this.servletRequest = httpServletRequest;
        this.servletResponse = httpServletResponse;
        this.requestHash = hashtable;
        this.client = this.getClient();
        this.sid = sessionID;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("requestType : " + this.requestType);
            AuthD.debug.message("client : " + this.client);
            AuthD.debug.message("sid : " + sessionID);
        }
        try {
            this.createSession(httpServletRequest, authContextLocal);
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception creating session .. :", (Throwable)exception);
            throw new AuthException(exception);
        }
        this.cookieSupport = ad.getCookieSupport(this.getClientType());
        this.cookieDetect = ad.getCookieDetect(this.cookieSupport);
        if (this.cookieSupport != null && this.cookieSupport.equals("false")) {
            this.cookieSupported = false;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("cookieSupport is : " + this.cookieSupport);
            AuthD.debug.message("cookieDetect is .. : " + this.cookieDetect);
            AuthD.debug.message("cookieSupported is .. : " + this.cookieSupported);
        }
        if (ad.isClientDetectionEnabled() && this.cookieDetect) {
            this.cookieSet = true;
        }
        this.setGoToURL();
        this.setGoToOnFailURL();
        this.persistentCookieArgExists();
        this.populateOrgProfile();
        return authContextLocal;
    }

    boolean createSession(HttpServletRequest httpServletRequest, AuthContextLocal authContextLocal) throws AuthException {
        SessionID sessionID;
        String string = this.getOrgDN();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState: createSession: orgDN is.. :" + string);
        }
        HttpSession httpSession = null;
        if (httpServletRequest != null && isHttpSessionEnabled) {
            httpSession = httpServletRequest.getSession(true);
        }
        AuthD.debug.message("LoginState: createSession: Creating new session: ");
        InternalSession internalSession = ad.newSession(string, httpSession);
        if (internalSession == null) {
            AuthD.debug.error("Session is null");
            throw new AuthException("115", null);
        }
        this.sid = sessionID = internalSession.getID();
        AuthUtils.authContextHash.put(sessionID, authContextLocal);
        this.sess = internalSession;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthUtil: createSession: New session: sid=" + sessionID);
            AuthD.debug.message("Sess is. :" + internalSession);
        }
        return true;
    }

    public SSOToken getSSOToken() throws SSOException {
        if (this.ssoToken != null) {
            return this.ssoToken;
        }
        if (this.sess != null && this.sess.getState() == 2) {
            return null;
        }
        try {
            this.ssoManager = SSOTokenManager.getInstance();
            this.ssoToken = this.ssoManager.createSSOToken(this.sess.getID().toString());
            return this.ssoToken;
        }
        catch (SSOException sSOException) {
            AuthD.debug.error("Error retrieving SSOToken :", (Throwable)sSOException);
            throw new SSOException("amAuth", "102", null);
        }
    }

    public String encodeURL(String string, HttpServletResponse httpServletResponse) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("in encodeURL");
            AuthD.debug.message("cookieDetect : " + this.cookieDetect);
            AuthD.debug.message("cookieSupported : " + this.cookieSupported);
        }
        if (!this.cookieDetect && this.cookieSupported) {
            return string;
        }
        if (this.sess == null) {
            return string;
        }
        String string2 = string;
        string2 = urlRewriteInPath ? this.sess.encodeURL(string, (short)2, false) : this.sess.encodeURL(httpServletResponse, string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthRequest encodeURL : URL=" + string + ", Rewritten URL=" + string2);
        }
        return string2;
    }

    public String getFileName(String string) {
        return this.getFileName(string, null);
    }

    public String getFileName(String string, String string2) {
        String string3;
        String string4 = this.localeContext.getLocale().toString();
        String string5 = string;
        String string6 = this.getClientType();
        String string7 = "/default";
        if (string2 == null) {
            string2 = templateDir == null ? LoginState.getTemplateDir() : templateDir;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Client Type is : " + string6);
        }
        String string8 = this.getOrgName();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("org is : " + string8);
        }
        if (string8 != null) {
            string3 = this.DNtoName(rootSuffix);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("rootOrgName is : " + string3);
            }
            if (string3 != null) {
                string7 = "/" + string3;
            }
        }
        try {
            String string9;
            string3 = null;
            if (this.orgDN != null && this.orgDN != rootSuffix && this.orgDN.endsWith(rootSuffix)) {
                int n = rootSuffix.length();
                int n2 = this.orgDN.length();
                int n3 = n2 - n;
                if (n3 > 0) {
                    string3 = this.orgDN.substring(0, n3 - 1);
                }
            }
            String string10 = this.getFilePath();
            String string11 = this.getOrgFilePath(string3);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Calling FileLookup : filename=" + string + ", domain=" + string7 + ", locale : " + string4 + ", filePath=" + string10 + ", filename=" + string5 + ", templateDir=" + string2 + ", orgPath : " + string11);
            }
            File file = null;
            if (!string6.equals(ad.getDefaultClient())) {
                string9 = this.getCharsetFileName(string5);
                file = FileLookup.getFirstExisting((String)string7, (String)this.localeContext.getLocale().toString(), null, (String)string11, (String)string10, (String)string9, (String)string2, (boolean)true);
            }
            if (file == null) {
                file = FileLookup.getFirstExisting((String)string7, (String)string4, null, (String)string11, (String)string10, (String)string5, (String)string2, (boolean)true);
            }
            string9 = file.getPath();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("File is.. " + string9);
            }
            return string9;
        }
        catch (FileLookupException fileLookupException) {
            if (AuthD.debug.warningEnabled()) {
                AuthD.debug.warning("File Lookup Exception", (Throwable)fileLookupException);
            }
            return string2 + "/" + "default" + "/" + string5;
        }
        catch (Exception exception) {
            if (AuthD.debug.warningEnabled()) {
                AuthD.debug.warning("Exception in getFileName", (Throwable)exception);
            }
            return string2 + "/" + "default" + "/" + string5;
        }
    }

    private String getCharsetFileName(String string) {
        String string2 = this.localeContext.getMIMECharset();
        if (string == null) {
            return null;
        }
        int n = string.indexOf(".");
        String string3 = null;
        string3 = n != -1 ? string.substring(0, n) + "_" + string2 + string.substring(n) : string + "_" + string2;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("charsetFilename is : " + string3);
        }
        return string3;
    }

    public boolean createUserProfile(String string, Set set) {
        this.userName = string;
        try {
            Object object;
            Object object2;
            if (!this.dynamicProfileCreation) {
                AuthD.debug.message("Error this user requires a profile to login");
                return false;
            }
            if (this.isApplicationModule()) {
                AuthD.debug.message("No profile created for Application module");
                return false;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Creating user entry: " + string);
                AuthD.debug.message("aliasList : " + set);
            }
            AMPeopleContainer aMPeopleContainer = ad.getPeopleContainer(this.userContainerDN);
            HashSet<String> hashSet = new HashSet<String>();
            String string2 = null;
            string2 = DN.isDN(string) ? this.DNtoName(string) : string;
            hashSet.add(string2);
            Set set2 = null;
            if (this.userCreationAttributes == null) {
                set2 = aMPeopleContainer.createUsers(hashSet);
            } else {
                object2 = new HashMap<String, HashMap>();
                object2.put(string2, this.userCreationAttributes);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("userMap is : " + object2);
                }
                set2 = aMPeopleContainer.createUsers((Map)object2);
            }
            object2 = (AMUser)set2.iterator().next();
            if (this.defaultRoles != null && !this.defaultRoles.isEmpty()) {
                object = this.defaultRoles.iterator();
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    if (!Misc.isDescendantOf((String)string3, (String)this.orgDN)) {
                        AuthD.debug.error("createUserProfile: role " + string3 + " does not belong to org " + this.orgDN);
                        continue;
                    }
                    try {
                        if (string3.length() == 0) continue;
                        object2.assignRole(string3);
                    }
                    catch (Exception exception) {
                        AuthD.debug.message("createUserProfile():invalid role: ", (Throwable)exception);
                    }
                }
            }
            if (set != null && !set.isEmpty()) {
                AuthD.debug.message("Adding alias list to user profile");
                object = new HashMap();
                if (this.externalAliasList != null && !this.externalAliasList.isEmpty()) {
                    set.addAll(this.externalAliasList);
                }
                object.put("iplanet-am-user-alias-list", set);
                object2.setAttributes((Map)object);
                object2.store();
            } else {
                AuthD.debug.message("Aliast list is empty");
            }
            this.userDN = object2.getDN();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Newly created USER DN is : " + this.userDN);
            }
            object = object2.getAttributes();
            this.populateUserAttributes((Map)object, true, null);
            return true;
        }
        catch (Exception exception) {
            block17: {
                AuthD.debug.error("Cannot create user profile for: " + string);
                if (!AuthD.debug.messageEnabled()) break block17;
                AuthD.debug.message("Stack trace: ", (Throwable)exception);
            }
            return false;
        }
    }

    void populateUserAttributes(Map map, boolean bl, AMEntity aMEntity) throws AMException {
        try {
            this.userPostLoginClassName = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-post-login-process-class");
            if (!bl) {
                this.userFailureURLSet = (Set)map.get("iplanet-am-user-failure-url");
                this.clientUserFailureURL = this.getRedirectUrl(this.userFailureURLSet);
                this.defaultUserFailureURL = this.tempDefaultURL;
                this.failureRoleURLSet = (Set)map.get("iplanet-am-auth-login-failure-url");
                this.clientFailureRoleURL = this.getRedirectUrl(this.failureRoleURLSet);
                this.defaultFailureRoleURL = this.tempDefaultURL;
                return;
            }
            this.maxSession = Misc.getIntMapAttr((Map)map, (String)"iplanet-am-session-max-session-time", (String)ad.getDefaultMaxSessionTime(), (Debug)AuthD.debug);
            this.idleTime = Misc.getIntMapAttr((Map)map, (String)"iplanet-am-session-max-idle-time", (String)ad.getDefaultMaxIdleTime(), (Debug)AuthD.debug);
            this.cacheTime = Misc.getIntMapAttr((Map)map, (String)"iplanet-am-session-max-caching-time", (String)ad.getDefaultMaxCachingTime(), (Debug)AuthD.debug);
            String string = Misc.getMapAttr((Map)map, (String)"inetuserstatus", (String)"active");
            if (aMEntity != null) {
                string = aMEntity.isActivated() ? "active" : "inactive";
            }
            String string2 = Misc.getMapAttr((Map)map, (String)"iplanet-am-user-login-status", (String)"active");
            String string3 = Misc.getMapAttr((Map)map, (String)"nsaccountlock", (String)"false");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("entity status is : " + string);
                AuthD.debug.message("user-login-status is : " + string2);
                AuthD.debug.message("nsaccountlock is : " + string3);
            }
            if (!(string2.equalsIgnoreCase("active") && string.equalsIgnoreCase("active") && string3.equalsIgnoreCase("false"))) {
                this.userEnabled = false;
            }
            String string4 = Misc.getMapAttr((Map)map, (String)"preferredlocale", null);
            this.localeContext.setUserLocale(string4);
            this.userAliasList = (Set)map.get("iplanet-am-user-alias-list");
            if (this.aliasAttrNames != null && !this.aliasAttrNames.isEmpty()) {
                Iterator iterator = this.aliasAttrNames.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    Set set = (Set)map.get(string5);
                    if (set == null) continue;
                    if (this.userAliasList == null) {
                        this.userAliasList = new HashSet();
                    }
                    this.userAliasList.addAll(set);
                }
            }
            this.accountLife = Misc.getMapAttr((Map)map, (String)"iplanet-am-user-account-life");
            this.userSuccessURLSet = (Set)map.get("iplanet-am-user-success-url");
            this.clientUserSuccessURL = this.getRedirectUrl(this.userSuccessURLSet);
            this.defaultUserSuccessURL = this.tempDefaultURL;
            this.successRoleURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
            this.clientSuccessRoleURL = this.getRedirectUrl(this.successRoleURLSet);
            this.defaultSuccessRoleURL = this.tempDefaultURL;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Populate User attributes\n  idle->" + this.idleTime + "\n  cache->" + this.cacheTime + "\n  max->" + this.maxSession + "\n  userLoginEnabled->" + this.userEnabled + "\n  charset->" + this.localeContext.getMIMECharset() + "\n  locale->" + this.localeContext.getLocale().toString() + "\n  userAlias->  :" + this.userAliasList + "\n  userSuccessURLSet-> :" + this.userSuccessURLSet + "\n  clientUserSuccessURL->  :" + this.clientUserSuccessURL + "\n  defaultUserSuccessURL->  :" + this.defaultUserSuccessURL + "\n  userFailureURLSet-> :" + this.userFailureURLSet + "\n  clientUserFailureURL->  :" + this.clientUserFailureURL + "\n  defaultUserFailureURL->  :" + this.defaultUserFailureURL + "\n  clientSuccessRoleURL ->  :" + this.clientSuccessRoleURL + "\n  defaultSuccessRoleURL ->  :" + this.defaultSuccessRoleURL + "\n  clientFailureRoleURL ->  :" + this.clientFailureRoleURL + "\n  defaultFailureRoleURL ->  :" + this.defaultFailureRoleURL + "\n  userPostLoginClassName -> : " + this.userPostLoginClassName + "\n  accountLife->" + this.accountLife);
            }
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Eception in populateUserAttributes : ", (Throwable)exception);
            }
            throw new AMException(exception.getMessage(), exception.toString());
        }
    }

    public boolean getUserProfile(String string, boolean bl) throws AuthException {
        try {
            return this.getUserProfile(string, bl, true);
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("getUserProfile(string,boolean)", (Throwable)exception);
            }
            throw new AuthException(exception);
        }
    }

    public boolean getUserProfile(String string, boolean bl, boolean bl2) throws AuthException {
        block39: {
            block37: {
                if (string == null || string.length() == 0) {
                    throw new AuthException("102", null);
                }
                this.dnByUserContainer = false;
                this.userDN = this.tokenToDN(string);
                this.userId = string;
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("In getUserProfile : token = " + string + " userDN = " + this.userDN);
                }
                try {
                    if (getUser) {
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("Getting user profile: " + this.userDN);
                        }
                        if (!this.nullUserContainerDN || !this.dnByUserContainer) {
                            this.amEntity = ad.getSDK().getEntity(this.userDN);
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("amEntity is.. :" + this.amEntity);
                            }
                            if (bl) {
                                Map map = this.amEntity.getAttributes(userAttributes);
                                this.populateUserAttributes(map, bl2, this.amEntity);
                            }
                            return true;
                        }
                        break block37;
                    }
                    if (bl) {
                        this.populateDefaultUserAttributes();
                    }
                    return true;
                }
                catch (Exception exception) {
                    if (ad.isSuperAdmin(string)) {
                        AuthD.debug.message("User is in the super admin list, no profile is ok");
                        return false;
                    }
                    if (!AuthD.debug.messageEnabled()) break block37;
                    AuthD.debug.message("No profile for user in default container", (Throwable)exception);
                }
            }
            try {
                String string2;
                Object object;
                String string3;
                AMSearchResults aMSearchResults;
                AMSearchControl aMSearchControl;
                block38: {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("In getUserProfile : Search for user " + string);
                    }
                    aMSearchControl = new AMSearchControl();
                    aMSearchControl.setSearchScope(2);
                    Set set = this.mergeSet(this.aliasAttrNames, userAttributes);
                    aMSearchControl.setReturnAttributes(set);
                    aMSearchControl.setMaxResults(2);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("alias attr=" + this.aliasAttrNames + ", attr=" + userAttributes + ",merge=" + set);
                    }
                    aMSearchResults = null;
                    string3 = string;
                    if (DN.isDN(string)) {
                        string3 = this.DNtoName(string);
                    }
                    try {
                        if (this.agentContainerDN != null && !this.agentContainerDN.equals("")) {
                            object = ad.getSDK().getOrganizationalUnit(this.agentContainerDN);
                            if (this.aliasAttrNames == null || this.aliasAttrNames.isEmpty()) {
                                if (AuthD.debug.messageEnabled()) {
                                    AuthD.debug.message("OrgUnit Search for user " + string3);
                                }
                                aMSearchResults = object.searchEntities(string3, null, null, aMSearchControl);
                            } else {
                                string2 = LoginState.constructFilter(this.toAvPairMap(this.aliasAttrNames, string3));
                                if (AuthD.debug.messageEnabled()) {
                                    AuthD.debug.message("OrgUnit Search for Filter " + string2);
                                }
                                aMSearchResults = object.searchEntities("*", aMSearchControl, string2, null);
                            }
                        }
                    }
                    catch (AMException aMException) {
                        if (!AuthD.debug.messageEnabled()) break block38;
                        AuthD.debug.message("OrganizationalUnit Search Error:" + aMException.toString());
                    }
                }
                if (aMSearchResults == null && this.userContainerDN != null && !this.userContainerDN.equals("")) {
                    object = null;
                    if (this.userOrgDN != null && !this.userOrgDN.equals("")) {
                        AuthD.debug.message("Search is based on userOrgDN");
                        object = ad.getSDK().getPeopleContainer(this.userOrgDN);
                    } else {
                        object = ad.getSDK().getPeopleContainer(this.userContainerDN);
                    }
                    if (this.aliasAttrNames == null || this.aliasAttrNames.isEmpty()) {
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("PeopleContainer Search for user " + string3);
                        }
                        aMSearchResults = object.searchEntities(string3, null, null, aMSearchControl);
                    } else {
                        string2 = LoginState.constructFilter(this.toAvPairMap(this.aliasAttrNames, string3));
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("PeopleContainer Search for Filter " + string2);
                        }
                        aMSearchResults = object.searchEntities("*", aMSearchControl, string2, null);
                    }
                }
                if (aMSearchResults == null) {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("No user Profile found for " + string3);
                    }
                    return false;
                }
                object = aMSearchResults.getResultAttributes();
                if (object == null || object.isEmpty()) {
                    return false;
                }
                if (object.size() > 1) {
                    AuthD.debug.error("getUserProfile : Multiple matches found for user '" + this.userId + "' in org " + this.orgDN + "\nPlease make sure user is unique within the login " + "organization, and contact your admin to fix the problem");
                    throw new AuthException("102", null);
                }
                string2 = (String)object.keySet().iterator().next();
                this.amEntity = ad.getSDK().getEntity(string2);
                this.userDN = this.amEntity.getDN();
                this.userId = this.DNtoName(this.userDN);
                this.setToken(this.userId);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("userDN is : " + this.userDN);
                    AuthD.debug.message("userID(token) is : " + this.userId);
                    AuthD.debug.message("token is : " + string);
                }
                if (bl) {
                    this.populateUserAttributes((Map)object.get(string2), bl2, this.amEntity);
                }
                return true;
            }
            catch (SSOException sSOException) {
                AuthD.debug.error("SSOException");
                if (!AuthD.debug.messageEnabled()) break block39;
                AuthD.debug.message("Stack trace: ", (Throwable)sSOException);
            }
            catch (AMException aMException) {
                AuthD.debug.error("No aliases for: " + this.aliasAttrNames + "=" + string);
                if (!AuthD.debug.messageEnabled()) break block39;
                AuthD.debug.message("Stack trace: ", (Throwable)aMException);
            }
        }
        return false;
    }

    public void populateDefaultUserAttributes() throws AMException {
        try {
            this.maxSession = Integer.parseInt(ad.getDefaultMaxSessionTime());
        }
        catch (Exception exception) {
            this.maxSession = 120;
        }
        try {
            this.idleTime = Integer.parseInt(ad.getDefaultMaxIdleTime());
        }
        catch (Exception exception) {
            this.idleTime = 30;
        }
        try {
            this.cacheTime = Integer.parseInt(ad.getDefaultMaxCachingTime());
        }
        catch (Exception exception) {
            this.cacheTime = 3;
        }
        this.userEnabled = true;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Populate Default User attributes\n  idle->" + this.idleTime + "\n  cache->" + this.cacheTime + "\n  max->" + this.maxSession + "\n  userLoginEnabled->" + this.userEnabled + "\n  clientUserSuccessURL ->" + this.clientUserSuccessURL + "\n  defaultUserSuccessURL ->" + this.defaultUserSuccessURL + "\n  clientUserFailureURL ->" + this.clientUserFailureURL + "\n  defaultUserFailureURL ->" + this.defaultUserFailureURL + "\n  clientSuccessRoleURL ->" + this.clientSuccessRoleURL + "\n  defaultSuccessRoleURL ->" + this.defaultSuccessRoleURL + "\n  clientFailureRoleURL ->" + this.clientFailureRoleURL + "\n  defaultFailureRoleURL ->" + this.defaultFailureRoleURL + "\n  userPostLoginClassName ->" + this.userPostLoginClassName + "\n  charset->" + this.localeContext.getMIMECharset() + "\n  locale->" + this.localeContext.getLocale().toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean searchUserProfile(Subject subject, AuthContext.IndexType indexType, String string) throws AuthException {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("in searchUserProfile");
            AuthD.debug.message("indexType is.. :" + indexType);
            AuthD.debug.message("indexName is.. :" + string);
            AuthD.debug.message("Subject is.. :" + subject);
            AuthD.debug.message("token is.. :" + this.token);
            AuthD.debug.message("tokenSet is.. :" + this.tokenSet);
            AuthD.debug.message("pCookieUserName is.. :" + this.pCookieUserName);
        }
        try {
            this.tokenSet = this.getTokenFromPrincipal(subject);
            Iterator iterator = this.tokenSet.iterator();
            boolean bl = true;
            if (this.ignoreUserProfile || this.principalList.startsWith("amService-")) {
                this.token = this.tokenSet.size() == 1 ? this.principalList : this.principalList.substring(0, this.principalList.indexOf("|"));
                if (DN.isDN(this.token)) {
                    this.userId = this.DNtoName(this.token);
                    this.userDN = this.token;
                } else {
                    this.userId = this.token;
                    this.userDN = this.getUserDN(this.token);
                }
                this.populateDefaultUserAttributes();
                return true;
            }
            if (indexType == AuthContext.IndexType.USER || this.pCookieUserName != null) {
                Map map;
                if (this.token == null && this.pCookieUserName != null) {
                    this.token = this.pCookieUserName;
                }
                if (this.token == null) {
                    return false;
                }
                if (DN.isDN(this.token)) {
                    this.token = this.DNtoName(this.token);
                }
                if (!this.checkAliasList(map = this.searchUserAliases(this.token, this.tokenSet))) {
                    if (!this.dynamicProfileCreation) throw new AuthException("107", null);
                    this.addAliasToUserProfile(this.token, map);
                }
            } else {
                boolean bl2 = true;
                if (this.tokenSet.isEmpty()) {
                    AuthD.debug.message("tokenset empty");
                    throw new AuthException("102", null);
                }
                if (this.tokenSet.size() == 1) {
                    AuthD.debug.message("tokenset size is 1");
                    this.token = (String)iterator.next();
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("principal is : " + this.principalList);
                    }
                    bl = this.getCreateUserProfile(this.principalList, true);
                    if (!this.userEnabled) {
                        this.setFailedUserId(this.DNtoName(this.token));
                        throw new AuthException("104", null);
                    }
                    if (ad.isSuperAdmin(this.principalList)) {
                        this.userDN = this.principalList;
                        return true;
                    }
                    if (bl && indexType == AuthContext.IndexType.ROLE) {
                        boolean bl3 = this.getUserForRole(this.getRoleDN(string, this.orgDN));
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("userRoleFound: " + bl3);
                        }
                        if (!bl3) {
                            throw new AuthException("113", null);
                        }
                    }
                } else {
                    AuthD.debug.message("came here !! multiple modules , users ");
                    String string2 = null;
                    bl = false;
                    boolean bl4 = false;
                    boolean bl5 = true;
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    HashMap<String, Boolean> hashMap2 = new HashMap<String, Boolean>();
                    Map map = new HashMap();
                    HashMap<String, Boolean> hashMap3 = new HashMap<String, Boolean>();
                    Boolean bl6 = Boolean.FALSE;
                    String string3 = null;
                    while (iterator.hasNext()) {
                        this.token = (String)iterator.next();
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("BEGIN WHILE: Token is.. : " + this.token);
                        }
                        bl = this.getUserProfile(this.token, true);
                        hashMap3.put(this.token, new Boolean(bl));
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("gotUserProfile : " + bl);
                        }
                        if (ad.isSuperAdmin(this.tokenToDN(this.token))) {
                            this.hasAdminToken = true;
                            string3 = this.token;
                            break;
                        }
                        if (!bl) continue;
                        if (string2 == null) {
                            string2 = this.token;
                        }
                        hashMap.put(this.token, new Boolean(this.userEnabled));
                        if (indexType == AuthContext.IndexType.ROLE) {
                            bl5 = this.getUserForRole(this.getRoleDN(string, this.orgDN));
                            hashMap2.put(this.token, new Boolean(bl5));
                        }
                        if (!(bl4 = this.getFoundUserAlias(map = this.searchUserAliases(this.token, this.tokenSet)))) continue;
                        string3 = this.token;
                        if (!AuthD.debug.messageEnabled()) break;
                        AuthD.debug.message("found aliases exiting while:" + map);
                        break;
                    }
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("Alias Token is : " + string3);
                        AuthD.debug.message("Profile Token :" + string2);
                        AuthD.debug.message("Token is : " + this.token);
                    }
                    if (string3 != null) {
                        this.token = string3;
                    }
                    if (!this.hasAdminToken) {
                        boolean bl7 = this.getUserEnabled(hashMap);
                        if (!bl7) {
                            this.setFailedUserId(this.DNtoName(this.token));
                            throw new AuthException("104", null);
                        }
                        if (indexType == AuthContext.IndexType.ROLE) {
                            bl5 = this.getUserRoleFound(hashMap2);
                            if (!bl5) {
                                throw new AuthException("113", null);
                            }
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("userRoleFound:" + bl5);
                            }
                        }
                        bl = this.getGotUserProfile(hashMap3);
                        if (AuthD.debug.messageEnabled()) {
                            AuthD.debug.message("userEnabled : " + bl7);
                        }
                        if (bl && !bl4) {
                            if (!this.dynamicProfileCreation) throw new AuthException("107", null);
                            if (AuthD.debug.messageEnabled()) {
                                AuthD.debug.message("dynamicProfileCreation : " + this.dynamicProfileCreation);
                                AuthD.debug.message("foundUserAliasMap : " + map);
                                AuthD.debug.message("foundUserAliasMap : " + bl4);
                            }
                            this.addAliasToUserProfile(string2, map);
                        }
                        if (!bl) {
                            bl = this.createUserProfileForTokens(this.tokenSet, hashMap3);
                        }
                    }
                }
            }
            if (!AuthD.debug.messageEnabled()) return bl;
            AuthD.debug.message("LoginState:searchUserProfile:returning: " + bl);
            return bl;
        }
        catch (AuthException authException) {
            throw new AuthException((Throwable)((Object)authException));
        }
        catch (Exception exception) {
            AuthD.debug.error("Error retrieving profile", (Throwable)exception);
            throw new AuthException(exception);
        }
    }

    boolean getCreateUserProfile(String string, boolean bl) throws AuthException {
        boolean bl2;
        boolean bl3 = true;
        boolean bl4 = this.getUserProfile(string, bl);
        boolean bl5 = ad.isSuperAdmin(string);
        if (!(bl4 || bl5 || (bl2 = this.createUserProfile(string, null)))) {
            bl3 = false;
        }
        return bl3;
    }

    /*
     * Unable to fully structure code
     */
    boolean createUserProfileForTokens(Set var1_1, Map var2_2) {
        var3_3 = new HashSet<E>();
        var4_4 = null;
        var5_5 = var1_1.iterator();
        while (var5_5.hasNext()) {
            var4_4 = (String)var5_5.next();
            if (!LoginState.ad.isSuperAdmin(var4_4)) ** GOTO lbl15
            break;
lbl-1000:
            // 1 sources

            {
                var6_6 = var5_5.next();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("alias list add token:" + (String)var6_6);
                }
                var3_3.add(var6_6);
lbl15:
                // 2 sources

                ** while (var5_5.hasNext())
            }
lbl16:
            // 1 sources

        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Tokens List is.. :" + var3_3);
        }
        try {
            var6_7 = this.createUserProfile(var4_4, var3_3);
            return var6_7;
        }
        catch (Exception var6_8) {
            AuthD.debug.error("Cannot create user profile for: " + var4_4);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Stack trace: ", (Throwable)var6_8);
            }
            return false;
        }
    }

    Map searchUserAliases(String string, Set set) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        String string2 = string;
        if (DN.isDN(string)) {
            string2 = this.DNtoName(string);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("userAliastList is.. :" + this.userAliasList);
            AuthD.debug.message("userTokenDN is.. :" + string);
            AuthD.debug.message("userToken is.. :" + string2);
            AuthD.debug.message("tokenSet is.. :" + set);
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (this.userAliasList != null && !this.userAliasList.isEmpty()) {
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("AuthToken is : " + string3);
                        AuthD.debug.message("userTokenDN is : " + string);
                    }
                    if (string3 != null && string3.equalsIgnoreCase(string2) && !hashMap.containsKey(string3)) {
                        hashMap.put(string3, Boolean.TRUE);
                        continue;
                    }
                    if (this.userAliasList.contains(string3)) {
                        hashMap.put(string3, Boolean.TRUE);
                        continue;
                    }
                    hashMap.put(string3, Boolean.FALSE);
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase(string2)) {
                    hashMap.put(string3, Boolean.TRUE);
                    continue;
                }
                hashMap.put(string3, Boolean.FALSE);
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("searchUserAliases: foundUserAliasMap : " + hashMap);
            }
        }
        return hashMap;
    }

    Set getTokenFromPrincipal(Subject subject) {
        Object object;
        Set<Principal> set = subject.getPrincipals();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Principal> iterator = set.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        String string = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            string = object.getName();
            if (string != null && !this.containsToken(stringBuffer, string)) {
                stringBuffer.append(string).append("|");
            }
            if (DN.isDN(string)) {
                hashSet.add(this.DNtoName(string));
            } else {
                hashSet.add(string);
            }
            if (!AuthD.debug.messageEnabled()) continue;
            AuthD.debug.message("principal name is... :" + string);
        }
        object = stringBuffer.toString();
        if (object != null && ((String)object).length() > 0) {
            this.principalList = ((String)object).substring(0, ((String)object).length() - 1);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Principal List is :" + this.principalList);
        }
        return hashSet;
    }

    public boolean isUserEnabled() {
        return this.userEnabled;
    }

    public void setAuthLevel(String string) {
        if (string == null) {
            this.authLevel = 0;
        } else {
            try {
                this.authLevel = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.authLevel = 0;
            }
        }
        if (this.authLevel < this.moduleAuthLevel) {
            this.authLevel = this.moduleAuthLevel;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("AuthLevel is set to : " + this.authLevel);
        }
    }

    public void setAuthRoleName(String string) {
        this.role = string;
    }

    public String getRoleDN(String string, String string2) {
        this.role = string;
        if (this.roleDN == null) {
            this.roleDN = this.roleToDN(this.role, string2);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Role dn is.. :" + this.roleDN);
        }
        return this.roleDN;
    }

    String roleToDN(String string, String string2) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("rolename : " + string);
        }
        if (string == null) {
            return null;
        }
        Object var3_3 = null;
        String string3 = null;
        try {
            AMStoreConnection aMStoreConnection = ad.getSDK();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string2);
            string3 = this.searchRole(aMOrganization, string);
        }
        catch (Exception exception) {
            AuthD.debug.error("getRole: Error : ", (Throwable)exception);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Role is .. : " + string3);
        }
        return string3;
    }

    String searchRole(AMOrganization aMOrganization, String string) {
        String string2;
        block4: {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("in getRoleName org : " + aMOrganization);
                AuthD.debug.message("in getRoleName role: " + string);
            }
            string2 = null;
            try {
                Set set = aMOrganization.searchAllRoles(string, 2);
                Iterator iterator = set.iterator();
                string2 = (String)iterator.next();
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block4;
                AuthD.debug.message("Error getRoleName : ", (Throwable)exception);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginState:searchRole" + string2);
        }
        return string2;
    }

    public void setAuthModuleName(String string) {
        this.authMethName = this.pAuthMethName != null ? this.pAuthMethName + "|" + string : string;
    }

    public boolean getUserForRole(String string) {
        String string2 = null;
        boolean bl = true;
        try {
            Object object;
            AMStoreConnection aMStoreConnection = ad.getSDK();
            int n = aMStoreConnection.getAMObjectType(string);
            Set set = null;
            if (n == 8) {
                object = aMStoreConnection.getFilteredRole(string);
                set = object.searchUsers(this.token, 2);
            } else {
                object = aMStoreConnection.getRole(string);
                set = object.searchUsers(this.token, 2);
            }
            if (set == null || set.isEmpty()) {
                return false;
            }
            object = set.iterator();
            string2 = (String)object.next();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("searchUser :Val is.. : " + string2);
            }
            if (string2 == null || string2.length() == 0 || string2.equals("")) {
                bl = false;
            }
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error getRoleName : ", (Throwable)exception);
            }
            bl = false;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning searchRole" + string2);
        }
        return bl;
    }

    void setIndexType(AuthContext.IndexType indexType) {
        this.indexType = indexType;
    }

    void setPreviousIndexType(AuthContext.IndexType indexType) {
        this.prevIndexType = this.indexType;
    }

    void setUserName(String string) {
        this.userName = string;
    }

    public boolean isPersistentCookieOn() {
        return this.persistentCookieOn;
    }

    public boolean getPersistentCookieMode() {
        return this.persistentCookieMode;
    }

    void setToken(String string) {
        this.token = string;
    }

    void setUserDN(String string) {
        this.userDN = string;
    }

    public Hashtable getRequestParamHash() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("LoginStateReturning.. hash :" + this.requestHash);
        }
        return this.requestHash;
    }

    boolean getUserEnabled(Map map) {
        Boolean bl = Boolean.FALSE;
        this.userEnabled = !map.containsValue(bl);
        return this.userEnabled;
    }

    boolean getUserRoleFound(Map map) {
        boolean bl = true;
        Boolean bl2 = Boolean.FALSE;
        if (map.containsValue(bl2)) {
            bl = false;
        }
        return bl;
    }

    boolean getFoundUserAlias(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("foundAliasMap :" + map);
        }
        boolean bl = true;
        Boolean bl2 = Boolean.FALSE;
        if (map == null || map.isEmpty() || map.containsValue(bl2)) {
            bl = false;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("foundUserAlias : " + bl);
        }
        return bl;
    }

    boolean getGotUserProfile(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("GotUserProfileMAP is: " + map);
        }
        boolean bl = false;
        Boolean bl2 = Boolean.TRUE;
        if (map.containsValue(bl2)) {
            bl = true;
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("gotUserProfile :" + bl);
        }
        return bl;
    }

    void addAliasToUserProfile(String string, Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Token : " + string);
            AuthD.debug.message("foundUserAliasMap : " + map);
        }
        try {
            AMStoreConnection aMStoreConnection = ad.getSDK();
            this.userDN = this.tokenToDN(string);
            AMUser aMUser = aMStoreConnection.getUser(this.userDN);
            if (map != null && !map.isEmpty()) {
                Object object;
                Set set = map.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    if (string == null || string.equalsIgnoreCase((String)object) || this.userAliasList.contains(object)) continue;
                    this.userAliasList.add(object);
                }
                AuthD.debug.message("Adding alias list to user profile");
                object = new HashMap();
                if (this.externalAliasList != null && !this.externalAliasList.isEmpty()) {
                    this.userAliasList.addAll(this.externalAliasList);
                }
                object.put("iplanet-am-user-alias-list", this.userAliasList);
                aMUser.setAttributes((Map)object);
                aMUser.store();
            }
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception : " + exception.getMessage(), (Throwable)exception);
        }
    }

    boolean checkAliasList(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("UserAliasList is.. : " + map);
        }
        boolean bl = true;
        Set set = map.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Boolean bl2;
            String string;
            Object k = iterator.next();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Token is.. : " + (String)k);
            }
            if (ad.isSuperAdmin(string = this.tokenToDN((String)k)) || !(bl2 = (Boolean)map.get(k)).toString().equals("false")) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String searchPersistentCookie() {
        try {
            String string = null;
            String string2 = CookieUtils.getCookieValueFromReq((HttpServletRequest)this.servletRequest, (String)this.pCookieName);
            if (string2 != null) {
                string = this.parsePersistentCookie(string2);
            }
            return string;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("ERROR searchPersistentCookie ", (Throwable)exception);
            }
            return null;
        }
    }

    private String parsePersistentCookie(String string) {
        try {
            String string2 = (String)AccessController.doPrivileged(new EncodeAction("inPersistentCookie"));
            if (string == null || string.equals("") || string.equals(string2)) {
                return null;
            }
            String string3 = (String)AccessController.doPrivileged(new DecodeAction(string));
            int n = string3.indexOf("%");
            if (n == -1) {
                return null;
            }
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1);
            int n2 = string5.indexOf("%");
            if (n2 == -1) {
                return null;
            }
            String string6 = string5.substring(0, n2);
            String string7 = string5.substring(n2 + 1);
            int n3 = string7.indexOf("%");
            if (n3 == -1) {
                return null;
            }
            String string8 = string7.substring(0, n3);
            string5 = string7.substring(n3 + 1);
            if ((n3 = string5.indexOf("%")) == -1) {
                return null;
            }
            int n4 = Integer.parseInt(string5.substring(0, n3));
            string7 = string5.substring(n3 + 1);
            if ((n3 = string7.indexOf("%")) == -1) {
                return null;
            }
            int n5 = Integer.parseInt(string7.substring(0, n3));
            int n6 = Integer.parseInt(string7.substring(n3 + 1));
            if (!this.getOrgName().equals(string6)) {
                this.userOrg = this.orgName = string6;
                this.orgDN = this.getOrgDN();
            }
            String string9 = null;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("authMethStr: " + string8);
            }
            int n7 = 0;
            String string10 = string8;
            while (n7 != -1) {
                n7 = string8.indexOf("|");
                if (n7 == -1) {
                    string9 = ad.getAuthenticatorForName(string8);
                    if (AuthD.debug.messageEnabled()) {
                        AuthD.debug.message("authMethStr is : " + string8);
                        AuthD.debug.message("authModuleName is : " + string9);
                    }
                    if (string9 != null) break;
                    return null;
                }
                String string11 = string8.substring(0, n7);
                string9 = ad.getAuthenticatorForName(string11);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("authModulename is : " + string11);
                    AuthD.debug.message("authModuleName instance is : " + string9);
                }
                if (string9 == null) {
                    return null;
                }
                string8 = string11 = string8.substring(n7 + 1, string8.length());
            }
            this.pAuthMethName = string10;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Found valid PC : username=" + string4 + "\ndomainname=" + string6 + "\nauthMethod=" + string10 + "\nmaxSession=" + n4 + "\nidleTime=" + n5 + "\ncacheTime=" + n6 + "\norgDN=" + this.orgDN);
            }
            return string4;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("ERROR:parsePersistentCookie : ", (Throwable)exception);
            }
            return null;
        }
    }

    public static String encodePCookie() {
        return (String)AccessController.doPrivileged(new EncodeAction("inPersistentCookie"));
    }

    public Cookie setPersistentCookie(String string) throws SSOException, AMException {
        String string2 = this.persistentCookieTime;
        Cookie cookie = null;
        if (string2 != null) {
            int n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                n = 0;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Add Cookie: maxage=" + n);
            }
            if (n > 0) {
                String string3 = this.getUserDN(this.userId) + "%" + this.getOrgName() + "%" + this.authMethName + "%" + Integer.toString(this.maxSession) + "%" + Integer.toString(this.idleTime) + "%" + Integer.toString(this.cacheTime);
                String string4 = (String)AccessController.doPrivileged(new EncodeAction(string3));
                cookie = LoginState.createPersistentCookie(ad.getPersistentCookieName(), string4, n, string);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Add PCookie = " + string3);
                }
            } else if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Persistent Cookie Mode configured for domain " + this.orgName + ", but no persistentCookieTime = " + string2);
            }
        }
        return cookie;
    }

    public static Cookie createPersistentCookie(String string, String string2, int n, String string3) {
        Cookie cookie = CookieUtils.newCookie((String)string, (String)string2, (String)"/", (String)string3);
        if (n >= 0) {
            cookie.setMaxAge(n);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("pCookie is.. :" + cookie);
        }
        return cookie;
    }

    public Cookie setlbCookie(String string, boolean bl) throws SSOException, AMException {
        String string2 = ad.getlbCookieName();
        String string3 = ad.getlbCookieValue();
        String string4 = this.persistentCookieTime;
        Cookie cookie = null;
        if (string4 != null && bl) {
            int n;
            try {
                n = Integer.parseInt(string4);
            }
            catch (Exception exception) {
                n = 0;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Add Load Balance Cookie: maxage=" + n);
            }
            if (n > 0) {
                cookie = LoginState.createPersistentCookie(string2, string3, n, string);
                AuthD.debug.message("Add Load Balance Cookie!");
            } else {
                AuthD.debug.message("No Load Balance Cookie set!");
            }
        } else {
            cookie = LoginState.createPersistentCookie(string2, string3, -1, string);
        }
        return cookie;
    }

    public AuthContext.IndexType getIndexType() {
        return this.indexType;
    }

    public AuthContext.IndexType getPreviousIndexType() {
        return this.prevIndexType;
    }

    void setGoToURL() {
        String string = (String)this.requestHash.get("goto");
        if (string != null && !string.equals("")) {
            this.gotoURL = string;
        }
    }

    void setGoToOnFailURL() {
        String string = (String)this.requestHash.get("gotoOnFail");
        if (string != null && !string.equals("")) {
            this.gotoOnFailURL = string;
        }
    }

    public String getSuccessLoginURL() {
        String string = this.servletRequest == null ? null : this.servletRequest.getParameter("goto");
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("currentGoto : " + string);
        }
        String string2 = null;
        if (string != null && string.length() != 0 && !string.equalsIgnoreCase("null")) {
            string2 = this.processURL(string);
        } else if (string2 == null || string2.length() == 0) {
            string2 = this.processURL(this.successLoginURL);
        }
        String string3 = this.encodeURL(string2, this.servletResponse);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("get fqdnURL : " + string2);
            AuthD.debug.message("get successLoginURL : " + this.successLoginURL);
            AuthD.debug.message("get encodedSuccessURL : " + string3);
        }
        return string3;
    }

    public String getConfiguredSuccessLoginURL() {
        String string = this.encodeURL(this.processURL(this.successLoginURL), this.servletResponse);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getSuccessLoginURL : " + this.successLoginURL);
            AuthD.debug.message("getSuccessLoginURL : " + string);
        }
        return string;
    }

    String getSuccessURLForRole() {
        String string;
        block2: {
            string = null;
            try {
                AMTemplate aMTemplate = this.getAMTemplate();
                string = this.getRoleURLFromAttribute(aMTemplate, "iplanet-am-auth-login-success-url");
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Execption:getSuccessURLForRole : ", (Throwable)exception);
            }
        }
        return string;
    }

    String getFailureURLForRole() {
        String string;
        block2: {
            string = null;
            try {
                AMTemplate aMTemplate = this.getAMTemplate();
                string = this.getRoleURLFromAttribute(aMTemplate, "iplanet-am-auth-login-failure-url");
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Error retrieving url ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
        }
        return string;
    }

    AMTemplate getAMTemplate() throws Exception {
        try {
            AMStoreConnection aMStoreConnection = ad.getSDK();
            AMRole aMRole = aMStoreConnection.getRole(this.roleDN);
            AMTemplate aMTemplate = aMRole.getTemplate("iPlanetAMAuthConfiguration", 301);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Returning AMTemplate : " + aMTemplate);
                AuthD.debug.message("for roleDN : " + this.roleDN);
            }
            return aMTemplate;
        }
        catch (Exception exception) {
            AuthD.debug.error("Error getting AMTemplate : ", (Throwable)exception);
            throw new Exception("102");
        }
    }

    String getRolePostLoginProcessClassName(AMTemplate aMTemplate) {
        try {
            Set set = aMTemplate.getAttribute("iplanet-am-auth-post-login-process-class");
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("postLoginProcess Class :" + set);
            }
            if (set.isEmpty()) {
                return null;
            }
            Iterator iterator = set.iterator();
            String string = (String)iterator.next();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Returning PostLoginProcess Classname :" + string);
            }
            return string;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error retrieving classname : ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
            return null;
        }
    }

    String getSuccessURLForService(String string) {
        String string2;
        block5: {
            string2 = null;
            try {
                if (this.serviceAttributesMap != null && this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(string);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("AttributeMAP is.. :" + this.serviceAttributesMap);
                }
                string2 = this.getServiceURLFromAttribute(this.serviceAttributesMap, "iplanet-am-auth-login-success-url");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("service successURL : " + string2);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error retrieving url ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
        }
        return string2;
    }

    String getFailureURLForService(String string) {
        String string2;
        block4: {
            string2 = null;
            try {
                if (this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(string);
                }
                string2 = this.getServiceURLFromAttribute(this.serviceAttributesMap, "iplanet-am-auth-login-failure-url");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Service failureURL: " + string2);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block4;
                AuthD.debug.message("Error retrieving url ");
                AuthD.debug.message("Exception : ", (Throwable)exception);
            }
        }
        return string2;
    }

    String getStringFromSet(Set set) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getStringFromSET : " + set);
        }
        if (set != null && !set.isEmpty()) {
            Iterator iterator = set.iterator();
            return (String)iterator.next();
        }
        return null;
    }

    Map getServiceAttributes(String string) throws Exception {
        try {
            Map map = AMAuthConfigUtils.getNamedConfig(string, this.orgDN, ad.getSSOAuthSession());
            return map;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error getting service attribute: ");
                AuthD.debug.message(" Exception : " + exception.getMessage());
            }
            throw new Exception(exception.getMessage());
        }
    }

    AMPostAuthProcessInterface getPostLoginProcessInstance(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("postLoginProcess Class Name is : " + string);
        }
        if (string == null || string.equals("")) {
            return null;
        }
        try {
            AMPostAuthProcessInterface aMPostAuthProcessInterface = (AMPostAuthProcessInterface)Class.forName(string).newInstance();
            return aMPostAuthProcessInterface;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Class not Found :", (Throwable)classNotFoundException);
            }
            return null;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error: ", (Throwable)exception);
            }
            return null;
        }
    }

    public void setSuccessLoginURL(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("URL : from modle  : " + string);
        }
        this.moduleSuccessLoginURL = string;
    }

    public void setFailureLoginURL(String string) {
        this.moduleFailureLoginURL = string;
    }

    public void setSuccessLoginURL(AuthContext.IndexType indexType, String string) {
        String string2;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("moduleSucessLoginURL : " + this.moduleSuccessLoginURL);
        }
        if (this.moduleSuccessLoginURL != null && !this.moduleSuccessLoginURL.equals("")) {
            this.successLoginURL = this.moduleSuccessLoginURL;
            return;
        }
        String string3 = null;
        if (this.clientUserSuccessURL != null && !this.clientUserSuccessURL.equals("")) {
            this.successLoginURL = this.clientUserSuccessURL;
            if (this.successLoginURL != null) {
                return;
            }
        }
        string3 = this.defaultUserSuccessURL;
        if (indexType == AuthContext.IndexType.ROLE) {
            string2 = this.getSuccessURLForRole();
            if (string2 != null && !string2.equals("")) {
                this.successLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            string2 = this.getSuccessURLForService(string);
            if (string2 != null && !string2.equals("")) {
                this.successLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (this.clientSuccessRoleURL != null && !this.clientSuccessRoleURL.equals("")) {
            this.successLoginURL = this.clientSuccessRoleURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultSuccessRoleURL;
        }
        if (this.clientOrgSuccessLoginURL != null && !this.clientOrgSuccessLoginURL.equals("")) {
            this.successLoginURL = this.clientOrgSuccessLoginURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultOrgSuccessLoginURL;
        }
        if (indexType == AuthContext.IndexType.SERVICE || indexType == AuthContext.IndexType.ROLE) {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultServiceSuccessURLSet);
        } else {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultSuccessURLSet);
            LoginState.ad.defaultSuccessURL = this.tempDefaultURL;
        }
        if (this.defaultSuccessURL != null && !this.defaultSuccessURL.equals("")) {
            this.successLoginURL = this.defaultSuccessURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.tempDefaultURL;
        }
        this.successLoginURL = string3;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Default url:" + this.successLoginURL);
        }
    }

    public void setFailureLoginURL(AuthContext.IndexType indexType, String string) {
        String string2;
        String string3;
        block22: {
            if (this.moduleFailureLoginURL != null && !this.moduleFailureLoginURL.equals("")) {
                this.failureLoginURL = this.moduleFailureLoginURL;
                return;
            }
            if (this.gotoOnFailURL != null && !this.gotoOnFailURL.equals("")) {
                this.failureLoginURL = this.gotoOnFailURL;
                return;
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("failureTokenId in setFailureLoginURL = " + this.failureTokenId);
            }
            string3 = null;
            if (this.failureTokenId != null) {
                try {
                    this.getUserProfile(this.failureTokenId, true, false);
                    if (this.clientUserFailureURL != null && !this.clientUserFailureURL.equals("")) {
                        this.failureLoginURL = this.clientUserFailureURL;
                        return;
                    }
                    string3 = this.defaultUserFailureURL;
                }
                catch (Exception exception) {
                    if (!AuthD.debug.messageEnabled()) break block22;
                    AuthD.debug.message("Error retreiving profile for : " + this.failureTokenId, (Throwable)exception);
                }
            }
        }
        if (indexType == AuthContext.IndexType.ROLE) {
            string2 = this.getFailureURLForRole();
            if (string2 != null && !string2.equals("")) {
                this.failureLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (indexType == AuthContext.IndexType.SERVICE) {
            string2 = this.getFailureURLForService(string);
            if (string2 != null && !string2.equals("")) {
                this.failureLoginURL = string2;
                return;
            }
            if (string3 == null || string3.equals("")) {
                string3 = this.tempDefaultURL;
            }
        }
        if (this.clientFailureRoleURL != null && !this.clientFailureRoleURL.equals("")) {
            this.failureLoginURL = this.clientFailureRoleURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultFailureRoleURL;
        }
        if (this.clientOrgFailureLoginURL != null && !this.clientOrgFailureLoginURL.equals("")) {
            this.failureLoginURL = this.clientOrgFailureLoginURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.defaultOrgFailureLoginURL;
        }
        if (indexType == AuthContext.IndexType.SERVICE || indexType == AuthContext.IndexType.ROLE) {
            this.defaultSuccessURL = this.getRedirectUrl(LoginState.ad.defaultServiceFailureURLSet);
        } else {
            this.defaultFailureURL = this.getRedirectUrl(LoginState.ad.defaultFailureURLSet);
            LoginState.ad.defaultFailureURL = this.tempDefaultURL;
        }
        if (this.defaultFailureURL != null && !this.defaultFailureURL.equals("")) {
            this.failureLoginURL = this.defaultFailureURL;
            return;
        }
        if (string3 == null || string3.equals("")) {
            string3 = this.tempDefaultURL;
        }
        this.failureLoginURL = string3;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("defaultFailureURL : " + this.failureLoginURL);
        }
    }

    public String processURL(String string) {
        String string2 = string;
        if (string2 != null) {
            string2 = this.processDynamicVariables(string2);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("processURL : " + string2);
        }
        return string2;
    }

    private String processDynamicVariables(String string) {
        if (string.indexOf("%") != -1) {
            StringBuffer stringBuffer = new StringBuffer(200);
            int n = string.indexOf("%protocol");
            if (n != -1) {
                stringBuffer.append(string.substring(0, n));
                if (isConsoleRemote) {
                    stringBuffer.append(consoleProto);
                } else {
                    String string2 = null;
                    if (this.servletRequest != null) {
                        string2 = RequestUtils.getRedirectProtocol((String)this.servletRequest.getScheme(), (String)this.servletRequest.getServerName());
                    }
                    if (string2 != null) {
                        stringBuffer.append(string2);
                    } else {
                        stringBuffer.append(consoleProto);
                    }
                }
                stringBuffer.append(string.substring(n + "%protocol".length()));
                string = stringBuffer.toString();
            }
            if ((n = string.indexOf("%host")) != -1) {
                int n2 = "%host".length();
                stringBuffer.delete(0, 200);
                stringBuffer.append(string.substring(0, n));
                if (isConsoleRemote) {
                    stringBuffer.append(consoleHost);
                } else {
                    String string3 = null;
                    if (this.servletRequest != null) {
                        string3 = this.servletRequest.getHeader("Host");
                    }
                    if (string3 != null) {
                        stringBuffer.append(string3);
                        ++n2;
                    } else {
                        stringBuffer.append(consoleHost);
                    }
                }
                stringBuffer.append(string.substring(n + n2));
                string = stringBuffer.toString();
            }
            if ((n = string.indexOf("%port")) != -1) {
                stringBuffer.delete(0, 200);
                stringBuffer.append(string.substring(0, n));
                if (isConsoleRemote) {
                    stringBuffer.append(consolePort);
                }
                stringBuffer.append(string.substring(n + "%port".length()));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public String getFailureLoginURL() {
        if (this.fqdnFailureLoginURL == null || this.fqdnFailureLoginURL.length() == 0) {
            this.fqdnFailureLoginURL = this.processURL(this.failureLoginURL);
        }
        return this.fqdnFailureLoginURL;
    }

    String getRoleURLFromAttribute(AMTemplate aMTemplate, String string) {
        try {
            Set set = aMTemplate.getAttribute(string);
            String string2 = this.getRedirectUrl(set);
            return string2;
        }
        catch (Exception exception) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Error getting role attribute ", (Throwable)exception);
            }
            return null;
        }
    }

    String getServiceURLFromAttribute(Map map, String string) {
        Set set = (Set)map.get(string);
        String string2 = this.getRedirectUrl(set);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("attr map: " + map + "\nserviceURL : " + string2);
        }
        return string2;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.servletResponse;
    }

    protected void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this.servletResponse = httpServletResponse;
    }

    public synchronized void setPersistentCookieOn() {
        this.persistentCookieOn = true;
    }

    public Callback[] getRecdCallback() {
        return this.prevCallback;
    }

    public synchronized void setPrevCallback(Callback[] callbackArray) {
        this.prevCallback = callbackArray;
    }

    protected AMUser getAMUser() {
        return this.amUser;
    }

    protected String getAccountLife() {
        return this.accountLife;
    }

    protected String getUserToken() {
        return this.token;
    }

    protected boolean getLoginFailureLockoutMode() {
        return this.loginFailureLockoutMode;
    }

    protected long getLoginFailureLockoutTime() {
        return this.loginFailureLockoutTime;
    }

    protected int getLoginFailureLockoutCount() {
        return this.loginFailureLockoutCount;
    }

    protected String getLoginLockoutNotification() {
        return this.loginLockoutNotification;
    }

    protected int getLoginLockoutUserWarning() {
        return this.loginLockoutUserWarning;
    }

    public void setErrorCode(String string) {
        this.errorCode = string;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorTemplate(String string) {
        this.errorTemplate = string;
    }

    public String getErrorTemplate() {
        return this.errorTemplate;
    }

    public void setModuleErrorTemplate(String string) {
        this.moduleErrorTemplate = string;
    }

    public String getModuleErrorTemplate() {
        return this.moduleErrorTemplate;
    }

    public void setTimedOut(boolean bl) {
        this.timedOut = bl;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setLockoutMsg(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setLockoutMsg :" + string);
        }
        this.lockoutMsg = string;
    }

    public String getLockoutMsg() {
        return this.lockoutMsg;
    }

    public static String getTemplateDir() {
        if (installBaseDir == null) {
            installBaseDir = LoginState.getInstallDir();
        }
        templateDir = installBaseDir + "/" + "config" + "/" + "auth";
        return templateDir;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public static String getInstallDir() {
        int n = installDir.lastIndexOf("/");
        installBaseDir = n != -1 ? installDir.substring(0, n) : installDir;
        return installBaseDir;
    }

    String getClientFilePath() {
        if (this.filePath != null) {
            return this.filePath;
        }
        return ad.getFilePath(this.getClientType());
    }

    String getFilePath() {
        this.filePath = this.getClientFilePath();
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.indexType != null && this.indexType.equals(AuthContext.IndexType.SERVICE)) {
            string = this.indexName;
        }
        if (this.filePath == null && string == null) {
            return null;
        }
        if (this.filePath != null && !this.filePath.equals("")) {
            stringBuffer.append("/").append(this.filePath);
        }
        if (string != null && !string.equals("")) {
            stringBuffer.append("/").append(string);
        }
        String string2 = stringBuffer.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("FilePath is.. :" + string2);
        }
        return string2;
    }

    String getOrgFilePath(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("remOrgName is: " + string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        if (string != null) {
            while (string != null && string.length() != 0) {
                int n;
                int n2 = string.lastIndexOf(",");
                if (n2 == -1) {
                    n = string.indexOf("=");
                    if (n == -1) {
                        stringBuffer.append("/").append(string);
                    } else {
                        string2 = string.substring(n + 1, string.length());
                        stringBuffer.append("/").append(string2);
                    }
                    string = null;
                } else {
                    string2 = string.substring(n2 + 1, string.length());
                    string = string.substring(0, n2);
                    n = string2.indexOf("=");
                    if (n != -1) {
                        string2 = string2.substring(n + 1, string2.length());
                    }
                    stringBuffer.append("/").append(string2);
                }
                if (!AuthD.debug.messageEnabled()) continue;
                AuthD.debug.message("remOrgName is : " + string);
            }
        }
        String string3 = stringBuffer.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("orgPath is : " + string3);
        }
        return string3;
    }

    public AuthContextLocal createAuthContext(SessionID sessionID, String string) throws AuthException {
        this.userOrg = this.getDomainNameByOrg(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("createAuthContext: userOrg is : " + this.userOrg);
        }
        if (this.userOrg == "" || this.userOrg == null) {
            AuthD.debug.error("domain is null, error condtion");
            this.logFailed(LoginState.ad.bundle.getString("invalidDomain"));
            throw new AuthException("108", null);
        }
        AuthD.debug.message("AuthUtil:getAuthContext:Creating new AuthContextLocal & LoginState");
        AuthContextLocal authContextLocal = new AuthContextLocal(this.userOrg);
        this.requestType = true;
        this.sid = sessionID;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("requestType : " + this.requestType);
            AuthD.debug.message("sid : " + sessionID);
            AuthD.debug.message("orgName passed: " + string);
        }
        try {
            this.createSession(null, authContextLocal);
        }
        catch (Exception exception) {
            AuthD.debug.error("Exception creating session .. :", (Throwable)exception);
            throw new AuthException("102", null);
        }
        this.populateOrgProfile();
        this.isRemote = true;
        return authContextLocal;
    }

    public void setAuthLevel(int n) {
        this.moduleAuthLevel = n;
        if (this.authLevel < this.moduleAuthLevel) {
            this.authLevel = this.moduleAuthLevel;
        }
    }

    public String getDomainNameByOrg(String string) {
        String string2;
        block2: {
            string2 = null;
            try {
                string2 = ad.getOrganizationDN(string, false, null);
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block2;
                AuthD.debug.message("Incorrect orgName passed:" + string, (Throwable)exception);
            }
        }
        return string2;
    }

    public Set getModuleInstances() {
        block5: {
            try {
                if (this.moduleInstances != null && !this.moduleInstances.isEmpty()) {
                    return this.moduleInstances;
                }
                this.moduleInstances = this.domainAuthenticators;
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("moduleInstances are : " + this.moduleInstances);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error getting moduleInstances ", (Throwable)exception);
            }
        }
        if (this.moduleInstances == null) {
            this.moduleInstances = Collections.EMPTY_SET;
        }
        return this.moduleInstances;
    }

    public Set getDomainAuthenticators() {
        return this.domainAuthenticators;
    }

    public void setX509Certificate(X509Certificate x509Certificate) {
        this.cert = x509Certificate;
    }

    public X509Certificate getX509Certificate() {
        return this.cert;
    }

    public void logSuccess() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LoginState.ad.bundle.getString("loginSuccess"));
            if (this.indexType != null && this.indexName != null) {
                stringBuffer.append(" ").append(this.indexType.toString()).append("->").append(this.indexName);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                hashtable.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                hashtable.put("Domain", this.orgDN);
            }
            if (this.authMethName != null) {
                hashtable.put("ModuleName", this.authMethName);
            }
            if (this.sess != null) {
                hashtable.put("LoginIDSid", this.sess.getID().toString());
            }
            ad.logIt(stringBuffer.toString(), 0, hashtable);
        }
        catch (Exception exception) {
            AuthD.debug.message("Error creating logSuccess message", (Throwable)exception);
        }
    }

    public void logFailed(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (string == null) {
                string = LoginState.ad.bundle.getString("loginFailed");
            }
            stringBuffer.append(string);
            if (this.indexType != null && this.indexName != null) {
                stringBuffer.append(" ").append(this.indexType.toString()).append("->").append(this.indexName);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                hashtable.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                hashtable.put("Domain", this.orgDN);
            }
            if (this.failureModuleList != null && this.failureModuleList.length() > 0) {
                hashtable.put("ModuleName", this.failureModuleList);
            }
            if (this.sess != null) {
                hashtable.put("LoginIDSid", this.sess.getID().toString());
            }
            ad.logIt(stringBuffer.toString(), 1, hashtable);
        }
        catch (Exception exception) {
            AuthD.debug.error("Error creating logFailed message", (Throwable)exception);
        }
    }

    public void logLogout() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(LoginState.ad.bundle.getString("logout"));
            if (this.indexType != null && this.indexName != null) {
                stringBuffer.append(" ").append(this.indexType.toString()).append("->").append(this.indexName);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.client != null) {
                hashtable.put("IPAddr", this.client);
            }
            if (this.userDN != null) {
                hashtable.put("LoginID", this.userDN);
            }
            if (this.orgDN != null) {
                hashtable.put("Domain", this.orgDN);
            }
            if (this.authMethName != null) {
                hashtable.put("ModuleName", this.authMethName);
            }
            if (this.sess != null) {
                hashtable.put("LoginIDSid", this.sess.getID().toString());
            }
            ad.logIt(stringBuffer.toString(), 0, hashtable);
        }
        catch (Exception exception) {
            AuthD.debug.error("Error creating logout message", (Throwable)exception);
        }
    }

    public String getLoginLockoutAttrName() {
        return this.loginLockoutAttrName;
    }

    public String getLoginLockoutAttrValue() {
        return this.loginLockoutAttrValue;
    }

    public long getLoginFailureLockoutDuration() {
        return this.loginFailureLockoutDuration;
    }

    public void setPrevAuthContext(AuthContextLocal authContextLocal) {
        this.oldAuthContext = authContextLocal;
    }

    public AuthContextLocal getPrevAuthContext() {
        return this.oldAuthContext;
    }

    public void setSessionUpgrade(boolean bl) {
        this.sessionUpgrade = bl;
    }

    public boolean isSessionUpgrade() {
        return this.sessionUpgrade;
    }

    void sessionUpgrade() {
        String string;
        String string2;
        LoginState loginState = AuthUtils.getLoginState(this.oldAuthContext);
        InternalSession internalSession = null;
        if (loginState != null) {
            internalSession = loginState.getSession();
        }
        if (internalSession == null) {
            return;
        }
        int n = 0;
        try {
            n = Integer.parseInt(internalSession.getProperty("AuthLevel"));
        }
        catch (NumberFormatException numberFormatException) {
            AuthD.debug.error("AuthLevel from session property bad format");
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("prevAuthLevel : " + n);
        }
        this.upgradeAuthLevel = n > this.authLevel ? n : this.authLevel;
        this.upgradeServiceName = string2 = internalSession.getProperty("Service");
        String string3 = null;
        if (this.indexType == AuthContext.IndexType.SERVICE) {
            string3 = this.indexName;
            if (string2 != null) {
                this.upgradeServiceName = string2;
                if (this.indexName != null && string2.indexOf(this.indexName) == -1) {
                    this.upgradeServiceName = this.indexName + "|" + string2;
                }
            } else {
                this.upgradeServiceName = this.indexName;
            }
        }
        this.upgradeRoleName = string = internalSession.getProperty("Role");
        if (this.indexType == AuthContext.IndexType.ROLE) {
            if (string != null) {
                this.upgradeRoleName = string;
                if (this.indexName != null && string.indexOf(this.indexName) == -1) {
                    this.upgradeRoleName = this.indexName + "|" + string;
                }
            } else {
                this.upgradeRoleName = this.indexName;
            }
        }
        String string4 = internalSession.getProperty("AuthType");
        String string5 = this.authMethName;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("authMethName (newModuleList) : " + this.authMethName);
            AuthD.debug.message("prevModuleList : " + string4);
        }
        this.upgradeModuleList = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string5);
        this.upgradeModuleList = string4 != string5 ? this.parsePropertyList(string4, string5) : stringBuffer.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("oldAuthLevel : " + n);
            AuthD.debug.message("newAuthLevel : " + this.authLevel);
            AuthD.debug.message("upgradeAuthLevel : " + this.upgradeAuthLevel);
            AuthD.debug.message("prevServiceName : " + string2);
            AuthD.debug.message("newServiceName : " + string3);
            AuthD.debug.message("upgradeServiceName : " + this.upgradeServiceName);
            AuthD.debug.message("preRoleName : " + string);
            AuthD.debug.message("newRoleName : " + this.roleDN);
            AuthD.debug.message("upgradeRoleName : " + this.upgradeRoleName);
            AuthD.debug.message("prevModuleList: " + string4);
            AuthD.debug.message("newModuleList: " + string5);
            AuthD.debug.message("upgradeModuleList: " + this.upgradeModuleList);
        }
        this.updateSessionProperty("AuthLevel", new Integer(this.upgradeAuthLevel).toString());
        this.updateSessionProperty("AuthType", this.upgradeModuleList);
        this.updateSessionProperty("Service", this.upgradeServiceName);
        this.updateSessionProperty("Role", this.upgradeRoleName);
    }

    void updateSessionProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        this.sess.putProperty(string, string2);
    }

    String parsePropertyList(String string, String string2) {
        String string3;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("oldProperty : " + string);
            AuthD.debug.message("newProperty : " + string2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (string2.indexOf(string3) != -1) continue;
            stringBuffer.append("|").append(string3);
        }
        string3 = stringBuffer.toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("propertyList is : " + string3);
        }
        return string3;
    }

    void setCookieSet(boolean bl) {
        this.cookieSet = bl;
    }

    boolean isCookieSet() {
        return this.cookieSet;
    }

    void setCookieSupported(boolean bl) {
        this.cookieSupported = bl;
    }

    boolean isCookieSupported() {
        return this.cookieSupported;
    }

    void onSuccessProcess(AuthContext.IndexType indexType, String string) {
        this.postLoginInstance = this.getPostLoginClass(indexType, string);
        if (this.postLoginInstance == null) {
            return;
        }
        this.executePostLoginSPI(this.postLoginInstance, true);
    }

    void onFailureProcess(AuthContext.IndexType indexType, String string) {
        AMPostAuthProcessInterface aMPostAuthProcessInterface = this.getPostLoginClass(indexType, string);
        if (aMPostAuthProcessInterface == null) {
            return;
        }
        this.executePostLoginSPI(aMPostAuthProcessInterface, false);
    }

    void onLogoutProcess(AuthContext.IndexType indexType, String string) {
        if (this.postLoginInstance == null) {
            return;
        }
        try {
            this.postLoginInstance.onLogout(this.servletRequest, this.servletResponse, this.getSSOToken());
        }
        catch (AuthenticationException authenticationException) {
            AuthD.debug.error("Error executing postLoginInstance.", (Throwable)((Object)authenticationException));
        }
        catch (Exception exception) {
            AuthD.debug.error("Error executing postLoginInstance.", (Throwable)exception);
        }
    }

    void executePostLoginSPI(AMPostAuthProcessInterface aMPostAuthProcessInterface, boolean bl) {
        block5: {
            try {
                if (bl) {
                    aMPostAuthProcessInterface.onLoginSuccess(this.requestMap, this.servletRequest, this.servletResponse, this.getSSOToken());
                    break block5;
                }
                aMPostAuthProcessInterface.onLoginFailure(this.requestMap, this.servletRequest, this.servletResponse);
            }
            catch (AuthenticationException authenticationException) {
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Error ", (Throwable)((Object)authenticationException));
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error ", (Throwable)exception);
            }
        }
    }

    AMPostAuthProcessInterface getPostLoginClass(AuthContext.IndexType indexType, String string) {
        String string2 = null;
        AMPostAuthProcessInterface aMPostAuthProcessInterface = null;
        if (indexType == AuthContext.IndexType.ROLE) {
            string2 = this.getRolePostLoginClassName();
        } else if (indexType == AuthContext.IndexType.SERVICE) {
            string2 = this.getServicePostLoginClassName(string);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getPostLoginClassName : " + string2);
        }
        if (string2 != null && !string2.equals("") && (aMPostAuthProcessInterface = this.getPostLoginProcessInstance(string2)) != null) {
            return aMPostAuthProcessInterface;
        }
        if (this.userPostLoginClassName != null && !this.userPostLoginClassName.equals("")) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("userPostLoginClass is : " + this.userPostLoginClassName);
            }
            if ((aMPostAuthProcessInterface = this.getPostLoginProcessInstance(this.userPostLoginClassName)) != null) {
                return aMPostAuthProcessInterface;
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("orgPostLoginClassName: " + this.orgPostLoginClassName);
        }
        aMPostAuthProcessInterface = this.getPostLoginProcessInstance(this.orgPostLoginClassName);
        return aMPostAuthProcessInterface;
    }

    String getRolePostLoginClassName() {
        String string = null;
        try {
            AMTemplate aMTemplate = this.getAMTemplate();
            string = this.getRolePostLoginProcessClassName(aMTemplate);
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("Role Post Login Class Name : " + string);
            }
            return string;
        }
        catch (Exception exception) {
            block3: {
                if (!AuthD.debug.messageEnabled()) break block3;
                AuthD.debug.message("Error get role class name ", (Throwable)exception);
            }
            return string;
        }
    }

    String getServicePostLoginClassName(String string) {
        String string2;
        block5: {
            string2 = null;
            try {
                if (this.serviceAttributesMap != null && this.serviceAttributesMap.isEmpty()) {
                    this.serviceAttributesMap = this.getServiceAttributes(string);
                }
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("Service Attributes are . :" + this.serviceAttributesMap);
                }
                Set set = (Set)this.serviceAttributesMap.get("iplanet-am-auth-post-login-process-class");
                string2 = this.getStringFromSet(set);
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("postLoginClassName: " + string2);
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block5;
                AuthD.debug.message("Error get service post login class name " + exception.getMessage());
            }
        }
        return string2;
    }

    void setModuleErrorMessage(String string) {
        this.moduleErrorMessage = string;
    }

    public String getModuleErrorMessage() {
        return this.moduleErrorMessage;
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    public synchronized void setPageTimeOut(long l) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Setting page timeout :" + l);
        }
        this.pageTimeOut = l;
    }

    public long getPageTimeOut() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning page timeout :" + this.pageTimeOut);
        }
        return this.pageTimeOut;
    }

    public void setLastCallbackSent(long l) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setting Last Callback Sent :" + l);
        }
        this.lastCallbackSent = l;
    }

    public long getLastCallbackSent() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returning Last Callback Sent :" + this.lastCallbackSent);
        }
        return this.lastCallbackSent;
    }

    private String getRedirectUrl(Set set) {
        String string = null;
        this.tempDefaultURL = null;
        if (set != null && !set.isEmpty()) {
            String string2 = null;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("URL is : " + string3);
                }
                if (string3 == null || string3.length() <= 0) continue;
                int n = string3.indexOf("|");
                if (n != -1) {
                    if (string != null) continue;
                    string = this.getClientURLFromString(string3, n);
                    continue;
                }
                if (string2 != null && string2.length() != 0) continue;
                string2 = string3;
            }
            this.tempDefaultURL = string2;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("defaultURL : " + string2);
                AuthD.debug.message("tempDefaultURL : " + this.tempDefaultURL);
            }
        }
        return string;
    }

    public boolean ignoreProfile() {
        return this.ignoreUserProfile;
    }

    boolean containsToken(StringBuffer stringBuffer, String string) {
        block5: {
            String string2 = stringBuffer.toString();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("principalString : " + string2);
            }
            if (string2 == null) {
                return false;
            }
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (!string3.equals(string)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.warningEnabled()) break block5;
                AuthD.debug.warning("getToken: ", (Throwable)exception);
            }
        }
        return false;
    }

    private Set mergeSet(Set set, Set set2) {
        if (set == null || set.isEmpty()) {
            if (set2 == null || set2.isEmpty()) {
                return Collections.EMPTY_SET;
            }
            return set2;
        }
        if (set2 == null || set2.isEmpty()) {
            return set;
        }
        HashSet hashSet = new HashSet(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    private Map toAvPairMap(Set set, String string) throws AMException {
        if (string == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashMap.put(this.userNamingAttr, hashSet);
        if (set == null || set.isEmpty()) {
            return hashMap;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            hashMap.put((String)iterator.next(), hashSet);
        }
        return hashMap;
    }

    String getDecodedQueryString(Hashtable hashtable, String string) {
        String string2;
        if (string == null || string.equals("")) {
            AuthD.debug.message("returning null no querystring");
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("paramNames is : " + enumeration);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string;
        Object var6_6 = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        this.queryParamsMap = new HashMap();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2 + "=") && string3.indexOf("&" + string2 + "=") == -1) continue;
            String string4 = (String)hashtable.get(string2);
            stringBuffer.append(string2).append("=").append(string4);
            this.queryParamsMap.put(string2, string4);
            stringBuffer2.append(string2).append(",");
            stringBuffer.append("&");
        }
        string2 = stringBuffer.toString();
        if (string2 != null && string2.length() > 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Returing decode query string : " + string2);
        }
        return string2;
    }

    public Map getQueryParamsMap() {
        return this.queryParamsMap;
    }

    public void setFailedUserId(String string) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("setting userID : " + string);
        }
        this.failureTokenId = string;
    }

    void updateSessionForFailover() {
        InternalSession internalSession = this.getSession();
        internalSession.setIsISStored(true);
    }

    public Callback[] getCallbacksPerState(String string) {
        Callback[] callbackArray = null;
        callbackArray = (Callback[])this.callbacksPerState.get(string);
        return callbackArray;
    }

    public void setCallbacksPerState(String string, Callback[] callbackArray) {
        this.callbacksPerState.put(string, callbackArray);
    }

    public void setPCookieUserName(String string) {
        this.pCookieUserName = string;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Setting Pcookie user name : " + this.pCookieUserName);
        }
    }

    public void setCookieDetect(boolean bl) {
        this.cookieDetect = bl;
    }

    public boolean isCookieDetect() {
        return this.cookieDetect;
    }

    private Subject addSSOTokenPrincipal(Subject subject) {
        if (subject == null) {
            subject = new Subject();
        }
        String string = this.getSid().toString();
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("sid is.. " + string);
        }
        SSOTokenPrincipal sSOTokenPrincipal = new SSOTokenPrincipal(string);
        subject.getPrincipals().add(sSOTokenPrincipal);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Subject is.. :" + subject);
        }
        return subject;
    }

    public void setUserCreationAttributes(Map map) {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("attributeValuePairs : " + map);
        }
        if (map != null && !map.isEmpty()) {
            if (this.userCreationAttributes == null) {
                this.userCreationAttributes = new HashMap();
            }
            if (map.containsKey("iplanet-am-user-alias-list")) {
                this.externalAliasList = (HashSet)map.get("iplanet-am-user-alias-list");
                if (AuthD.debug.messageEnabled()) {
                    AuthD.debug.message("externalAliasList:" + this.externalAliasList);
                }
                map.remove("iplanet-am-user-alias-list");
            }
            this.userCreationAttributes.putAll(map);
        }
    }

    public void setSuccessModuleName(String string) {
        this.successModuleSet.add(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Module name is .. " + string);
            AuthD.debug.message("successModuleSet is : " + this.successModuleSet);
        }
    }

    protected Set getSuccessModuleSet() {
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("getSuccessModuleSet : " + this.successModuleSet);
        }
        return this.successModuleSet;
    }

    private String getClientURLFromString(String string, int n) {
        String string2 = null;
        String string3 = string.substring(0, n);
        if (string3 != null && string3.equals(this.clientType) && string.length() > n) {
            string2 = string.substring(n + 1, string.length());
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("URL is :" + string2);
        }
        return string2;
    }

    private boolean isApplicationModule() {
        boolean bl = false;
        String string = this.authMethName;
        if (this.requestHash != null && !this.requestHash.isEmpty()) {
            string = (String)this.requestHash.get("module");
        }
        bl = string != null && string.equalsIgnoreCase("Application");
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("is Application Module : " + bl);
        }
        return bl;
    }

    public void setFailureModuleName(String string) {
        this.failureModuleSet.add(string);
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Module name is .. " + string);
            AuthD.debug.message("failureModuleSet is : " + this.failureModuleSet);
        }
    }

    public Set getFailureModuleSet() {
        return this.failureModuleSet;
    }

    public void setFailureModuleList(String string) {
        this.failureModuleList = string;
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("failureModulelist :" + string);
        }
    }

    protected static String constructFilter(Map map) {
        String string = "";
        if (map != null) {
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("avPairs Map : " + map);
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(|");
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Iterator iterator2 = ((Set)map.get(string2)).iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    stringBuffer.append("(").append(string2).append("=").append(string3).append(")");
                }
            }
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("Search filter string : " + string);
        }
        return string;
    }

    public boolean isAgent(String string) {
        boolean bl;
        block3: {
            bl = false;
            try {
                AMStoreConnection aMStoreConnection = ad.getSDK();
                int n = aMStoreConnection.getAMObjectType(string);
                String string2 = aMStoreConnection.getAMObjectName(n);
                if (string2.equalsIgnoreCase("agent")) {
                    bl = true;
                    AuthD.debug.message("user is of type 'Agent'");
                }
            }
            catch (Exception exception) {
                if (!AuthD.debug.messageEnabled()) break block3;
                AuthD.debug.message("Error isAgent : ", (Throwable)exception);
            }
        }
        return bl;
    }

    protected void setModuleMap(Map map) {
        this.moduleMap = map;
    }

    protected String getModuleName(String string) {
        return (String)this.moduleMap.get(string);
    }

    public void setRequestLocale(HttpServletRequest httpServletRequest) {
        this.localeContext.setLocale(httpServletRequest);
    }

    static {
        block3: {
            rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
            consoleProto = SystemProperties.get((String)"com.iplanet.am.console.protocol", (String)"http");
            consoleHost = SystemProperties.get((String)"com.iplanet.am.console.host");
            consolePort = SystemProperties.get((String)"com.iplanet.am.console.port");
            isConsoleRemote = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.console.remote"));
            isSessionFailoverEnabled = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.session.failover.enabled"));
            urlRewriteInPath = Boolean.valueOf(SystemProperties.get((String)"com.sun.identity.cookieRewritingInPath", (String)""));
            ad = AuthD.getAuth();
            getUser = true;
            userAttributes = new HashSet();
            isHttpSessionEnabled = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.session.httpSession.enabled"));
            dcTree = null;
            installDir = SystemProperties.get((String)"com.iplanet.am.install.basedir");
            installBaseDir = null;
            templateDir = null;
            serviceURI = null;
            userAttributes.add("iplanet-am-auth-login-success-url");
            userAttributes.add("iplanet-am-auth-login-failure-url");
            userAttributes.add("iplanet-am-user-alias-list");
            userAttributes.add("iplanet-am-session-max-session-time");
            userAttributes.add("iplanet-am-session-max-idle-time");
            userAttributes.add("iplanet-am-session-max-caching-time");
            userAttributes.add("inetuserstatus");
            userAttributes.add("nsaccountlock");
            userAttributes.add("preferredlocale");
            userAttributes.add("iplanet-am-user-login-status");
            userAttributes.add("iplanet-am-user-account-life");
            userAttributes.add("iplanet-am-user-success-url");
            userAttributes.add("iplanet-am-user-failure-url");
            userAttributes.add("iplanet-am-auth-post-login-process-class");
            String string = SystemProperties.get((String)"com.sun.identity.authentication.getuserprofile", (String)"true");
            if (string.equalsIgnoreCase("false")) {
                getUser = false;
            }
            serviceURI = SystemProperties.get((String)"com.iplanet.am.services.deploymentDescriptor") + "/UI/Login";
            String string2 = SystemProperties.get((String)"com.iplanet.am.domaincomponent");
            if (string2 == null) break block3;
            try {
                dcTree = new DomainComponentTree(ad.getSSOAuthSession(), new Guid(string2));
            }
            catch (Exception exception) {
                if (!AuthD.debug.warningEnabled()) break block3;
                AuthD.debug.warning("LoginState: Unable to find DC Tree dn: " + string2, (Throwable)exception);
            }
        }
    }
}

