/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthThreadManager;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStateCallback;
import com.sun.identity.authentication.service.PagePropertiesCallback;
import com.sun.identity.authentication.spi.LoginTimeOutException;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DSAMECallbackHandler
implements CallbackHandler {
    static Debug debug = Debug.getInstance((String)"amCallback");
    AMLoginContext am;
    Callback[] getRequiredInfo = null;
    LoginState loginState;
    Callback[] submitRequiredInfo = null;
    static AuthThreadManager authThreadManager;
    String sid = null;

    public DSAMECallbackHandler() {
    }

    public DSAMECallbackHandler(AMLoginContext aMLoginContext) {
        this.am = aMLoginContext;
        authThreadManager = AMLoginContext.authThread;
        this.loginState = aMLoginContext.getLoginState();
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        debug.message("callback handler method");
        long l = 60L;
        long l2 = System.currentTimeMillis();
        if (callbackArray != null) {
            l = this.getTimeOut(callbackArray[0]);
        }
        this.loginState.setLastCallbackSent(l2);
        this.loginState.setPageTimeOut(l);
        if (callbackArray.length == 1 && callbackArray[0] instanceof LoginStateCallback) {
            debug.message("LoginState Callbacks");
            ((LoginStateCallback)callbackArray[0]).setLoginState(this.loginState);
        } else {
            Callback[] callbackArray2;
            if (this.am.isPureJAAS()) {
                this.loginState.setSubmittedCallback(null, this.am);
                this.loginState.setReceivedCallback(callbackArray, this.am);
                callbackArray2 = Thread.currentThread();
                if (debug.messageEnabled()) {
                    debug.message("waiting for submitted info " + callbackArray2);
                }
                callbackArray = this.am.submitCallbackInfo();
                if (authThreadManager.isTimedOut((Thread)callbackArray2)) {
                    this.loginState.setTimedOut(true);
                    this.loginState.setReceivedCallback(null, this.am);
                    authThreadManager.removeFromHash((Thread)callbackArray2, "timedOutHash");
                    throw new IOException("110");
                }
            } else if (this.loginState.getSubmittedInfo() != null) {
                debug.message("DSAMEHandler: found submitted callbacks !");
                callbackArray2 = this.loginState.getSubmittedInfo();
                this.copyCallbacks(callbackArray, callbackArray2);
                this.loginState.setReceivedCallback_NoThread(null);
            } else {
                this.loginState.setReceivedCallback_NoThread(callbackArray);
                l2 = System.currentTimeMillis();
                this.loginState.setLastCallbackSent(l2);
                debug.message("Set callbacks, throwing java.lang.Error.");
                throw new Error("return from DSAMECallback");
            }
            try {
                this.checkLoginTimeout(l2, l);
            }
            catch (LoginTimeOutException loginTimeOutException) {
                debug.error(" Page Timeout ", (Throwable)loginTimeOutException);
                this.loginState.setTimedOut(true);
                this.loginState.setReceivedCallback(null, this.am);
                throw new IOException("110");
            }
            if (debug.messageEnabled()) {
                debug.message("DSAMECAllbackhandler..." + callbackArray);
            }
            if (this.am.isPureJAAS()) {
                this.loginState.setReceivedCallback(null, this.am);
            }
        }
    }

    private void copyCallbacks(Callback[] callbackArray, Callback[] callbackArray2) {
        int n = callbackArray.length;
        int n2 = callbackArray2.length;
        if (n == n2) {
            int n3 = 0;
            while (n3 < n) {
                if (callbackArray[n3] != callbackArray2[n3]) {
                    callbackArray[n3] = callbackArray2[n3];
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            int n5 = 0;
            while (callbackArray[n4] instanceof PagePropertiesCallback) {
                ++n4;
            }
            while (callbackArray2[n5] instanceof PagePropertiesCallback) {
                ++n5;
            }
            int n6 = n - n4;
            if (n6 > n2 - n5) {
                n6 = n2 - n5;
            }
            int n7 = 0;
            while (n7 < n6) {
                if (callbackArray[n4] != callbackArray2[n5]) {
                    callbackArray[n4] = callbackArray2[n5];
                }
                ++n4;
                ++n5;
                ++n7;
            }
        }
    }

    long getTimeOut(Callback callback) {
        long l = 60L;
        if (callback == null) {
            return l;
        }
        if (callback instanceof PagePropertiesCallback) {
            PagePropertiesCallback pagePropertiesCallback = (PagePropertiesCallback)callback;
            l = new Integer(pagePropertiesCallback.getTimeOutValue()).longValue();
        } else {
            l = 60L;
        }
        return l;
    }

    void checkLoginTimeout(long l, long l2) throws LoginTimeOutException {
        long l3 = System.currentTimeMillis();
        if (l + (l2 - 3L) * 1000L < l3) {
            throw new LoginTimeOutException("amAuth", "loginTimeout", null);
        }
    }
}

