/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;

public class AuthXMLResponse {
    String authErrorCode;
    String authErrorMessage;
    String authErrorTemplate;
    String authURL;
    static Debug debug;
    String tokenId = null;
    AuthContextLocal authContext = null;
    AuthContext.Status loginStatus = AuthContext.Status.IN_PROGRESS;
    String errorCode = null;
    String errorMessage = null;
    String errorTemplate = null;
    String loginURL = null;
    Callback[] reqdCallbacks;
    int requestType;
    String successURL = null;
    String failureURL = null;
    boolean isException = false;
    SSOToken ssoToken = null;
    SSOTokenID ssoTokenID = null;
    AuthUtils authUtils = null;
    String authIdentifier;
    String prevAuthIdentifier;
    Set moduleNames = new HashSet();
    AuthContextLocal oldAuthContext = null;

    public AuthXMLResponse(int n) {
        debug = Debug.getInstance((String)"amXMLHandler");
        this.requestType = n;
        this.authUtils = new AuthUtils();
    }

    public void setErrorCode(String string) {
        try {
            this.errorCode = string;
            this.authErrorMessage = this.authUtils.getErrorMessage(string);
            this.authErrorTemplate = this.authUtils.getErrorTemplate(string);
            if (debug.messageEnabled()) {
                debug.message("Auth error message " + this.authErrorMessage);
                debug.message("Auth error template" + this.authErrorTemplate);
            }
            this.loginStatus = AuthContext.Status.FAILED;
        }
        catch (Exception exception) {
            debug.message("error : ", (Throwable)exception);
        }
    }

    public void setErrorMessage(String string) {
        this.authErrorMessage = string;
    }

    public void setFailureURL(String string) {
        this.failureURL = string;
    }

    public void setLoginStatus(AuthContext.Status status) {
        this.loginStatus = status;
    }

    public void setReqdCallbacks(Callback[] callbackArray) {
        this.reqdCallbacks = callbackArray;
    }

    public String createXMLErrorString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Exception").append(" ");
        if (this.authErrorMessage != null) {
            stringBuffer.append("message").append("=").append("\"").append(this.authErrorMessage).append("\"").append(" ");
        }
        if (this.tokenId != null) {
            stringBuffer.append("tokenId").append("=").append("\"").append(this.tokenId).append("\"");
        }
        if (this.errorCode != null) {
            stringBuffer.append(" ").append("errorCode").append("=").append("\"").append(this.errorCode).append("\"");
        }
        if (this.authErrorTemplate != null) {
            stringBuffer.append(" ").append("templateName").append("=").append("\"").append(this.authErrorTemplate).append("\"");
        }
        stringBuffer.append(">").append("</Exception>");
        String string = stringBuffer.toString();
        if (debug.messageEnabled()) {
            debug.message("Error Response String : " + string);
        }
        return string;
    }

    String createLoginStatusString() {
        Object object;
        debug.message("in createLoginStatusSTring");
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.loginStatus.toString();
        stringBuffer.append("<LoginStatus");
        if (string != null) {
            stringBuffer.append(" ").append("status").append("=").append("\"").append(string).append("\"");
        }
        if (this.loginStatus == AuthContext.Status.SUCCESS) {
            this.setSSOToken();
            if (this.ssoToken != null) {
                this.ssoTokenID = this.ssoToken.getTokenID();
                if (debug.messageEnabled()) {
                    debug.message("ssoTokenID is : " + this.ssoTokenID.toString());
                }
            }
            if (this.ssoTokenID != null) {
                stringBuffer.append(" ").append("ssoToken").append("=").append("\"").append(this.ssoTokenID.toString()).append("\"");
            }
            this.successURL = this.authUtils.getLoginSuccessURL(this.authContext);
            if (this.successURL != null) {
                stringBuffer.append(" ").append("successURL").append("=").append("\"").append(this.successURL).append("\"");
            }
            object = this.authContext.getSubject();
            if (debug.messageEnabled()) {
                debug.message("Subject is : " + object);
            }
            String string2 = AuthXMLUtils.getSerializedSubject((Subject)object);
            if (debug.messageEnabled()) {
                debug.message("serialized Subject is : " + string2);
            }
            stringBuffer.append(">").append("<Subject>").append(string2).append("</Subject>");
        } else if (this.loginStatus == AuthContext.Status.FAILED) {
            this.failureURL = this.authUtils.getLoginFailedURL(this.authContext);
            if (this.failureURL != null) {
                stringBuffer.append(" ").append("failureURL").append("=").append("\"").append(this.failureURL).append("\"");
            }
            stringBuffer.append(">");
        } else {
            stringBuffer.append(">");
        }
        stringBuffer.append("</LoginStatus>");
        object = stringBuffer.toString();
        if (debug.messageEnabled()) {
            debug.message("LoginStatus XML STring : " + (String)object);
        }
        return object;
    }

    public String toXMLString() {
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer();
            Object[] objectArray = new String[]{this.loginStatus == AuthContext.Status.FAILED ? this.prevAuthIdentifier : this.authIdentifier};
            if (debug.messageEnabled()) {
                debug.message("Old authIdentifier : " + this.prevAuthIdentifier);
                debug.message("New authIdentifier : " + this.authIdentifier);
                debug.message("Returning authIdentifier : " + (String)objectArray[0]);
            }
            stringBuffer.append(MessageFormat.format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<AuthContext version=\"1.0\"><Response authIdentifier=\"{0}\">", objectArray));
            if (debug.messageEnabled()) {
                debug.message("Request type is : " + this.requestType);
            }
            switch (this.requestType) {
                case 0: {
                    if (this.loginStatus == AuthContext.Status.FAILED || this.isException) {
                        stringBuffer.append(this.createXMLErrorString());
                        this.authUtils.destroySession(this.authContext);
                        break;
                    }
                    if (this.loginStatus == AuthContext.Status.SUCCESS) {
                        stringBuffer.append(this.createLoginStatusString());
                        debug.message("destroying old session");
                        if (this.oldAuthContext == null) break;
                        this.authUtils.destroySession(this.oldAuthContext);
                        break;
                    }
                    stringBuffer.append(this.createLoginStatusString());
                    break;
                }
                case 1: 
                case 2: 
                case 6: 
                case 8: {
                    if (this.reqdCallbacks != null) {
                        string = AuthXMLUtils.getXMLForCallbacks(this.reqdCallbacks);
                        stringBuffer.append("<GetRequirements>");
                        stringBuffer.append(string);
                        stringBuffer.append("</GetRequirements>");
                        break;
                    }
                    if (this.loginStatus == AuthContext.Status.FAILED || this.isException) {
                        stringBuffer.append(this.createLoginStatusString());
                        stringBuffer.append(this.createXMLErrorString());
                        this.authUtils.destroySession(this.authContext);
                        break;
                    }
                    if (this.loginStatus != AuthContext.Status.SUCCESS) break;
                    stringBuffer.append(this.createLoginStatusString());
                    break;
                }
                case 3: {
                    if (this.isException) {
                        stringBuffer.append(this.createXMLErrorString());
                        break;
                    }
                    stringBuffer.append(this.getXMLForQueryInfo());
                    break;
                }
                case 4: 
                case 5: {
                    if (this.isException) {
                        stringBuffer.append(this.createXMLErrorString());
                        break;
                    }
                    stringBuffer.append(this.createLoginStatusString());
                }
            }
            stringBuffer.append("</Response></AuthContext>");
            string = stringBuffer.toString();
            return string;
        }
        catch (Exception exception) {
            debug.message("Exceiton in toXMLString : ", (Throwable)exception);
            return null;
        }
    }

    public void setAuthContext(AuthContextLocal authContextLocal) {
        this.authContext = authContextLocal;
    }

    public void setIsException(boolean bl) {
        this.isException = bl;
    }

    public void setAuthIdentifier(String string) {
        this.authIdentifier = string;
    }

    public void setModuleNames(Set set) {
        this.moduleNames = set;
    }

    public String getXMLForQueryInfo() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<QueryResult").append(" ").append("requestedInformation").append("=").append("\"").append("moduleInstanceNames").append("\"").append(">");
        if (!this.moduleNames.isEmpty()) {
            object = this.moduleNames.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                stringBuffer.append("<Value>").append(string).append("</Value>");
            }
        }
        stringBuffer.append("</QueryResult>");
        object = stringBuffer.toString();
        if (debug.messageEnabled()) {
            debug.message("Query Result : " + (String)object);
        }
        return object;
    }

    public void setPrevAuthIdentifier(String string) {
        this.prevAuthIdentifier = string;
    }

    public void setSSOToken() {
        if (this.authContext != null) {
            this.ssoToken = this.authContext.getSSOToken();
        }
        if (debug.messageEnabled()) {
            debug.message("ssoToken is: " + this.ssoToken);
        }
    }

    public void setPrevAuthContext(AuthContextLocal authContextLocal) {
        authContextLocal = this.oldAuthContext;
    }
}

