/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.share.AuthXMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuthXMLRequestParser {
    static Debug debug = Debug.getInstance((String)"amXMLHandler");
    Document xmlDocument = null;
    AuthXMLRequest authXMLRequest = null;

    public AuthXMLRequestParser(String string) {
        try {
            this.xmlDocument = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string.toString().getBytes("UTF-8")));
            if (debug.messageEnabled()) {
                debug.message("AuthXMLRequestParser : xmlDocument : " + this.xmlDocument);
            }
        }
        catch (Exception exception) {
            debug.message("AuthXMLRequest Parser error : ", (Throwable)exception);
        }
    }

    public AuthXMLRequest parseXML() {
        block13: {
            try {
                Callback[] callbackArray;
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Node node;
                debug.message("entering parseXML");
                if (this.xmlDocument == null) {
                    return null;
                }
                this.authXMLRequest = new AuthXMLRequest();
                Element element = this.xmlDocument.getDocumentElement();
                if (element == null) break block13;
                String string = element.getAttribute("version");
                if (debug.messageEnabled()) {
                    debug.message("Request Version is.. : " + string);
                }
                if (string != null) {
                    this.authXMLRequest.setRequestVersion(string);
                }
                Node node2 = XMLUtils.getChildNode((Node)element, (String)"Request");
                String string2 = null;
                if (node2 != null) {
                    string2 = this.parseNodeAttributes(node2, "authIdentifier");
                    if (debug.messageEnabled()) {
                        debug.message("AuthIdentifier is : " + string2);
                    }
                    this.authXMLRequest.setAuthIdentifier(string2);
                }
                if ((node = XMLUtils.getChildNode((Node)node2, (String)"NewAuthContext")) != null) {
                    object5 = this.parseNodeAttributes(node, "orgName");
                    this.authXMLRequest.setOrgName((String)object5);
                    this.authXMLRequest.setRequestType(0);
                    object4 = AuthUtils.getAuthContext((String)object5, string2);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object4);
                    this.authXMLRequest.setPrevAuthIdentifier(string2);
                }
                if ((object5 = XMLUtils.getChildNode((Node)node2, (String)"QueryInformation")) != null) {
                    object4 = this.parseNodeAttributes((Node)object5, "requestedInformation");
                    this.authXMLRequest.setRequestInformation((String)object4);
                    this.authXMLRequest.setRequestType(3);
                    object3 = AuthUtils.getAuthContext(null, string2, false);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object3);
                }
                if ((object4 = XMLUtils.getChildNode((Node)node2, (String)"Login")) != null) {
                    this.authXMLRequest.setRequestType(1);
                    this.parseLoginNodeElements((Node)object4, this.authXMLRequest);
                    object3 = AuthUtils.getAuthContext(null, string2, false);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object3);
                }
                if ((object3 = XMLUtils.getChildNode((Node)node2, (String)"SubmitRequirements")) != null) {
                    this.authXMLRequest.setRequestType(2);
                    object2 = AuthUtils.getAuthContext(null, string2, false);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object2);
                    object = new AuthUtils();
                    callbackArray = ((AuthUtils)object).getRecdCallback((AuthContextLocal)object2);
                    this.parseSubmitReqElements((Node)object3, this.authXMLRequest, callbackArray);
                }
                if ((object2 = XMLUtils.getChildNode((Node)node2, (String)"Logout")) != null) {
                    this.authXMLRequest.setRequestType(4);
                    object = AuthUtils.getAuthContext(null, string2, true);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)object);
                }
                if ((object = XMLUtils.getChildNode((Node)node2, (String)"Abort")) != null) {
                    this.authXMLRequest.setRequestType(5);
                    callbackArray = AuthUtils.getAuthContext(null, string2, true);
                    this.authXMLRequest.setAuthContext((AuthContextLocal)callbackArray);
                }
            }
            catch (Exception exception) {
                debug.message("Error in parseXML: : ", (Throwable)exception);
            }
        }
        return this.authXMLRequest;
    }

    private String parseNodeAttributes(Node node, String string) {
        try {
            if (node == null) {
                return null;
            }
            String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)string);
            if (debug.messageEnabled()) {
                debug.message("Attr Value is : " + string2);
            }
            return string2;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Error getting " + string);
                debug.message("Exception ", (Throwable)exception);
            }
            return null;
        }
    }

    private void parseLoginNodeElements(Node node, AuthXMLRequest authXMLRequest) {
        authXMLRequest.setRequestType(1);
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"IndexTypeNamePair");
        if (node2 != null) {
            String string = this.parseNodeAttributes(node2, "indexType");
            if (debug.messageEnabled()) {
                debug.message("indexType is .. : " + string);
            }
            authXMLRequest.setIndexType(string);
            Node node3 = XMLUtils.getChildNode((Node)node2, (String)"IndexName");
            if (node3 != null) {
                String string2 = XMLUtils.getValueOfValueNode((Node)node3);
                if (debug.messageEnabled()) {
                    debug.message("indexName is .. : " + string2);
                }
                authXMLRequest.setIndexName(string2);
            }
            authXMLRequest.setRequestType(6);
        } else {
            Node node4 = XMLUtils.getChildNode((Node)node, (String)"Subject");
            if (node4 != null) {
                authXMLRequest.setRequestType(8);
                String string = XMLUtils.getValueOfValueNode((Node)node4);
                Subject subject = null;
                try {
                    subject = AuthXMLUtils.getDeSerializedSubject(string);
                }
                catch (Exception exception) {
                    debug.message("Error deserializing ", (Throwable)exception);
                }
                authXMLRequest.setSubject(subject);
            }
        }
    }

    void parseSubmitReqElements(Node node, AuthXMLRequest authXMLRequest, Callback[] callbackArray) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Callbacks");
        Callback[] callbackArray2 = AuthXMLUtils.getCallbacks(node2, true, callbackArray);
        authXMLRequest.setSubmittedCallbacks(callbackArray2);
    }
}

