/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.server.AuthXMLResponse;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.X509CertificateCallback;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.L10NMessage;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthXMLHandler
implements RequestHandler {
    public static boolean localFlag = false;
    private String localAuthServerProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    private String localAuthServer = SystemProperties.get((String)"com.iplanet.am.server.host");
    private String localAuthServerPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    public static String localAuthServiceID;
    static Debug debug;
    private Locale locale = null;

    public AuthXMLHandler() {
        localAuthServiceID = this.localAuthServerProtocol + "://" + this.localAuthServer + ":" + this.localAuthServerPort;
        this.locale = new ISLocaleContext().getLocale();
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResponseSet responseSet = new ResponseSet("auth");
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request, httpServletRequest);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request, HttpServletRequest httpServletRequest) {
        String string = request.getContent();
        AuthXMLRequest authXMLRequest = AuthXMLRequest.parseXML(string);
        authXMLRequest.setHttpServletRequest(httpServletRequest);
        AuthXMLResponse authXMLResponse = this.processAuthXMLRequest(authXMLRequest, httpServletRequest);
        return new Response(authXMLResponse.toXMLString());
    }

    private AuthXMLResponse processAuthXMLRequest(AuthXMLRequest authXMLRequest, HttpServletRequest httpServletRequest) {
        Object object;
        String[] stringArray;
        Object object2;
        Object object3;
        Object object4;
        if (debug.messageEnabled()) {
            debug.message("authXMLRequest is : " + authXMLRequest);
        }
        int n = authXMLRequest.getRequestType();
        String string = authXMLRequest.getAuthIdentifier();
        String string2 = authXMLRequest.getOrgName();
        String string3 = authXMLRequest.getPrevAuthIdentifier();
        AuthContextLocal authContextLocal = authXMLRequest.getAuthContext();
        AuthXMLResponse authXMLResponse = new AuthXMLResponse(n);
        AuthUtils authUtils = new AuthUtils();
        authXMLResponse.setAuthContext(authContextLocal);
        authXMLResponse.setAuthIdentifier(string);
        authXMLResponse.setPrevAuthIdentifier(string3);
        if (debug.messageEnabled()) {
            debug.message("authContext is : " + authContextLocal);
            debug.message("requestType : " + n);
        }
        if (authUtils.getIndexType(authContextLocal) == AuthContext.IndexType.LEVEL) {
            object4 = authXMLRequest.getSubmittedCallbacks();
            if (debug.messageEnabled()) {
                debug.message("Callbacks are  : " + object4);
            }
            if (object4 != null) {
                if (debug.messageEnabled()) {
                    debug.message("Callback length is : " + ((Callback[])object4).length);
                }
                if (object4[0] instanceof ChoiceCallback) {
                    object3 = (ChoiceCallback)object4[0];
                    object2 = ((ChoiceCallback)object3).getSelectedIndexes();
                    Object object5 = object2[0];
                    stringArray = ((ChoiceCallback)object3).getChoices();
                    object = stringArray[object5];
                    if (debug.messageEnabled()) {
                        debug.message("Selected Index is : " + (String)object);
                    }
                    authXMLRequest.setIndexType("moduleInstance");
                    authXMLRequest.setIndexName((String)object);
                    authXMLRequest.setRequestType(6);
                    n = 6;
                }
            }
        }
        switch (n) {
            case 0: {
                try {
                    if (authContextLocal == null) {
                        throw new AuthException("108", null);
                    }
                    object4 = httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
                    object3 = (X509Certificate[])object4;
                    object2 = AuthUtils.getLoginState(authContextLocal);
                    AuthContextLocal authContextLocal2 = ((LoginState)object2).getPrevAuthContext();
                    authXMLResponse.setPrevAuthContext(authContextLocal2);
                    if (object3 != null && ((Object)object3).length != 0) {
                        if (debug.messageEnabled()) {
                            debug.message("length of cert array : " + ((Object)object3).length);
                        }
                        ((LoginState)object2).setX509Certificate((X509Certificate)object3[0]);
                    }
                    stringArray = null;
                    if (httpServletRequest != null) {
                        stringArray = httpServletRequest.getRemoteAddr();
                        ((LoginState)object2).setClient((String)stringArray);
                    }
                    object = ((LoginState)object2).getSession().getID();
                    String string4 = null;
                    if (object != null) {
                        string4 = object.toString();
                    }
                    if (debug.messageEnabled()) {
                        debug.message("sidString is.. : " + string4);
                    }
                    authXMLResponse.setAuthIdentifier(string4);
                    authXMLResponse.setLoginStatus(AuthContext.Status.IN_PROGRESS);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error creating AuthContext ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 1: {
                try {
                    authContextLocal.login();
                    this.getRequirements(authContextLocal, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error during login ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 6: {
                try {
                    object4 = authXMLRequest.getIndexType();
                    object3 = authXMLRequest.getIndexName();
                    if (debug.messageEnabled()) {
                        debug.message("indexName is : " + (String)object3);
                        debug.message("indexType is : " + object4);
                    }
                    authContextLocal.login((AuthContext.IndexType)object4, (String)object3);
                    this.getRequirements(authContextLocal, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Login Exception ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 8: {
                try {
                    object4 = authXMLRequest.getSubject();
                    authContextLocal.login((Subject)object4);
                    this.getRequirements(authContextLocal, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Login Exception ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 2: {
                try {
                    object4 = authXMLRequest.getSubmittedCallbacks();
                    authContextLocal.submitRequirements((Callback[])object4);
                    object3 = null;
                    if (authContextLocal.hasMoreRequirements()) {
                        object3 = authContextLocal.getRequirements();
                    }
                    authXMLResponse.setReqdCallbacks((Callback[])object3);
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error during login ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 3: {
                try {
                    object4 = authContextLocal.getModuleInstanceNames();
                    authXMLResponse.setModuleNames((Set)object4);
                    authXMLResponse.setAuthContext(authContextLocal);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error aborting ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 4: {
                try {
                    authContextLocal.logout();
                    object4 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object4);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error logging out");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 5: {
                try {
                    authContextLocal.abort();
                    object4 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object4);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error aborting ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
        }
        return authXMLResponse;
    }

    void getRequirements(AuthContextLocal authContextLocal, AuthXMLResponse authXMLResponse) {
        Callback[] callbackArray = null;
        boolean bl = false;
        if (authContextLocal.hasMoreRequirements()) {
            Object object;
            callbackArray = authContextLocal.getRequirements();
            int n = 0;
            while (n < callbackArray.length) {
                if (callbackArray[n] instanceof X509CertificateCallback) {
                    bl = true;
                    object = (X509CertificateCallback)callbackArray[n];
                    LoginState loginState = AuthUtils.getLoginState(authContextLocal);
                    if (loginState != null) {
                        X509Certificate x509Certificate = loginState.getX509Certificate();
                        ((X509CertificateCallback)object).setCertificate(x509Certificate);
                    }
                }
                ++n;
            }
            if (bl && callbackArray.length == 1) {
                authContextLocal.submitRequirements(callbackArray);
                if (authContextLocal.hasMoreRequirements()) {
                    callbackArray = authContextLocal.getRequirements();
                    authXMLResponse.setReqdCallbacks(callbackArray);
                } else {
                    object = authContextLocal.getStatus();
                    if (debug.messageEnabled()) {
                        debug.message("Status: " + object);
                    }
                    authXMLResponse.setLoginStatus((AuthContext.Status)object);
                }
            } else {
                authXMLResponse.setReqdCallbacks(callbackArray);
            }
        } else {
            AuthContext.Status status = authContextLocal.getStatus();
            if (debug.messageEnabled()) {
                debug.message(" Status: " + status);
            }
            authXMLResponse.setLoginStatus(status);
        }
    }

    private void checkACException(AuthXMLResponse authXMLResponse, AuthContextLocal authContextLocal) {
        AuthLoginException authLoginException = authContextLocal.getLoginException();
        if (authLoginException == null) {
            return;
        }
        authXMLResponse.setErrorMessage(authLoginException.getL10NMessage(this.locale));
        authXMLResponse.setIsException(true);
    }

    private void setErrorCode(AuthXMLResponse authXMLResponse, Exception exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof L10NMessage) {
            authXMLResponse.setErrorCode(this.getAuthErrorCode((L10NMessage)exception));
        } else {
            authXMLResponse.setErrorCode(exception.getMessage());
        }
        authXMLResponse.setIsException(true);
    }

    private String getAuthErrorCode(L10NMessage l10NMessage) {
        String string = l10NMessage.getErrorCode();
        if (string == null) {
            string = l10NMessage.getMessage();
        }
        return string;
    }

    static {
        debug = Debug.getInstance((String)"amXMLHandler");
    }
}

