/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.unix;

import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.spi.AuthenticationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ResourceBundle;

public class UnixHelper {
    protected static final int DAEMON_TIMEOUT_mS = 7500;
    private final int MAXLOOP = 200;
    private Socket sock = null;
    private BufferedReader reader = null;
    private PrintWriter writer = null;
    private static final String charSet = "ISO8859_1";
    public static Debug debug;

    public UnixHelper(int n, String string) throws AuthenticationException {
        debug = Debug.getInstance((String)"amUnixHelper");
        debug.message("unix helper...init");
        try {
            this.sock = new Socket("127.0.0.1", n);
            this.sock.setSoTimeout(7500);
            this.reader = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), charSet));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream(), charSet)));
        }
        catch (UnknownHostException unknownHostException) {
            throw new AuthenticationException(string, "UnixHelperLocalhost", null);
        }
        catch (IOException iOException) {
            throw new AuthenticationException(string, "UnixHelperIOEx", null);
        }
    }

    protected synchronized int do_write(String string) {
        this.writer.println(string);
        this.writer.flush();
        return string.length();
    }

    public String do_read(int n, ResourceBundle resourceBundle) throws IOException {
        char[] cArray = new char[254];
        debug.message("in do_read...");
        int n2 = this.reader.read(cArray, 0, n);
        String string = new String(cArray);
        try {
            if (!string.equals(new String(string.getBytes("ASCII"), "ASCII"))) {
                throw new IOException(resourceBundle.getString("UnixHelperInputNotASCII"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            debug.message("Unsupported coding ...");
            throw new IOException(resourceBundle.getString("UnixHelperInputEncodingException"));
        }
        debug.message("returng... readString... " + string);
        return string;
    }

    public int configHelper(String string, String string2, String string3, Debug debug, ResourceBundle resourceBundle) {
        String string4;
        try {
            string4 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -1;
        }
        if (!string4.startsWith("Enter Unix Helper Listen Port")) {
            return -2;
        }
        int n = this.do_write(string);
        try {
            string4 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -3;
        }
        if (!string4.startsWith("Enter Unix Helper Session Timeout")) {
            return -4;
        }
        n = this.do_write(string2);
        try {
            string4 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -5;
        }
        if (!string4.startsWith("Enter Unix Helper Max Sessions")) {
            return -6;
        }
        n = this.do_write(string3);
        try {
            string4 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -7;
        }
        if (!string4.startsWith("get_config_info: amunixd configured successfully")) {
            return -8;
        }
        return 0;
    }

    public int authenticate(String string, String string2, String string3, String string4, ResourceBundle resourceBundle) {
        int n = 200;
        int n2 = 1000;
        if (debug.messageEnabled()) {
            debug.message("authenticate.....userlogin" + string);
            debug.message("authenticate.....serviceModule" + string3);
        }
        do {
            int n3;
            String string5 = "";
            try {
                debug.message("calling do_read");
                string5 = this.do_read(254, resourceBundle);
                debug.message("after do_read");
            }
            catch (IOException iOException) {
                return -1;
            }
            if (string5.length() == 0) {
                return -1;
            }
            debug.message("Instring is.. : " + string5);
            if (string5.startsWith("Enter Unix login:")) {
                n3 = this.do_write(string);
                n2 = 1000;
            } else if (string5.startsWith("Enter password:")) {
                n3 = this.do_write(string2);
                n2 = 1000;
            } else if (string5.startsWith("Enter Service Name :")) {
                debug.message("writing service name");
                n3 = this.do_write(string3);
                debug.message("after writing service name" + n3);
                n2 = 1000;
            } else if (string5.startsWith("Enter Client IP Address:")) {
                n3 = string4 != null ? this.do_write(string4) : this.do_write("0.0.0.0");
                n2 = 1000;
            } else if (string5.startsWith("Authentication passed")) {
                n2 = 0;
            } else if (string5.startsWith("Access denied")) {
                n2 = -1;
            } else if (string5.startsWith("unknown return code ")) {
                n2 = -1;
            } else if (string5.startsWith("Processing timed-")) {
                n2 = -1;
            } else if (string5.startsWith("Processing erro")) {
                n2 = -1;
            } else if (string5.startsWith("Authentication Failed")) {
                n2 = -1;
                if (string5.indexOf("Password Expired") != -1) {
                    debug.message("password expired for " + string);
                    n2 = 2;
                }
            } else {
                n2 = 1000;
            }
            if (--n != 0) continue;
            n2 = -1;
        } while (n2 == 1000);
        debug.message("returning... k from authenticate" + n2);
        return n2;
    }

    protected synchronized void destroy(ResourceBundle resourceBundle) {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (IOException iOException) {
            System.err.println(resourceBundle.getString("UnixDestroyIOEx"));
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(resourceBundle.getString("UnixDestroyEx") + exception.getMessage());
        }
    }
}

