/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.safeword;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.safeword.SafeWordPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import securecomputing.ssl.SimpleSSLClient;
import securecomputing.swec.AuthenState;
import securecomputing.swec.AuthenticatorData;
import securecomputing.swec.DynamicPwdData;
import securecomputing.swec.EasspMessage;
import securecomputing.swec.FixedPwdData;
import securecomputing.swec.SafeWordClient;
import securecomputing.swec.SwecConfig;
import sun.security.provider.Sun;

public class SafeWord
extends AMLoginModule {
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private Map sharedState;
    private static final String ATTRIBUTE_SERVER_SPECIFICATION = "iplanet-am-auth-safeword-server-specification";
    private static final String ATTRIBUTE_SYSTEM_NAME = "iplanet-am-auth-safeword-system-name";
    private static final String ATTRIBUTE_SRVR_VERIF_PATH = "iplanet-am-auth-safeword-srvr-verif-path";
    private static final String ATTRIBUTE_LOG_ENABLE = "iplanet-am-auth-safeword-log-enable";
    private static final String ATTRIBUTE_LOG_LEVEL = "iplanet-am-auth-safeword-log-level";
    private static final String ATTRIBUTE_LOG_PATH = "iplanet-am-auth-safeword-log-path";
    private static final String ATTRIBUTE_AUTH_LEVEL = "iplanet-am-auth-safeword-auth-level";
    private static final String ATTRIBUTE_CLIENT_TYPE = "iplanet-am-auth-safeword-client-type";
    private static final String ATTRIBUTE_MINIMUM_STRENGTH = "iplanet-am-auth-safeword-minimum-strength";
    private static final String ATTRIBUTE_EASSP_VERSION = "iplanet-am-auth-safeword-eassp-version";
    private static final String ATTRIBUTE_TIMEOUT = "iplanet-am-auth-safeword-timeout";
    private static final String DEFAULT_EASSP_VERSION = "101";
    private static final String DEFAULT_SERVER_SPECIFICATION = "localhost 7482";
    private static final String DEFAULT_TIMEOUT = "120";
    private static final String DEFAULT_MINIMUM_STRENGTH = "5";
    private static final String DEFAULT_LOG_LEVEL = "DEBUG";
    private static final String DEFAULT_VAR_DIR = SystemProperties.get((String)"com.iplanet.am.install.vardir");
    private String serverSpec;
    private String serverVerifFilesPath = null;
    private String statusLogLevel;
    private String logEnabled = "ON";
    private String statusLogFilePath = null;
    private String authLevel;
    private String clientType;
    private String minimumStrength;
    private String version;
    private SafeWordClient swClient = null;
    private AuthenState aState = null;
    private String challengeID;
    private String timeOut;
    private boolean flag = false;
    private String userTokenId;
    private SafeWordPrincipal userPrincipal;
    private Map options;
    private static final int PAGE_USERNAME = 1;
    private static final int PAGE_PASSWORD = 2;
    private static final String amAuthSafeWord = "amAuthSafeWord";
    private boolean getCredentialsFromSharedState;
    private Provider defProv = null;
    private boolean switchProvider = false;
    private static boolean isIAIKLoaded = false;

    public void init(Subject subject, Map map, Map map2) {
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthSafeWord, locale);
        if (debug.messageEnabled()) {
            debug.message("SafeWord resource bundle locale=" + locale);
        }
        this.options = map2;
        this.sharedState = map;
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        try {
            if (n == 1) {
                this.initAuthConfig();
                if (callbackArray != null && callbackArray.length == 0) {
                    this.userTokenId = (String)this.sharedState.get(this.getUserKey());
                    if (this.userTokenId == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.userTokenId = this.getUserName(callbackArray);
                }
                this.initSafeWordClient();
                if (this.sendRequestForChallengeID()) {
                    this.setDynamicText(2);
                }
                if (this.version != null && this.version.equals(DEFAULT_EASSP_VERSION)) {
                    long l = System.currentTimeMillis();
                    new TimeoutThread(l).start();
                }
                return 2;
            }
            if (n == 2) {
                String string = this.getPassword(callbackArray);
                this.storeUsernamePasswd(this.userTokenId, string);
                this.flag = true;
                this.authenticate(string);
                return -1;
            }
            if (debug.messageEnabled()) {
                debug.message("Invalid login state: " + n);
            }
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInvalidState", new Object[]{new Integer(n)});
        }
        catch (AuthLoginException authLoginException) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            this.setFailureID(this.userTokenId);
            throw authLoginException;
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new SafeWordPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.challengeID = null;
    }

    private synchronized void setSecurityProvider() {
        block9: {
            try {
                Serializable serializable;
                Serializable serializable2;
                Provider[] providerArray = Security.getProviders();
                if (!isIAIKLoaded) {
                    serializable2 = Class.forName("iaik.security.provider.IAIK");
                    serializable = (Provider)((Class)serializable2).newInstance();
                    Security.removeProvider(((Provider)serializable).getName());
                    if (debug.messageEnabled()) {
                        debug.message("Loaded provider : " + ((Provider)serializable).getInfo());
                    }
                    Security.insertProviderAt((Provider)serializable, 2);
                    isIAIKLoaded = true;
                }
                this.defProv = providerArray[0];
                serializable2 = new Sun();
                if (debug.messageEnabled()) {
                    debug.message("default provider: " + this.defProv.getName() + ", sun provider: " + ((Provider)serializable2).getName());
                }
                if (!this.defProv.getName().equals(((Provider)serializable2).getName())) {
                    Security.removeProvider(((Provider)serializable2).getName());
                    Security.insertProviderAt((Provider)serializable2, 1);
                    this.switchProvider = true;
                }
                if (debug.messageEnabled()) {
                    serializable = new StringBuffer();
                    providerArray = Security.getProviders();
                    int n = 0;
                    while (n < providerArray.length) {
                        Provider provider = providerArray[n];
                        ((StringBuffer)serializable).append("\t" + provider.getName() + "\n");
                        ++n;
                    }
                    debug.message("Current providers = " + ((StringBuffer)serializable).toString());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                debug.message("Provider IAIK not found. Add iaik_jce.jar or iaik_jce_full.jar to your classpath.");
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block9;
                debug.message("Error in 'setSecurityProvider' : " + exception);
            }
        }
    }

    private void resetProvider() {
        if (this.switchProvider) {
            debug.message("resetting provider ...");
            Security.removeProvider(this.defProv.getName());
            Security.insertProviderAt(this.defProv, 1);
            this.switchProvider = false;
            this.defProv = null;
        }
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options != null) {
            String string;
            this.serverSpec = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_SERVER_SPECIFICATION, (String)DEFAULT_SERVER_SPECIFICATION);
            this.version = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_EASSP_VERSION, (String)DEFAULT_EASSP_VERSION);
            this.serverVerifFilesPath = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_SRVR_VERIF_PATH);
            if (this.serverVerifFilesPath == null) {
                this.serverVerifFilesPath = this.getServerConfigPath();
            }
            if ((string = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_LOG_ENABLE, (String)"true")).equals("false")) {
                this.logEnabled = "OFF";
            }
            this.statusLogLevel = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_LOG_LEVEL, (String)DEFAULT_LOG_LEVEL);
            this.statusLogFilePath = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_LOG_PATH);
            if (this.statusLogFilePath == null) {
                this.statusLogFilePath = this.getServerLogPath();
            }
            this.authLevel = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_AUTH_LEVEL);
            this.clientType = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_CLIENT_TYPE);
            this.minimumStrength = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_MINIMUM_STRENGTH, (String)DEFAULT_MINIMUM_STRENGTH);
            this.timeOut = Misc.getMapAttr((Map)this.options, (String)ATTRIBUTE_TIMEOUT, (String)DEFAULT_TIMEOUT);
            if (debug.messageEnabled()) {
                debug.message("SafeWord Auth config parameters:\niplanet-am-auth-safeword-server-specification: " + this.serverSpec + "\n" + ATTRIBUTE_SRVR_VERIF_PATH + ": " + this.serverVerifFilesPath + "\n" + ATTRIBUTE_TIMEOUT + ": " + " timeOut: " + this.timeOut + "\n" + ATTRIBUTE_LOG_ENABLE + ": " + this.logEnabled + "\n" + ATTRIBUTE_LOG_LEVEL + ": " + this.statusLogLevel + "\n" + ATTRIBUTE_LOG_PATH + ": " + this.statusLogFilePath + "\n" + ATTRIBUTE_EASSP_VERSION + ": " + this.version + "\n" + ATTRIBUTE_CLIENT_TYPE + ": " + this.clientType + "\n" + ATTRIBUTE_AUTH_LEVEL + ": " + this.authLevel + "\n");
            }
        } else {
            debug.error("options is null");
            throw new AuthLoginException(amAuthSafeWord, "SafeWordOptInit", null);
        }
    }

    private String getUserName(Callback[] callbackArray) throws AuthLoginException {
        return ((NameCallback)callbackArray[0]).getName();
    }

    private void initSafeWordClient() throws AuthLoginException {
        this.setSecurityProvider();
        SwecConfig swecConfig = new SwecConfig();
        swecConfig.setDefaults();
        swecConfig.setProperty("Eassp_Version", this.version);
        swecConfig.setProperty("Server_Spec", this.serverSpec);
        swecConfig.setProperty("Server_Verification_Files_Path", this.serverVerifFilesPath);
        swecConfig.setProperty("Status_Log_File_Path", this.statusLogFilePath);
        swecConfig.setProperty("Socket_Timeout", this.timeOut);
        swecConfig.setProperty("File_Status_Log_Enable", this.logEnabled);
        swecConfig.setProperty("GLOBAL_Message_Level", this.statusLogLevel);
        swecConfig.setProperty("Socket_Timeout", this.timeOut);
        if (this.version != null && (this.version.equals("201") || this.version.equals("200"))) {
            if (debug.messageEnabled()) {
                debug.message("Set 20x specific configuration - EASSP Ver: " + this.version);
            }
            swecConfig.setProperty("SSL_Enable", "ON");
            SimpleSSLClient.seedRandomGenerator();
        }
        debug.message("About to get new SafeWordClient");
        try {
            this.swClient = new SafeWordClient(swecConfig);
            if (debug.messageEnabled()) {
                debug.message("New SafeWordClient: " + this.swClient.getResultText());
            }
        }
        catch (Exception exception) {
            debug.error("Failed to create new SafeWordClient.", (Throwable)exception);
            throw new AuthLoginException(amAuthSafeWord, "SafeWordNewSWClient", null, exception);
        }
        debug.message("Done init new SafeWordClient");
        this.resetProvider();
    }

    private boolean sendRequestForChallengeID() throws AuthLoginException {
        EasspMessage easspMessage;
        EasspMessage easspMessage2;
        Object object;
        if (this.userTokenId == null || this.userTokenId.equals("")) {
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordUserIdNull", null);
        }
        try {
            if (!this.userTokenId.equals(new String(this.userTokenId.getBytes("ASCII"), "ASCII"))) {
                this.closeClient();
                throw new AuthLoginException(amAuthSafeWord, "SafeWordUseridNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInputEncodingException", null);
        }
        try {
            object = this.swClient.createRequestMsg(this.userTokenId, "name");
            if (debug.messageEnabled()) {
                debug.message("Submitting requestMsg for userID: " + this.userTokenId);
            }
            object.setAgentName(this.clientType);
            object.setClientType(this.clientType);
            boolean bl = true;
            easspMessage2 = null;
            object.setAuthenticationRequirements(bl, this.minimumStrength, easspMessage2);
            easspMessage = this.swClient.sendMessage(object);
        }
        catch (Exception exception) {
            debug.error("Failed to send/receive eassp message :" + exception.getMessage());
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordEasspError", null);
        }
        object = easspMessage.getIdData();
        String string = easspMessage.getStatusText();
        switch (easspMessage.getMessageType()) {
            case 1: {
                if (debug.messageEnabled()) {
                    debug.message("Received challenge to auth request by " + (String)object);
                }
                easspMessage2 = easspMessage;
                this.aState = new AuthenState(easspMessage2);
                AuthenticatorData authenticatorData = this.aState.getCurrentAuthenticator();
                try {
                    if (authenticatorData instanceof FixedPwdData) {
                        debug.message("Current Authenticator Fixed Password");
                        return false;
                    }
                    if (authenticatorData instanceof DynamicPwdData) {
                        debug.message("Current Authenticator Dynamic Password");
                        DynamicPwdData dynamicPwdData = (DynamicPwdData)authenticatorData;
                        this.challengeID = dynamicPwdData.getChallenge();
                        return true;
                    }
                }
                catch (Exception exception) {
                    debug.error("Received Non-Dynamic Authenticator");
                    this.setFailureID(this.userTokenId);
                    this.closeClient();
                    throw new AuthLoginException(amAuthSafeWord, "SafeWordUnsupportedAuthenticator", null, exception);
                }
            }
            case 3: {
                this.closeClient();
                if (easspMessage.passedCheck()) {
                    debug.error("Successful Authentication, but only id sent. Msg: " + string);
                    this.setFailureID(this.userTokenId);
                    throw new AuthLoginException(amAuthSafeWord, "SafeWordSuccessOnlyUserID", new Object[]{string});
                }
                debug.error("Authentication Failed, only id sent. Check for lockout on server. Msg: " + string);
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthSafeWord, "SafeWordLoginFailed", new Object[]{string});
            }
        }
        this.closeClient();
        this.setFailureID(this.userTokenId);
        debug.error("Authentication Failed, unknown return value: " + easspMessage.getMessageType());
        throw new AuthLoginException(amAuthSafeWord, "SafeWordLoginFailedUnknown", new Object[]{string});
    }

    private void setDynamicText(int n) throws AuthLoginException {
        Callback[] callbackArray = this.getCallback(n);
        String string = ((PasswordCallback)callbackArray[0]).getPrompt();
        boolean bl = ((PasswordCallback)callbackArray[0]).isEchoOn();
        if (debug.messageEnabled()) {
            debug.message("Set dynamic text: challengeID: " + this.challengeID);
        }
        if (this.challengeID != null) {
            string = string + "[" + this.challengeID + "]: ";
        }
        callbackArray[0] = new PasswordCallback(string, bl);
        this.replaceCallback(n, 0, callbackArray[0]);
    }

    private String getPassword(Callback[] callbackArray) throws AuthLoginException {
        char[] cArray = ((PasswordCallback)callbackArray[0]).getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callbackArray[0]).clearPassword();
        return new String(cArray2);
    }

    private void authenticate(String string) throws AuthLoginException {
        FixedPwdData fixedPwdData;
        if (string == null || string.equals("")) {
            if (debug.messageEnabled()) {
                debug.message(this.userTokenId + " supplied no challenge response");
            }
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordNoChallRsp", null);
        }
        try {
            if (!string.equals(new String(string.getBytes("ASCII"), "ASCII"))) {
                this.closeClient();
                throw new AuthLoginException(amAuthSafeWord, "SafeWordChalRspNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.closeClient();
            throw new AuthLoginException(amAuthSafeWord, "SafeWordInputEncodingException", null);
        }
        int n = this.aState.getAuthenComboCount();
        if (n > 1 && debug.messageEnabled()) {
            debug.message("Authenticator Combo (" + n + " authenticators) not supported");
        }
        if (debug.messageEnabled()) {
            debug.message("Anthenticator Combo count = " + n);
        }
        AuthenticatorData authenticatorData = this.aState.getCurrentAuthenticator();
        debug.message("Checking challenge response return message type");
        try {
            if (authenticatorData instanceof FixedPwdData) {
                fixedPwdData = (FixedPwdData)authenticatorData;
                fixedPwdData.setPwd(string);
            } else if (authenticatorData instanceof DynamicPwdData) {
                fixedPwdData = (DynamicPwdData)authenticatorData;
                fixedPwdData.setPwd(string);
            }
        }
        catch (Exception exception) {
            this.closeClient();
            debug.error("Received unknown Authenticator");
            throw new AuthLoginException(amAuthSafeWord, "SafeWordUnsupportedAuthenticator", null, exception);
        }
        debug.message("Challenge response return message type Dynamic");
        fixedPwdData = this.swClient.createResponseMsg(this.aState);
        debug.message("After creating new responseMsg");
        fixedPwdData.setAgentName(this.clientType);
        fixedPwdData.setClientType(this.clientType);
        boolean bl = true;
        String string2 = null;
        fixedPwdData.setAuthenticationRequirements(bl, this.minimumStrength, string2);
        EasspMessage easspMessage = this.swClient.sendMessage((EasspMessage)fixedPwdData);
        debug.message("After creating new returnMsg");
        String string3 = easspMessage.getIdData();
        String string4 = easspMessage.getStatusText();
        if (debug.messageEnabled()) {
            debug.message("Challenge response returns '" + string4 + "' for userid " + string3);
        }
        this.closeClient();
        if (easspMessage.passedCheck()) {
            if (debug.messageEnabled()) {
                debug.message("Authentication successful for userid = " + this.userTokenId + ", id = " + string3);
            }
        } else {
            debug.error("SafeWord authentication failed for userid = " + this.userTokenId + ", id = " + string3);
            throw new InvalidPasswordException(amAuthSafeWord, "SafeWordChallFailed", null, this.userTokenId, null);
        }
        this.setAuthLevel(Integer.parseInt(this.authLevel));
    }

    private String getServerConfigPath() {
        if (this.serverVerifFilesPath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DEFAULT_VAR_DIR).append("/auth/safeword/serverVerification");
            this.serverVerifFilesPath = stringBuffer.toString();
        }
        return this.serverVerifFilesPath;
    }

    private String getServerLogPath() {
        if (this.statusLogFilePath == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(DEFAULT_VAR_DIR).append("/auth/safeword/safe.log");
            this.statusLogFilePath = stringBuffer.toString();
        }
        return this.statusLogFilePath;
    }

    private void closeClient() {
        this.swClient.close();
        this.swClient = null;
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthSafeWord);
        }
    }

    class TimeoutThread
    extends Thread {
        long start;
        int iTimeOut;

        public TimeoutThread(long l) {
            this.iTimeOut = Integer.parseInt(SafeWord.this.timeOut);
            this.start = l;
        }

        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                try {
                    if (l - this.start >= (long)(this.iTimeOut * 1000) && !SafeWord.this.flag) {
                        SafeWord.this.closeClient();
                        break;
                    }
                    if (SafeWord.this.flag) break;
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("Error in timeout thread run : " + interruptedException);
                }
            }
        }
    }
}

