/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.radius;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.radius.RADIUSPrincipal;
import com.sun.identity.authentication.modules.radius.client.ChallengeException;
import com.sun.identity.authentication.modules.radius.client.RadiusConn;
import com.sun.identity.authentication.modules.radius.client.RejectException;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import java.io.IOException;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class RADIUS
extends AMLoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private static String adminDN;
    private static String hostName;
    private String userTokenId = null;
    private String attribute = "dn";
    private String userDN;
    private String authDN = "";
    private String authPassword = "";
    private String searchFilter = "";
    private String baseDN = "";
    private String serverHost = "";
    private String userNamingAttr = "uid";
    private String ssl = "false";
    private String passwd = null;
    private String sState;
    private ChallengeException cException;
    private String challengeID;
    private static HashSet orgHash;
    private final int FINISHED = -1;
    private final int REJECTED = 0;
    private final int LOGIN = 1;
    private final int CHALLENGE = 2;
    private boolean primary = true;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private RADIUSPrincipal userPrincipal = null;
    private String username;
    private char[] password;
    private static final int MSG_INFORMATION = 0;
    private static final int MSG_WARNING = 1;
    private static final int MSG_ERROR = 2;
    private static boolean helperConfigDone;
    private static Locale locale;
    private ResourceBundle bundle = null;
    private static Debug debug;
    private static final String DEFAULT_TIMEOUT = "5";
    private static final String DEFAULT_SERVER_PORT = "1645";
    private String server1;
    private String server2;
    private String sharedSecret;
    private String serverPort = "1645";
    private int iServerPort = 1645;
    private String timeOut = "5";
    private int iTimeOut = 5;
    private RadiusConn _radiusConn = null;
    private int screenState;
    private boolean radiusSSL = false;
    private static final String amAuthRadius = "amAuthRadius";
    private boolean getCredentialsFromSharedState;

    public void init(Subject subject, Map map, Map map2) {
        block10: {
            try {
                this.bundle = AMLoginModule.amCache.getResBundle(amAuthRadius, this.getLoginLocale());
                if (debug.messageEnabled()) {
                    debug.message("Radius resbundle locale=" + this.getLoginLocale());
                }
                this.sharedState = map;
                this.options = map2;
                if (map2 != null) {
                    try {
                        this.server1 = Misc.getServerMapAttr((Map)map2, (String)"iplanet-am-auth-radius-server1");
                        if (this.server1 == null) {
                            this.server1 = "localhost";
                            debug.error("Error: primary server attribute misconfigured using localhost");
                        }
                        this.server2 = Misc.getServerMapAttr((Map)map2, (String)"iplanet-am-auth-radius-server2");
                        if (this.server1 == null) {
                            this.server1 = "localhost";
                            debug.error("Error: primary server attribute misconfigured using localhost");
                        }
                        this.sharedSecret = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-radius-secret");
                        this.serverPort = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-radius-server-port", (String)DEFAULT_SERVER_PORT);
                        this.iServerPort = Integer.parseInt(this.serverPort);
                        this.timeOut = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-radius-timeout", (String)DEFAULT_TIMEOUT);
                        this.iTimeOut = Integer.parseInt(this.timeOut);
                        String string = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-radius-auth-level");
                        if (debug.messageEnabled()) {
                            debug.message("server1: " + this.server1 + " server2: " + this.server2 + " serverPort: " + this.serverPort + " timeOut: " + this.timeOut + " authLevel: " + string);
                        }
                        if (this.sharedSecret == null || this.sharedSecret.equals("")) {
                            debug.error("RADIUS initialization failure; no Shared Secret");
                        }
                        break block10;
                    }
                    catch (Exception exception) {
                        debug.error("RADIUS parameters initialization failure", (Throwable)exception);
                    }
                    break block10;
                }
                debug.error("options not initialized");
            }
            catch (Exception exception) {
                debug.error("RADIUS init Error....", (Throwable)exception);
            }
        }
    }

    private void setDynamicText(int n) throws AuthLoginException {
        Callback[] callbackArray = this.getCallback(n);
        String string = ((PasswordCallback)callbackArray[0]).getPrompt();
        boolean bl = ((PasswordCallback)callbackArray[0]).isEchoOn();
        if (this.challengeID != null) {
            string = string + "[" + this.challengeID + "]: ";
        }
        callbackArray[0] = new PasswordCallback(string, bl);
        this.replaceCallback(n, 0, callbackArray[0]);
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        String string = null;
        switch (n) {
            case 1: {
                try {
                    this._radiusConn = new RadiusConn(this.server1, this.server2, this.iServerPort, this.sharedSecret, this.iTimeOut);
                }
                catch (SocketException socketException) {
                    debug.error("RADIUS login failure; Socket Exception se == ", (Throwable)socketException);
                    this.shutdown();
                    throw new AuthLoginException(amAuthRadius, "RadiusNoServer", null);
                }
                catch (Exception exception) {
                    debug.error("RADIUS login failure; Can't connect to RADIUS server", (Throwable)exception);
                    this.shutdown();
                    throw new AuthLoginException(amAuthRadius, "RadiusNoServer", null);
                }
                if (callbackArray != null && callbackArray.length == 0) {
                    this.username = (String)this.sharedState.get(this.getUserKey());
                    string = (String)this.sharedState.get(this.getPwdKey());
                    if (this.username == null || string == null) {
                        return 1;
                    }
                    this.getCredentialsFromSharedState = true;
                } else {
                    this.username = ((NameCallback)callbackArray[0]).getName();
                    string = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
                    if (debug.messageEnabled()) {
                        debug.message("username: " + this.username);
                    }
                }
                this.storeUsernamePasswd(this.username, string);
                try {
                    this.succeeded = false;
                    this._radiusConn.authenticate(this.username, string);
                }
                catch (RejectException rejectException) {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.message("Radius login request rejected", (Throwable)rejectException);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new InvalidPasswordException(amAuthRadius, "RadiusLoginFailed", null, this.username, rejectException);
                }
                catch (IOException iOException) {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.error("Radius request IOException", (Throwable)iOException);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.error("Radius No Such Algorithm Exception", (Throwable)noSuchAlgorithmException);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (ChallengeException challengeException) {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    this.cException = challengeException;
                    this.sState = challengeException.getState();
                    if (this.sState == null) {
                        debug.error("Radius failure - no state returned in challenge");
                        this.shutdown();
                        this.setFailureID(this.username);
                        throw new AuthLoginException(amAuthRadius, "RadiusAuth", null);
                    }
                    this.challengeID = challengeException.getReplyMessage();
                    if (debug.messageEnabled()) {
                        debug.message("Server challenge with challengeID: " + this.challengeID);
                    }
                    this.setDynamicText(2);
                    return 2;
                }
                catch (Exception exception) {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null, exception);
                }
                this.succeeded = true;
                break;
            }
            case 2: {
                this.passwd = this.getChallengePassword(callbackArray);
                if (debug.messageEnabled()) {
                    debug.message("reply to challenge--username: " + this.username);
                }
                try {
                    this.succeeded = false;
                    this._radiusConn.replyChallenge(this.username, this.passwd, this.cException);
                }
                catch (ChallengeException challengeException) {
                    this.sState = challengeException.getState();
                    if (this.sState == null) {
                        debug.error("handle Challenge failure - no state returned");
                        this.shutdown();
                        this.setFailureID(this.username);
                        throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                    }
                    this.resetCallback(2, 1);
                    this.challengeID = challengeException.getReplyMessage();
                    if (debug.messageEnabled()) {
                        debug.message("Server challenge again with challengeID: " + this.challengeID);
                    }
                    this.setDynamicText(2);
                    return 2;
                }
                catch (RejectException rejectException) {
                    debug.error("Radius challenge response rejected", (Throwable)rejectException);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new InvalidPasswordException(amAuthRadius, "RadiusLoginFailed", null, this.username, rejectException);
                }
                catch (IOException iOException) {
                    debug.error("Radius challenge IOException", (Throwable)iOException);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    debug.error("Radius No Such Algorithm Exception", (Throwable)noSuchAlgorithmException);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                catch (Exception exception) {
                    debug.error("RADIUS challenge Authentication Failed ", (Throwable)exception);
                    this.shutdown();
                    this.setFailureID(this.username);
                    throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
                }
                this.succeeded = true;
                break;
            }
            default: {
                debug.error("RADIUS Authentication Failed - invalid state" + n);
                this.shutdown();
                this.succeeded = false;
                this.setFailureID(this.username);
                throw new AuthLoginException(amAuthRadius, "RadiusLoginFailed", null);
            }
        }
        if (this.succeeded) {
            if (debug.messageEnabled()) {
                debug.message("RADIUS authentication successful");
            }
            if (this.username != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.username, ",");
                this.userTokenId = stringTokenizer.nextToken();
            }
            if (debug.messageEnabled()) {
                debug.message("userTokenID: " + this.userTokenId);
            }
            this.shutdown();
            return -1;
        }
        if (debug.messageEnabled()) {
            debug.message("RADIUS authentication to be ignored");
        }
        return 0;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new RADIUSPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.authPassword = null;
        this.passwd = null;
        this.challengeID = null;
        this.userTokenId = null;
        this.username = null;
        this.password = null;
    }

    private String getChallengePassword(Callback[] callbackArray) throws AuthLoginException {
        char[] cArray = ((PasswordCallback)callbackArray[0]).getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callbackArray[0]).clearPassword();
        return new String(cArray2);
    }

    private String charToString(char[] cArray, Callback callback) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callback).clearPassword();
        return new String(cArray2);
    }

    public void shutdown() {
        try {
            this._radiusConn.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._radiusConn = null;
    }

    static {
        orgHash = new HashSet();
        helperConfigDone = false;
        locale = null;
        debug = null;
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthRadius);
        }
    }
}

