/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.membership;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.modules.membership.MembershipPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.authentication.spi.UserNamePasswordValidationException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class Membership
extends AMLoginModule {
    private static Debug debug;
    private ResourceBundle bundle;
    private Map sharedState;
    private static String adminDN;
    private static String hostName;
    private static int port;
    private static boolean ldapSSL;
    private static HashSet orgHash;
    static final int USER_NOT_FOUND = 1;
    static final int PASSWORD_EXP = 2;
    static final int PASSWORD_INVALID = 3;
    static final int CONFIG_ERROR = 4;
    static final int CANNOT_CONTACT_SERVER = 5;
    static final int PASSWORD_EXPIRED_STATE = 20;
    static final int PASSWORD_EXPIRING = 21;
    static final int PASSWORD_CHANGED = 22;
    static final int PASSWORD_MISMATCH = 23;
    static final int PASSWORD_USERNAME_SAME = 24;
    static final int PASSWORD_NOT_UPDATE = 25;
    static final int SUCCESS = 26;
    static final int WRONG_PASSWORD_ENTERED = 27;
    static final int PASSWORD_UPDATED_SUCCESSFULLY = 28;
    static final int USER_PASSWORD_SAME = 29;
    static final int PASSWORD_MIN_CHARACTERS = 30;
    static final int SERVER_DOWN = 31;
    static final int PASSWORD_RESET_STATE = 32;
    private static final int FINISHED = -1;
    private static final int LOGIN_FAILED = 0;
    private static final int LOGIN = 1;
    private static final int PASSWORD_CHANGE = 2;
    private static final int WRONG_PASSWORD_ERROR = 3;
    private static final int NO_USER_PROFILE_ERROR = 4;
    private static final int NO_USER_NAME_ERROR = 5;
    private static final int NO_PASSWORD_ERROR = 6;
    private static final int NO_CONFIRMATION_ERROR = 7;
    private static final int PASSWORD_MISMATCH_ERROR = 8;
    private static final int CONFIGURATION_ERROR = 9;
    private static final int USER_EXISTS_ERROR = 10;
    private static final int PROFILE_ERROR = 11;
    private static final int MISSING_REQ_FIELD_ERROR = 12;
    private static final int USER_PASSWORD_SAME_ERROR = 13;
    private static final int INVALID_PASSWORD = 14;
    private static final int PASSWORD_EXPIRED = 15;
    private static final int REGISTRATION = 16;
    private static final int CHOOSE_USERNAMES = 17;
    private static final int DISCLAIMER = 18;
    private int previousScreen;
    private String validatedUserID;
    private MembershipPrincipal userPrincipal;
    private Map options;
    private boolean primary = true;
    private LDAPAuthUtils ldapUtil;
    private String serviceStatus;
    private boolean isDisclaimerExist = true;
    private Set defaultRoles;
    private int requiredPasswordLength;
    private String peopleContainerDN;
    private PasswordCallback pwdCallback;
    private String createMyOwn;
    private String userID;
    private String userName;
    private Map userAttrs;
    private static final String amAuthMembership = "amAuthMembership";
    private String regEx;
    private static final String INVALID_CHARS = "iplanet-am-auth-membership-invalid-chars";
    private boolean isReset;
    private boolean getCredentialsFromSharedState;
    private Callback[] callbacks;

    public void init(Subject subject, Map map, Map map2) {
        java.util.Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthMembership, locale);
        if (debug.messageEnabled()) {
            debug.message("Membership getting resource bundle for locale: " + locale);
        }
        this.options = map2;
        this.sharedState = map;
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("in process(), login state is " + n);
        }
        this.callbacks = callbackArray;
        switch (n) {
            case 1: {
                this.previousScreen = 1;
                int n2 = 0;
                if (callbackArray != null && callbackArray.length != 0) {
                    n2 = ((ConfirmationCallback)callbackArray[2]).getSelectedIndex();
                    if (debug.messageEnabled()) {
                        debug.message("LOGIN page button index: " + n2);
                    }
                }
                if (n2 == 0) {
                    return this.loginUser(callbackArray);
                }
                this.initAuthConfig();
                return 16;
            }
            case 2: {
                int n3 = ((ConfirmationCallback)callbackArray[3]).getSelectedIndex();
                if (n3 == 0) {
                    return this.changeToNewPassword(callbackArray);
                }
                if (this.isReset) {
                    this.isReset = false;
                    return 1;
                }
                return -1;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.previousScreen;
            }
            case 17: {
                return this.chooseUserID(callbackArray);
            }
            case 18: {
                int n4 = ((ConfirmationCallback)callbackArray[0]).getSelectedIndex();
                if (debug.messageEnabled()) {
                    debug.message("DISCLAIMER page button index: " + n4);
                }
                if (n4 == 0) {
                    return this.registerNewUser();
                }
                if (n4 == 1) {
                    return 1;
                }
                throw new AuthLoginException(amAuthMembership, "loginException", null);
            }
        }
        this.previousScreen = 16;
        int n5 = ((ConfirmationCallback)callbackArray[callbackArray.length - 1]).getSelectedIndex();
        if (debug.messageEnabled()) {
            debug.message("REGISTRATION page button index: " + n5);
        }
        if (n5 == 0) {
            int n6 = this.getAndCheckRegistrationFields(callbackArray);
            if (n6 == 16) {
                if (this.isDisclaimerExist) {
                    return 18;
                }
                return this.registerNewUser();
            }
            return n6;
        }
        if (n5 == 1) {
            this.clearCallbacks(callbackArray);
            return 1;
        }
        return 0;
    }

    private void clearCallbacks(Callback[] callbackArray) {
        int n = 0;
        while (n < callbackArray.length) {
            if (callbackArray[n] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callbackArray[n];
                nameCallback.setName("");
            }
            ++n;
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new MembershipPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
        this.userName = null;
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options == null || this.options.isEmpty()) {
            debug.error("options is null or empty");
            throw new AuthLoginException(amAuthMembership, "unable-to-initialize-options", null);
        }
        try {
            String string;
            String string2 = null;
            if (!orgHash.contains(this.getRequestOrg())) {
                string2 = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-server");
                if (string2 == null) {
                    debug.error("Fatal error: primary ldap attribute misconfigured");
                    throw new AuthLoginException(amAuthMembership, "missing-primary-server", null);
                }
                if (debug.messageEnabled()) {
                    debug.message("Using primary server " + string2);
                }
            } else {
                string2 = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-server2");
                if (string2 == null) {
                    debug.message("No secondary server, resetting to primary");
                    this.removeOrg();
                    throw new AuthLoginException(amAuthMembership, "Nosecserver", null);
                }
                this.primary = false;
                if (debug.messageEnabled()) {
                    debug.message("Using secondary server " + string2);
                }
            }
            if ((string = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-base-dn")) == null) {
                debug.error("Fatal error: baseDN for search has invalid value");
            }
            String string3 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-bind-dn", (String)"");
            String string4 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-bind-passwd", (String)"");
            String string5 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-user-naming-attribute", (String)"uid");
            Set set = (Set)this.options.get("iplanet-am-auth-membership-user-search-attributes");
            String string6 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-search-filter", (String)"");
            boolean bl = Boolean.valueOf(Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-ssl-enabled", (String)"false"));
            String string7 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-auth-level");
            if (string7 != null) {
                try {
                    int n = Integer.parseInt(string7);
                    this.setAuthLevel(n);
                }
                catch (NumberFormatException numberFormatException) {
                    debug.error("invalid auth level " + string7, (Throwable)numberFormatException);
                }
            }
            String string8 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-search-scope", (String)"SUBTREE");
            int n = 2;
            if (string8.equalsIgnoreCase("OBJECT")) {
                n = 0;
            } else if (string8.equalsIgnoreCase("ONELEVEL")) {
                n = 1;
            }
            String string9 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-return-user-dn", (String)"true");
            int n2 = string2.indexOf(58);
            int n3 = 389;
            String string10 = null;
            if (n2 != -1) {
                string10 = string2.substring(n2 + 1);
                n3 = Integer.parseInt(string10);
                string2 = string2.substring(0, n2);
            }
            this.regEx = Misc.getMapAttr((Map)this.options, (String)INVALID_CHARS);
            this.ldapUtil = new LDAPAuthUtils(string2, n3, bl, this.bundle, string);
            this.ldapUtil.setScope(n);
            this.ldapUtil.setFilter(string6);
            this.ldapUtil.setUserNamingAttribute(string5);
            this.ldapUtil.setUserSearchAttribute(set);
            this.ldapUtil.setAuthPassword(string4);
            this.ldapUtil.setReturnUserDN(string9);
            this.ldapUtil.setAuthDN(string3);
            if (debug.messageEnabled()) {
                debug.message("setup LDAPAuthUtils:\nserver host: " + string2 + "\nserver port: " + n3 + "\nbase DN: " + string + "\nsearch scope " + n + "\nsearch filter: " + string6 + "\nuser naming attribute: " + string5 + "\nuser search attributes: " + set + "\nreturned user DN: " + string9 + "\nbind DN: " + string3);
            }
            this.serviceStatus = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-default-user-status", (String)"Active");
            this.isDisclaimerExist = this.getNumberOfStates() >= 18;
            this.defaultRoles = (Set)this.options.get("iplanet-am-auth-membership-default-roles");
            string8 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-min-password-length");
            if (string8 != null) {
                this.requiredPasswordLength = Integer.parseInt(string8);
            }
            Map map = this.getOrgServiceTemplate(null, "iPlanetAMAuthService");
            this.peopleContainerDN = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-user-container");
            if (!Misc.isDescendantOf((String)this.peopleContainerDN, (String)this.getRequestOrg())) {
                debug.error("Default People Container '" + this.peopleContainerDN + "' does not belong to org " + this.getRequestOrg());
                throw new AuthLoginException(amAuthMembership, "invalidContainerDN", null);
            }
            if (this.callbacks != null && this.callbacks.length != 0) {
                Callback[] callbackArray = this.getCallback(2);
                this.pwdCallback = (PasswordCallback)callbackArray[0];
            }
        }
        catch (Exception exception) {
            debug.error("unable to initialize in initAuthConfig(): ", (Throwable)exception);
            throw new AuthLoginException(amAuthMembership, "LDAPex", null, exception);
        }
    }

    private static void initSystemProperties() {
        adminDN = AMLoginModule.getSuperAdminUser();
        hostName = SystemProperties.get((String)"com.iplanet.am.directory.host");
        String string = SystemProperties.get((String)"com.iplanet.am.directory.port");
        port = Integer.parseInt(string);
        ldapSSL = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.directory.ssl.enabled", (String)"false"));
        if (debug.messageEnabled()) {
            debug.message("system parameters from AMConfig.properties: \nadminDN: " + adminDN + "\nHost: " + hostName + "\nPORT: " + port + "\nSSL: " + ldapSSL);
        }
    }

    private int loginUser(Callback[] callbackArray) throws AuthLoginException {
        String string = null;
        if (callbackArray != null && callbackArray.length == 0) {
            this.userName = (String)this.sharedState.get(this.getUserKey());
            string = (String)this.sharedState.get(this.getPwdKey());
            if (this.userName == null || string == null) {
                return 1;
            }
            this.getCredentialsFromSharedState = true;
        } else {
            this.userName = ((NameCallback)callbackArray[0]).getName();
            string = this.getPassword((PasswordCallback)callbackArray[1]);
        }
        this.storeUsernamePasswd(this.userName, string);
        if (debug.messageEnabled()) {
            debug.message("trying to login user: " + this.userName);
        }
        try {
            if (this.isSuperAdmin(this.userName)) {
                this.ldapUtil = new LDAPAuthUtils(hostName, port, ldapSSL, this.bundle);
                this.ldapUtil.authenticateSuperAdmin(this.userName, string, adminDN);
                if (this.ldapUtil.getState() == 26) {
                    this.validatedUserID = adminDN;
                    return -1;
                }
                debug.message("Invalid admin ID or admin Password");
                this.setFailureID(this.ldapUtil.getUserId(this.userName));
                throw new AuthLoginException(amAuthMembership, "InvalidUP", null);
            }
            this.initAuthConfig();
            this.validateUserName(this.userName, this.regEx);
            this.validatePassword(string);
            this.ldapUtil.authenticateUser(this.userName, string);
            int n = this.ldapUtil.getState();
            return this.processMembershipLoginState(n, this.userName, string);
        }
        catch (LDAPUtilException lDAPUtilException) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            String string2 = this.ldapUtil.getUserId();
            this.setFailureID(string2);
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    if (debug.messageEnabled()) {
                        debug.message("The specified user does not exist. userID: " + this.userName);
                    }
                    return 16;
                }
                case 49: {
                    if (debug.messageEnabled()) {
                        debug.message("Invalid password. userID: " + this.userName);
                    }
                    throw new InvalidPasswordException(amAuthMembership, "InvalidUP", null, string2, null);
                }
                case 53: {
                    debug.message("Unwilling to perform. Account inactivated");
                    throw new AuthLoginException(amAuthMembership, "AcctInactive", null);
                }
                case 48: {
                    debug.message("Inappropriate authentication.");
                    throw new AuthLoginException(amAuthMembership, "InappAuth", null);
                }
            }
            throw new AuthLoginException(amAuthMembership, "LDAPex", null, lDAPUtilException);
        }
        catch (UserNamePasswordValidationException userNamePasswordValidationException) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            debug.message("Invalid Characters detected");
            throw new AuthLoginException(userNamePasswordValidationException);
        }
    }

    private int processMembershipLoginState(int n, String string, String string2) throws AuthLoginException {
        try {
            switch (n) {
                case 26: {
                    this.validatedUserID = this.ldapUtil.getUserId();
                    return -1;
                }
                case 21: {
                    this.validatedUserID = this.ldapUtil.getUserId();
                    String string3 = this.bundle.getString("PasswordExp");
                    String string4 = Locale.formatMessage((String)string3, (Object)this.ldapUtil.getExpTime());
                    this.replaceHeader(2, string4);
                    return 2;
                }
                case 32: {
                    this.validatedUserID = this.ldapUtil.getUserId();
                    this.isReset = true;
                    String string5 = this.bundle.getString("PasswordReset");
                    this.replaceHeader(2, string5);
                    return 2;
                }
                case 20: {
                    return 15;
                }
                case 31: {
                    if (this.primary) {
                        this.addOrg();
                        this.initAuthConfig();
                        this.ldapUtil.authenticateUser(string, string2);
                        int n2 = this.ldapUtil.getState();
                        return this.processMembershipLoginState(n2, string, string2);
                    }
                    this.removeOrg();
                    throw new AuthLoginException(amAuthMembership, "LDAPex", null);
                }
                case 1: {
                    if (this.getCredentialsFromSharedState) {
                        this.getCredentialsFromSharedState = false;
                        return 1;
                    }
                    debug.message("The specified user does not exist");
                    throw new AuthLoginException(amAuthMembership, "NoUser", null);
                }
            }
            return 0;
        }
        catch (LDAPUtilException lDAPUtilException) {
            if (this.getCredentialsFromSharedState) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            this.setFailureID(this.ldapUtil.getUserId(string));
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist");
                    throw new AuthLoginException(amAuthMembership, "NoUser", null);
                }
                case 49: {
                    debug.message("Invalid password");
                    throw new AuthLoginException(amAuthMembership, "InvalidUP", null);
                }
            }
            throw new AuthLoginException(amAuthMembership, "LDAPex", null, lDAPUtilException);
        }
    }

    private int changeToNewPassword(Callback[] callbackArray) throws AuthLoginException {
        debug.message("trying to change user password");
        String string = this.getPassword((PasswordCallback)callbackArray[0]);
        String string2 = this.getPassword((PasswordCallback)callbackArray[1]);
        String string3 = this.getPassword((PasswordCallback)callbackArray[2]);
        this.validatePassword(string2);
        try {
            this.ldapUtil.changePassword(string, string2, string3);
            int n = this.ldapUtil.getState();
            return this.processMembershipPasswordState(n);
        }
        catch (LDAPUtilException lDAPUtilException) {
            this.setFailureID(this.ldapUtil.getUserId(this.userName));
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist");
                    return 16;
                }
                case 49: {
                    debug.message("Invalid password");
                    throw new AuthLoginException(amAuthMembership, "InvalidUP", null);
                }
            }
            throw new AuthLoginException(amAuthMembership, "LDAPex", null, lDAPUtilException);
        }
    }

    private int processMembershipPasswordState(int n) throws AuthLoginException {
        switch (n) {
            case 28: {
                this.validatedUserID = this.ldapUtil.getUserId();
                return -1;
            }
            case 25: {
                this.replaceHeader(2, this.bundle.getString("PInvalid"));
                return 2;
            }
            case 23: {
                this.replaceHeader(2, this.bundle.getString("PasswdMismatch"));
                return 2;
            }
            case 24: {
                this.replaceHeader(2, this.bundle.getString("UPSame"));
                return 2;
            }
            case 27: {
                this.replaceHeader(2, this.bundle.getString("PasswdSame"));
                return 2;
            }
            case 30: {
                this.replaceHeader(2, this.bundle.getString("PasswdMinChars"));
                return 2;
            }
            case 29: {
                this.replaceHeader(2, this.bundle.getString("UPsame"));
                return 2;
            }
        }
        return 0;
    }

    private int registerNewUser() throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("trying to register(create) a new user: " + this.userID);
        }
        try {
            AMStoreConnection aMStoreConnection = new AMStoreConnection(this.getSSOSession());
            AMPeopleContainer aMPeopleContainer = aMStoreConnection.getPeopleContainer(this.peopleContainerDN);
            Set set = aMPeopleContainer.searchUsers(this.userID, 2);
            if (set != null && set.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("unable to register, user " + this.userID + " already exists");
                }
                return 10;
            }
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            hashMap.put(this.userID, this.userAttrs);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.serviceStatus);
            this.userAttrs.put("inetuserstatus", hashSet);
            Set set2 = aMPeopleContainer.createUsers(hashMap);
            if (this.defaultRoles != null && this.defaultRoles.size() > 0) {
                Iterator iterator = set2.iterator();
                AMUser aMUser = (AMUser)iterator.next();
                iterator = this.defaultRoles.iterator();
                String string = this.getRequestOrg();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!Misc.isDescendantOf((String)string2, (String)string)) {
                        debug.error("registerNewUser() : role " + string2 + " does not belong to org " + string);
                        continue;
                    }
                    try {
                        if (string2.length() == 0) continue;
                        aMUser.assignRole(string2);
                    }
                    catch (Exception exception) {
                        debug.message("invalid role: ", (Throwable)exception);
                    }
                }
            }
        }
        catch (SSOException sSOException) {
            debug.error("profile exception occured: ", (Throwable)sSOException);
            return 11;
        }
        catch (AMException aMException) {
            debug.error("profile exception occured: ", (Throwable)aMException);
            return 11;
        }
        this.validatedUserID = this.userID;
        if (debug.messageEnabled()) {
            debug.message("registration is completed, created user: " + this.validatedUserID);
        }
        return -1;
    }

    private int getAndCheckRegistrationFields(Callback[] callbackArray) throws AuthLoginException {
        Set set;
        Object object;
        HashMap<Object, Set> hashMap = new HashMap<Object, Set>();
        this.userID = this.getCallbackFieldValue(callbackArray[0]);
        if (this.userID == null || this.userID.equals("")) {
            return 5;
        }
        this.validateUserName(this.userID, this.regEx);
        String string = this.getPassword((PasswordCallback)callbackArray[1]);
        String string2 = this.getPassword((PasswordCallback)callbackArray[2]);
        int n = this.checkPassword(string, string2);
        if (debug.messageEnabled()) {
            debug.message("state returned from checkPassword(): " + n);
        }
        if (n != -1) {
            return n;
        }
        this.validatePassword(string2);
        if (string.equals(this.userID)) {
            return 13;
        }
        int n2 = 0;
        while (n2 < callbackArray.length) {
            object = this.getAttribute(16, n2);
            set = this.getCallbackFieldValues(callbackArray[n2]);
            if (this.isRequired(16, n2) && set.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("Empty value for required field :" + (String)object);
                }
                return 12;
            }
            if (object != null && !((String)object).equals("")) {
                hashMap.put(object, set);
            }
            ++n2;
        }
        this.userAttrs = hashMap;
        try {
            object = new AMStoreConnection(this.getSSOSession()).getPeopleContainer(this.peopleContainerDN);
            set = object.searchUsers(this.userID, 2);
            if (set != null && set.size() > 0) {
                Set set2;
                if (debug.messageEnabled()) {
                    debug.message("user ID " + this.userID + " already exists");
                }
                if ((set2 = this.getNewUserIDs(hashMap, 0)) == null) {
                    return 10;
                }
                ArrayList arrayList = this.getNonExistingUserIDs(set2, (AMPeopleContainer)object);
                this.resetCallback(17, 0);
                Callback[] callbackArray2 = this.getCallback(17);
                ChoiceCallback choiceCallback = (ChoiceCallback)callbackArray2[0];
                String string3 = choiceCallback.getPrompt();
                this.createMyOwn = choiceCallback.getChoices()[0];
                arrayList.add(this.createMyOwn);
                String[] stringArray = arrayList.toArray(new String[0]);
                ChoiceCallback choiceCallback2 = new ChoiceCallback(string3, stringArray, 0, false);
                choiceCallback2.setSelectedIndex(0);
                this.replaceCallback(17, 0, choiceCallback2);
                return 17;
            }
        }
        catch (SSOException sSOException) {
            debug.error("profile exception occured: ", (Throwable)sSOException);
            return 11;
        }
        catch (AMException aMException) {
            debug.error("profile exception occured: ", (Throwable)aMException);
            return 11;
        }
        if (debug.messageEnabled()) {
            debug.message("the user attributes to be created:\n" + this.userAttrs);
        }
        return 16;
    }

    private int checkPassword(String string, String string2) {
        if (string == null || string.equals("")) {
            debug.message("password was missing from the form");
            return 6;
        }
        if (string.length() < this.requiredPasswordLength) {
            debug.message("password was not long enough");
            return 14;
        }
        if (string2 == null || string2.equals("")) {
            debug.message("no confirmation password");
            return 7;
        }
        if (!string.equals(string2)) {
            return 8;
        }
        return -1;
    }

    private int chooseUserID(Callback[] callbackArray) throws AuthLoginException {
        String string = this.getCallbackFieldValue(callbackArray[0]);
        if (string.equals(this.createMyOwn)) {
            return 16;
        }
        String string2 = this.getAttribute(16, 0);
        this.userID = string;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.userID);
        this.userAttrs.put(string2, hashSet);
        if (this.isDisclaimerExist) {
            return 18;
        }
        return this.registerNewUser();
    }

    private String getPassword(PasswordCallback passwordCallback) {
        char[] cArray = passwordCallback.getPassword();
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return new String(cArray2);
    }

    private void replacePasswordPrompt(PasswordCallback passwordCallback, int n, int n2, String string) throws AuthLoginException {
        String string2 = passwordCallback.getPrompt();
        boolean bl = passwordCallback.isEchoOn();
        int n3 = string2.indexOf("#REPLACE#");
        String string3 = string2.substring(0, n3) + string + string2.substring(n3 + 9);
        this.replaceCallback(n, n2, new PasswordCallback(string3, bl));
    }

    private Set getCallbackFieldValues(Callback callback) {
        HashSet<String> hashSet = new HashSet<String>();
        if (callback instanceof NameCallback) {
            String string = ((NameCallback)callback).getName();
            if (string != null && !string.equals("")) {
                hashSet.add(string);
            }
        } else if (callback instanceof PasswordCallback) {
            String string = this.getPassword((PasswordCallback)callback);
            if (string != null && !string.equals("")) {
                hashSet.add(string);
            }
        } else if (callback instanceof ChoiceCallback) {
            String[] stringArray = ((ChoiceCallback)callback).getChoices();
            int[] nArray = ((ChoiceCallback)callback).getSelectedIndexes();
            int n = 0;
            while (n < nArray.length) {
                hashSet.add(stringArray[nArray[n]]);
                ++n;
            }
        }
        return hashSet;
    }

    private String getCallbackFieldValue(Callback callback) {
        Set set = this.getCallbackFieldValues(callback);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            return (String)iterator.next();
        }
        return null;
    }

    private ArrayList getNonExistingUserIDs(Set set, AMPeopleContainer aMPeopleContainer) throws AMException, SSOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Set set2 = aMPeopleContainer.searchUsers(string, 2);
            if (set2 != null && !set2.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private synchronized void addOrg() {
        orgHash.add(this.getRequestOrg());
    }

    private synchronized void removeOrg() {
        orgHash.remove(this.getRequestOrg());
    }

    static {
        orgHash = new HashSet();
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthMembership);
        }
        Membership.initSystemProperties();
    }
}

