/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.cert;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.security.x509.CRLDistributionPoint;
import com.iplanet.security.x509.CRLDistributionPointsExtension;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.authentication.modules.cert.Cert;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

class CRLValidation {
    private Cert certModule = null;
    private Debug debug = null;
    private static final String amAuthCert = "amAuthCert";
    private String searchFilter = null;
    private LDAPAttribute certAttribute = null;
    private LDAPAttribute crlAttribute = null;
    private Date nextCRLUpdate = null;
    private LDAPEntry cachedEntry = null;
    private static CertificateFactory cf = null;

    public CRLValidation(Cert cert) {
        this.certModule = cert;
        this.debug = this.certModule.getDebug();
    }

    public boolean verifyCertificate() throws AuthLoginException {
        if (this.certModule == null) {
            return false;
        }
        return this.verifyCertificate(this.certModule.getLDAPConnection(), this.certModule.getCertificate());
    }

    private boolean verifyCertificate(LDAPConnection lDAPConnection, X509Certificate x509Certificate) throws AuthLoginException {
        Object object;
        Object object2;
        String string = this.certModule.getChkAttrCRL();
        String string2 = null;
        try {
            object2 = (sun.security.x509.X500Name)x509Certificate.getIssuerDN();
            object = new X500Name(((sun.security.x509.X500Name)object2).getEncoded());
            string2 = ((X500Name)object).getAttributeValue(string);
            if (this.debug.messageEnabled()) {
                this.debug.message("verifyCertificate retrieved attribute " + string + " : " + string2);
            }
            this.searchFilter = "(" + string + "=" + string2 + ")";
            if (this.debug.messageEnabled()) {
                this.debug.message("verifyCertificate - ldc.search: using filter: " + this.searchFilter);
            }
        }
        catch (Exception exception) {
            this.debug.error("verifyCertificate : " + exception);
            return false;
        }
        if (!this.getCRLFromCache(lDAPConnection)) {
            return false;
        }
        this.nextCRLUpdate = this.getNextCRLUpdate();
        if (this.nextCRLUpdate != null && this.nextCRLUpdate.before(new Date())) {
            object2 = this.getCRLdpExt(x509Certificate);
            boolean bl = this.getUpdateCRLFromCrlDP(lDAPConnection, this.cachedEntry.getDN().toString(), (CRLDistributionPointsExtension)object2);
            if (!bl) {
                this.debug.error("Failed to update CRL.");
                return false;
            }
        }
        object2 = null;
        try {
            object = this.certAttribute.getByteValues();
            byte[] byArray = (byte[])object.nextElement();
            object2 = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(byArray));
            Enumeration enumeration = this.crlAttribute.getByteValues();
            byArray = (byte[])enumeration.nextElement();
            X509CRL x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(byArray));
            if (x509CRL.isRevoked(x509Certificate)) {
                if (this.debug.messageEnabled()) {
                    this.debug.message("Certificate is CertRevoked.");
                }
                return false;
            }
        }
        catch (Exception exception) {
            this.debug.error("Certificate: CertRevoked = ", (Throwable)exception);
            throw new AuthLoginException(amAuthCert, "CertRevoked", null);
        }
        boolean bl = true;
        if (!((Object)((X509Certificate)object2).getIssuerDN()).equals(((X509Certificate)object2).getSubjectDN())) {
            if (this.debug.messageEnabled()) {
                this.debug.message("Verifying next signer");
            }
            bl = this.verifyCertificate(lDAPConnection, (X509Certificate)object2);
        }
        return bl;
    }

    private Date getNextCRLUpdate() {
        X509CRL x509CRL = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
            Enumeration enumeration = this.crlAttribute.getByteValues();
            byte[] byArray = (byte[])enumeration.nextElement();
            x509CRL = (X509CRL)cf.generateCRL(new ByteArrayInputStream(byArray));
            if (this.debug.messageEnabled()) {
                this.debug.message("NextCRLUpdate : " + x509CRL.getNextUpdate().toString());
            }
        }
        catch (Exception exception) {
            this.debug.error("Error in getting NextCRLUpdate");
            return null;
        }
        return x509CRL.getNextUpdate();
    }

    private boolean getCRLFromCache(LDAPConnection lDAPConnection) {
        try {
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.certModule.getStartSearchLoc(), 2, this.searchFilter, null, false);
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                this.debug.error("verifyCertificate - No CRL Cache is configured");
                return false;
            }
            this.cachedEntry = lDAPSearchResults.next();
            LDAPAttributeSet lDAPAttributeSet = this.cachedEntry.getAttributeSet();
            this.certAttribute = lDAPAttributeSet.getAttribute("cacertificate");
            if (this.certAttribute == null) {
                this.certAttribute = lDAPAttributeSet.getAttribute("cacertificate;binary");
                if (this.certAttribute == null) {
                    return false;
                }
            }
            if (this.certAttribute.size() > 1) {
                this.debug.error("More than one CAs entries are configured");
                return false;
            }
            this.crlAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist");
            if (this.crlAttribute == null) {
                this.crlAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist;binary");
                if (this.crlAttribute == null) {
                    this.debug.error("No CRL Cache is configured");
                    return false;
                }
            }
            if (this.crlAttribute.size() > 1) {
                this.debug.error("More than one CRL entries are configured");
                return false;
            }
        }
        catch (Exception exception) {
            this.debug.error("Error in getting Cached CRL");
            return false;
        }
        return true;
    }

    private CRLDistributionPointsExtension getCRLdpExt(X509Certificate x509Certificate) {
        CRLDistributionPointsExtension cRLDistributionPointsExtension = null;
        CertificateExtensions certificateExtensions = null;
        try {
            X509CertImpl x509CertImpl = new X509CertImpl(x509Certificate.getEncoded());
            X509CertInfo x509CertInfo = new X509CertInfo(x509CertImpl.getTBSCertificate());
            certificateExtensions = (CertificateExtensions)x509CertInfo.get("extensions");
            Enumeration enumeration = certificateExtensions.getElements();
            while (enumeration.hasMoreElements()) {
                Extension extension = (Extension)enumeration.nextElement();
                String string = extension.getExtensionId().toString();
                if (!string.equals("2.5.29.31")) continue;
                cRLDistributionPointsExtension = new CRLDistributionPointsExtension(new Boolean(false), extension.getExtensionValue());
                break;
            }
        }
        catch (Exception exception) {
            this.debug.error("Error finding CRL distribution Point configured: ", (Throwable)exception);
        }
        return cRLDistributionPointsExtension;
    }

    private CRLDistributionPoint[] getCRLdp(CRLDistributionPointsExtension cRLDistributionPointsExtension) {
        CRLDistributionPoint[] cRLDistributionPointArray = null;
        if (cRLDistributionPointsExtension != null && cRLDistributionPointsExtension.getNumPoints() > 0) {
            cRLDistributionPointArray = new CRLDistributionPoint[cRLDistributionPointsExtension.getNumPoints()];
            for (int i = 0; i < cRLDistributionPointsExtension.getNumPoints(); ++i) {
                cRLDistributionPointArray[i] = cRLDistributionPointsExtension.getPointAt(i);
            }
        }
        return cRLDistributionPointArray;
    }

    private synchronized boolean getUpdateCRLFromCrlDP(LDAPConnection lDAPConnection, String string, CRLDistributionPointsExtension cRLDistributionPointsExtension) {
        if (!this.getCRLFromCache(lDAPConnection)) {
            return false;
        }
        this.nextCRLUpdate = this.getNextCRLUpdate();
        if (this.nextCRLUpdate != null && this.nextCRLUpdate.after(new Date())) {
            return true;
        }
        CRLDistributionPoint[] cRLDistributionPointArray = this.getCRLdp(cRLDistributionPointsExtension);
        byte[] byArray = null;
        GeneralNames generalNames = null;
        int n = 0;
        boolean bl = false;
        if (cRLDistributionPointArray == null) {
            return false;
        }
        block0: while (!bl && n < cRLDistributionPointArray.length) {
            generalNames = cRLDistributionPointArray[n++].getFullName();
            int n2 = 0;
            do {
                String string2;
                String string3;
                int n3;
                if ((n3 = (string3 = (string2 = generalNames.get(n2++).toString().trim()).toLowerCase()).indexOf("http")) == -1 && (n3 = string3.indexOf("https")) == -1 && (n3 = string3.indexOf("ldap")) == -1 && (n3 = string3.indexOf("ldaps")) == -1) continue;
                string2 = string2.substring(n3, string2.length());
                if (this.debug.messageEnabled()) {
                    this.debug.message("DP Name : " + string2);
                }
                if ((byArray = this.getCRLByURI(string2)) == null) continue;
                bl = true;
                continue block0;
            } while (n2 < generalNames.size());
        }
        if (byArray != null) {
            this.crlAttribute = new LDAPAttribute("certificaterevocationlist");
            this.crlAttribute.addValue(byArray);
            return this.replaceLDAPAttr(lDAPConnection, string, this.crlAttribute);
        }
        return false;
    }

    private boolean replaceLDAPAttr(LDAPConnection lDAPConnection, String string, LDAPAttribute lDAPAttribute) {
        LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
        try {
            lDAPConnection.modify(string, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            this.debug.error("Error updating CRL Cache : ", (Throwable)lDAPException);
            return false;
        }
        return true;
    }

    private byte[] getCRLByURI(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim().toLowerCase();
        if (string2.startsWith("http") || string2.startsWith("https")) {
            return this.getCRLByHttpURI(string);
        }
        if (string2.startsWith("ldap") || string2.startsWith("ldaps")) {
            return this.getCRLByLdapURI(string);
        }
        return null;
    }

    private byte[] getCRLByLdapURI(String string) {
        LDAPUrl lDAPUrl = null;
        LDAPConnection lDAPConnection = null;
        byte[] byArray = null;
        try {
            lDAPUrl = new LDAPUrl(string);
            lDAPConnection = lDAPUrl.isSecure() ? new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory()) : new LDAPConnection();
            lDAPConnection.connect(lDAPUrl.getHost(), lDAPUrl.getPort(), "", "");
            LDAPSearchResults lDAPSearchResults = lDAPConnection.search(lDAPUrl.getDN().toString(), 0, null, null, false);
            if (lDAPSearchResults == null || !lDAPSearchResults.hasMoreElements()) {
                this.debug.error("verifyCertificate - No CRL distribution Point configured");
                return null;
            }
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist");
            if (lDAPAttribute == null && (lDAPAttribute = lDAPAttributeSet.getAttribute("certificaterevocationlist;binary")) == null) {
                this.debug.error("verifyCertificate - No CRL distribution Point configured");
                return null;
            }
            byArray = (byte[])lDAPAttribute.getByteValues().nextElement();
        }
        catch (Exception exception) {
            this.debug.error("Error in getting CRL", (Throwable)exception);
        }
        return byArray;
    }

    private byte[] getCRLByHttpURI(String string) {
        String string2 = "";
        StringBuffer stringBuffer = null;
        HttpURLConnection httpURLConnection = null;
        byte[] byArray = null;
        String string3 = this.certModule.getUriParamsCRL();
        try {
            int n;
            CharSequence charSequence;
            Object object;
            Object object2;
            Object object3;
            if (string3 != null) {
                stringBuffer = new StringBuffer();
                object3 = new StringTokenizer(string3, ",");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    String string4 = ((StringTokenizer)object3).nextToken();
                    object2 = new StringTokenizer(string4, "=");
                    if (((StringTokenizer)object2).countTokens() != 2) continue;
                    object = ((StringTokenizer)object2).nextToken();
                    charSequence = ((StringTokenizer)object2).nextToken();
                    stringBuffer.append(URLEncoder.encode((String)object) + "=" + URLEncoder.encode((String)charSequence));
                    if (!((StringTokenizer)object3).hasMoreTokens()) continue;
                    stringBuffer.append("&");
                }
            }
            object3 = new URL(string);
            httpURLConnection = (HttpURLConnection)((URL)object3).openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            int n2 = stringBuffer.toString().trim().getBytes("UTF-8").length;
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(n2));
            object2 = new DataOutputStream(httpURLConnection.getOutputStream());
            ((DataOutputStream)object2).writeBytes(stringBuffer.toString().trim());
            ((DataOutputStream)object2).flush();
            ((FilterOutputStream)object2).close();
            object = httpURLConnection.getInputStream();
            charSequence = new StringBuffer();
            byte[] byArray2 = new byte[1024];
            while ((n = ((InputStream)object).read(byArray2, 0, byArray2.length)) != -1) {
                ((StringBuffer)charSequence).append(new String(byArray2));
            }
            byArray = ((StringBuffer)charSequence).toString().getBytes();
        }
        catch (Exception exception) {
            this.debug.message("Error in getting CRL", (Throwable)exception);
        }
        return byArray;
    }
}

