/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.application;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.application.ApplicationPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.security.DecodeAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.servlet.http.HttpServletRequest;

public class Application
extends AMLoginModule {
    private String userTokenId = null;
    private Principal userPrincipal = null;
    private String errorMsg = null;
    private static String secret = null;
    private static final String amAuthApplication = "amAuthApplication";
    private static Debug debug = Debug.getInstance((String)"amAuthApplication");
    private ResourceBundle bundle = null;
    private static String rootSuffix = null;
    private LDAPAuthUtils ldapUtil;
    private Map currentConfig;

    public void init(Subject subject, Map map, Map map2) {
        try {
            debug.message("in initialize...");
            Locale locale = this.getLoginLocale();
            this.bundle = AMLoginModule.amCache.getResBundle(amAuthApplication, locale);
            if (debug.messageEnabled()) {
                debug.message("ApplicationAuth resbundle locale=" + locale);
            }
        }
        catch (Exception exception) {
            debug.error("ApplicationAuthModule Init: " + exception.getMessage());
            if (debug.messageEnabled()) {
                debug.message("Stack trace: ", (Throwable)exception);
            }
            this.errorMsg = "appInitFalied";
        }
        if (secret == null || secret.equals("")) {
            debug.message("Init : NULL secret in AMConfig.properties");
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthApplication, this.errorMsg, null);
        }
        HttpServletRequest httpServletRequest = this.getHttpServletRequest();
        String string = null;
        String string2 = null;
        if (httpServletRequest != null) {
            string = httpServletRequest.getParameter("IDToken0");
            string2 = httpServletRequest.getParameter("IDToken1");
            if (string == null && string2 == null) {
                string = httpServletRequest.getParameter("Login.Token0");
                string2 = httpServletRequest.getParameter("Login.Token1");
            }
        }
        if (string2 == null && string == null) {
            Map map = this.sendCallback();
            if (map == null) {
                throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
            }
            string2 = (String)map.get("secret");
            string = (String)map.get("uid");
        }
        if (string2 == null) {
            throw new AuthLoginException(amAuthApplication, "noPassword", null);
        }
        if (secret != null && !secret.equals("") && string2.equals(secret)) {
            if (debug.messageEnabled()) {
                debug.message("App.validate, secret matched : " + string);
            }
            if (!this.dnEntryExist(string = string == null || string.equals("") ? "amService-gateway" : "amService-" + string)) {
                debug.error(string + " is not a valid ldap entry");
                this.setFailureID(string);
                throw new AuthLoginException(amAuthApplication, "wrongSecret", null);
            }
            this.userTokenId = string;
        } else if (this.authenticateToLDAP(string, string2) == 26) {
            this.userTokenId = this.ldapUtil.getUserId();
            if (debug.messageEnabled()) {
                debug.message("Auth is successful,returning User = " + this.userTokenId);
            }
        } else {
            debug.error("App.validate, User not Valid: " + string);
            this.setFailureID(string);
            throw new AuthLoginException(amAuthApplication, "userInvalid", null);
        }
        return -1;
    }

    private boolean dnEntryExist(String string) {
        String string2 = "cn=" + string + ",ou=DSAME Users," + rootSuffix;
        boolean bl = this.isValidUserEntry(string2);
        return bl;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new ApplicationPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    private Map sendCallback() {
        try {
            CallbackHandler callbackHandler = this.getCallbackHandler();
            if (callbackHandler == null) {
                throw new AuthLoginException(amAuthApplication, "NoCallbackHandler", null);
            }
            Callback[] callbackArray = new Callback[]{new NameCallback(this.bundle.getString("appname")), new PasswordCallback(this.bundle.getString("secret"), true)};
            if (debug.messageEnabled()) {
                debug.message("Callback is.. :" + callbackArray);
            }
            callbackHandler.handle(callbackArray);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                Callback callback = callbackArray[n2];
                if (callback instanceof PasswordCallback) {
                    object = ((PasswordCallback)callback).getPassword();
                    if (object != null) {
                        hashMap.put("secret", new String((char[])object));
                    }
                } else if (callback instanceof NameCallback && (object = (Object)((NameCallback)callback).getName()) != null) {
                    hashMap.put("uid", object);
                }
                ++n2;
            }
            return hashMap;
        }
        catch (Exception exception) {
            block9: {
                debug.error("sendCallback: " + exception.getMessage());
                if (!debug.messageEnabled()) break block9;
                debug.message("Stack trace: ", (Throwable)exception);
            }
            return null;
        }
    }

    private int authenticateToLDAP(String string, String string2) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message(" In authenticateToLDAP with User : " + string);
        }
        try {
            if (this.initLDAPAttributes("iPlanetAMAuthLDAPService")) {
                this.ldapUtil.authenticateUser(string, string2);
                return this.ldapUtil.getState();
            }
            this.setFailureID(string);
            throw new AuthLoginException(amAuthApplication, "basicLDAPex", null);
        }
        catch (LDAPUtilException lDAPUtilException) {
            this.setFailureID(string);
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist.");
                    throw new AuthLoginException(amAuthApplication, "NoUser", null);
                }
                case 49: {
                    debug.message("Invalid password.");
                    String string3 = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(amAuthApplication, "InvalidUP", null, string3, lDAPUtilException);
                }
            }
            throw new AuthLoginException(amAuthApplication, "basicLDAPex", null);
        }
    }

    private boolean initLDAPAttributes(String string) throws AuthLoginException {
        String string2 = null;
        this.currentConfig = this.getOrgServiceTemplate(this.getRequestOrg(), string);
        try {
            string2 = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-server");
            if (string2 == null) {
                debug.message("No server for configuring");
                return false;
            }
            String string3 = Misc.getServerMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-base-dn");
            if (string3 == null) {
                debug.error("Fatal error: baseDN for search has invalid value");
                throw new AuthLoginException(amAuthApplication, "basednnull", null);
            }
            String string4 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-dn", (String)"");
            String string5 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-bind-passwd", (String)"");
            String string6 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-user-naming-attribute", (String)"uid");
            Set set = (Set)this.currentConfig.get("iplanet-am-auth-ldap-user-search-attributes");
            String string7 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-filter", (String)"");
            boolean bl = Boolean.valueOf(Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-ssl-enabled", (String)"false"));
            String string8 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-search-scope", (String)"SUBTREE");
            int n = 2;
            if (string8.equalsIgnoreCase("OBJECT")) {
                n = 0;
            } else if (string8.equalsIgnoreCase("ONELEVEL")) {
                n = 1;
            }
            String string9 = Misc.getMapAttr((Map)this.currentConfig, (String)"iplanet-am-auth-ldap-return-user-dn", (String)"true");
            int n2 = string2.indexOf(58);
            int n3 = 389;
            String string10 = null;
            if (n2 != -1) {
                string10 = string2.substring(n2 + 1);
                n3 = Integer.parseInt(string10);
                string2 = string2.substring(0, n2);
            }
            this.ldapUtil = new LDAPAuthUtils(string2, n3, bl, this.bundle, string3);
            this.ldapUtil.setScope(n);
            this.ldapUtil.setFilter(string7);
            this.ldapUtil.setUserNamingAttribute(string6);
            this.ldapUtil.setUserSearchAttribute(set);
            this.ldapUtil.setAuthPassword(string5);
            this.ldapUtil.setAuthDN(string4);
            this.ldapUtil.setReturnUserDN(string9);
            if (debug.messageEnabled()) {
                debug.message("bindDN-> " + string4 + "\nbaseDN-> " + string3 + "\nuserNamingAttr-> " + string6 + "\nuserSearchAttr(s)-> " + set + "\nsearchFilter-> " + string7 + "\nsearchScope-> " + n + "\nssl-> " + bl + "\nHost: " + string2 + "\nINDEDX : " + n2 + "\nPORT : " + n3);
            }
            return true;
        }
        catch (Exception exception) {
            debug.error("LDAP Init Exception", (Throwable)exception);
            throw new AuthLoginException(amAuthApplication, "basicLDAPex", null, exception);
        }
    }

    static {
        debug.message("Application module getting secret");
        String string = SystemProperties.get((String)"com.iplanet.am.service.secret").trim();
        secret = (String)AccessController.doPrivileged(new DecodeAction(string));
        rootSuffix = SystemProperties.get((String)"com.iplanet.am.rootsuffix");
    }
}

