/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.jaas;

import com.iplanet.am.util.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private boolean configProvided = false;
    private ModuleInfo[] moduleStack;
    private static final Class[] PARAMS = new Class[0];
    LoginException firstError = null;
    LoginException firstRequiredError = null;
    boolean success = false;
    private static final Debug debug = Debug.getInstance((String)"amJAAS");

    private void init(AppConfigurationEntry[] appConfigurationEntryArray) throws LoginException {
        this.moduleStack = new ModuleInfo[appConfigurationEntryArray.length];
        int n = 0;
        while (n < appConfigurationEntryArray.length) {
            this.moduleStack[n] = new ModuleInfo(new AppConfigurationEntry(appConfigurationEntryArray[n].getLoginModuleName(), appConfigurationEntryArray[n].getControlFlag(), appConfigurationEntryArray[n].getOptions()), null);
            ++n;
        }
    }

    public LoginContext(AppConfigurationEntry[] appConfigurationEntryArray, CallbackHandler callbackHandler) throws LoginException {
        this.init(appConfigurationEntryArray);
        if (callbackHandler == null) {
            throw new LoginException("invalid null CallbackHandler provided");
        }
        this.callbackHandler = callbackHandler;
    }

    public LoginContext(AppConfigurationEntry[] appConfigurationEntryArray, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this.init(appConfigurationEntryArray);
        if (subject == null) {
            throw new LoginException("invalid null Subject provided");
        }
        this.subject = subject;
        this.subjectProvided = true;
        if (callbackHandler == null) {
            throw new LoginException("invalid null CallbackHandler provided");
        }
        this.callbackHandler = callbackHandler;
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invoke(LOGIN_METHOD);
            this.invoke(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException loginException) {
            try {
                this.invoke(ABORT_METHOD);
            }
            catch (LoginException loginException2) {
                throw loginException;
            }
            throw loginException;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException("null subject - logout called before login");
        }
        this.invoke(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void throwException(LoginException loginException, LoginException loginException2) throws LoginException {
        throw loginException != null ? loginException : loginException2;
    }

    private void invoke(String string) throws LoginException {
        int n = 0;
        while (n < this.moduleStack.length) {
            block38: {
                Object[] objectArray;
                try {
                    Object[] objectArray2;
                    int n2 = 0;
                    Method[] methodArray = null;
                    if (this.moduleStack[n].module != null) {
                        methodArray = this.moduleStack[n].module.getClass().getMethods();
                    } else {
                        objectArray2 = Class.forName(this.moduleStack[n].entry.getLoginModuleName());
                        Constructor<?> constructor = objectArray2.getConstructor(PARAMS);
                        Object[] objectArray3 = new Object[]{};
                        this.moduleStack[n].module = constructor.newInstance(objectArray3);
                        methodArray = this.moduleStack[n].module.getClass().getMethods();
                        n2 = 0;
                        while (n2 < methodArray.length) {
                            if (methodArray[n2].getName().equals(INIT_METHOD)) break;
                            ++n2;
                        }
                        objectArray = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[n].entry.getOptions()};
                        methodArray[n2].invoke(this.moduleStack[n].module, objectArray);
                    }
                    n2 = 0;
                    while (n2 < methodArray.length) {
                        if (methodArray[n2].getName().equals(string)) break;
                        ++n2;
                    }
                    objectArray2 = new Object[]{};
                    boolean bl = (Boolean)methodArray[n2].invoke(this.moduleStack[n].module, objectArray2);
                    if (bl) {
                        if (!string.equals(ABORT_METHOD) && !string.equals(LOGOUT_METHOD) && this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && this.firstRequiredError == null) {
                            if (debug.messageEnabled()) {
                                debug.message(string + " SUFFICIENT success");
                            }
                            return;
                        }
                        if (debug.messageEnabled()) {
                            debug.message(string + " success");
                        }
                        this.success = true;
                    } else if (debug.messageEnabled()) {
                        debug.message(string + " ignored");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new LoginException("unable to instantiate LoginModule, module, because it does not provide a no-argument constructor:" + this.moduleStack[n].entry.getLoginModuleName());
                }
                catch (InstantiationException instantiationException) {
                    throw new LoginException("unable to instantiate LoginModule: " + instantiationException.getMessage());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new LoginException("unable to find LoginModule class: " + classNotFoundException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new LoginException("unable to access LoginModule: " + illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof Error) {
                        debug.message("Target exception is java.lang.Error.");
                        throw (Error)invocationTargetException.getTargetException();
                    }
                    if (invocationTargetException.getTargetException() instanceof LoginException) {
                        objectArray = (Object[])invocationTargetException.getTargetException();
                    } else if (invocationTargetException.getTargetException() instanceof SecurityException) {
                        objectArray = new LoginException("Security Exception");
                        if (debug.messageEnabled()) {
                            debug.message("original security exception with detail msg replaced by new exception with empty detail msg");
                            debug.message("original security exception: " + invocationTargetException.getTargetException().toString());
                        }
                    } else {
                        StringWriter stringWriter = new StringWriter();
                        invocationTargetException.getTargetException().printStackTrace(new PrintWriter(stringWriter));
                        stringWriter.flush();
                        objectArray = new LoginException(stringWriter.toString());
                    }
                    if (this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                        if (debug.messageEnabled()) {
                            debug.message(string + " REQUISITE failure");
                        }
                        if (string.equals(ABORT_METHOD) || string.equals(LOGOUT_METHOD)) {
                            if (this.firstRequiredError == null) {
                                this.firstRequiredError = objectArray;
                            }
                        } else {
                            this.throwException(this.firstRequiredError, (LoginException)objectArray);
                        }
                    }
                    if (this.moduleStack[n].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                        if (debug.messageEnabled()) {
                            debug.message(string + " REQUIRED failure");
                            debug.message("Exception: " + objectArray);
                        }
                        if (this.firstRequiredError == null) {
                            this.firstRequiredError = objectArray;
                            debug.message("Set firstRequiredError to " + objectArray);
                        }
                    }
                    if (debug.messageEnabled()) {
                        debug.message(string + " OPTIONAL failure");
                    }
                    if (this.firstError != null) break block38;
                    this.firstError = objectArray;
                }
            }
            ++n;
        }
        if (this.firstRequiredError != null) {
            this.throwException(this.firstRequiredError, null);
        } else if (!this.success && this.firstError != null) {
            this.throwException(this.firstError, null);
        } else if (!this.success) {
            this.throwException(new LoginException("Login Failure: all modules ignored"), null);
        } else {
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry appConfigurationEntry, Object object) {
            this.entry = appConfigurationEntry;
            this.module = object;
        }
    }
}

