/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.ums.Guid;
import com.iplanet.ums.TemplateManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import com.sun.identity.authentication.internal.util.AuthI18n;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class LocalLdapAuthModule
implements LoginModule {
    private static final String UIDATTR = "uid";
    private static final String TEMPLATE_NAME = "BasicUser";
    private static Debug debug = Debug.getInstance((String)"amAuthInternal");
    private static boolean readServerConfiguration = false;
    private static String baseDN = null;
    private static LDAPConnection conn = null;
    private static ConnectionPool anonConnectionPool = null;
    private CallbackHandler cbHandler;
    private LoginException exception;
    private AuthSubject subject;
    private Map sharedState;
    private Map options;

    public void initialize(AuthSubject authSubject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = authSubject;
        this.cbHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
    }

    public boolean login() throws LoginException {
        Object object;
        Object object2;
        String string = null;
        char[] cArray = null;
        Set set = this.subject.getPrincipals();
        if (set.size() == 0) {
            object2 = new Callback[]{new NameCallback("User name: "), new PasswordCallback("Password: ", false)};
            try {
                this.cbHandler.handle((Callback[])object2);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException(unsupportedCallbackException.getMessage());
            }
            catch (IOException iOException) {
                throw new LoginException(iOException.getMessage());
            }
            string = ((NameCallback)object2[0]).getName();
            cArray = ((PasswordCallback)object2[1]).getPassword();
        } else {
            object2 = (Principal)set.toArray()[0];
            string = object2.getName();
            set.remove(object2);
            object = new Callback[]{new PasswordCallback("Password: ", false)};
            try {
                this.cbHandler.handle((Callback[])object);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new LoginException(unsupportedCallbackException.getMessage());
            }
            catch (IOException iOException) {
                throw new LoginException(iOException.getMessage());
            }
            cArray = ((PasswordCallback)object[0]).getPassword();
        }
        object2 = this.getDN(string);
        object = new String(cArray);
        if (object == null || ((String)object).length() == 0) {
            throw new LoginException("NULL_OR_EMPTY_PASSWORD");
        }
        if (!this.authenticate((String)object2, (String)object)) {
            throw new LoginException("LOGIN_FALIED");
        }
        set.add(new AuthPrincipal((String)object2));
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean commit() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean authenticate(String var1_1, String var2_2) throws LoginException {
        block32: {
            var3_3 = null;
            var4_4 = false;
            var5_5 = (String)this.options.get("ORGANIZATION");
            if (var5_5 == null || var5_5.equals("ldap://") || var5_5.equals("ldaps://") || !var5_5.startsWith("ldap://") && !var5_5.startsWith("ldaps://")) {
                try {
                    var6_6 = DSConfigMgr.getDSConfigMgr();
                    var7_11 = var6_6.getServerInstance("default", LDAPUser.Type.AUTH_BASIC);
                    var8_14 = var6_6.getHostName("default");
                    if (var7_11.getConnectionType() == Server.Type.CONN_SSL) {
                        try {
                            var3_3 = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
                        }
                        catch (Exception var9_16) {
                            LocalLdapAuthModule.debug.error("getConnection.JSSSocketFactory", (Throwable)var9_16);
                            throw new LDAPServiceException(AuthI18n.authI18n.getString("dscfg-jssSockFactoryFail"));
                        }
                    } else {
                        var3_3 = new LDAPConnection();
                    }
                    if (var1_1 == null || var2_2 == null) {
                        throw new LoginException(AuthI18n.authI18n.getString("dscfg-connectFail"));
                    }
                    var3_3.connect(3, var8_14, 389, var1_1, var2_2);
                }
                catch (LDAPServiceException var6_7) {
                    LocalLdapAuthModule.debug.error("Authenticate failed: " + var6_7);
                    throw new LoginException(var6_7.getMessage());
                }
                catch (LDAPException var7_12) {
                    LocalLdapAuthModule.debug.error("Authenticate failed: " + var7_12);
                    throw new LoginException(var7_12.getMessage());
                }
            }
            try {
                if (LocalLdapAuthModule.debug.messageEnabled()) {
                    LocalLdapAuthModule.debug.message("authenticate(): orgUrl= " + var5_5);
                }
                var7_13 = false;
                if (var5_5.startsWith("ldaps://")) {
                    var6_8 = "ldaps://".length();
                    var7_13 = true;
                } else {
                    var6_8 = "ldap://".length();
                }
                var8_15 = var5_5.indexOf(58, var6_8);
                if (var8_15 == -1 && (var8_15 = var5_5.indexOf(47, var6_8)) == -1) {
                    var8_15 = var5_5.length();
                }
                var9_17 = var5_5.substring(var6_8, var8_15);
                var10_18 = "389";
                var6_8 = var8_15 + 1;
                if (var6_8 < var5_5.length()) {
                    var8_15 = var5_5.indexOf(47, var6_8);
                    if (var8_15 == -1) {
                        var8_15 = var5_5.length();
                    }
                    var10_18 = var5_5.substring(var6_8, var8_15);
                }
                if (var7_13) {
                    try {
                        var3_3 = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
                        if (!LocalLdapAuthModule.debug.messageEnabled()) ** GOTO lbl59
                        LocalLdapAuthModule.debug.message("authenticate(): LDAPConnection created with new SSLSocketFactory()");
                    }
                    catch (Exception var11_19) {
                        LocalLdapAuthModule.debug.error("authentication().JSSSocketFactory()", (Throwable)var11_19);
                        throw new LoginException(var11_19.getMessage());
                    }
                } else {
                    var3_3 = new LDAPConnection();
                }
lbl59:
                // 3 sources

                if (LocalLdapAuthModule.debug.messageEnabled()) {
                    LocalLdapAuthModule.debug.message("before connect(), hostName=" + var9_17 + ",port=" + var10_18);
                }
                var3_3.connect(var9_17, Integer.parseInt(var10_18));
            }
            catch (Exception var6_9) {
                LocalLdapAuthModule.debug.error("authentication", (Throwable)var6_9);
                throw new LoginException(var6_9.getMessage());
            }
            var3_3.authenticate(3, var1_1, var2_2);
            var13_20 = null;
            try {
                if (var4_4) {
                    LocalLdapAuthModule.anonConnectionPool.close(var3_3);
                    break block32;
                }
                var3_3.disconnect();
            }
            catch (LDAPException var14_22) {}
            break block32;
            {
                catch (LDAPException var6_10) {
                    throw new LoginException(var6_10.getMessage());
                }
            }
            catch (Throwable var12_24) {
                var13_21 = null;
                try {
                    if (var4_4) {
                        LocalLdapAuthModule.anonConnectionPool.close(var3_3);
                    } else {
                        var3_3.disconnect();
                    }
                }
                catch (LDAPException var14_23) {
                    // empty catch block
                }
                throw var12_24;
            }
        }
        return true;
    }

    private String getDN(String string) throws LoginException {
        CharSequence charSequence;
        String string2 = "";
        if (string == null) {
            throw new LoginException(AuthI18n.authI18n.getString("com.iplanet.auth.invalid-username"));
        }
        if (DN.isDN(string)) {
            return string;
        }
        String string3 = UIDATTR;
        try {
            charSequence = (String)this.options.get("ORGANIZATION");
            if (charSequence != null && !DN.isDN((String)charSequence)) {
                charSequence = baseDN;
            }
            string3 = TemplateManager.getTemplateManager().getCreationTemplate(TEMPLATE_NAME, charSequence == null ? null : new Guid((String)charSequence)).getNamingAttribute();
        }
        catch (Exception exception) {
            // empty catch block
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append('(').append(string3).append('=').append(string).append(')');
        String[] stringArray = new String[]{"noAttr"};
        LDAPSearchResults lDAPSearchResults = null;
        try {
            if (!readServerConfiguration) {
                LocalLdapAuthModule.readServerConfig();
            }
            lDAPSearchResults = conn.search(baseDN, 2, ((StringBuffer)charSequence).toString(), stringArray, false);
        }
        catch (LDAPException lDAPException) {
            throw new LoginException(lDAPException.getMessage());
        }
        LDAPEntry lDAPEntry = null;
        try {
            if (lDAPSearchResults.hasMoreElements()) {
                lDAPEntry = lDAPSearchResults.next();
                string2 = lDAPEntry.getDN();
            }
        }
        catch (LDAPException lDAPException) {
            throw new LoginException(lDAPException.getMessage());
        }
        if (string2 == "") {
            throw new LoginException("INVALID_USER_NAME");
        }
        return string2;
    }

    private static void readServerConfig() throws LoginException {
        if (readServerConfiguration) {
            return;
        }
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            conn = dSConfigMgr.getNewBasicConnection();
            ServerInstance serverInstance = dSConfigMgr.getServerInstance("default", LDAPUser.Type.AUTH_BASIC);
            baseDN = serverInstance.getBaseDN();
            readServerConfiguration = true;
        }
        catch (LDAPServiceException lDAPServiceException) {
            throw new LoginException(lDAPServiceException.getMessage());
        }
    }
}

