/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.sdk.AMEventListener;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.config.AMAuthConfigType;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMAuthLevelManager;
import com.sun.identity.authentication.config.AMSDKEventListener;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.security.auth.login.ConfigFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class AMConfiguration
extends Configuration {
    private static Map jaasConfig = new HashMap();
    private static Map listenersMap = new HashMap();
    private static ConfigFile configFile = null;
    private static Debug debug = Debug.getInstance((String)"amAuthConfig");
    private final String CONSOLE_SERVICE = "adminconsoleservice";
    private Configuration defConfig = null;

    public AMConfiguration(Configuration configuration) {
        this.defConfig = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        debug.message("inside AMConfiguration.initializa()");
        Map map = jaasConfig;
        synchronized (map) {
            jaasConfig = new HashMap();
        }
        Map map2 = listenersMap;
        synchronized (map2) {
            listenersMap = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppConfigurationEntry[] cloneConfigurationEntry(AppConfigurationEntry[] appConfigurationEntryArray, String string) {
        if (debug.messageEnabled()) {
            debug.message("AMConfiguration.cloneConfigurationEntry, orgDN=" + string + ", entries=" + appConfigurationEntryArray);
        }
        ArrayList<AppConfigurationEntry> arrayList = new ArrayList<AppConfigurationEntry>();
        Set set = AMAuthLevelManager.getInstance().getSupportedModule(string);
        if (debug.messageEnabled()) {
            debug.message("supported module for " + string + "=" + set);
        }
        if (set.isEmpty()) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray2 = appConfigurationEntryArray;
        synchronized (appConfigurationEntryArray) {
            int n = appConfigurationEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = appConfigurationEntryArray[n2].getLoginModuleName();
                if (!set.contains(AMAuthConfigUtils.getModuleName(string2))) {
                    if (debug.messageEnabled()) {
                        debug.message("skip module " + string2);
                    }
                } else {
                    arrayList.add(new AppConfigurationEntry(appConfigurationEntryArray[n2].getLoginModuleName(), appConfigurationEntryArray[n2].getControlFlag(), appConfigurationEntryArray[n2].getOptions()));
                }
                ++n2;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            n = arrayList.size();
            if (n == 0) {
                return null;
            }
            AppConfigurationEntry[] appConfigurationEntryArray3 = new AppConfigurationEntry[n];
            int n3 = 0;
            while (n3 < n) {
                appConfigurationEntryArray3[n3] = (AppConfigurationEntry)arrayList.get(n3);
                ++n3;
            }
            return appConfigurationEntryArray3;
        }
    }

    private String getOrganization(String string) {
        return new AMAuthConfigType(string).getOrganization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppConfigurationEntry[] newConfiguration(String string) {
        if (debug.messageEnabled()) {
            debug.message("newConfig, name = " + string);
        }
        AMAuthConfigType aMAuthConfigType = new AMAuthConfigType(string);
        AppConfigurationEntry[] appConfigurationEntryArray = null;
        try {
            switch (aMAuthConfigType.getIndexType()) {
                case 1: {
                    appConfigurationEntryArray = this.getUserBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                case 2: {
                    appConfigurationEntryArray = this.getOrgBasedConfig(aMAuthConfigType.getOrganization(), string, false);
                    break;
                }
                case 3: {
                    appConfigurationEntryArray = this.getRoleBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                case 4: {
                    if (aMAuthConfigType.getIndexName().equals("adminconsoleservice")) {
                        appConfigurationEntryArray = this.getOrgBasedConfig(aMAuthConfigType.getOrganization(), string, true);
                        break;
                    }
                    appConfigurationEntryArray = this.getServiceBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                case 5: {
                    appConfigurationEntryArray = this.getModuleBasedConfig(aMAuthConfigType.getOrganization(), aMAuthConfigType.getIndexName(), string);
                    break;
                }
                default: {
                    if (debug.messageEnabled()) {
                        debug.message("Unable to find config " + string + " in IS config");
                    }
                    debug.message("Getting default configuration.");
                    if (this.defConfig != null) {
                        appConfigurationEntryArray = this.defConfig.getAppConfigurationEntry(string);
                    }
                    if (appConfigurationEntryArray == null) {
                        if (configFile == null) {
                            configFile = new ConfigFile();
                        }
                        debug.message("Getting configuration from confFile.");
                        appConfigurationEntryArray = configFile.getAppConfigurationEntry(string);
                    }
                    if (appConfigurationEntryArray == null) {
                        debug.error("newConfiguration, invalid config " + string);
                    }
                    return appConfigurationEntryArray;
                }
            }
        }
        catch (Exception exception) {
            debug.error("newConfiguration.switch", (Throwable)exception);
        }
        if (appConfigurationEntryArray == null) {
            if (debug.messageEnabled()) {
                debug.message("newConfig, config not defined " + string);
            }
            return null;
        }
        appConfigurationEntryArray = AuthUtils.retainSupportedModules(appConfigurationEntryArray, aMAuthConfigType.getClientType());
        Map map = jaasConfig;
        synchronized (map) {
            if (!jaasConfig.containsKey(string)) {
                jaasConfig.put(string, appConfigurationEntryArray);
            }
        }
        return this.cloneConfigurationEntry(appConfigurationEntryArray, aMAuthConfigType.getOrganization());
    }

    private String getServiceNameForModule(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(n + 1) : string;
        return AMAuthConfigUtils.getModuleServiceName(string2);
    }

    private String getLoginModuleClassName(String string) {
        return AuthD.getAuth().getAuthenticatorForName(string);
    }

    private Map getLoginModuleAttributes(AMOrganization aMOrganization, String string) throws AMException, SSOException {
        Object object;
        Object object2;
        Object object3;
        HashMap<String, Object> hashMap;
        block16: {
            String string2;
            block15: {
                block14: {
                    string2 = this.getServiceNameForModule(string);
                    if (debug.messageEnabled()) {
                        debug.message("getLoginModuleAttibutes, class = " + string + ", service=" + string2);
                    }
                    if (!AuthD.getAuth().containsAuthenticator(AMAuthConfigUtils.getModuleName(string))) {
                        debug.error("getLoginModuleAttributes, invalid authenticator " + string);
                        return null;
                    }
                    hashMap = null;
                    try {
                        if (string2.equals("iPlanetAMAuthLDAPService")) {
                            object3 = new ServiceConfigManager(string2, AuthD.getAuth().getSSOAuthSession());
                            object2 = ((ServiceConfigManager)object3).getOrganizationConfig(aMOrganization.getDN(), null);
                            hashMap = new HashMap<String, Object>();
                            hashMap.put("ServiceConfig", object2);
                        } else {
                            object3 = aMOrganization.getTemplate(string2, 302);
                            hashMap = object3.getAttributes();
                        }
                    }
                    catch (Exception exception) {
                        if (!debug.messageEnabled()) break block14;
                        debug.message("No ORGANIZATION template for " + string2 + ", " + exception.getMessage());
                    }
                }
                object3 = null;
                try {
                    object2 = aMOrganization.getTemplate(string2, 301);
                    object3 = object2.getAttributes();
                }
                catch (Exception exception) {
                    if (!debug.messageEnabled()) break block15;
                    debug.message("No DYNAMIC template for " + string2 + ", " + exception.getMessage());
                }
            }
            object2 = null;
            try {
                object = new ServiceSchemaManager(string2, AuthD.getAuth().getSSOAuthSession());
                ServiceSchema serviceSchema = ((ServiceSchemaManager)object).getSchema(SchemaType.GLOBAL);
                if (serviceSchema != null) {
                    object2 = serviceSchema.getAttributeDefaults();
                }
            }
            catch (Exception exception) {
                if (!debug.messageEnabled()) break block16;
                debug.message("No GLOBAL schema for " + string2 + ", " + exception.getMessage());
            }
        }
        object = new HashMap();
        if (object2 != null) {
            object.putAll(object2);
        }
        if (object3 != null) {
            object.putAll(object3);
        }
        if (hashMap != null) {
            object.putAll(hashMap);
        }
        return object;
    }

    private AppConfigurationEntry[] getOrgBasedConfig(String string, String string2, boolean bl) {
        if (debug.messageEnabled()) {
            debug.message("getOrgBasedConfig,  START " + string);
        }
        try {
            AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            if (aMOrganization.isExists()) {
                AMTemplate aMTemplate = aMOrganization.getTemplate("iPlanetAMAuthService", 302);
                Set set = null;
                set = bl ? aMTemplate.getAttribute("iplanet-am-auth-admin-auth-module") : aMTemplate.getAttribute("iplanet-am-auth-org-config");
                if (set != null && !set.isEmpty()) {
                    String string3 = (String)set.iterator().next();
                    AppConfigurationEntry[] appConfigurationEntryArray = AMAuthConfigUtils.parseValues(string3);
                    int n = appConfigurationEntryArray.length;
                    AppConfigurationEntry[] appConfigurationEntryArray2 = new AppConfigurationEntry[n];
                    int n2 = 0;
                    while (n2 < n) {
                        String string4 = appConfigurationEntryArray[n2].getLoginModuleName();
                        Map map = this.getLoginModuleAttributes(aMOrganization, string4);
                        if (map == null) {
                            return null;
                        }
                        map.putAll(appConfigurationEntryArray[n2].getOptions());
                        appConfigurationEntryArray2[n2] = new AppConfigurationEntry(string4, appConfigurationEntryArray[n2].getControlFlag(), map);
                        this.addServiceListener(this.getServiceNameForModule(string4), string2);
                        ++n2;
                    }
                    this.addServiceListener("iPlanetAMAuthService", string2);
                    if (debug.messageEnabled()) {
                        debug.message("OrgBasedConfig, got config for " + string);
                    }
                    return appConfigurationEntryArray2;
                }
                if (debug.messageEnabled()) {
                    debug.message("OrgBasedConfig, config attr not defined " + string);
                }
                return null;
            }
            if (debug.warningEnabled()) {
                debug.warning("OrgBasedConfig, org not exists " + string);
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("getOrgBasedConfig org=" + string, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getUserBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("getUserBasedConfig,  START " + string + "|" + string2);
        }
        try {
            AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            AMUser aMUser = aMStoreConnection.getUser(string2);
            if (aMUser.isExists()) {
                Set set = aMUser.getAttribute("iplanet-am-user-auth-config");
                if (set != null && !set.isEmpty()) {
                    Object object;
                    String string4 = (String)set.iterator().next();
                    AppConfigurationEntry[] appConfigurationEntryArray = AMAuthConfigUtils.parseValues(string4);
                    int n = appConfigurationEntryArray.length;
                    AppConfigurationEntry[] appConfigurationEntryArray2 = new AppConfigurationEntry[n];
                    int n2 = 0;
                    while (n2 < n) {
                        object = appConfigurationEntryArray[n2].getLoginModuleName();
                        Map map = this.getLoginModuleAttributes(aMOrganization, (String)object);
                        if (map == null) {
                            return null;
                        }
                        map.putAll(appConfigurationEntryArray[n2].getOptions());
                        appConfigurationEntryArray2[n2] = new AppConfigurationEntry((String)object, appConfigurationEntryArray[n2].getControlFlag(), map);
                        this.addServiceListener(this.getServiceNameForModule((String)object), string3);
                        ++n2;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("userBased, SDK listener " + aMUser.getDN());
                    }
                    object = new AMSDKEventListener(string3);
                    ((AMSDKEventListener)object).setListenedObject(aMUser);
                    aMUser.addEventListener((AMEventListener)object);
                    this.addToListenersMap(string3, object);
                    if (debug.messageEnabled()) {
                        debug.message("UserBasedConfig, return config " + string3);
                    }
                    return appConfigurationEntryArray2;
                }
                if (debug.messageEnabled()) {
                    debug.message("UserBasedConfig, config not defined " + string2);
                }
                return null;
            }
            if (debug.warningEnabled()) {
                debug.warning("UserBasedConfig, user not exist " + string2);
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("getUserBasedConfig " + string2 + "|" + string, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getServiceBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("ServiceBasedConfig,  START " + string + "|" + string2);
        }
        try {
            AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            Map map = AMAuthConfigUtils.getNamedConfig(string2, string, AuthD.getAuth().getSSOAuthSession());
            Set set = (Set)map.get("iplanet-am-auth-configuration");
            String string4 = null;
            if (set != null && !set.isEmpty()) {
                string4 = (String)set.iterator().next();
            }
            if (string4 == null) {
                return null;
            }
            AppConfigurationEntry[] appConfigurationEntryArray = AMAuthConfigUtils.parseValues(string4);
            int n = appConfigurationEntryArray.length;
            AppConfigurationEntry[] appConfigurationEntryArray2 = new AppConfigurationEntry[n];
            int n2 = 0;
            while (n2 < n) {
                String string5 = appConfigurationEntryArray[n2].getLoginModuleName();
                Map map2 = this.getLoginModuleAttributes(aMOrganization, string5);
                if (map2 == null) {
                    return null;
                }
                map2.putAll(appConfigurationEntryArray[n2].getOptions());
                appConfigurationEntryArray2[n2] = new AppConfigurationEntry(string5, appConfigurationEntryArray[n2].getControlFlag(), map2);
                this.addServiceListener(this.getServiceNameForModule(string5), string3);
                ++n2;
            }
            if (debug.messageEnabled()) {
                debug.message("serviceBased, add SM listener on " + string2);
            }
            this.addServiceListener("iPlanetAMAuthConfiguration", string3);
            if (debug.messageEnabled()) {
                debug.message("ServiceBasedConfig, return config " + string2 + ", org=" + string);
            }
            return appConfigurationEntryArray2;
        }
        catch (Exception exception) {
            debug.error("getServiceBasedConfig " + string2 + "|" + string, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getRoleBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("RoleBasedConfig,  START " + string + "|" + string2);
        }
        try {
            AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            AMRole aMRole = aMStoreConnection.getRole(string2);
            if (aMRole.isExists()) {
                AMTemplate aMTemplate = aMRole.getTemplate("iPlanetAMAuthConfiguration", 301);
                Set set = aMTemplate.getAttribute("iplanet-am-auth-configuration");
                if (set != null && !set.isEmpty()) {
                    Object object;
                    String string4 = (String)set.iterator().next();
                    AppConfigurationEntry[] appConfigurationEntryArray = AMAuthConfigUtils.parseValues(string4);
                    int n = appConfigurationEntryArray.length;
                    AppConfigurationEntry[] appConfigurationEntryArray2 = new AppConfigurationEntry[n];
                    int n2 = 0;
                    while (n2 < n) {
                        object = appConfigurationEntryArray[n2].getLoginModuleName();
                        Map map = this.getLoginModuleAttributes(aMOrganization, (String)object);
                        if (map == null) {
                            return null;
                        }
                        map.putAll(appConfigurationEntryArray[n2].getOptions());
                        appConfigurationEntryArray2[n2] = new AppConfigurationEntry((String)object, appConfigurationEntryArray[n2].getControlFlag(), map);
                        this.addServiceListener(this.getServiceNameForModule((String)object), string3);
                        ++n2;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("RoleBase, add SDK listener on " + string2);
                    }
                    object = new AMSDKEventListener(string3);
                    ((AMSDKEventListener)object).setListenedObject(aMRole);
                    aMRole.addEventListener((AMEventListener)object);
                    this.addToListenersMap(string3, object);
                    if (debug.messageEnabled()) {
                        debug.message("RoleBaseConfig, return config " + string2);
                    }
                    return appConfigurationEntryArray2;
                }
                if (debug.warningEnabled()) {
                    debug.warning("RoleBaseConfig, role config not defined " + string2);
                }
                return null;
            }
            if (debug.warningEnabled()) {
                debug.warning("RoleBaseConfig, role not exist " + string2);
            }
            return null;
        }
        catch (Exception exception) {
            debug.error("getRoleBasedConfig " + string + "|" + string2, (Throwable)exception);
            return null;
        }
    }

    private AppConfigurationEntry[] getModuleBasedConfig(String string, String string2, String string3) {
        if (debug.messageEnabled()) {
            debug.message("ModuleBasedConfig,  START " + string + "|" + string2);
        }
        try {
            AMStoreConnection aMStoreConnection = AuthD.getAuth().getSDK();
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string);
            Map map = this.getLoginModuleAttributes(aMOrganization, string2);
            if (map == null) {
                return null;
            }
            AppConfigurationEntry[] appConfigurationEntryArray = new AppConfigurationEntry[]{new AppConfigurationEntry(this.getLoginModuleClassName(string2), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map)};
            this.addServiceListener(this.getServiceNameForModule(string2), string3);
            if (debug.messageEnabled()) {
                debug.message("ModuleBaseConfig, return config " + string2 + ", " + string);
            }
            return appConfigurationEntryArray;
        }
        catch (Exception exception) {
            debug.error("getModuleBasedConfig " + string + "|" + string2, (Throwable)exception);
            return null;
        }
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        if (string == null) {
            return null;
        }
        AppConfigurationEntry[] appConfigurationEntryArray = (AppConfigurationEntry[])jaasConfig.get(string);
        if (appConfigurationEntryArray != null) {
            if (debug.messageEnabled()) {
                debug.message("getAppConfigurationEntry[], found " + string);
            }
            return this.cloneConfigurationEntry(appConfigurationEntryArray, this.getOrganization(string));
        }
        if (debug.messageEnabled()) {
            debug.message("getAppConfigurationEntry[], new " + string);
        }
        return this.newConfiguration(string);
    }

    public void refresh() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processListenerEvent(String string) {
        Map map = jaasConfig;
        synchronized (map) {
            if (debug.messageEnabled()) {
                debug.message("pLE, remove config " + string);
            }
            jaasConfig.remove(string);
        }
        this.removeListenersMap(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListenersMap(String string) {
        Map map = listenersMap;
        synchronized (map) {
            Set set = (Set)listenersMap.get(string);
            if (set == null) {
                if (debug.messageEnabled()) {
                    debug.message("remove, no listeners for " + string);
                }
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                AMSDKEventListener aMSDKEventListener = (AMSDKEventListener)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("remove SDK listener on " + string + " for dn=" + aMSDKEventListener.getListenedObject().getDN());
                }
                aMSDKEventListener.getListenedObject().removeEventListener(aMSDKEventListener);
                aMSDKEventListener.setListenedObject(null);
            }
            listenersMap.remove(string);
        }
        AMAuthLevelManager.getInstance().removeAuthConfigListener(string);
    }

    private void addServiceListener(String string, String string2) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("addServiceListener for " + string + ", name=" + string2);
        }
        AMAuthLevelManager.getInstance().addAuthConfigListener(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToListenersMap(String string, Object object) {
        Map map = listenersMap;
        synchronized (map) {
            HashSet<Object> hashSet = (HashSet<Object>)listenersMap.get(string);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                hashSet.add(object);
                listenersMap.put(string, hashSet);
            } else {
                hashSet.add(object);
            }
        }
    }
}

