/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.config;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.config.AMAuthConfigType;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfiguration;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceNotFoundException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.Configuration;

public class AMAuthLevelManager
implements ServiceListener {
    private static AMAuthLevelManager instance = null;
    private Map listenerMap = new HashMap();
    private static Map authLevelMap = new HashMap();
    private static Map supportedModulesMap = new HashMap();
    private static Map authConfigListenerMap = new HashMap();
    private static String CORE_AUTH = "iPlanetAMAuthService";
    private Debug debug = Debug.getInstance((String)"amAuthConfig");
    static /* synthetic */ Class class$com$sun$identity$authentication$config$AMAuthLevelManager;

    public AMAuthLevelManager() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMAuthLevelManager getInstance() {
        if (instance == null) {
            Class clazz = class$com$sun$identity$authentication$config$AMAuthLevelManager == null ? (class$com$sun$identity$authentication$config$AMAuthLevelManager = AMAuthLevelManager.class$("com.sun.identity.authentication.config.AMAuthLevelManager")) : class$com$sun$identity$authentication$config$AMAuthLevelManager;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new AMAuthLevelManager();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerListener(String string, Map map) {
        List list = (List)this.listenerMap.get(string);
        if (list != null) {
            if (this.debug.messageEnabled()) {
                this.debug.message("initialize, existing " + string);
            }
            map.put(string, list);
            Map map2 = this.listenerMap;
            synchronized (map2) {
                this.listenerMap.remove(string);
            }
        }
        try {
            list = this.addServiceListener(string);
            if (list != null) {
                map.put(string, list);
            }
        }
        catch (Exception exception) {
            this.debug.error("can't add listener for " + string, (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initialize() {
        Object object;
        Object object2;
        Object object3;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this.registerListener(CORE_AUTH, hashMap);
        this.registerListener("iPlanetAMAuthConfiguration", hashMap);
        Iterator iterator = AuthD.getAuth().getAuthenticators();
        if (iterator != null) {
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                object2 = (List)this.listenerMap.get(object3);
                if (object2 != null) {
                    if (this.debug.messageEnabled()) {
                        this.debug.message("initialize, existing " + (String)object3);
                    }
                    hashMap.put(object3, object2);
                    object = this.listenerMap;
                    synchronized (object) {
                        this.listenerMap.remove(object3);
                        continue;
                    }
                }
                try {
                    object2 = this.addServiceListener(AMAuthConfigUtils.getModuleServiceName((String)object3));
                    if (object2 == null) continue;
                    hashMap.put(object3, object2);
                }
                catch (Exception exception) {
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("authlevel, add service listener," + exception.getMessage());
                }
            }
        }
        if (!this.listenerMap.isEmpty()) {
            iterator = this.listenerMap.values().iterator();
            while (iterator.hasNext()) {
                object3 = (List)iterator.next();
                object2 = (ServiceSchemaManager)object3.get(0);
                object = (String)object3.get(1);
                ServiceConfigManager serviceConfigManager = (ServiceConfigManager)object3.get(2);
                String string = (String)object3.get(3);
                try {
                    ((ServiceSchemaManager)object2).removeListener((String)object);
                    serviceConfigManager.removeListener(string);
                }
                catch (Exception exception) {
                    this.debug.error("remove listeners ", (Throwable)exception);
                }
            }
        }
        object3 = this.listenerMap;
        synchronized (object3) {
            this.listenerMap = hashMap;
        }
    }

    private List addServiceListener(String string) throws SMSException, SSOException {
        if (this.debug.messageEnabled()) {
            this.debug.message("addServiceListener for " + string);
        }
        ServiceSchemaManager serviceSchemaManager = null;
        try {
            serviceSchemaManager = new ServiceSchemaManager(string, AuthD.getAuth().getSSOAuthSession());
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
        String string2 = serviceSchemaManager.addListener(this);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(serviceSchemaManager);
        arrayList.add(string2);
        ServiceConfigManager serviceConfigManager = null;
        try {
            serviceConfigManager = new ServiceConfigManager(string, AuthD.getAuth().getSSOAuthSession());
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return null;
        }
        string2 = serviceConfigManager.addListener(this);
        arrayList.add(serviceConfigManager);
        arrayList.add(string2);
        return arrayList;
    }

    public Set getModulesForLevel(int n, String string, String string2) {
        Map map = (Map)authLevelMap.get(string);
        if (map == null) {
            map = this.initOrgAuthLevel(string);
        }
        if (map == null || map.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set set = this.getModuleForLevel(n, map);
        if (this.debug.messageEnabled()) {
            this.debug.message("getModuleForLevel " + n + ", org=" + string + ", modules=" + set);
        }
        AuthUtils.retainSupportedModules(set, string2);
        if (this.debug.messageEnabled()) {
            this.debug.message("getModuleForLevel, modules=" + set);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map initOrgAuthLevel(String string) {
        Object object;
        HashSet<String> hashSet;
        Object object2;
        Object object3;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        try {
            object3 = AuthD.getAuth().getOrganizationTemplate(string, CORE_AUTH);
            object2 = object3.getAttributes();
            hashSet = (HashSet<String>)object2.get("iplanet-am-auth-allowed-modules");
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add("Application");
            object = supportedModulesMap;
            synchronized (object) {
                supportedModulesMap.put(string, hashSet);
            }
        }
        catch (Exception exception) {
            this.debug.error("initOrgAuthLevel " + string, (Throwable)exception);
            return hashMap;
        }
        if (!hashSet.isEmpty()) {
            object3 = hashSet.iterator();
            while (object3.hasNext()) {
                Object object4;
                object2 = (String)object3.next();
                if (this.debug.messageEnabled()) {
                    this.debug.message("initOrgAuthLevel process " + (String)object2);
                }
                object = AMAuthConfigUtils.getModuleServiceName((String)object2);
                ServiceConfig serviceConfig = null;
                try {
                    object4 = new ServiceConfigManager((String)object, AuthD.getAuth().getSSOAuthSession());
                    serviceConfig = ((ServiceConfigManager)object4).getOrganizationConfig(string, null);
                }
                catch (Exception exception) {
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("initOrgAuthLevel " + (String)object + ", " + exception.getMessage());
                    continue;
                }
                if (serviceConfig == null) {
                    if (!this.debug.messageEnabled()) continue;
                    this.debug.message("initOrgAuthLevel " + string + " service " + (String)object);
                    continue;
                }
                object4 = AMAuthConfigUtils.getAuthLevelAttribute((String)object2);
                Map map = serviceConfig.getAttributes();
                String string2 = Misc.getMapAttr((Map)map, (String)object4);
                Integer n = null;
                if (string2 != null && !string2.equals("")) {
                    try {
                        n = Integer.decode(string2);
                    }
                    catch (Exception exception) {
                        this.debug.error("initOrgAuthLevel, invalid level", (Throwable)exception);
                    }
                }
                if (n == null) {
                    n = new Integer(0);
                }
                if (this.debug.messageEnabled()) {
                    this.debug.message("initOrgAuthLevel add " + (String)object2);
                }
                hashMap.put(object2, n);
            }
        }
        object3 = authLevelMap;
        synchronized (object3) {
            authLevelMap.put(string, hashMap);
        }
        return hashMap;
    }

    private Set getModuleForLevel(int n, Map map) {
        Iterator iterator = map.keySet().iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if ((Integer)map.get(string) < n) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
        if (this.debug.messageEnabled()) {
            this.debug.message("authlevel : globalConfigChanged " + string + ", ver=" + string2 + ", group=" + string3 + ", componnet=" + string4 + ", type=" + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
        if (this.debug.messageEnabled()) {
            this.debug.message("authlevel : orgConfigChanged " + string + ", ver=" + string2 + ", org=" + string3 + ", group=" + string4 + ", componnet=" + string5 + ", type=" + n);
        }
        Map map = authLevelMap;
        synchronized (map) {
            authLevelMap.remove(string3);
        }
        if (string.equals(CORE_AUTH)) {
            Map map2 = supportedModulesMap;
            synchronized (map2) {
                supportedModulesMap.remove(string3);
            }
        }
        this.updateAuthConfiguration(string, string3, string5);
    }

    public void schemaChanged(String string, String string2) {
        if (this.debug.messageEnabled()) {
            this.debug.message("authlevel : schemaChanged " + string + ", ver=" + string2);
        }
        if (string.equals(CORE_AUTH)) {
            this.initialize();
        }
        this.updateAuthConfiguration(string, "", "");
    }

    public int getLevelForModule(String string, String string2) {
        Map map;
        if (this.debug.messageEnabled()) {
            this.debug.message("moduleName : " + string);
            this.debug.message("orgDN : " + string2);
        }
        if ((map = (Map)authLevelMap.get(string2)) == null) {
            map = this.initOrgAuthLevel(string2);
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("Map is : " + map);
        }
        if (map == null || map.isEmpty()) {
            return 0;
        }
        Integer n = (Integer)map.get(string);
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n;
        if (this.debug.messageEnabled()) {
            this.debug.message("authLevel : " + n2);
        }
        return n2;
    }

    protected Set getSupportedModule(String string) {
        Set set;
        if (this.debug.messageEnabled()) {
            this.debug.message("getSupportedModules=" + string);
        }
        if ((set = (Set)supportedModulesMap.get(string)) == null) {
            this.initOrgAuthLevel(string);
            set = (Set)supportedModulesMap.get(string);
            if (set == null) {
                return Collections.EMPTY_SET;
            }
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("supported modules are : " + set);
        }
        return set;
    }

    protected void removeAuthConfigListener(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.removeConfigListenerEntry(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthConfigListener(String string, String string2) {
        HashSet<String> hashSet = (HashSet<String>)authConfigListenerMap.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            hashSet.add(string2);
            Map map = authConfigListenerMap;
            synchronized (map) {
                authConfigListenerMap.put(string, hashSet);
            }
        }
        HashSet<String> hashSet2 = hashSet;
        synchronized (hashSet2) {
            hashSet.add(string2);
        }
    }

    private synchronized void updateAuthConfiguration(String string, String string2, String string3) {
        Set set = (Set)authConfigListenerMap.get(string);
        if (set == null || set.isEmpty()) {
            return;
        }
        HashSet<String> hashSet = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (!this.processAuthConfigEntry(string, string2, string3, string4)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string4);
        }
        if (hashSet == null) {
            return;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("updateAuthConfiguration, updated=" + hashSet);
        }
        this.removeConfigListenerEntry(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConfigListenerEntry(Set set) {
        Map map = authConfigListenerMap;
        synchronized (map) {
            Iterator iterator = authConfigListenerMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Set set2 = (Set)authConfigListenerMap.get(string);
                if (this.debug.messageEnabled()) {
                    this.debug.message("updateAuthConfiguration, check " + string + ", entries=" + set2);
                }
                if (set2 == null || set2.isEmpty()) continue;
                set2.removeAll(set);
            }
        }
    }

    private boolean processAuthConfigEntry(String string, String string2, String string3, String string4) {
        boolean bl = false;
        if (string3.equals("")) {
            bl = true;
        } else if (string.equals(CORE_AUTH) || string.startsWith("iPlanetAMAuth") && string.endsWith("Service")) {
            AMAuthConfigType aMAuthConfigType = new AMAuthConfigType(string4);
            if (aMAuthConfigType.getOrganization().equals(string2)) {
                bl = true;
            }
        } else if (string.equals("iPlanetAMAuthConfiguration")) {
            int n = string3.lastIndexOf("/");
            String string5 = "";
            string5 = n != -1 ? string3.substring(n + 1) : string3;
            AMAuthConfigType aMAuthConfigType = new AMAuthConfigType(string4);
            if (aMAuthConfigType.getIndexType() == 4 && aMAuthConfigType.getIndexName().equalsIgnoreCase(string5) && aMAuthConfigType.getOrganization().equals(string2)) {
                if (this.debug.messageEnabled()) {
                    this.debug.message(string4 + " matches " + string5);
                }
                bl = true;
            }
        }
        if (bl) {
            if (this.debug.messageEnabled()) {
                this.debug.message("processSMNotification, name=" + string4);
            }
            ((AMConfiguration)Configuration.getConfiguration()).processListenerEvent(string4);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

