/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaAttributeContainer;
import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaManager;
import com.netscape.jndi.ldap.schema.SchemaMatchingRuleContainer;
import com.netscape.jndi.ldap.schema.SchemaObjectClassContainer;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPConnection;

public class SchemaRoot
extends SchemaDirContext {
    static final String m_className = "javax.naming.directory.DirContext";
    SchemaDirContext m_classContainer;
    SchemaDirContext m_attrContainer;
    SchemaDirContext m_matchRuleContainer;
    SchemaManager m_schemaMgr;

    public SchemaRoot(LDAPConnection lDAPConnection) throws NamingException {
        this.m_path = "";
        this.m_schemaMgr = new SchemaManager(lDAPConnection);
        this.m_classContainer = new SchemaObjectClassContainer(this.m_schemaMgr);
        this.m_attrContainer = new SchemaAttributeContainer(this.m_schemaMgr);
        this.m_matchRuleContainer = new SchemaMatchingRuleContainer(this.m_schemaMgr);
    }

    public void bind(String string, Object object) throws NamingException {
        if (!(object instanceof DirContext)) {
            throw new IllegalArgumentException("Can not bind this type of object");
        }
        this.createSubcontext(string, ((DirContext)object).getAttributes(""));
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        return schemaObjectSubordinateNamePair.schemaObj.createSubcontext(schemaObjectSubordinateNamePair.subordinateName, attributes);
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.createSubcontext(name.toString(), attributes);
    }

    public void destroySubcontext(String string) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        schemaObjectSubordinateNamePair.schemaObj.destroySubcontext(schemaObjectSubordinateNamePair.subordinateName);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Attributes getAttributes(String string) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        return schemaObjectSubordinateNamePair.schemaObj.getAttributes(schemaObjectSubordinateNamePair.subordinateName);
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            throw new OperationNotSupportedException();
        }
        return schemaObjectSubordinateNamePair.schemaObj.getAttributes(schemaObjectSubordinateNamePair.subordinateName, stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    public NamingEnumeration list(String string) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            return new SchemaRootNameClassPairEnum();
        }
        return schemaObjectSubordinateNamePair.schemaObj.list(schemaObjectSubordinateNamePair.subordinateName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            return new SchemaRootBindingEnum();
        }
        return schemaObjectSubordinateNamePair.schemaObj.listBindings(schemaObjectSubordinateNamePair.subordinateName);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookup(String string) throws NamingException {
        SchemaDirContext.SchemaObjectSubordinateNamePair schemaObjectSubordinateNamePair = this.resolveSchemaObject(string);
        if (schemaObjectSubordinateNamePair.schemaObj == this) {
            return this;
        }
        return schemaObjectSubordinateNamePair.schemaObj.lookup(schemaObjectSubordinateNamePair.subordinateName);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            System.out.println(new SchemaRoot(null).resolveSchemaObject(string));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(String string, Object object) throws NamingException {
        this.unbind(string);
        this.bind(string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    public void rename(String string, String string2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    SchemaDirContext.SchemaObjectSubordinateNamePair resolveSchemaObject(String string) throws NamingException {
        SchemaDirContext schemaDirContext = null;
        if (string.length() == 0) {
            schemaDirContext = this;
        } else if (string.startsWith("ClassDefinition") || string.startsWith("ClassDefinition".toLowerCase())) {
            string = string.substring("ClassDefinition".length());
            schemaDirContext = this.m_classContainer;
        } else if (string.startsWith("AttributeDefinition") || string.startsWith("AttributeDefinition".toLowerCase())) {
            string = string.substring("AttributeDefinition".length());
            schemaDirContext = this.m_attrContainer;
        } else if (string.startsWith("MatchingRule") || string.startsWith("MatchingRule".toLowerCase())) {
            string = string.substring("MatchingRule".length());
            schemaDirContext = this.m_matchRuleContainer;
        } else {
            throw new NameNotFoundException(string);
        }
        if (string.length() > 1 && string.startsWith("/")) {
            string = string.substring(1);
        }
        return new SchemaDirContext.SchemaObjectSubordinateNamePair(schemaDirContext, string);
    }

    public void unbind(String string) throws NamingException {
        this.destroySubcontext(string);
    }

    public void unbind(Name name) throws NamingException {
        this.destroySubcontext(name);
    }

    class SchemaRootNameClassPairEnum
    implements NamingEnumeration {
        private int m_idx = -1;

        SchemaRootNameClassPairEnum() {
        }

        public void close() {
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.m_idx < 2;
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            ++this.m_idx;
            if (this.m_idx == 0) {
                return new NameClassPair("ClassDefinition", SchemaRoot.m_className);
            }
            if (this.m_idx == 1) {
                return new NameClassPair("AttributeDefinition", SchemaRoot.m_className);
            }
            if (this.m_idx == 2) {
                return new NameClassPair("MatchingRule", SchemaRoot.m_className);
            }
            throw new NoSuchElementException("SchemaRootEnumerator");
        }
    }

    class SchemaRootBindingEnum
    implements NamingEnumeration {
        private int m_idx = -1;

        SchemaRootBindingEnum() {
        }

        public void close() {
        }

        public boolean hasMore() {
            return this.hasMoreElements();
        }

        public boolean hasMoreElements() {
            return this.m_idx < 2;
        }

        public Object next() {
            return this.nextElement();
        }

        public Object nextElement() {
            ++this.m_idx;
            if (this.m_idx == 0) {
                return new Binding("ClassDefinition", SchemaRoot.m_className, SchemaRoot.this.m_classContainer);
            }
            if (this.m_idx == 1) {
                return new Binding("AttributeDefinition", SchemaRoot.m_className, SchemaRoot.this.m_attrContainer);
            }
            if (this.m_idx == 2) {
                return new Binding("MatchingRule", SchemaRoot.m_className, SchemaRoot.this.m_matchRuleContainer);
            }
            throw new NoSuchElementException("SchemaRootEnumerator");
        }
    }
}

