/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.common.ExceptionMapper;
import java.util.Enumeration;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;

class SchemaManager {
    private LDAPSchema m_schema;
    private LDAPConnection m_ld;
    private boolean m_isLoaded;
    private boolean m_isObjectClassDirty;
    private boolean m_isAttributeDirty;
    private boolean m_isMatchingRuleDirty;

    private SchemaManager() {
    }

    public SchemaManager(LDAPConnection lDAPConnection) {
        this.m_ld = lDAPConnection;
        this.m_isLoaded = false;
        this.m_isMatchingRuleDirty = false;
        this.m_isAttributeDirty = false;
        this.m_isObjectClassDirty = false;
    }

    void createAttribute(LDAPAttributeSchema lDAPAttributeSchema) throws NamingException {
        try {
            lDAPAttributeSchema.add(this.m_ld);
            this.m_isAttributeDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void createMatchingRule(LDAPMatchingRuleSchema lDAPMatchingRuleSchema) throws NamingException {
        try {
            lDAPMatchingRuleSchema.add(this.m_ld);
            this.m_isMatchingRuleDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void createObjectClass(LDAPObjectClassSchema lDAPObjectClassSchema) throws NamingException {
        try {
            lDAPObjectClassSchema.add(this.m_ld);
            this.m_isObjectClassDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    LDAPAttributeSchema getAttribute(String string) throws NamingException {
        if (!this.m_isLoaded || this.m_isAttributeDirty) {
            this.load();
        }
        return this.m_schema.getAttribute(string);
    }

    Enumeration getAttributeNames() throws NamingException {
        if (!this.m_isLoaded || this.m_isAttributeDirty) {
            this.load();
        }
        return this.m_schema.getAttributeNames();
    }

    Enumeration getAttributes() throws NamingException {
        if (!this.m_isLoaded || this.m_isAttributeDirty) {
            this.load();
        }
        return this.m_schema.getAttributes();
    }

    LDAPMatchingRuleSchema getMatchingRule(String string) throws NamingException {
        if (!this.m_isLoaded || this.m_isMatchingRuleDirty) {
            this.load();
        }
        return this.m_schema.getMatchingRule(string);
    }

    Enumeration getMatchingRuleNames() throws NamingException {
        if (!this.m_isLoaded || this.m_isMatchingRuleDirty) {
            this.load();
        }
        return this.m_schema.getMatchingRuleNames();
    }

    Enumeration getMatchingRules() throws NamingException {
        if (!this.m_isLoaded || this.m_isMatchingRuleDirty) {
            this.load();
        }
        return this.m_schema.getMatchingRules();
    }

    LDAPObjectClassSchema getObjectClass(String string) throws NamingException {
        if (!this.m_isLoaded || this.m_isObjectClassDirty) {
            this.load();
        }
        return this.m_schema.getObjectClass(string);
    }

    Enumeration getObjectClassNames() throws NamingException {
        if (!this.m_isLoaded || this.m_isObjectClassDirty) {
            this.load();
        }
        return this.m_schema.getObjectClassNames();
    }

    Enumeration getObjectClasses() throws NamingException {
        if (!this.m_isLoaded || this.m_isObjectClassDirty) {
            this.load();
        }
        return this.m_schema.getObjectClasses();
    }

    void load() throws NamingException {
        try {
            this.m_schema = new LDAPSchema();
            this.m_schema.fetchSchema(this.m_ld);
            this.m_isLoaded = true;
            this.m_isMatchingRuleDirty = false;
            this.m_isAttributeDirty = false;
            this.m_isObjectClassDirty = false;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void modifyAttribute(LDAPAttributeSchema lDAPAttributeSchema, LDAPAttributeSchema lDAPAttributeSchema2) throws NamingException {
        try {
            lDAPAttributeSchema.modify(this.m_ld, lDAPAttributeSchema2);
            this.m_isAttributeDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void modifyMatchingRule(LDAPMatchingRuleSchema lDAPMatchingRuleSchema, LDAPMatchingRuleSchema lDAPMatchingRuleSchema2) throws NamingException {
        try {
            lDAPMatchingRuleSchema.modify(this.m_ld, lDAPMatchingRuleSchema2);
            this.m_isMatchingRuleDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void modifyObjectClass(LDAPObjectClassSchema lDAPObjectClassSchema, LDAPObjectClassSchema lDAPObjectClassSchema2) throws NamingException {
        try {
            lDAPObjectClassSchema.modify(this.m_ld, lDAPObjectClassSchema2);
            this.m_isObjectClassDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void removeAttribute(String string) throws NamingException {
        LDAPAttributeSchema lDAPAttributeSchema = this.getAttribute(string);
        if (lDAPAttributeSchema == null) {
            throw new NameNotFoundException(string);
        }
        try {
            lDAPAttributeSchema.remove(this.m_ld);
            this.m_isAttributeDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void removeMatchingRule(String string) throws NamingException {
        LDAPMatchingRuleSchema lDAPMatchingRuleSchema = this.getMatchingRule(string);
        if (lDAPMatchingRuleSchema == null) {
            throw new NameNotFoundException(string);
        }
        try {
            lDAPMatchingRuleSchema.remove(this.m_ld);
            this.m_isMatchingRuleDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }

    void removeObjectClass(String string) throws NamingException {
        LDAPObjectClassSchema lDAPObjectClassSchema = this.getObjectClass(string);
        if (lDAPObjectClassSchema == null) {
            throw new NameNotFoundException(string);
        }
        try {
            lDAPObjectClassSchema.remove(this.m_ld);
            this.m_isObjectClassDirty = true;
        }
        catch (LDAPException lDAPException) {
            throw ExceptionMapper.getNamingException(lDAPException);
        }
    }
}

