/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaManager;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import netscape.ldap.LDAPModificationSet;

public class SchemaElement
extends SchemaDirContext {
    SchemaManager m_schemaMgr;
    static final String NUMERICOID = "NUMERICOID";
    static final String NAME = "NAME";
    static final String DESC = "DESC";
    static final String SYNTAX = "SYNTAX";
    static final String SUP = "SUP";
    static final String MUST = "MUST";
    static final String MAY = "MAY";
    static final String SINGLEVALUE = "SINGLE-VALUE";
    static final String OBSOLETE = "OBSOLETE";
    static final String EQUALITY = "EQUALITY";
    static final String ORDERING = "ORDERING";
    static final String SUBSTRING = "SUBSTRING";
    static final String COLLECTIVE = "COLLECTIVE";
    static final String NOUSERMOD = "NO-USER-MODIFICATION";
    static final String USAGE = "USAGE";
    static final String ABSTRACT = "ABSTRACT";
    static final String STRUCTURAL = "STRUCTURAL";
    static final String AUXILIARY = "AUXILIARY";
    static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";

    SchemaElement(SchemaManager schemaManager) {
        this.m_schemaMgr = schemaManager;
    }

    static String getSchemaAttrValue(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        if (namingEnumeration.hasMoreElements()) {
            return (String)namingEnumeration.nextElement();
        }
        throw new InvalidAttributeValueException(String.valueOf(attribute.getID()) + " must have a value");
    }

    public NamingEnumeration list(String string) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration();
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return new SchemaDirContext.EmptyNamingEnumeration();
    }

    void modifySchemaElementAttrs(Attributes attributes, int n, Attributes attributes2) throws NamingException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMore()) {
            NamingEnumeration<?> namingEnumeration2;
            Attribute attribute;
            Attribute attribute2 = namingEnumeration.next();
            if (n == 1) {
                attribute = attributes.get(attribute2.getID());
                if (attribute == null) {
                    attributes.put(attribute2);
                    continue;
                }
                namingEnumeration2 = attribute2.getAll();
                while (namingEnumeration2.hasMore()) {
                    attribute.add(namingEnumeration2.nextElement());
                }
                continue;
            }
            if (n == 2) {
                attributes.put(attribute2);
                continue;
            }
            if (n == 3) {
                attribute = attributes.get(attribute2.getID());
                if (attribute == null) {
                    throw new NoSuchAttributeException(attribute2.getID());
                }
                if (attribute2.size() == 0) {
                    attributes.remove(attribute2.getID());
                    continue;
                }
                namingEnumeration2 = attribute2.getAll();
                while (namingEnumeration2.hasMore()) {
                    String string = (String)namingEnumeration2.nextElement();
                    attribute.remove(string);
                    attribute.remove(string.toLowerCase());
                }
                if (attribute.size() != 0) continue;
                attributes.remove(attribute2.getID());
                continue;
            }
            throw new IllegalArgumentException("Illegal Attribute Modification Operation");
        }
    }

    void modifySchemaElementAttrs(Attributes attributes, ModificationItem[] modificationItemArray) throws NamingException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        int n = 0;
        while (n < modificationItemArray.length) {
            int n2 = modificationItemArray[n].getModificationOp();
            Attribute attribute = modificationItemArray[n].getAttribute();
            BasicAttributes basicAttributes = new BasicAttributes(true);
            basicAttributes.put(attribute);
            this.modifySchemaElementAttrs(attributes, n2, basicAttributes);
            ++n;
        }
    }

    static boolean parseTrueFalseValue(Attribute attribute) throws NamingException {
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        if (namingEnumeration.hasMore()) {
            String string = (String)namingEnumeration.nextElement();
            if (string.equals("true")) {
                return true;
            }
            if (string.equals("false")) {
                return false;
            }
            throw new InvalidAttributeValueException(String.valueOf(attribute.getID()) + " value must be \"true\", \"false\" or absent");
        }
        return false;
    }

    static String syntaxIntToString(int n) throws NamingException {
        if (n == 1) {
            return cisString;
        }
        if (n == 4) {
            return cesString;
        }
        if (n == 3) {
            return telephoneString;
        }
        if (n == 6) {
            return intString;
        }
        if (n == 5) {
            return dnString;
        }
        if (n == 2) {
            return binaryString;
        }
        throw new InvalidAttributeValueException("Interanal error, unexpected syntax value " + n);
    }

    static int syntaxStringToInt(String string) throws NamingException {
        if (string.equals(cisString)) {
            return 1;
        }
        if (string.equals(cesString)) {
            return 4;
        }
        if (string.equals(telephoneString)) {
            return 3;
        }
        if (string.equals(intString)) {
            return 6;
        }
        if (string.equals(dnString)) {
            return 5;
        }
        if (string.equals(binaryString)) {
            return 2;
        }
        throw new InvalidAttributeValueException(string);
    }

    static String[] vectorToStringAry(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }
}

