/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.common;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ShareableEnv
implements Cloneable {
    private static final Object REMOVED_PROPERTY = new Object();
    protected Hashtable m_privateEnv;
    protected Vector m_sharedEnv;
    protected ShareableEnv m_parentEnv;
    protected int m_parentSharedEnvIdx = -1;

    private ShareableEnv() {
    }

    public ShareableEnv(ShareableEnv shareableEnv, int n) {
        this.m_parentEnv = shareableEnv;
        this.m_parentSharedEnvIdx = n;
    }

    public ShareableEnv(Hashtable hashtable) {
        this.m_privateEnv = hashtable;
    }

    public Object clone() {
        this.freezeUpdates();
        if (this.m_sharedEnv != null) {
            return new ShareableEnv(this, this.m_sharedEnv.size() - 1);
        }
        return new ShareableEnv(this.m_parentEnv, this.m_parentSharedEnvIdx);
    }

    protected void freezeUpdates() {
        if (this.m_privateEnv != null) {
            if (this.m_sharedEnv == null) {
                this.m_sharedEnv = new Vector();
            }
            this.m_sharedEnv.addElement(this.m_privateEnv);
            this.m_privateEnv = null;
        }
    }

    public Hashtable getAllProperties() {
        Hashtable hashtable = null;
        hashtable = this.m_sharedEnv != null ? this.getAllSharedProperties(this.m_sharedEnv.size() - 1) : this.getAllSharedProperties(-1);
        if (hashtable == null) {
            hashtable = new Hashtable(51);
        }
        if (this.m_privateEnv != null) {
            Hashtable hashtable2 = this.m_privateEnv;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable2.get(k);
                if (v != REMOVED_PROPERTY) {
                    hashtable.put(k, v);
                    continue;
                }
                hashtable.remove(k);
            }
        }
        return hashtable;
    }

    private Hashtable getAllSharedProperties(int n) {
        Hashtable hashtable = null;
        if (this.m_parentEnv != null) {
            hashtable = this.m_parentEnv.getAllSharedProperties(this.m_parentSharedEnvIdx);
        }
        if (hashtable == null) {
            hashtable = new Hashtable(51);
        }
        if (n >= 0) {
            int n2 = 0;
            while (n2 <= n) {
                Hashtable hashtable2 = (Hashtable)this.m_sharedEnv.elementAt(n2);
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    Object v = hashtable2.get(k);
                    if (v != REMOVED_PROPERTY) {
                        hashtable.put(k, v);
                        continue;
                    }
                    hashtable.remove(k);
                }
                ++n2;
            }
        }
        return hashtable;
    }

    public Object getProperty(String string) {
        Object v;
        if (this.m_privateEnv != null && (v = this.m_privateEnv.get(string)) != null) {
            return v == REMOVED_PROPERTY ? null : v;
        }
        if (this.m_sharedEnv != null) {
            return this.getSharedProperty(this.m_sharedEnv.size() - 1, string);
        }
        return this.getSharedProperty(-1, string);
    }

    private Object getSharedProperty(int n, String string) {
        if (n >= 0) {
            int n2 = n;
            while (n2 >= 0) {
                Hashtable hashtable = (Hashtable)this.m_sharedEnv.elementAt(n2);
                Object v = hashtable.get(string);
                if (v != null) {
                    return v == REMOVED_PROPERTY ? null : v;
                }
                --n2;
            }
        }
        if (this.m_parentSharedEnvIdx >= 0) {
            return this.m_parentEnv.getSharedProperty(this.m_parentSharedEnvIdx, string);
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ShareableEnv shareableEnv = new ShareableEnv(null, -1);
        System.err.println("c0.getProperty(p1)=" + shareableEnv.getProperty("p1"));
        System.err.println("c0.getAllProperties()=" + shareableEnv.getAllProperties());
        System.err.println("c0.setProperty(p1,vxxx)=" + shareableEnv.setProperty("p1", "vxxx"));
        System.err.println("c0.setProperty(p2,v2)=" + shareableEnv.setProperty("p2", "v2"));
        System.err.println("c0.setProperty(p3,v3)=" + shareableEnv.setProperty("p3", "v3"));
        System.err.println("c0.setProperty(p1,v1)=" + shareableEnv.setProperty("p1", "v1"));
        System.err.println("c0.getAllProperties()=" + shareableEnv.getAllProperties());
        System.err.println("---");
        ShareableEnv shareableEnv2 = (ShareableEnv)shareableEnv.clone();
        System.err.println("c01.getProperty(p1)=" + shareableEnv2.getProperty("p1"));
        System.err.println("c01.getAllProperties()=" + shareableEnv2.getAllProperties());
        System.err.println("c01.setProperty(p1,v1a)=" + shareableEnv2.setProperty("p1", "v1a"));
        System.err.println("c01.getProperty(p1)=" + shareableEnv2.getProperty("p1"));
        System.err.println("c01.removeProperty(p2)=" + shareableEnv2.removeProperty("p2"));
        System.err.println("c01.getProperty(p2)=" + shareableEnv2.getProperty("p2"));
        System.err.println("c01.setProperty(p11,v11a)=" + shareableEnv2.setProperty("p11", "v11a"));
        System.err.println("c01.getAllProperties()=" + shareableEnv2.getAllProperties());
        System.err.println("---");
        ShareableEnv shareableEnv3 = (ShareableEnv)shareableEnv.clone();
        System.err.println("c02.getProperty(p1)=" + shareableEnv3.getProperty("p1"));
        System.err.println("c02.getAllProperties()=" + shareableEnv3.getAllProperties());
        System.err.println("---");
        ShareableEnv shareableEnv4 = (ShareableEnv)shareableEnv2.clone();
        System.err.println("c011.getProperty(p1)=" + shareableEnv4.getProperty("p1"));
        System.err.println("c011.getAllProperties()=" + shareableEnv4.getAllProperties());
        System.err.println("c011.setProperty(p1,v11b)=" + shareableEnv4.setProperty("p1", "v11b"));
        System.err.println("c011.getProperty(p1)=" + shareableEnv4.getProperty("p1"));
        System.err.println("c011.getAllProperties()=" + shareableEnv4.getAllProperties());
        System.err.println("---");
        System.err.println("c01.getAllProperties()=" + shareableEnv2.getAllProperties());
        System.err.println("c01.removeProperty(p11)=" + shareableEnv2.removeProperty("p11"));
        System.err.println("c01.getAllProperties()=" + shareableEnv2.getAllProperties());
        System.err.println("c011.getAllProperties()=" + shareableEnv4.getAllProperties());
        System.err.println("---");
        ShareableEnv shareableEnv5 = (ShareableEnv)shareableEnv2.clone();
        System.err.println("c012.getAllProperties()=" + shareableEnv5.getAllProperties());
        System.err.println("c012.getProperty(p1)=" + shareableEnv5.getProperty("p1"));
        System.err.println("---");
        System.err.println("c0=" + shareableEnv);
        System.err.println("c01=" + shareableEnv2);
        System.err.println("c02=" + shareableEnv3);
        System.err.println("c011=" + shareableEnv4);
        System.err.println("c012=" + shareableEnv5);
    }

    public Object removeProperty(String string) {
        Object object = null;
        object = this.m_sharedEnv != null ? this.getSharedProperty(this.m_sharedEnv.size() - 1, string) : this.getSharedProperty(-1, string);
        if (object == null) {
            if (this.m_privateEnv != null) {
                return this.m_privateEnv.remove(string);
            }
        } else {
            this.setProperty(string, REMOVED_PROPERTY);
        }
        return object;
    }

    public Object setProperty(String string, Object object) {
        Object object2 = this.getProperty(string);
        if (this.m_privateEnv == null) {
            this.m_privateEnv = new Hashtable(5);
        }
        this.m_privateEnv.put(string, object);
        return object2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ShareableEnv private=");
        if (this.m_privateEnv != null) {
            stringBuffer.append("(");
            stringBuffer.append(this.m_privateEnv.size());
            stringBuffer.append(")");
        }
        stringBuffer.append(" shared=");
        if (this.m_sharedEnv != null) {
            int n = 0;
            while (n < this.m_sharedEnv.size()) {
                Hashtable hashtable = (Hashtable)this.m_sharedEnv.elementAt(n);
                stringBuffer.append("(");
                stringBuffer.append(hashtable.size());
                stringBuffer.append(")");
                ++n;
            }
        }
        stringBuffer.append(" parentIdx=");
        stringBuffer.append(this.m_parentSharedEnvIdx);
        return stringBuffer.toString();
    }
}

