/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributesImpl;
import com.netscape.jndi.ldap.LdapContextImpl;
import com.netscape.jndi.ldap.LdapNameParser;
import com.netscape.jndi.ldap.common.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeBase64Decoder;
import netscape.ldap.util.MimeBase64Encoder;

public class ObjectMapper {
    static final String OC_JAVAOBJECT = "javaObject";
    static final String OC_SERIALOBJ = "javaSerializedObject";
    static final String OC_MARSHALOBJ = "javaMarshalledObject";
    static final String OC_REFERENCE = "javaNamingReference";
    static final String OC_CONTAINER = "javaContainer";
    static final String AT_CLASSNAME = "javaClassName";
    static final String AT_CLASSNAMES = "javaClassNames";
    static final String AT_DESCRIPTION = "description";
    static final String AT_JAVADOC = "javaDoc";
    static final String AT_CODEBASE = "javaCodeBase";
    static final String AT_SERIALDATA = "javaSerializedData";
    static final String AT_REFADDR = "javaReferenceAddress";
    static final String AT_OBJFACTORY = "javaFactory";
    static final String DEFAULT_OBJCLASS = "javax.naming.directory.DirContext";

    private static void decodeRefAddr(String string, Reference reference) throws NamingException {
        if (string.length() == 0) {
            throw new NamingException("Bad Reference encoding, empty refAddr");
        }
        String string2 = string.substring(0, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        if (n != 3 && n != 4) {
            Debug.println(3, "enc=" + string + " delimChar=" + string2 + " tokCount=" + n);
            throw new NamingException("Bad Reference encoding");
        }
        String string3 = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            String string4 = stringTokenizer.nextToken();
            if (n3 == 0) {
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (Exception exception) {
                    throw new NamingException("Bad Reference encoding, refAddr position not an initger");
                }
            } else if (n3 == 1) {
                if (string4.length() == 0) {
                    throw new NamingException("Bad Reference encoding, empty refAddr type");
                }
                string3 = string4;
            } else if (n3 == 2) {
                if (string4.length() == 0 && n != 4) {
                    throw new NamingException("Bad Reference encoding, empty refAddr string value");
                }
                reference.add(n2, new StringRefAddr(string3, string4));
            } else {
                if (string4.length() == 0) {
                    throw new NamingException("Bad Reference encoding, empty refAddr binary value");
                }
                MimeBase64Decoder mimeBase64Decoder = new MimeBase64Decoder();
                ByteBuf byteBuf = new ByteBuf(string4);
                ByteBuf byteBuf2 = new ByteBuf();
                mimeBase64Decoder.translate(byteBuf, byteBuf2);
                mimeBase64Decoder.eof(byteBuf2);
                reference.add(n2, (RefAddr)ObjectMapper.deserializeObject(byteBuf2.toBytes()));
            }
            ++n3;
        }
    }

    private static Reference decodeRefObj(LDAPAttributeSet lDAPAttributeSet) throws NamingException {
        try {
            LDAPAttribute lDAPAttribute = null;
            String string = null;
            String string2 = null;
            String string3 = null;
            lDAPAttribute = lDAPAttributeSet.getAttribute(AT_CLASSNAME);
            if (lDAPAttribute == null) {
                throw new NamingException("Bad Reference encoding, no attribute javaClassName");
            }
            string = (String)lDAPAttribute.getStringValues().nextElement();
            lDAPAttribute = lDAPAttributeSet.getAttribute(AT_OBJFACTORY);
            if (lDAPAttribute != null) {
                string2 = (String)lDAPAttribute.getStringValues().nextElement();
            }
            if ((lDAPAttribute = lDAPAttributeSet.getAttribute(AT_CODEBASE)) != null) {
                string3 = (String)lDAPAttribute.getStringValues().nextElement();
            }
            Reference reference = new Reference(string, string2, string3);
            lDAPAttribute = lDAPAttributeSet.getAttribute(AT_REFADDR);
            if (lDAPAttribute == null) {
                return reference;
            }
            Enumeration enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                ObjectMapper.decodeRefAddr((String)enumeration.nextElement(), reference);
            }
            return reference;
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            NamingException namingException = new NamingException("NamingManager.getStateToStore failed");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object deserializeObject(byte[] byArray) throws NamingException {
        Object object;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
                Object var5_4 = null;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("Failed to deserialize object");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (byteArrayInputStream == null) throw throwable;
                byteArrayInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        if (objectInputStream != null) {
            objectInputStream.close();
        }
        if (byteArrayInputStream == null) return object;
        byteArrayInputStream.close();
        return object;
    }

    static Attributes encodeDirCtxObj(DirContext dirContext, Attributes attributes) throws NamingException {
        Attributes attributes2 = dirContext.getAttributes("");
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMore()) {
            attributes.put(namingEnumeration.next());
        }
        return attributes;
    }

    private static String encodeRefAddr(char c, int n, RefAddr refAddr) throws NamingException {
        if (refAddr instanceof StringRefAddr) {
            String string = (String)refAddr.getContent();
            if (string != null && string.length() > 0 && string.charAt(0) == c) {
                throw new NamingException("Can not encode StringRefAddr, value starts with the delimiter character " + c);
            }
            return String.valueOf(c + n + c) + refAddr.getType() + c + string;
        }
        byte[] byArray = ObjectMapper.serializeObject(refAddr);
        MimeBase64Encoder mimeBase64Encoder = new MimeBase64Encoder();
        ByteBuf byteBuf = new ByteBuf();
        ByteBuf byteBuf2 = new ByteBuf();
        byteBuf.append(byArray);
        mimeBase64Encoder.translate(byteBuf, byteBuf2);
        mimeBase64Encoder.eof(byteBuf2);
        return String.valueOf(c + n + c) + refAddr.getType() + c + c + byteBuf2.toString();
    }

    private static Attributes encodeRefObj(char c, Reference reference, Attributes attributes) throws NamingException {
        if (reference.getClassName() != null) {
            attributes.put(new BasicAttribute(AT_CLASSNAME, reference.getClassName()));
        }
        if (reference.getFactoryClassName() != null) {
            attributes.put(new BasicAttribute(AT_OBJFACTORY, reference.getFactoryClassName()));
        }
        if (reference.getFactoryClassLocation() != null) {
            attributes.put(new BasicAttribute(AT_CODEBASE, reference.getFactoryClassLocation()));
        }
        if (reference.size() > 0) {
            BasicAttribute basicAttribute = new BasicAttribute(AT_REFADDR);
            int n = 0;
            while (n < reference.size()) {
                basicAttribute.add(ObjectMapper.encodeRefAddr(c, n, reference.get(n)));
                ++n;
            }
            attributes.put(basicAttribute);
        }
        return attributes;
    }

    static Attributes encodeSerialObj(Serializable serializable, Attributes attributes) throws NamingException {
        if (attributes.get(AT_CLASSNAME) == null) {
            attributes.put(new BasicAttribute(AT_CLASSNAME, serializable.getClass().getName()));
        }
        attributes.put(new BasicAttribute(AT_SERIALDATA, ObjectMapper.serializeObject(serializable)));
        return attributes;
    }

    static Object entryToObject(LDAPEntry lDAPEntry) throws NamingException {
        try {
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            LDAPAttribute lDAPAttribute = null;
            lDAPAttribute = lDAPAttributeSet.getAttribute(AT_SERIALDATA);
            if (lDAPAttribute != null) {
                byte[] byArray = (byte[])lDAPAttribute.getByteValues().nextElement();
                return ObjectMapper.deserializeObject(byArray);
            }
            lDAPAttribute = lDAPAttributeSet.getAttribute(AT_REFADDR);
            if (lDAPAttribute != null) {
                return ObjectMapper.decodeRefObj(lDAPAttributeSet);
            }
            return null;
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            NamingException namingException = new NamingException("NamingManager.getStateToStore failed");
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    static Object entryToObject(LDAPEntry lDAPEntry, LdapContextImpl ldapContextImpl) throws NamingException {
        Object object = ObjectMapper.entryToObject(lDAPEntry);
        if (object == null) {
            object = new LdapContextImpl(lDAPEntry.getDN(), ldapContextImpl);
        }
        try {
            String string = LdapNameParser.getRelativeName(ldapContextImpl.m_ctxDN, lDAPEntry.getDN());
            Name name = LdapNameParser.getParser().parse(string);
            AttributesImpl attributesImpl = new AttributesImpl(lDAPEntry.getAttributeSet(), ldapContextImpl.m_ctxEnv.getUserDefBinaryAttrs());
            object = DirectoryManager.getObjectInstance(object, name, ldapContextImpl, ldapContextImpl.getEnvironment(), attributesImpl);
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            NamingException namingException = new NamingException("NamingManager.getObjectInstance failed");
            namingException.setRootCause(exception);
            throw namingException;
        }
        return object;
    }

    static String getClassName(LDAPEntry lDAPEntry) {
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute(AT_CLASSNAME);
        if (lDAPAttribute != null) {
            String string = (String)lDAPAttribute.getStringValues().nextElement();
            return string;
        }
        return DEFAULT_OBJCLASS;
    }

    public static void main(String[] stringArray) {
        byte[] byArray = new byte[]{97, 48, 65, 16, 127, -86};
        MimeBase64Encoder mimeBase64Encoder = new MimeBase64Encoder();
        MimeBase64Decoder mimeBase64Decoder = new MimeBase64Decoder();
        ByteBuf byteBuf = new ByteBuf();
        ByteBuf byteBuf2 = new ByteBuf();
        byteBuf.append(byArray);
        mimeBase64Encoder.translate(byteBuf, byteBuf2);
        mimeBase64Encoder.eof(byteBuf2);
        System.err.println("in=" + byteBuf);
        System.err.println("out=" + byteBuf2);
        byteBuf = new ByteBuf(byteBuf2.toString());
        byteBuf2 = new ByteBuf();
        mimeBase64Decoder.translate(byteBuf, byteBuf2);
        mimeBase64Decoder.eof(byteBuf2);
        System.err.println("in=" + byteBuf);
        System.err.println("out=" + byteBuf2);
    }

    static LDAPAttributeSet objectToAttrSet(Object object, String string, LdapContextImpl ldapContextImpl, Attributes attributes) throws NamingException {
        Cloneable cloneable;
        try {
            cloneable = LdapNameParser.getParser().parse(string);
            DirStateFactory.Result result = DirectoryManager.getStateToBind(object, (Name)cloneable, ldapContextImpl, ldapContextImpl.getEnvironment(), attributes);
            object = result.getObject();
            attributes = result.getAttributes();
        }
        catch (Exception exception) {
            if (exception instanceof NamingException) {
                throw (NamingException)exception;
            }
            NamingException namingException = new NamingException("NamingManager.getStateToStore failed");
            namingException.setRootCause(exception);
            throw namingException;
        }
        if (object == null) {
            return AttributesImpl.jndiAttrsToLdapAttrSet(attributes);
        }
        if (attributes == null) {
            attributes = new BasicAttributes(true);
        }
        if ((cloneable = attributes.get("objectClass")) == null) {
            cloneable = attributes.get("objectclass");
        }
        if (cloneable == null) {
            cloneable = new BasicAttribute("objectClass", "top");
            cloneable.add(OC_CONTAINER);
            attributes.put((Attribute)cloneable);
        }
        cloneable.add(OC_JAVAOBJECT);
        if (object instanceof Reference) {
            cloneable.add(OC_REFERENCE);
            char c = ldapContextImpl.m_ctxEnv.getRefSeparator();
            attributes = ObjectMapper.encodeRefObj(c, (Reference)object, attributes);
        } else if (object instanceof Referenceable) {
            cloneable.add(OC_REFERENCE);
            char c = ldapContextImpl.m_ctxEnv.getRefSeparator();
            attributes = ObjectMapper.encodeRefObj(c, ((Referenceable)object).getReference(), attributes);
        } else if (object instanceof Serializable) {
            if (!cloneable.contains(OC_MARSHALOBJ) && !cloneable.contains(OC_MARSHALOBJ.toLowerCase())) {
                cloneable.add(OC_SERIALOBJ);
            }
            attributes = ObjectMapper.encodeSerialObj((Serializable)object, attributes);
        } else if (object instanceof DirContext) {
            attributes = ObjectMapper.encodeDirCtxObj((DirContext)object, attributes);
        } else {
            throw new NamingException("Can not bind object of type " + object.getClass().getName());
        }
        return AttributesImpl.jndiAttrsToLdapAttrSet(attributes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] serializeObject(Object object) throws NamingException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                Object var5_4 = null;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("Failed to serialize object");
                namingException.setRootCause(exception);
                throw namingException;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (byteArrayOutputStream == null) throw throwable;
                byteArrayOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {}
        if (objectOutputStream != null) {
            objectOutputStream.close();
        }
        if (byteArrayOutputStream == null) return byArray;
        byteArrayOutputStream.close();
        return byArray;
    }
}

