/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.AttributeEnum;
import com.netscape.jndi.ldap.AttributeIDEnum;
import java.util.Enumeration;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPModificationSet;

class AttributesImpl
implements Attributes {
    LDAPAttributeSet m_attrSet;
    static String[] m_binaryAttrs = new String[]{"photo", "userpassword", "jpegphoto", "audio", "thumbnailphoto", "thumbnaillogo", "usercertificate", "cacertificate", "certificaterevocationlist", "authorityrevocationlist", "crosscertificatepair", "personalsignature", "x500uniqueidentifier", "javaserializeddata"};
    static String[] m_userBinaryAttrs = null;

    public AttributesImpl(LDAPAttributeSet lDAPAttributeSet, String[] stringArray) {
        this.m_attrSet = lDAPAttributeSet;
        m_userBinaryAttrs = stringArray;
    }

    public Object clone() {
        return new AttributesImpl((LDAPAttributeSet)this.m_attrSet.clone(), m_userBinaryAttrs);
    }

    public Attribute get(String string) {
        LDAPAttribute lDAPAttribute = this.m_attrSet.getAttribute(string);
        return lDAPAttribute == null ? null : AttributesImpl.ldapAttrToJndiAttr(lDAPAttribute);
    }

    public NamingEnumeration getAll() {
        return new AttributeEnum(this.m_attrSet.getAttributes());
    }

    public NamingEnumeration getIDs() {
        return new AttributeIDEnum(this.m_attrSet.getAttributes());
    }

    static boolean isBinaryAttribute(String string) {
        if (string.indexOf(";binary") >= 0) {
            return true;
        }
        string = string.toLowerCase();
        int n = 0;
        while (n < m_binaryAttrs.length) {
            if (m_binaryAttrs[n].equals(string)) {
                return true;
            }
            ++n;
        }
        int n2 = 0;
        while (m_userBinaryAttrs != null && n2 < m_userBinaryAttrs.length) {
            if (m_userBinaryAttrs[n2].equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isCaseIgnored() {
        return false;
    }

    static LDAPAttribute jndiAttrToLdapAttr(Attribute attribute) throws NamingException {
        LDAPAttribute lDAPAttribute = new LDAPAttribute(attribute.getID());
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Object e = namingEnumeration.nextElement();
            if (e == null) continue;
            if (e instanceof byte[]) {
                lDAPAttribute.addValue((byte[])e);
                continue;
            }
            lDAPAttribute.addValue(e.toString());
        }
        return lDAPAttribute;
    }

    static LDAPAttributeSet jndiAttrsToLdapAttrSet(Attributes attributes) throws NamingException {
        LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            lDAPAttributeSet.add(AttributesImpl.jndiAttrToLdapAttr((Attribute)namingEnumeration.nextElement()));
        }
        return lDAPAttributeSet;
    }

    static LDAPModificationSet jndiAttrsToLdapModSet(int n, Attributes attributes) throws NamingException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            LDAPAttribute lDAPAttribute = AttributesImpl.jndiAttrToLdapAttr(namingEnumeration.next());
            if (n == 1) {
                lDAPModificationSet.add(0, lDAPAttribute);
                continue;
            }
            if (n == 2) {
                lDAPModificationSet.add(2, lDAPAttribute);
                continue;
            }
            if (n == 3) {
                lDAPModificationSet.add(1, lDAPAttribute);
                continue;
            }
            throw new IllegalArgumentException("Illegal Attribute Modification Operation");
        }
        return lDAPModificationSet;
    }

    static LDAPModificationSet jndiModsToLdapModSet(ModificationItem[] modificationItemArray) throws NamingException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        int n = 0;
        while (n < modificationItemArray.length) {
            int n2 = modificationItemArray[n].getModificationOp();
            LDAPAttribute lDAPAttribute = AttributesImpl.jndiAttrToLdapAttr(modificationItemArray[n].getAttribute());
            if (n2 == 1) {
                lDAPModificationSet.add(0, lDAPAttribute);
            } else if (n2 == 2) {
                lDAPModificationSet.add(2, lDAPAttribute);
            } else if (n2 == 3) {
                lDAPModificationSet.add(1, lDAPAttribute);
            }
            ++n;
        }
        return lDAPModificationSet;
    }

    static Attribute ldapAttrToJndiAttr(LDAPAttribute lDAPAttribute) {
        BasicAttribute basicAttribute = new BasicAttribute(lDAPAttribute.getName());
        Enumeration enumeration = null;
        enumeration = AttributesImpl.isBinaryAttribute(lDAPAttribute.getName()) ? lDAPAttribute.getByteValues() : lDAPAttribute.getStringValues();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                basicAttribute.add(enumeration.nextElement());
            }
        }
        return basicAttribute;
    }

    public Attribute put(String string, Object object) {
        LDAPAttribute lDAPAttribute = this.m_attrSet.getAttribute(string);
        if (object == null) {
            this.m_attrSet.add(new LDAPAttribute(string));
        } else if (object instanceof byte[]) {
            this.m_attrSet.add(new LDAPAttribute(string, (byte[])object));
        } else {
            this.m_attrSet.add(new LDAPAttribute(string, object.toString()));
        }
        return lDAPAttribute == null ? null : AttributesImpl.ldapAttrToJndiAttr(lDAPAttribute);
    }

    public Attribute put(Attribute attribute) {
        try {
            LDAPAttribute lDAPAttribute = this.m_attrSet.getAttribute(attribute.getID());
            this.m_attrSet.add(AttributesImpl.jndiAttrToLdapAttr(attribute));
            return lDAPAttribute == null ? null : AttributesImpl.ldapAttrToJndiAttr(lDAPAttribute);
        }
        catch (NamingException namingException) {
            System.err.println("Error in AttributesImpl.put(): " + namingException.toString());
            namingException.printStackTrace(System.err);
            return null;
        }
    }

    public Attribute remove(String string) {
        Attribute attribute = this.get(string);
        this.m_attrSet.remove(string);
        return attribute;
    }

    public int size() {
        return this.m_attrSet.size();
    }
}

