/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import netscape.ldap.LDAPException;

public class UMSException
extends Exception {
    static ResourceBundle xcptMsgs = null;
    protected String xcptMessage;
    protected Throwable rootCause;
    private int _resultCode = -1;

    public UMSException(String string) {
        super(string);
        this.xcptMessage = string;
    }

    public UMSException(String string, Throwable throwable) {
        super(string);
        this.xcptMessage = string;
        this.rootCause = throwable;
    }

    protected UMSException() {
        this.xcptMessage = null;
    }

    public String getMessage() {
        if (this.getRootCause() == null) {
            return this.xcptMessage;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.rootCause instanceof LDAPException ? ((LDAPException)this.rootCause).getLDAPErrorMessage() : this.rootCause.getMessage();
        if (this.xcptMessage != null) {
            stringBuffer.append(this.xcptMessage).append("::").append(string);
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public PrintWriter log(PrintWriter printWriter) {
        return UMSException.log(this, printWriter);
    }

    public static PrintWriter log(Throwable throwable, PrintWriter printWriter) {
        printWriter.println("-----------");
        printWriter.println(throwable.toString());
        printWriter.println("Stack Trace:");
        printWriter.print(UMSException.getStackTrace(throwable));
        printWriter.println("-----------");
        printWriter.flush();
        return printWriter;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("--------------------------------------");
        stringBuffer.append("Got UMS Exception\n");
        String string = this.getMessage();
        if (string != null && string.length() > 0) {
            stringBuffer.append("Message: ").append(this.getMessage());
        }
        if (this.rootCause != null) {
            stringBuffer.append("\nLower level exception: ");
            stringBuffer.append(this.getRootCause());
        }
        return stringBuffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream printStream) {
        if (this.rootCause != null) {
            String string = super.toString();
            PrintStream printStream2 = printStream;
            synchronized (printStream2) {
                printStream.print(string + (string.endsWith(".") ? "" : ".") + "  Root exception is ");
                this.rootCause.printStackTrace(printStream);
            }
        } else {
            super.printStackTrace(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter printWriter) {
        if (this.rootCause != null) {
            String string = super.toString();
            PrintWriter printWriter2 = printWriter;
            synchronized (printWriter2) {
                printWriter.print(string + (string.endsWith(".") ? "" : ".") + "  Root exception is ");
                this.rootCause.printStackTrace(printWriter);
            }
        } else {
            super.printStackTrace(printWriter);
        }
    }

    private static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }
}

