/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.controls.LDAPVirtualListResponse;

public class SearchResults
implements Serializable {
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    public static final String VLVRESPONSE_CONTENT_COUNT = "vlvContentCount";
    public static final String VLVRESPONSE_FIRST_POSITION = "vlvFirstPosition";
    public static final String VLVRESPONSE_RESULT_CODE = "vlvResultCode";
    public static final String VLVRESPONSE_CONTEXT = "vlvContext";
    static final String EXPECT_VLV_RESPONSE = "expectVlvResponse";
    static final String BASE_ID = "baseID";
    static final String SEARCH_FILTER = "searchFilter";
    static final String SORT_KEYS = "sortKeys";
    static final String SEARCH_SCOPE = "searchScope";
    private LDAPSearchResults m_ldapSearchResults = null;
    private LDAPConnection m_conn = null;
    private Principal m_principal = null;
    private Hashtable m_attrHash = null;
    private static String[] vlvAttrNames = new String[]{"vlvContentCount", "vlvFirstPosition", "vlvResultCode", "vlvContext"};
    private String[] m_attrVals = null;
    private int m_attrIndex = 0;
    private DataLayer m_dataLayer = null;

    protected SearchResults(LDAPSearchResults lDAPSearchResults, LDAPConnection lDAPConnection, DataLayer dataLayer) {
        this.m_ldapSearchResults = lDAPSearchResults;
        this.m_conn = lDAPConnection;
        this.m_dataLayer = dataLayer;
        if (debug.messageEnabled()) {
            debug.message("Constructing SearchResults: " + this + " with connection : " + lDAPConnection);
        }
    }

    protected SearchResults(LDAPSearchResults lDAPSearchResults, LDAPConnection lDAPConnection) {
        this(lDAPSearchResults, lDAPConnection, null);
    }

    SearchResults(Attr attr) {
        this.m_attrVals = attr == null ? new String[0] : attr.getStringValues();
    }

    public boolean hasMoreElements() {
        boolean bl;
        boolean bl2 = this.m_attrVals != null ? this.m_attrIndex < this.m_attrVals.length : (bl = this.m_ldapSearchResults.hasMoreElements());
        if (!bl && this.m_conn != null) {
            if (debug.messageEnabled()) {
                debug.message("Finishing SearchResults: " + this + "  with connection : " + this.m_conn);
                debug.message("SearchResults: " + this + "  releasing connection : " + this.m_conn);
            }
            this.m_dataLayer.releaseConnection(this.m_conn);
        }
        return bl;
    }

    public PersistentObject next() throws UMSException {
        block11: {
            try {
                if (this.m_attrVals != null) {
                    if (this.m_attrIndex < this.m_attrVals.length) {
                        String string = this.m_attrVals[this.m_attrIndex++];
                        PersistentObject persistentObject = new PersistentObject();
                        persistentObject.setGuid(new Guid(string));
                        persistentObject.setPrincipal(this.m_principal);
                        return persistentObject;
                    }
                    throw new NoSuchElementException();
                }
                LDAPEntry lDAPEntry = this.m_ldapSearchResults.next();
                if (lDAPEntry == null) break block11;
                String string = lDAPEntry.getDN();
                AttrSet attrSet = new AttrSet(lDAPEntry.getAttributeSet());
                Class clazz = TemplateManager.getTemplateManager().getJavaClassForEntry(string, attrSet);
                PersistentObject persistentObject = null;
                try {
                    persistentObject = (PersistentObject)clazz.newInstance();
                }
                catch (Exception exception) {
                    Object[] objectArray = new String[]{exception.toString()};
                    String string2 = i18n.getString("ums-newinstancefailed", objectArray);
                    throw new UMSException(string2);
                }
                persistentObject.setAttrSet(attrSet);
                persistentObject.setGuid(new Guid(lDAPEntry.getDN()));
                persistentObject.setPrincipal(this.m_principal);
                return persistentObject;
            }
            catch (LDAPException lDAPException) {
                this.abandon();
                debug.error("Exception in SearchResults.next: ", (Throwable)lDAPException);
                Object[] objectArray = new String[]{lDAPException.errorCodeToString()};
                String string = i18n.getString("ums-nextentryfailed", objectArray);
                int n = lDAPException.getLDAPResultCode();
                switch (n) {
                    case 3: {
                        throw new TimeLimitExceededException(string, lDAPException);
                    }
                    case 4: {
                        throw new SizeLimitExceededException(string, lDAPException);
                    }
                    case 11: {
                        throw new SizeLimitExceededException(string, lDAPException);
                    }
                }
                throw new UMSException(string, lDAPException);
            }
        }
        return null;
    }

    public PersistentObject assertOneEntry() throws EntryNotFoundException, UMSException {
        PersistentObject persistentObject = null;
        if (this.hasMoreElements()) {
            persistentObject = this.next();
        }
        if (persistentObject == null) {
            throw new EntryNotFoundException();
        }
        if (this.hasMoreElements()) {
            this.abandon();
            throw new UMSException(i18n.getString("ums-multipleentries"));
        }
        return persistentObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String string) throws UMSException {
        if (!this.isVLVAttrs(string)) {
            return this.m_attrHash == null ? null : this.m_attrHash.get(string);
        }
        if (this.m_ldapSearchResults == null) {
            return null;
        }
        LDAPControl[] lDAPControlArray = this.m_ldapSearchResults.getResponseControls();
        if (lDAPControlArray == null && this.expectVlvResponse()) {
            PersistentObject persistentObject = this.getParentContainer();
            SearchResults searchResults = this;
            synchronized (searchResults) {
                String[] stringArray = new String[]{"objectclass"};
                SortKey[] sortKeyArray = (SortKey[])this.get(SORT_KEYS);
                String string2 = (String)this.get(SEARCH_FILTER);
                Integer n = (Integer)this.get(SEARCH_SCOPE);
                int n2 = n == null ? 2 : n;
                SearchControl searchControl = new SearchControl();
                searchControl.setVLVRange(1, 0, 0);
                if (sortKeyArray == null) {
                    searchControl.setSortKeys(stringArray);
                } else {
                    searchControl.setSortKeys(sortKeyArray);
                }
                searchControl.setSearchScope(n2);
                SearchResults searchResults2 = persistentObject.search(string2, stringArray, searchControl);
                while (searchResults2.hasMoreElements()) {
                    searchResults2.next();
                }
                searchResults2.set(EXPECT_VLV_RESPONSE, new Boolean(false));
                return searchResults2.get(string);
            }
        }
        if (lDAPControlArray == null) {
            return null;
        }
        LDAPVirtualListResponse lDAPVirtualListResponse = null;
        int n = 0;
        while (n < lDAPControlArray.length) {
            if (lDAPControlArray[n] instanceof LDAPVirtualListResponse) {
                lDAPVirtualListResponse = (LDAPVirtualListResponse)lDAPControlArray[n];
            }
            ++n;
        }
        if (string.equalsIgnoreCase(VLVRESPONSE_CONTENT_COUNT) && lDAPVirtualListResponse != null) {
            return new Integer(lDAPVirtualListResponse.getContentCount());
        }
        if (string.equalsIgnoreCase(VLVRESPONSE_FIRST_POSITION) && lDAPVirtualListResponse != null) {
            return new Integer(lDAPVirtualListResponse.getFirstPosition());
        }
        if (string.equalsIgnoreCase(VLVRESPONSE_RESULT_CODE) && lDAPVirtualListResponse != null) {
            return new Integer(lDAPVirtualListResponse.getResultCode());
        }
        if (string.equalsIgnoreCase(VLVRESPONSE_CONTEXT) && lDAPVirtualListResponse != null) {
            return new String(lDAPVirtualListResponse.getContext());
        }
        return null;
    }

    public void abandon() throws UMSException {
        if (this.m_conn != null && this.m_ldapSearchResults != null) {
            try {
                this.m_dataLayer.releaseConnection(this.m_conn);
                if (debug.messageEnabled()) {
                    debug.message("Abandoning SearchResults: " + this + " connection : " + this.m_conn);
                }
                if (this.hasMoreElements()) {
                    this.m_conn.abandon(this.m_ldapSearchResults);
                }
                if (debug.messageEnabled()) {
                    debug.message("SearchResults: " + this + " releasing connection : " + this.m_conn);
                }
            }
            catch (LDAPException lDAPException) {
                throw new UMSException(this.m_conn.toString(), lDAPException);
            }
        }
    }

    protected void setPrincipal(Principal principal) {
        this.m_principal = principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void set(String string, Object object) {
        if (this.m_attrHash == null) {
            SearchResults searchResults = this;
            synchronized (searchResults) {
                if (this.m_attrHash == null) {
                    this.m_attrHash = new Hashtable();
                }
            }
        }
        this.m_attrHash.put(string, object);
    }

    private boolean expectVlvResponse() {
        Boolean bl = new Boolean(false);
        try {
            bl = (Boolean)this.get(EXPECT_VLV_RESPONSE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl == null ? false : bl;
    }

    private PersistentObject getParentContainer() throws UMSException {
        String string = null;
        PersistentObject persistentObject = null;
        try {
            string = (String)this.get(BASE_ID);
            Guid guid = new Guid(string);
            persistentObject = new PersistentObject(this.m_principal, guid);
        }
        catch (UMSException uMSException) {
            throw new UMSException(uMSException.getMessage());
        }
        return persistentObject;
    }

    private boolean isVLVAttrs(String string) {
        int n = 0;
        while (n < vlvAttrNames.length) {
            if (string.equalsIgnoreCase(vlvAttrNames[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

