/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.ums.AccessRightObject;
import com.iplanet.ums.BaseRole;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import netscape.ldap.util.DN;

public class Resource
extends PersistentObject {
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static final String MEMBER_ATTR_NAME = "memberof";
    private static final String DEFAULT_NAMING_ATTR = "cn";
    static final String NEW_INSTANCE_FAILED = "newinstancefailed";
    private static final Class _class = class$com$iplanet$ums$Resource == null ? (class$com$iplanet$ums$Resource = Resource.class$("com.iplanet.ums.Resource")) : class$com$iplanet$ums$Resource;
    static /* synthetic */ Class class$com$iplanet$ums$Resource;

    protected Resource() throws UMSException {
    }

    Resource(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    Resource(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public Resource(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public AttrSet getAttributes(SearchTemplate searchTemplate) throws UMSException {
        AttrSet attrSet = new AttrSet();
        String[] stringArray = searchTemplate.getAttributeNames();
        int n = 0;
        while (n < stringArray.length) {
            attrSet.add(this.getAttribute(stringArray[n]));
            ++n;
        }
        return attrSet;
    }

    public AccessRightObject getAccessRight(Guid guid) throws UMSException, ACIParseException {
        AccessRightObject accessRightObject = new AccessRightObject();
        Collection collection = this.getRoles();
        Iterator iterator = collection.iterator();
        if (iterator != null) {
            if (debug.messageEnabled()) {
                debug.message("Resource.getAccessRight : Get rights for : " + guid.getDn());
            }
            DN dN = new DN(guid.getDn());
            while (iterator.hasNext()) {
                Guid guid2 = new Guid((String)iterator.next());
                DN dN2 = new DN(guid2.getDn());
                if (debug.messageEnabled()) {
                    debug.message("Resource.getAccessRight : Role Dn : " + guid2.getDn());
                }
                if (dN2.getParent().isDescendantOf(dN)) continue;
                BaseRole baseRole = (BaseRole)UMSObject.getObject(this.getPrincipal(), guid2);
                if (debug.messageEnabled()) {
                    debug.message("Resource.getAccessRight : Role " + baseRole.getGuid());
                }
                AccessRightObject accessRightObject2 = baseRole.getAccessRight();
                accessRightObject.grantReadPermission(accessRightObject2.getReadableAttributeNames());
                accessRightObject.grantWritePermission(accessRightObject2.getWritableAttributeNames());
                debug.message("Resource.getAccessRight : Done grant");
            }
        }
        return accessRightObject;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

