/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SearchTemplate;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.User;
import java.security.Principal;
import netscape.ldap.util.DN;

public class PeopleContainer
extends PersistentObject {
    private static final Class _class = class$com$iplanet$ums$PeopleContainer == null ? (class$com$iplanet$ums$PeopleContainer = PeopleContainer.class$("com.iplanet.ums.PeopleContainer")) : class$com$iplanet$ums$PeopleContainer;
    private static final String NUM_USER_ATTR_NAME = "nsNumUsers";
    private static final String NUM_PEOPLECONTAINER_ATTR_NAME = "nsNumPeopleContainers";
    private static final String MAX_USER_ATTR_NAME = "nsMaxUsers";
    private static final String MAX_PEOPLECONTAINER_ATTR_NAME = "nsMaxPeopleContainers";
    private static final String BASIC_USER_SEARCH = "BasicUserSearch";
    private static final String BASIC_PEOPLECONTAINER_SEARCH = "BasicPeopleContainerSearch";
    static final String MULTIPLE_PEOPLE_CONTAINERS_SUPPORT = "MultiplePeopleContainersSupport";
    static /* synthetic */ Class class$com$iplanet$ums$PeopleContainer;

    protected PeopleContainer() throws UMSException {
    }

    PeopleContainer(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    PeopleContainer(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public PeopleContainer(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public void addUser(User user) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        super.addChild(user);
    }

    public void addChildPeopleContainer(PeopleContainer peopleContainer) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        super.addChild(peopleContainer);
    }

    public void removeUser(User user) throws AccessRightsException, UMSException {
        super.removeChild(user);
    }

    public void removeChildPeopleContainer(PeopleContainer peopleContainer) throws AccessRightsException, EntryNotFoundException, UMSException {
        super.removeChild(peopleContainer);
    }

    public long getUserCount() throws UMSException {
        SearchTemplate searchTemplate = TemplateManager.getTemplateManager().getSearchTemplate(BASIC_USER_SEARCH, this.getParentGuid());
        SearchResults searchResults = this.getChildren(searchTemplate, null);
        long l = 0L;
        while (searchResults.hasMoreElements()) {
            searchResults.next();
            ++l;
        }
        return l;
    }

    public long getChildPeopleContainerCount() throws UMSException {
        SearchTemplate searchTemplate = TemplateManager.getTemplateManager().getSearchTemplate(BASIC_PEOPLECONTAINER_SEARCH, this.getParentGuid());
        SearchResults searchResults = this.getChildren(searchTemplate, null);
        long l = 0L;
        while (searchResults.hasMoreElements()) {
            searchResults.next();
            ++l;
        }
        return l;
    }

    public void setMaxUserLimit(long l) throws UMSException {
        String string = new Long(l).toString();
        this.setAttribute(new Attr(MAX_USER_ATTR_NAME, string));
    }

    public void setMaxChildPeopleContainerLimit(long l) throws UMSException {
        String string = new Long(l).toString();
        this.setAttribute(new Attr(MAX_PEOPLECONTAINER_ATTR_NAME, string));
    }

    public long getMaxUserLimit() throws UMSException {
        String string = this.getAttribute(MAX_USER_ATTR_NAME).getValue();
        return new Long(string);
    }

    public long getMaxChildPeopleContainerLimit() throws UMSException {
        String string = this.getAttribute(MAX_PEOPLECONTAINER_ATTR_NAME).getValue();
        return new Long(string);
    }

    public boolean isMember(User user) throws UMSException {
        DN dN = new DN(user.getDN());
        DN dN2 = new DN(this.getDN());
        return dN.getParent().equals(dN2);
    }

    public String getName() throws UMSException {
        return this.getAttribute(this.getNamingAttribute()).getValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

